package com.ebike.openservices.oprmgmt.service.impl;

import java.util.List;
import java.util.Map;

import com.ebike.openservices.base.service.AbstractEbikeBaseService;
import com.ebike.openservices.oprmgmt.dao.OrgOprDao;
import com.ebike.openservices.oprmgmt.jdbcdao.ExcelDao;
import com.ebike.openservices.oprmgmt.jdbcdao.RateSetDao;
import com.ebike.openservices.oprmgmt.response.OrgOprResponse;
import com.ebike.openservices.oprmgmt.service.RateSetService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RateSetServiceImpl  extends AbstractEbikeBaseService implements RateSetService {

  private final RateSetDao rDao;

  private final OrgOprDao orgOprDao;

  private ExcelDao edao;
  @Autowired
  public RateSetServiceImpl(RateSetDao rDao, OrgOprDao orgOprDao, ExcelDao edao) {
    this.rDao = rDao;
      this.orgOprDao = orgOprDao;
      this.edao=edao;
  }



  @Override
  public List<Map<String,Object>> queryRateStation(String subburo,Map<String,String> map)
  {
	  return rDao.queryRateStation(subburo, map);
  }
    @Override
  public int queryRateCount(String subburo,Map<String,String> map)
  {
	  return rDao.queryRateCount(subburo, map);
  }
    @Override
  public List<Map<String,Object>> queryRateModel(String stationId)
  {
	  return rDao.queryRateModel(stationId);
  }
    @Override
  public int rateModelCount(String stationId)
  {
	  return rDao.rateModelCount(stationId);
  }
  //下载模板
  @Override
  public  String findPhoneById(String userId)
  {
	  return rDao.findPhoneById(userId);
  }
//    @Override
//  public void exportExcel(String phone,ServletOutputStream outputStream) throws IOException
//  {
//    edao.exportExcel(phone, outputStream);
//  }
  @Override
  public Map<String, String> importExcel(String stationId,String csbsId,String uuid)
  {
      return edao.importExcel(stationId,csbsId,uuid);
  }
  @Override
  public int addMobilePhone(String uuid, String userPhone) {
      return edao.addMobilePhone(uuid,userPhone);
  }
  @Override
  public String sRateAdd(Map<String,String> map)
  {
	  return rDao.sRateAdd(map);
  }
  @Override
  public String rateModify(Map<String,String> map)
  {
	  return rDao.rateModify(map);
  }
  @Override
  public Map<String,Object> stopRate(String csbsId,String orgName,String stationId,String subburo)
  {
	  return rDao.stopRate(csbsId,orgName,stationId,subburo);
  }
  @Override
  public Map<String,Object> forbiddens(String csbsId,String orgName,String stationId,String subburo,String  schemeId)
  {
    return rDao.forbiddens(csbsId,orgName,stationId,subburo,schemeId);
  }
  @Override
  public String unForbiddens(String csbsId,String orgName,String stationId,String subburo,String  schemeId)
  {
    return rDao.unForbiddens(csbsId,orgName,stationId,subburo,schemeId);
  }

  @Override
  public List<Map<String,Object>> qShareStation(String subburo,Map<String,String> map)
  {
	  return rDao.qShareStation(subburo, map);
  }
  @Override
  public int qShareCount(String subburo,Map<String,String> map)
  {
	  return rDao.qShareCount(subburo, map);
  }
  @Override
  public List<Map<String,Object>> queryOperationInfo(String csbsId)
  {
	  return rDao.queryOperationInfo(csbsId);
  }
  @Override
  public int operationCount(String csbsId)
  {
	  return rDao.operationCount(csbsId);
  }
  @Override
  public boolean checkCsbsById(String scheId,String stationId)
  {
	  return rDao.checkCsbsById(scheId,stationId);
  }
  @Override
  public boolean yysOpConfirm(Map<String,String> map)
  {
	  return rDao.yysOpConfirm(map);
  }
  @Override
  public String getInsertOrUpdate(String newCsbsUsersListId)
  {
	  return rDao.getInsertOrUpdate(newCsbsUsersListId);
  }
  @Override
  public List<Map<String,Object>> getPromptData(String newCsbsUsersListId)
  {
	  return rDao.getPromptData(newCsbsUsersListId);
  }
  @Override
  public List<Map<String,Object>> queryUserPhone(String  csbsUsersListId)
  {
	  return rDao.queryUserPhone(csbsUsersListId);
  }
  @Override
  public int queryPhoneCount(String csbsUsersListId)
  {
	  return rDao.queryPhoneCount(csbsUsersListId);
  }
  @Override
  public List<Map<String,Object>> queryNewUserPhone(String  csbsUsersListId)
  {
	  return rDao.queryNewUserPhone(csbsUsersListId);
  }
  @Override
  public int newPhoneCount(String csbsUsersListId)
  {
	  return rDao.newPhoneCount(csbsUsersListId);
  }

  @Override
  public List<Map<String, Object>> getUserList(String csbsUsersListId) {
    return rDao.getUserList(csbsUsersListId);
  }


  @Override
  public Map<String, Object> getStationInfoByCsbsId(String csbsId) {
     return rDao.getStationInfoByCsbsId(csbsId);
  }

  @Override
  public int foriddenConfirm(Map<String, String> map) {
    return rDao.foriddenConfirm(map);
  }

    @Override
    public OrgOprResponse queryOrgOpr(OrgOprResponse orgOprResponse) {
        return orgOprDao.queryOrgOpr(orgOprResponse);
    }

}

