package com.ebike.openservices.oprmgmt.service.impl;

import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.ObjectUtil;
import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.easesource.data.id.generator.IdGenerator;
import com.ebike.openservices.oprmgmt.dao.RechargeCardsDao;
import com.ebike.openservices.oprmgmt.entity.po.CardCustomPurchaseApplyRelacs;
import com.ebike.openservices.oprmgmt.entity.vo.RechargeCardVo;
import com.ebike.openservices.oprmgmt.entity.vo.RefundRecordVo;
import com.ebike.openservices.oprmgmt.entity.vo.StationVo;
import com.ebike.openservices.oprmgmt.request.RechargeCardRequest;
import com.ebike.openservices.oprmgmt.service.RechargeCardsService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @param
 * @ClassName RechargeCardServiceImpl
 * @Description TODO
 * @Author zhouyi
 * @Data 2021/7/15 16:07
 * @Version 1.0
 **/
@Service
public class RechargeCardsServiceImpl implements RechargeCardsService {
    @Resource
    private RechargeCardsDao rechargeCardsDao;

    @Resource
    private IdGenerator idGenerator;

    /***
     * @Description TODO 充电卡模糊查询（运营商端）
     * @author zhouyi
     * @return java.util.Map<java.lang.String, java.lang.Object>
     * @data 2021/7/15
     * @param request
     */
    @Override
    public Map<String, Object> listRechargeCardVo(RechargeCardRequest request) {
        String orgNo = request.getOrgNo();
        //账户总余额
        BigDecimal totalAccountBalance = new BigDecimal(0);
        //账户总充值
        BigDecimal totalInAmount = new BigDecimal(0);
        RechargeCardVo rechargeCardVo = rechargeCardsDao.getBalance(orgNo);
        RechargeCardVo rechargeCardVov = rechargeCardsDao.getIncome(orgNo);
        if (ObjectUtil.isNotEmpty(rechargeCardVo) && ObjectUtil.isNotEmpty(rechargeCardVo.getTotalAccountBalance())) {
            totalAccountBalance = rechargeCardVo.getTotalAccountBalance();
        }
        if (ObjectUtil.isNotEmpty(rechargeCardVov) && ObjectUtil.isNotEmpty(rechargeCardVov.getTotalInAmount())) {
            totalInAmount = rechargeCardVov.getTotalInAmount();
        }

        Sorter sorter = new Sorter();
        Pager pager = new Pager();
        pager.setPageNumber(request.getCurrent());
        pager.setPageSize(10);
        List<RechargeCardVo> rechargeCardVos = rechargeCardsDao.listRechargeCardVo(request, sorter, pager);
        Integer totalPage = rechargeCardsDao.getTotalPage(request);
        //讲未绑定的手机号和绑定时间设置为空
        rechargeCardVos.forEach(rechargeCardVo1 -> {
            if (ObjectUtil.isNotEmpty(rechargeCardVo1.getStatus())&&rechargeCardVo1.getStatus() == 0) {
                    rechargeCardVo1.setBindTime(null);
                    rechargeCardVo1.setPhoneNo(null);
            }
        });
        Map<String, Object> map = Dict.create()
            .set("rechargeCardVos", rechargeCardVos)
            .set("totalAccountBalance", totalAccountBalance)
            .set("totalInAmount", totalInAmount)
            .set("totalPage", totalPage);
        return map;
    }

    /***
     * @Description TODO 充电卡订单模糊查询
     * @author zhouyi
     * @return java.util.List<com.ebike.openservices.oprmgmt.entity.vo.RechargeCardVo>
     * @data 2021/7/15
     * @param batch
     * @param phoneNo
     */
    @Override
    public Map<String, Object> listRechargeCardOrder(String batch, String phoneNo, String orgNo, Integer current) {
        Sorter sorter = new Sorter();
        Pager pager = new Pager();
        pager.setPageNumber(current);
        pager.setPageSize(10);
        List<RechargeCardVo> rechargeCardOrders = rechargeCardsDao.listRechargeCardOrder(batch, phoneNo, orgNo, sorter, pager);
        Integer totalPage = rechargeCardsDao.getOrderTotalPage(batch, phoneNo, orgNo);
        Map<String, Object> map = Dict.create()
            .set("rechargeCardOrders", rechargeCardOrders)
            .set("totalPage", totalPage);
        return map;
    }

    /***
     * @Description TODO 查询  已关联  未关联电站
     * @author zhouyi
     * @return java.util.List<com.ebike.openservices.oprmgmt.entity.vo.StationVo>
     * @data 2021/7/15
     * @param id
     * @param orgNo
     * @param type  1已关联   2未关联
     */
    @Override
    public Map<String, Object> listStation(Long id, String orgNo, String stationName, String stationAddr, String type) {
        /*Sorter sorter = new Sorter();
        Pager pager = new Pager();
        pager.setPageNumber(current);
        pager.setPageSize(10);*/
        List<StationVo> stationVos = null;
        //Integer totalPage = null;
        Map<String, Object> map = new HashMap<>();
        if (type.equals("1")) {
            stationVos = rechargeCardsDao.listStationAssociated(id, stationName, stationAddr/*,sorter,pager*/);
            //totalPage =rechargeCardsDao.getStationAssociatedTotalPage(id,stationName,stationAddr);
            map.put("stationVos", stationVos);
            // map.put("totalPage",totalPage);
        } else if (type.equals("2")) {
            stationVos = rechargeCardsDao.listStation(orgNo, stationName, stationAddr/*,sorter,pager*/);
            //totalPage =rechargeCardsDao.getStationTotalPage(orgNo,stationName,stationAddr);
            map.put("stationVos", stationVos);
            // map.put("totalPage",totalPage);
        }
        return map;
    }

    /***
     * @Description TODO 解除关联
     * @author zhouyi
     * @return java.lang.Integer
     * @data 2021/7/16
     * @param id
     * @param stationIdStr
     */
    @Override
    public Integer removeAssociated(Long id, String stationIdStr) {
        Integer num = null;
        String[] stationIds = stationIdStr.split(",");
        for (int i = 0; i < stationIds.length; i++) {
            Long stationId = Long.parseLong(stationIds[i]);
            num = rechargeCardsDao.removeAssociated(id, stationId);
        }
        return num;
    }

    /***
     * @Description TODO 创建关联
     * @author zhouyi
     * @return java.lang.Integer
     * @data 2021/7/16
     * @param stationIdStr
     */
    @Override
    public Integer createAssociated(Long purchaseApplyId, String stationIdStr, String orgNo) {
        Integer num = null;
        String[] stationIds = stationIdStr.split(",");
        for (int i = 0; i < stationIds.length; i++) {
            Long stationId = Long.parseLong(stationIds[i]);
            CardCustomPurchaseApplyRelacs customPurchaseApplyRelacs = CardCustomPurchaseApplyRelacs.builder()
                .id(idGenerator.nextId())
                .primaryOrgNo(orgNo)
                .purchaseApplyId(purchaseApplyId)
                .orgNo(orgNo)
                .chargeStationId(stationId)
                .gmtCreate(System.currentTimeMillis()).build();
            num = rechargeCardsDao.createAssociated(customPurchaseApplyRelacs);
        }
        return num;
    }
   /***
    * @Description TODO  退款记录
    * @author zhouyi
    * @return java.util.List<com.ebike.openservices.oprmgmt.entity.vo.RefundRecordVo>
    * @data 2021/7/19
    * @param id
    * @param current
    */
    @Override
    public Map<String,Object> getRefundRecord(String id, Integer current,String startDate,String endDate) {
        Sorter sorter = new Sorter();
        Pager pager = new Pager();
        pager.setPageNumber(current);
        pager.setPageSize(10);
        List<RefundRecordVo> refundRecordVos=rechargeCardsDao.getRefundRecord(id,startDate,endDate,sorter,pager);
        Integer totalPage = rechargeCardsDao.getRefundTotalPage(id,startDate,endDate);
        Map<String,Object> map=Dict.create()
            .set("refundRecordVos",refundRecordVos)
            .set("totalPage",totalPage);
        return map;
    }
}
