package com.ebike.openservices.oprmgmt.service.impl;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import com.ebike.openservices.base.service.AbstractEbikeBaseService;
import com.ebike.openservices.oprmgmt.jdbcdao.RateSetDao;
import com.ebike.openservices.oprmgmt.jdbcdao.StationCostDao;
import com.ebike.openservices.oprmgmt.service.StationCostService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


@Service
public class StationCostServiceImpl extends AbstractEbikeBaseService implements StationCostService {
    


	private final  StationCostDao costdao;

	@Autowired
	public StationCostServiceImpl(StationCostDao costdao) {
		this.costdao = costdao;
	}


	@Override
	public List<Map<String,Object>>  queryCost(String subburo,Map<String,String> map)
	{
		return costdao.queryCost(subburo, map);
	}
	@Override
	public int costCount(String subburo,Map<String,String> map)
	{
		return costdao.costCount(subburo, map);
	}
	@Override
	public boolean updateCscsinfo(String csId,String stationId,String costId,String cscsStatus,String orgName)
	{
		return costdao.updateCscsinfo(csId,stationId,costId,cscsStatus,orgName);
	}
	@Override
	public boolean insertCscsInfo(String stationId,String costId,String orgName)
	{
		return costdao.insertCscsInfo(stationId,costId,orgName);
	}
	@Override
	public String queryCostCount(String stationId)
	{
		return costdao.queryCostCount(stationId);
	}
	@Override
	public List<Map<String,Object>> costOpInfo(String cscsId)
	{
		return costdao.costOpInfo(cscsId);
	}
	@Override
	public int costOpInfoCount(String cscsId)
	{
	    return costdao.costOpInfoCount(cscsId);
	}
	@Override
	public List<Map<String,Object>>  queryShareCost(String subburo,Map<String,String> map)
	{
		return costdao.queryShareCost(subburo, map);
	}
	@Override
	public int queryShareCostCount(String subburo,Map<String,String> map)
	{
		return costdao.queryShareCostCount(subburo, map);
	}
	@Override
	public boolean yysOpConfirm(String cscsId,String confirmFlag,String subburo,String orgName,String logType)
	{
		return costdao.yysOpConfirm(cscsId, confirmFlag, subburo, orgName,logType);
	}

}
