package com.ebike.openservices.oprmgmt.service.impl;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import com.ebike.openservices.base.service.AbstractEbikeBaseService;
import com.ebike.openservices.oprmgmt.jdbcdao.StationCostDao;
import com.ebike.openservices.oprmgmt.jdbcdao.StationViewDao;
import com.ebike.openservices.oprmgmt.service.StationViewService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


@Service
public class StationViewServiceImpl extends AbstractEbikeBaseService implements StationViewService {
   


	private final StationViewDao viewDao;

	@Autowired
	public StationViewServiceImpl(StationViewDao viewDao) {
		this.viewDao = viewDao;
	}


	@Override
	public List<Map<String,Object>> queryCostInfo(String stationId)
	{
		return viewDao.queryCostInfo(stationId);
	}
	@Override
	public List<Map<String,Object>> queryShareStation(String subburo,Map<String,String> map)
	{
		return viewDao.queryShareStation(subburo, map);
	}
	@Override
	public int queryShareCount(String subburo,Map<String,String> map)
	{
		return viewDao.queryShareCount(subburo, map);
	}
	@Override
	public List<Map<String,Object>> queryRateModel(String stationId)
	{
		return viewDao.queryRateModel(stationId);
	}
	@Override
	public List<Map<String,Object>> partnerQuery(String stationId)
	{
		return viewDao.partnerQuery(stationId);
	}
	@Override
	public List<Map<String,Object>> querydevInfo(String stationId)
	{
		return viewDao.querydevInfo(stationId);
	}
	@Override
	public List<Map<String,Object>> queryMeterInfo(String stationId)
	{
		return viewDao.queryMeterInfo(stationId);
	}
}
