package com.ebike.openservices.oprmgmt.service.impl;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.ebike.openservices.base.service.AbstractEbikeBaseService;
import com.ebike.openservices.oprmgmt.dao.TmplBillingDao;
import com.ebike.openservices.oprmgmt.entity.TmplBillingDo;
import com.ebike.openservices.oprmgmt.enums.ErrorCodeEnum;
import com.ebike.openservices.oprmgmt.exception.BizException;
import com.ebike.openservices.oprmgmt.request.TmplBillingRequest;
import com.ebike.openservices.oprmgmt.service.TmplBillingService;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 充电汽车项目-->计费模板维护
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-04-13
 */
@Service
public class TmplBillingServiceImpl extends AbstractEbikeBaseService implements TmplBillingService {

    @Resource
    private TmplBillingDao tmplBillingDao;

    @Override
    public List<TmplBillingDo> getTmplBillingDoList(TmplBillingRequest params, Sorter sorter, Pager pager) {
        List<TmplBillingDo> list = tmplBillingDao.getTmplBillingDoList(params, sorter, pager);
        for (TmplBillingDo tmplBillingDo : list) {
            Long gmtCreate = tmplBillingDo.getGmtCreate();
            String gmtCreateTime = DateUtil.format(new Date(gmtCreate), DatePattern.NORM_DATETIME_MINUTE_PATTERN);
            tmplBillingDo.setGmtCreateTime(gmtCreateTime);
        }
        return list;
    }

    @Override
    public Integer getTmplBillingDoCount(TmplBillingRequest params) {
        return tmplBillingDao.getTmplBillingDoCount(params);
    }

    @Override
    public void insertTmplBilling(TmplBillingRequest params) {
        long id = idGenerator.nextId();
        params.setId(id);
        params.setTmplDesc("模板说明");
        params.setBillingClass(2);
        params.setBillingSubclass(2);
        Map<String, Object> json = Maps.newHashMap();
        if ("single".equals(params.getPriceRateType())) {
            json.put("price_rate_type", "single");
            json.put("price_total", params.getPriceTotal());
        } else if ("deviceMulti".equals(params.getPriceRateType())) {
            json.put("price_rate_type", "multi");
            json.put("rate_count", 4);
            json.put("rate_period_type", 1);
            json.put("price_rate01", params.getPriceRate01());
            json.put("price_rate02", params.getPriceRate02());
            json.put("price_rate03", params.getPriceRate03());
            json.put("price_rate04", params.getPriceRate04());
            json.put("price_service", params.getPriceService());
        } else if ("multi".equals(params.getPriceRateType())) {
            json.put("price_rate_type", "multi");
            json.put("rate_count", params.getRateCount());
            json.put("rate_period_type", 2);
            if (StrUtil.isNotBlank(params.getStartValueRatePeriod01())) {
                json.put("start_value_rate_period01", params.getStartValueRatePeriod01());
            }
            if (StrUtil.isNotBlank(params.getPriceRate01())) {
                json.put("price_rate01", params.getPriceRate01());
                json.put("number_rate_period01", 1);
            }
            if (StrUtil.isNotBlank(params.getStartValueRatePeriod02())) {
                json.put("start_value_rate_period02", params.getStartValueRatePeriod02());
            }
            if (StrUtil.isNotBlank(params.getPriceRate02())) {
                json.put("price_rate02", params.getPriceRate02());
                json.put("number_rate_period02", 2);
            }
            if (StrUtil.isNotBlank(params.getStartValueRatePeriod03())) {
                json.put("start_value_rate_period03", params.getStartValueRatePeriod03());
            }
            if (StrUtil.isNotBlank(params.getPriceRate03())) {
                json.put("price_rate03", params.getPriceRate03());
                json.put("number_rate_period03", 3);
            }
            if (StrUtil.isNotBlank(params.getStartValueRatePeriod04())) {
                json.put("start_value_rate_period04", params.getStartValueRatePeriod04());
            }
            if (StrUtil.isNotBlank(params.getPriceRate04())) {
                json.put("price_rate04", params.getPriceRate04());
                json.put("number_rate_period04", 4);
            }
            if (StrUtil.isNotBlank(params.getStartValueRatePeriod05())) {
                json.put("start_value_rate_period05", params.getStartValueRatePeriod05());
            }
            if (StrUtil.isNotBlank(params.getPriceRate05())) {
                json.put("price_rate05", params.getPriceRate05());
                json.put("number_rate_period05", 5);
            }
            if (StrUtil.isNotBlank(params.getStartValueRatePeriod06())) {
                json.put("start_value_rate_period06", params.getStartValueRatePeriod06());
            }
            if (StrUtil.isNotBlank(params.getPriceRate06())) {
                json.put("price_rate06", params.getPriceRate06());
                json.put("number_rate_period06", 6);
            }
            if (StrUtil.isNotBlank(params.getStartValueRatePeriod07())) {
                json.put("start_value_rate_period07", params.getStartValueRatePeriod07());
            }
            if (StrUtil.isNotBlank(params.getPriceRate07())) {
                json.put("price_rate07", params.getPriceRate07());
                json.put("number_rate_period07", 7);
            }
            if (StrUtil.isNotBlank(params.getStartValueRatePeriod08())) {
                json.put("start_value_rate_period08", params.getStartValueRatePeriod08());
            }
            if (StrUtil.isNotBlank(params.getPriceRate08())) {
                json.put("price_rate08", params.getPriceRate08());
                json.put("number_rate_period08", 8);
            }
            if (StrUtil.isNotBlank(params.getStartValueRatePeriod09())) {
                json.put("start_value_rate_period09", params.getStartValueRatePeriod09());
            }
            if (StrUtil.isNotBlank(params.getPriceRate09())) {
                json.put("price_rate09", params.getPriceRate09());
                json.put("number_rate_period09", 9);
            }
            if (StrUtil.isNotBlank(params.getStartValueRatePeriod10())) {
                json.put("start_value_rate_period10", params.getStartValueRatePeriod10());
            }
            if (StrUtil.isNotBlank(params.getPriceRate10())) {
                json.put("price_rate10", params.getPriceRate10());
                json.put("number_rate_period10", 10);
            }
            json.put("price_service", params.getPriceService());
        }
        JSONObject jso = new JSONObject(json);
        params.setBillingParams(jso.toString());
        params.setBillingModel(params.getBillingModel());
        params.setBillingInterval(params.getBillingInterval());
        params.setSortSn(1);
        params.setCreator(params.getCreator());
        if (params.getType() == 2) {
            params.setGmtCreate(System.currentTimeMillis());
            params.setGmtModified(System.currentTimeMillis());
            params.setGmtDeleted(System.currentTimeMillis());
        } else {
            params.setGmtCreate(System.currentTimeMillis());
            params.setGmtModified(0L);
            params.setGmtDeleted(0L);
        }
        params.setModifier(params.getModifier());
        params.setIsDeleted(0);
        params.setDeleter(params.getDeleter());
        params.setVersion(1);
        tmplBillingDao.insertTmplBilling(params);
    }

    @Override
    public void updateTmplBilling(TmplBillingRequest params) {
        deleteTmplBilling(params);
        insertTmplBilling(params);
    }

    @Override
    public void deleteTmplBilling(TmplBillingRequest params) {
        int countByTmplId = tmplBillingDao.getCountByTmplId(params.getId());
        if (countByTmplId > 0) {
            throw new BizException(ErrorCodeEnum.CHARGING_STATION_ASSOCIATION_ERROR);
        }
        tmplBillingDao.deleteTmplBilling(params);
    }

    @Override
    public TmplBillingDo getMaxTmplNo() {
        String pre = "EVT";
        TmplBillingDo maxTmplNo = tmplBillingDao.getMaxTmplNo();
        if (maxTmplNo  == null || StrUtil.isBlank(maxTmplNo.getTmplNo())) {
            maxTmplNo.setTmplNo(pre + "00001");
        } else {
            String tmplNo = maxTmplNo.getTmplNo();
            String format = String.format("%05d", (Long.parseLong(StrUtil.removePrefix(tmplNo, pre)) + 1));
            maxTmplNo.setTmplNo(pre + format);
        }
        return maxTmplNo;
    }

    @Override
    public String queryTmplInfoById(String tmplId) {
        return tmplBillingDao.selectTmplInfoById(tmplId);
    }
}
