package com.ebike.openservices.oprmgmt.util;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.BeanUtils;

import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * 属性映射工具类
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/14
 */
public class ConvertUtils {

    public static <T> T convert(Object source, Class<T> target) {
        if (source == null) {
            return null;
        }
        T targetObject = null;
        try {
            targetObject = target.newInstance();
            BeanUtils.copyProperties(source, targetObject);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return targetObject;
    }

    public static <T> List<T> convert(Collection<?> sourceList, Class<T> target) {
        if (sourceList == null) {
            return null;
        }
        List targetList = new ArrayList<>(sourceList.size());
        try {
            for (Object source : sourceList) {
                T targetObject = target.newInstance();
                BeanUtils.copyProperties(source, targetObject);
                targetList.add(targetObject);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return targetList;
    }

    public static Boolean toEmptyDefaultValue(Object object) {
        try {
            Field[] fields = object.getClass().getDeclaredFields();
            for (Field field : fields) {
                field.setAccessible(true);
                if (ObjectUtils.isEmpty(field.get(object))) {
                    Class type = field.getType();
                    if (type == Integer.class) {
                        field.set(object, 0);
                    } else if (type == Long.class) {
                        field.set(object, 0L);
                    } else if (type == Float.class) {
                        field.set(object, 0);
                    } else if (type == Double.class) {
                        field.set(object, 0);
                    } else if (type == BigDecimal.class) {
                        field.set(object, BigDecimal.ZERO);
                    } else if (type == String.class) {
                        field.set(object, "");
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

}
