/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.oprmgmt.jdbcdao.impl;

import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.data.jdbc.SqlParamsBuilder;
import com.ebike.openservices.base.dao.AbstractEbikeBaseJdbcDao;
import com.ebike.openservices.oprmgmt.jdbcdao.ChargeBikePileDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class ChargeBikePileDaoImpl
extends AbstractEbikeBaseJdbcDao
implements ChargeBikePileDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Qualifier(value="ebikeJdbcTemplate")
    private final JdbcTemplate ebikeJdbcTemplate;

    @Autowired
    public ChargeBikePileDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public String topOrgToEmpty(String orgNo) {
        List list = new ArrayList();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        sql.append("SELECT t.* FROM cisp_sys.bp_org t WHERE t.p_org_no is null ");
        sql.append(" and t.org_no= ? ", (Object)orgNo);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getOrgList=" + sql.toString());
        }
        try {
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
        }
        catch (Exception e) {
            e.printStackTrace();
            return orgNo;
        }
        if (list != null && list.size() > 0) {
            return "";
        }
        return orgNo;
    }

    @Override
    public List<Map<String, Object>> getChargePileData(String subburo, Map<String, String> map, int start, int limit) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append("select p.ID,p.chargedeviceNo,p.plugCount,d.USER_NAME as 'installer',f.USER_NAME as 'dismantler',b.XH,b.STATUS,b.RUNDATE,b.STOPDATE,c.opStatus,e.NAME ");
            sql.append(" ,sum(CASE WHEN h.opStatus = '0' THEN 1 ELSE 0 END ) AS 'NUsedPlugCount' ");
            sql.append(" ,sum(CASE WHEN h.opStatus = '1' or h.opStatus = '2'  THEN 1 ELSE 0 END ) AS 'useringPlug' ");
            sql.append(" ,sum(CASE WHEN h.opStatus = '8' THEN 1 ELSE 0 END ) AS 'checkingPlug' , ");
            sql.append(" sum(CASE WHEN h.opStatus = '9' THEN 1 ELSE 0 END ) AS 'damagePlug' ");
            sql.append(" from cisp_dev.dev_ebikechargedevice p left join cisp_dev.dev_powersystemresource b on p.id=b.id  ");
            sql.append(" left join  cisp_dev.dev_ebikechargestation a on  a.ID=p.CHARGESTATIONID ");
            sql.append("  LEFT JOIN   cisp_dev.dev_powersystemresource e on a.ID=e.ID ");
            sql.append(" left join ebike.ebike_chargedevice_ops c on p.ID=c.chargedeviceId left join cisp_sys.bp_user d on p.INSTALLER=d.USER_NO ");
            sql.append(" left join cisp_sys.bp_user f on p.DISMANTLER=f.USER_NO ");
            sql.append(" left join cisp_dev.dev_ebikechargeplug g  on p.ID=g.CHARGEDEVICEID  ");
            sql.append(" left join ebike.ebike_chargeplug_ops h on g.ID=h.chargeplugId where 1=1  ");
            sql.append(" and ( b.SUBBURO=?", (Object)subburo);
            sql.append(" or b.BURO=? )", (Object)subburo);
            sql.append(" and b.STATUS = ?", (Object)map.get("devstatus"));
            sql.append(" and c.opStatus=?", (Object)map.get("opStatus"));
            sql.append(" and e.name like ? ", (Object)("%" + map.get("name") + "%"));
            sql.append(" and p.chargedeviceNo like ?", (Object)("%" + map.get("chargedeviceNo") + "%"));
            sql.append(" GROUP BY p.ID ");
            if (start != -1 && limit != -1) {
                sql.append(" limit ? ", (Object)start);
                sql.append(" , ? ", (Object)limit);
            }
            this.logger.debug(">>>>>>>>>>>>>>>>>>>>>>>getChargePileData<<<<<<<<<<<<<<<<<<<<<<" + sql.toString());
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rownum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("ID", rs.getLong("ID"));
                    map.put("stationName", rs.getString("NAME"));
                    map.put("chargedeviceNo", rs.getString("chargedeviceNo"));
                    map.put("plugCount", rs.getInt("plugCount"));
                    map.put("installer", rs.getString("installer"));
                    map.put("STATUS", rs.getString("STATUS"));
                    map.put("RUNDATE", rs.getTimestamp("RUNDATE"));
                    map.put("STOPDATE", rs.getTimestamp("STOPDATE"));
                    map.put("dismantler", rs.getString("dismantler"));
                    map.put("opStatus", rs.getString("opStatus"));
                    map.put("NUsedPlugCount", rs.getInt("NUsedPlugCount"));
                    map.put("useringPlug", rs.getInt("useringPlug"));
                    map.put("checkingPlug", rs.getInt("checkingPlug"));
                    map.put("damagePlug", rs.getInt("damagePlug"));
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int getChargePileCount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from cisp_dev.dev_ebikechargedevice p left join cisp_dev.dev_powersystemresource b on p.id=b.id  ");
            sql.append(" left join  cisp_dev.dev_ebikechargestation a on  a.ID=p.CHARGESTATIONID ");
            sql.append("  LEFT JOIN   cisp_dev.dev_powersystemresource e on a.ID=e.ID ");
            sql.append(" left join ebike.ebike_chargedevice_ops c on p.ID=c.chargedeviceId left join cisp_sys.bp_user d on p.INSTALLER=d.USER_NO ");
            sql.append(" left join cisp_sys.bp_user f on p.DISMANTLER=f.USER_NO where 1=1");
            sql.append(" and ( b.SUBBURO=?", (Object)subburo);
            sql.append(" or b.BURO=? )", (Object)subburo);
            sql.append(" and b.STATUS=?", (Object)map.get("devstatus"));
            sql.append(" and p.chargedeviceNo=?", (Object)map.get("chargedeviceNo"));
            sql.append(" and c.opStatus=?", (Object)map.get("opStatus"));
            sql.append(" and e.name like ? ", (Object)("%" + map.get("name") + "%"));
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public List<Map<String, Object>> getOppersonList(Map<String, String> map, int start, int limit) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append("select * from ebike.ebike_opperson c  where 1=1");
            sql.append(" and c.oppersonMobile=?", (Object)map.get("oppersonMobile"));
            sql.append(" and c.oppersonName like ? ", (Object)("%" + map.get("oppersonName") + "%"));
            sql.append(" and ( c.subburo = ?", (Object)map.get("subburo_no"));
            sql.append(" or c.buro = ? )", (Object)map.get("subburo_no"));
            sql.append(" and c.valid ='T'");
            if (start != -1 && limit != -1) {
                sql.append(" limit ? ", (Object)start);
                sql.append(" , ? ", (Object)limit);
            }
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int getChargeOppersonCount(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append("select count(1) from ebike.ebike_opperson c where 1=1 ");
            sql.append(" and c.oppersonMobile=?", (Object)map.get("oppersonMobile"));
            sql.append(" and c.oppersonName like ?", (Object)("%" + map.get("oppersonName") + "%"));
            sql.append(" and ( c.subburo = ?", (Object)map.get("subburo_no"));
            sql.append(" or c.buro = ? )", (Object)map.get("subburo_no"));
            sql.append(" and c.valid ='T'");
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public boolean checkOppersonExist(String oppersonMobile) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append("select count(1) from ebike.ebike_opperson c where 1=1 ");
            sql.append(" and c.oppersonMobile=?", (Object)oppersonMobile);
            sql.append(" and c.valid ='T' )");
            results = (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    @Override
    public boolean checkOppersonById(String ids) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int result = 0;
        try {
            sql.append("select count(1) from ebike.ebike_cs_op_rela where 1=1 and oppersonId in (?)", (Object)ids, ",");
            result = (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
            this.logger.debug(">>>>>>>>>>>>>>>>>>>>>oppersonId<<<<<<<<<<<<<<<<<" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return result > 0;
    }

    @Override
    public boolean saveChargeOpperson(String uuid, String subburo, String oppersonName, String oppersonMobile, String name) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append("insert into ebike.ebike_opperson");
            sql.append("(oppersonId,buro,subburo,oppersonName,oppersonMobile,creator,createTime)");
            sql.append("values(?,?,?,?,?,?,?)");
            results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{uuid, subburo, subburo, oppersonName, oppersonMobile, name, new Date()});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    @Override
    public boolean updateOpperson(String oppserId, String subburo, String oppersonName, String oppersonMobile, String name) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append("update ebike.ebike_opperson set ");
            sql.append("oppersonName = ?", (Object)oppersonName);
            sql.append(" ,oppersonMobile=?", (Object)oppersonMobile);
            sql.append(" ,updater=?", (Object)name);
            sql.append(" ,updateTime=?", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"HH:mm:ss"));
            sql.append("where 1=1 ");
            sql.append(" and oppersonId=? ", (Object)oppserId);
            sql.append(" and ( subburo=? ", (Object)subburo);
            sql.append(" or buro=? )", (Object)subburo);
            results = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            this.logger.debug(" ========UpdateFl=========" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    @Override
    public boolean delOpperson(String ids) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        if (ids == null || "".equals(ids)) {
            return false;
        }
        try {
            sql.append("update ebike.ebike_opperson  set valid='F' where 1=1 ");
            sql.append(" and oppersonId in (?)", (Object)ids, ",");
            this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }
}

