/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.oprmgmt.jdbcdao.impl;

import com.easesource.data.jdbc.SqlParamsBuilder;
import com.ebike.openservices.base.dao.AbstractEbikeBaseJdbcDao;
import com.ebike.openservices.oprmgmt.jdbcdao.ChargeBikeStationDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class ChargeBikeStationDaoImpl
extends AbstractEbikeBaseJdbcDao
implements ChargeBikeStationDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Qualifier(value="ebikeJdbcTemplate")
    private final JdbcTemplate ebikeJdbcTemplate;

    @Autowired
    public ChargeBikeStationDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public List<Map<String, Object>> queryStation(String subburo, Map<String, String> map, int start) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        this.logger.debug("============================queryStation11==============" + map.get("schemeType"));
        SqlParamsBuilder sql = new SqlParamsBuilder();
        sql.append("select  a.id, a.stationNo,b.NAME,GROUP_CONCAT(c.CHARGEDEVICENO order by c.CHARGEDEVICENO asc) as chargedeviceNo,b.STATUS,sum(c.plugCount) as 'plugCount',d.schemeName,d.schemeId,d.isReturn,d.schemeType");
        sql.append(" ,a.servicePlaceType,a.chargeFeeMode ");
        sql.append(" from cisp_dev.dev_ebikechargestation a left join cisp_dev.dev_powersystemresource b on a.id=b.id");
        sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.id=c.chargestationId ");
        sql.append(" left join ebike.ebike_cs_bs_rela f on (f.chargestationId=a.ID) left JOIN ebike.ebike_billingscheme d on (f.schemeId=d.schemeId) where 1=1 ");
        sql.append(" and a.stationNo like?", (Object)("%" + map.get("stationNo") + "%"));
        sql.append(" and b.NAME like ?", (Object)("%" + map.get("stationName") + "%"));
        sql.append(" and b.STATUS=?", (Object)map.get("status"));
        sql.append(" and d.schemeType=?", (Object)map.get("schemeType"));
        sql.append(" and d.isReturn=?", (Object)map.get("isReturn"));
        sql.append(" and d.schemeName like ?", (Object)("%" + map.get("schemeName") + "%"));
        sql.append(" and ( b.BURO= ? ", (Object)subburo);
        sql.append("or  b.SUBBURO = ? ) ", (Object)subburo);
        sql.append(" group by a.id ");
        sql.append("order by a.stationNo asc ");
        if (start == 1) {
            sql.append(" limit 0,10 ");
        } else {
            sql.append(" limit ? ", (Object)((start - 1) * 10));
            sql.append(" ,10 ");
        }
        this.logger.debug("============================queryStation==============" + map.get("schemeType"));
        try {
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
            this.logger.debug("============================list.toString()==============" + list.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int getChargeStationCount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        sql.append(" select count(1) from (select count(1) from cisp_dev.dev_ebikechargestation a left join cisp_dev.dev_powersystemresource b on a.id=b.id");
        sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.id=c.chargestationId ");
        sql.append(" left join ebike.ebike_cs_bs_rela f on (f.chargestationId=a.ID) left JOIN ebike.ebike_billingscheme d on (f.schemeId=d.schemeId) where 1=1 ");
        sql.append(" and c.CHARGEDEVICENO like?", (Object)("%" + map.get("stationNo") + "%"));
        sql.append(" and b.NAME like ?", (Object)("%" + map.get("stationName") + "%"));
        sql.append(" and b.STATUS=?", (Object)map.get("status"));
        sql.append(" and d.schemeType=?", (Object)map.get("schemeType"));
        sql.append(" and d.isReturn=?", (Object)map.get("isReturn"));
        sql.append(" and d.schemeName like ?", (Object)("%" + map.get("schemeName") + "%"));
        sql.append(" and ( b.BURO= ? ", (Object)subburo);
        sql.append("or  b.SUBBURO = ? ) ", (Object)subburo);
        sql.append(" group by a.id ");
        sql.append(" ) r");
        this.logger.debug("getChargeStationCount=" + sql.toString());
        try {
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public boolean deleteStation(String ids) {
        if (ids == null || "".equals(ids)) {
            return false;
        }
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" delete from cisp_dev.dev_ebikechargestation where ID in (?) ", (Object)ids, ",");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("deleteStation=" + sql.toString());
            }
            this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean checkStationNoExist(String stationNo, String subburo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" select count(1) from cisp_dev.dev_ebikechargestation a left join cisp_dev.dev_powersystemresource t on a.id=t.id where 1=1 ");
            sql.append(" and a.STATIONNO = ? ", (Object)stationNo);
            sql.append(" and (t.SUBBURO=? ", (Object)subburo);
            sql.append(" or t.BURO =? )", (Object)subburo);
            results = (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
            this.logger.debug(">>>>>>>>>>>>checkStationNoExist<<<<<<<<<<<<<<" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    @Override
    public boolean checkResult(String id) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int result = 0;
        try {
            sql.append(" select count(1) from ebike.ebike_chargerecord_his where 1=1 ");
            sql.append(" and chargestationId=?", (Object)id);
            this.logger.debug("<<<<<<<<<<<<<<>checkResult>>>>>>>>>>>>>>>" + sql.toString());
            this.logger.debug("<<<<<<<<<<<<<<>checkResult>>>>>>>>>>>>>>>" + sql.toString());
            result = (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return result > 0;
    }

    @Override
    public boolean deleteRela(String ids) {
        this.logger.debug("ids========================" + ids);
        if (ids == null || "".equals(ids)) {
            return false;
        }
        this.deleteOpRela(ids);
        this.deleteCsRela(ids);
        this.deleteShRela(ids);
        SqlParamsBuilder sql = new SqlParamsBuilder();
        sql.append(" delete from ebike.ebike_cs_bs_rela  where chargestationId in (?) ", (Object)ids, ",");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">>>>>>>>>>>>>>>>>>deleopperson<<<<<<<<<<<<<<<<<=" + sql.toString());
        }
        try {
            this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void deleteOpRela(String ids) {
        this.logger.debug("ids========================" + ids);
        SqlParamsBuilder sql = new SqlParamsBuilder();
        sql.append(" delete from ebike.ebike_cs_op_rela  where chargestationId in (?) ", (Object)ids, ",");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">>>>>>>>>>>>>>>>>>deleopperson<<<<<<<<<<<<<<<<<=" + sql.toString());
        }
        try {
            this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteCsRela(String ids) {
        this.logger.debug("ids========================" + ids);
        SqlParamsBuilder sql = new SqlParamsBuilder();
        sql.append(" delete from ebike.ebike_cs_cs_rela  where chargestationId in (?) ", (Object)ids, ",");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">>>>>>>>>>>>>>>>>>deleopperson<<<<<<<<<<<<<<<<<=" + sql.toString());
        }
        try {
            this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteShRela(String ids) {
        this.logger.debug("ids========================" + ids);
        SqlParamsBuilder sql = new SqlParamsBuilder();
        sql.append(" delete from ebike.ebike_cs_sh_rela  where chargestationId in (?) ", (Object)ids, ",");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">>>>>>>>>>>>>>>>>>deleopperson<<<<<<<<<<<<<<<<<=" + sql.toString());
        }
        try {
            this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map<String, Object> getSchemeNameById(String id) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List list = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            sql.append(" select  a.schemeName ,a.schemeId  from ebike.ebike_billingscheme a  ");
            sql.append(" left join ebike.ebike_cs_bs_rela b on a.schemeId=b.schemeId where 1=1 ");
            sql.append(" and b.chargestationId=?", (Object)id);
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return map;
        }
        if (list.size() > 0 && list != null) {
            return (Map)list.get(0);
        }
        return map;
    }

    @Override
    public List<Map<String, Object>> getStationFwfData(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        String type = map.get("type");
        try {
            if ("1".equals(type)) {
                sql.append(" SELECT '\u7535\u52a8\u81ea\u884c\u8f66\u7535\u6869' as type, ecs.id AS chargestationId, ecs.stationNo AS chargestationNo, pss.name AS chargestationName,org.org_name as orgName,ecs.STATIONADDR,pss.STATUS,GROUP_CONCAT(dev.CHARGEDEVICENO) as deviceNo ");
                sql.append(" , oo.serviceRate AS orgDefServiceRate, ecc.serviceRate AS csServiceRate ");
                sql.append("  , IFNULL(ecc.serviceRate, IFNULL(oo.serviceRate, 0.0)) AS serviceRate,ecc.minServiceMoney  ");
                sql.append(" FROM cisp_dev.dev_ebikechargestation ecs ");
                sql.append("  INNER JOIN cisp_dev.dev_powersystemresource pss ON pss.id = ecs.id AND pss.className = 'EBikeChargeStation' ");
                sql.append(" LEFT JOIN ebike.ebike_orgopr oo ON oo.subburo = pss.subburo ");
                sql.append(" LEFT JOIN ebike.ebike_cssr_config ecc ON ecc.chargestationId = ecs.id  ");
                sql.append("   LEFT JOIN cisp_sys.bp_org org on pss.subburo=org.org_no ");
                sql.append(" left join cisp_dev.dev_ebikechargedevice dev on ecs.id=dev.CHARGESTATIONID where 1=1 ");
                sql.append(" and pss.subburo=? ", (Object)map.get("orgNo"));
                sql.append(" and ecs.stationNo like ? ", (Object)("%" + map.get("stationNo") + "%"));
                sql.append(" and pss.name like ? ", (Object)("%" + map.get("stationName") + "%"));
                sql.append(" and pss.STATUS=? ", (Object)map.get("stationStatus"));
                sql.append(" and dev.CHARGEDEVICENO like ? ", (Object)("%" + map.get("chargestationNo") + "%"));
                sql.append(" group by ecs.ID ");
                sql.append(" union all ");
                sql.append(" select '\u7535\u52a8\u6c7d\u8f66\u7535\u6869' as type, ");
                sql.append(" ecs.id AS chargestationId, ");
                sql.append(" ecs.charging_station_no AS chargestationNo, ");
                sql.append(" ecs.charging_station_name AS chargestationName, ");
                sql.append(" org.org_name AS orgName, ");
                sql.append(" ecs.charging_station_addr AS STATIONADDR, ");
                sql.append(" ecs.charging_station_status AS STATUS, ");
                sql.append(" GROUP_CONCAT( dev.charging_pile_no ) AS deviceNo, ");
                sql.append(" oo.serviceRate AS orgDefServiceRate, ");
                sql.append(" ecc.serviceRate AS csServiceRate, ");
                sql.append(" IFNULL( ecc.serviceRate, IFNULL( oo.serviceRate, 0.0 ) ) AS serviceRate, ");
                sql.append(" ecc.minServiceMoney  ");
                sql.append(" from ");
                sql.append(" ebike.oper_ev_charging_station ecs ");
                sql.append(" LEFT JOIN ebike.ebike_orgopr oo ON oo.subburo = ecs.org_no ");
                sql.append(" LEFT JOIN ebike.ebike_cssr_config ecc ON ecc.chargestationId = ecs.id ");
                sql.append(" LEFT JOIN cisp_sys.bp_org org ON ecs.org_no = org.org_no ");
                sql.append(" left join ebike.dev_ev_charging_pile dev on ecs.id=dev.charging_station_id ");
                sql.append(" where true ");
                sql.append(" and ecs.org_no = ? ", (Object)map.get("orgNo"));
                sql.append(" and ecs.charging_station_no like ? ", (Object)("%" + map.get("stationNo") + "%"));
                sql.append(" and ecs.charging_station_name like ? ", (Object)("%" + map.get("stationName") + "%"));
                sql.append(" and ecs.charging_station_status=? ", (Object)map.get("stationStatus"));
                sql.append(" and dev.CHARGEDEVICENO like ? ", (Object)("%" + map.get("chargestationNo") + "%"));
                sql.append(" group by ecs.ID ");
            } else if ("2".equals(type)) {
                sql.append(" SELECT '\u7535\u52a8\u81ea\u884c\u8f66\u7535\u6869' as type,ecs.id AS chargestationId, ecs.stationNo AS chargestationNo, pss.name AS chargestationName,org.org_name as orgName,ecs.STATIONADDR,pss.STATUS,GROUP_CONCAT(dev.CHARGEDEVICENO) as deviceNo ");
                sql.append(" , oo.serviceRate AS orgDefServiceRate, ecc.serviceRate AS csServiceRate ");
                sql.append("  , IFNULL(ecc.serviceRate, IFNULL(oo.serviceRate, 0.0)) AS serviceRate,ecc.minServiceMoney  ");
                sql.append(" FROM cisp_dev.dev_ebikechargestation ecs ");
                sql.append("  INNER JOIN cisp_dev.dev_powersystemresource pss ON pss.id = ecs.id AND pss.className = 'EBikeChargeStation' ");
                sql.append(" LEFT JOIN ebike.ebike_orgopr oo ON oo.subburo = pss.subburo ");
                sql.append(" LEFT JOIN ebike.ebike_cssr_config ecc ON ecc.chargestationId = ecs.id  ");
                sql.append("   LEFT JOIN cisp_sys.bp_org org on pss.subburo=org.org_no ");
                sql.append(" left join cisp_dev.dev_ebikechargedevice dev on ecs.id=dev.CHARGESTATIONID where 1=1 ");
                sql.append(" and pss.subburo=? ", (Object)map.get("orgNo"));
                sql.append(" and ecs.stationNo like ? ", (Object)("%" + map.get("stationNo") + "%"));
                sql.append(" and pss.name like ? ", (Object)("%" + map.get("stationName") + "%"));
                sql.append(" and pss.STATUS=? ", (Object)map.get("stationStatus"));
                sql.append(" and dev.CHARGEDEVICENO like ? ", (Object)("%" + map.get("chargestationNo") + "%"));
                sql.append(" group by ecs.ID ");
            } else if ("3".equals(type)) {
                sql.append(" select '\u7535\u52a8\u6c7d\u8f66\u7535\u6869' as type,");
                sql.append(" ecs.id AS chargestationId, ");
                sql.append(" ecs.charging_station_no AS chargestationNo, ");
                sql.append(" ecs.charging_station_name AS chargestationName, ");
                sql.append(" org.org_name AS orgName, ");
                sql.append(" ecs.charging_station_addr AS STATIONADDR, ");
                sql.append(" ecs.charging_station_status AS STATUS, ");
                sql.append(" GROUP_CONCAT( dev.charging_pile_no ) AS deviceNo, ");
                sql.append(" oo.serviceRate AS orgDefServiceRate, ");
                sql.append(" ecc.serviceRate AS csServiceRate, ");
                sql.append(" IFNULL( ecc.serviceRate, IFNULL( oo.serviceRate, 0.0 ) ) AS serviceRate, ");
                sql.append(" ecc.minServiceMoney  ");
                sql.append(" from ");
                sql.append(" ebike.oper_ev_charging_station ecs ");
                sql.append(" LEFT JOIN ebike.ebike_orgopr oo ON oo.subburo = ecs.org_no ");
                sql.append(" LEFT JOIN ebike.ebike_cssr_config ecc ON ecc.chargestationId = ecs.id ");
                sql.append(" LEFT JOIN cisp_sys.bp_org org ON ecs.org_no = org.org_no ");
                sql.append(" left join ebike.dev_ev_charging_pile dev on ecs.id=dev.charging_station_id ");
                sql.append(" where true ");
                sql.append(" and ecs.org_no = ? ", (Object)map.get("orgNo"));
                sql.append(" and ecs.charging_station_no like ? ", (Object)("%" + map.get("stationNo") + "%"));
                sql.append(" and ecs.charging_station_name like ? ", (Object)("%" + map.get("stationName") + "%"));
                sql.append(" and ecs.charging_station_status=? ", (Object)map.get("stationStatus"));
                sql.append(" and dev.CHARGEDEVICENO like ? ", (Object)("%" + map.get("chargestationNo") + "%"));
                sql.append(" group by ecs.ID ");
            }
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("type", rs.getString("type"));
                    map.put("chargestationId", rs.getLong("chargestationId"));
                    map.put("chargestationNo", rs.getString("chargestationNo"));
                    map.put("chargestationName", rs.getString("chargestationName"));
                    map.put("orgName", rs.getString("orgName"));
                    map.put("STATIONADDR", rs.getString("STATIONADDR"));
                    map.put("STATUS", rs.getString("STATUS"));
                    map.put("deviceNo", rs.getString("deviceNo"));
                    map.put("minServiceMoney", rs.getDouble("minServiceMoney"));
                    map.put("csServiceRate", rs.getDouble("serviceRate"));
                    return map;
                }
            });
            this.logger.debug(">>>>>>>>>>>>getStationFwfData<<<<<<<<<<<<<<" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int getStationFwfCount(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        SqlParamsBuilder sql1 = null;
        SqlParamsBuilder sql2 = null;
        String type = map.get("type");
        try {
            if ("1".equals(type)) {
                sql1 = new SqlParamsBuilder();
                sql2 = new SqlParamsBuilder();
                sql1.append(" select count(1) from (select count(1)");
                sql1.append(" FROM cisp_dev.dev_ebikechargestation ecs ");
                sql1.append("  INNER JOIN cisp_dev.dev_powersystemresource pss ON pss.id = ecs.id AND pss.className = 'EBikeChargeStation' ");
                sql1.append(" LEFT JOIN ebike.ebike_orgopr oo ON oo.subburo = pss.subburo ");
                sql1.append(" LEFT JOIN ebike.ebike_cssr_config ecc ON ecc.chargestationId = ecs.id  ");
                sql1.append("   LEFT JOIN cisp_sys.bp_org org on pss.subburo=org.org_no ");
                sql1.append(" left join cisp_dev.dev_ebikechargedevice dev on ecs.id=dev.CHARGESTATIONID where 1=1 ");
                sql1.append(" and pss.subburo=? ", (Object)map.get("orgNo"));
                sql1.append(" and ecs.stationNo like ? ", (Object)("%" + map.get("stationNo") + "%"));
                sql1.append(" and pss.name like ? ", (Object)("%" + map.get("stationName") + "%"));
                sql1.append(" and pss.STATUS=? ", (Object)map.get("stationStatus"));
                sql1.append(" and dev.CHARGEDEVICENO like ? ", (Object)("%" + map.get("chargestationNo") + "%"));
                sql1.append(" group by ecs.ID ) n");
                sql2.append(" select count(1) from (select count(1)");
                sql2.append(" from ");
                sql2.append(" ebike.oper_ev_charging_station ecs ");
                sql2.append(" LEFT JOIN ebike.ebike_orgopr oo ON oo.subburo = ecs.org_no ");
                sql2.append(" LEFT JOIN ebike.ebike_cssr_config ecc ON ecc.chargestationId = ecs.id ");
                sql2.append(" LEFT JOIN cisp_sys.bp_org org ON ecs.org_no = org.org_no ");
                sql2.append(" left join ebike.dev_ev_charging_pile dev on ecs.id=dev.charging_station_id ");
                sql2.append(" where true ");
                sql2.append(" and ecs.org_no = ? ", (Object)map.get("orgNo"));
                sql2.append(" and ecs.charging_station_no like ? ", (Object)("%" + map.get("stationNo") + "%"));
                sql2.append(" and ecs.charging_station_name like ? ", (Object)("%" + map.get("stationName") + "%"));
                sql2.append(" and ecs.charging_station_status=? ", (Object)map.get("stationStatus"));
                sql2.append(" and dev.CHARGEDEVICENO like ? ", (Object)("%" + map.get("chargestationNo") + "%"));
                sql2.append(" group by ecs.ID ) n");
            } else if ("2".equals(type)) {
                sql.append(" select count(1) from (select count(1)");
                sql.append(" FROM cisp_dev.dev_ebikechargestation ecs ");
                sql.append("  INNER JOIN cisp_dev.dev_powersystemresource pss ON pss.id = ecs.id AND pss.className = 'EBikeChargeStation' ");
                sql.append(" LEFT JOIN ebike.ebike_orgopr oo ON oo.subburo = pss.subburo ");
                sql.append(" LEFT JOIN ebike.ebike_cssr_config ecc ON ecc.chargestationId = ecs.id  ");
                sql.append("   LEFT JOIN cisp_sys.bp_org org on pss.subburo=org.org_no ");
                sql.append(" left join cisp_dev.dev_ebikechargedevice dev on ecs.id=dev.CHARGESTATIONID where 1=1 ");
                sql.append(" and pss.subburo=? ", (Object)map.get("orgNo"));
                sql.append(" and ecs.stationNo like ? ", (Object)("%" + map.get("stationNo") + "%"));
                sql.append(" and pss.name like ? ", (Object)("%" + map.get("stationName") + "%"));
                sql.append(" and pss.STATUS=? ", (Object)map.get("stationStatus"));
                sql.append(" and dev.CHARGEDEVICENO like ? ", (Object)("%" + map.get("chargestationNo") + "%"));
                sql.append(" group by ecs.ID ) n");
            } else if ("3".equals(type)) {
                sql.append(" select count(1) from (select count(1)");
                sql.append(" from ");
                sql.append(" ebike.oper_ev_charging_station ecs ");
                sql.append(" LEFT JOIN ebike.ebike_orgopr oo ON oo.subburo = ecs.org_no ");
                sql.append(" LEFT JOIN ebike.ebike_cssr_config ecc ON ecc.chargestationId = ecs.id ");
                sql.append(" LEFT JOIN cisp_sys.bp_org org ON ecs.org_no = org.org_no ");
                sql.append(" left join ebike.dev_ev_charging_pile dev on ecs.id=dev.charging_station_id ");
                sql.append(" where true ");
                sql.append(" and ecs.org_no = ? ", (Object)map.get("orgNo"));
                sql.append(" and ecs.charging_station_no like ? ", (Object)("%" + map.get("stationNo") + "%"));
                sql.append(" and ecs.charging_station_name like ? ", (Object)("%" + map.get("stationName") + "%"));
                sql.append(" and ecs.charging_station_status=? ", (Object)map.get("stationStatus"));
                sql.append(" and dev.CHARGEDEVICENO like ? ", (Object)("%" + map.get("chargestationNo") + "%"));
                sql.append(" group by ecs.ID ) n");
            }
            if ("1".equals(type)) {
                return (Integer)this.ebikeJdbcTemplate.queryForObject(sql1.getSql(), sql1.getParams(), Integer.class) + (Integer)this.ebikeJdbcTemplate.queryForObject(sql2.getSql(), sql2.getParams(), Integer.class);
            }
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public boolean fwfAdd(String stationId, String stationfwf, String minServiceMoneys) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" replace into ebike.ebike_cssr_config(chargestationId,serviceRate,minServiceMoney,effTime)");
            sql.append(" values(?,?,?,?)");
            results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{stationId, Double.valueOf(stationfwf), Double.valueOf(minServiceMoneys), new Date()});
            results = this.selectCount(stationId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    public int selectCount(String stationId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" select count(1) from ebike.ebike_cssr_config where 1=1 ");
            sql.append(" and chargestationId=? ", (Object)stationId);
            results = (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
            results = results > 0 ? this.insertFwfLog(stationId, "10") : this.insertFwfLog(stationId, "20");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    public int insertFwfLog(String stationId, String logType) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" insert into ebike.ebike_log_cssr_config(chargestationId,logType,logTime)");
            sql.append(" values(?,?,?)");
            results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{stationId, logType, new Date()});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    @Override
    public List<Map<String, Object>> getOrgList() {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select subburo,orgoprName from ebike.ebike_orgopr ");
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
        }
        catch (Exception ex) {
            return list;
        }
        return list;
    }
}

