/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.oprmgmt.jdbcdao.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.easesource.commons.util.UuidUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.data.jdbc.SqlParamsBuilder;
import com.ebike.openservices.base.dao.AbstractEbikeBaseJdbcDao;
import com.ebike.openservices.oprmgmt.jdbcdao.ChargeFlszDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class ChargeFlszDaoImpl
extends AbstractEbikeBaseJdbcDao
implements ChargeFlszDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Qualifier(value="ebikeJdbcTemplate")
    private final JdbcTemplate ebikeJdbcTemplate;

    @Autowired
    public ChargeFlszDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public List<Map<String, Object>> querySchemInfo(String subburo, Map<String, String> map, int start) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append("select * from ebike.ebike_billingscheme b where 1=1");
            sql.append(" and b.closingPeriod=?", (Object)map.get("sclosingPeriod"));
            sql.append(" and b.schemeName like ?", (Object)("%" + map.get("schemeName") + "%"));
            sql.append(" and b.isReturn=?", (Object)map.get("isReturn"));
            sql.append(" and schemeType=?", (Object)map.get("schemeType"));
            sql.append(" and ( b.SUBBURO = ?", (Object)subburo);
            sql.append(" or b.BURO = ? ) ", (Object)subburo);
            sql.append(" and b.valid='T' ");
            sql.append("order by b.createTime asc ");
            if (start == 1) {
                sql.append(" limit 0,10 ");
            } else {
                int starts = (start - 1) * 10;
                int end = start * 10;
                sql.append(" limit ? ", (Object)starts);
                sql.append(" , 10 ");
            }
            this.logger.debug(sql.toString());
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (rs, rownum) -> {
                HashMap<String, Object> map1 = new HashMap<String, Object>();
                map1.put("schemeId", rs.getString("schemeId"));
                map1.put("schemeNo", rs.getString("schemeNo"));
                map1.put("schemeType", rs.getString("schemeType"));
                map1.put("unitPrice1", rs.getDouble("unitPrice1"));
                map1.put("unitPrice2", rs.getDouble("unitPrice2"));
                map1.put("unitPrice3", rs.getDouble("unitPrice3"));
                map1.put("unitPrice4", rs.getDouble("unitPrice4"));
                map1.put("stepPower1", rs.getInt("stepPower1"));
                map1.put("stepPower2", rs.getInt("stepPower2"));
                map1.put("stepPower3", rs.getInt("stepPower3"));
                map1.put("stepPower4", rs.getInt("stepPower4"));
                map1.put("schemeName", rs.getString("schemeName"));
                map1.put("minCharge", rs.getDouble("minCharge"));
                map1.put("isReturn", rs.getString("isReturn"));
                map1.put("schemeDetails", rs.getObject("schemeDetails"));
                if (rs.getInt("closingPeriod") == 0) {
                    map1.put("closingPeriod", "");
                } else {
                    map1.put("closingPeriod", rs.getInt("closingPeriod"));
                }
                return map1;
            });
            this.logger.debug(">>>>>>>>>>>>getSchemeInfo<<<<<<<<<<<<<<" + sql.toString());
        }
        catch (Exception ex) {
            return list;
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> selectSchemInfo(String subburo, Map<String, String> map, int start) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append("select * from ebike.ebike_billingscheme b where 1=1");
            sql.append(" and b.closingPeriod=?", (Object)map.get("sclosingPeriod"));
            sql.append(" and b.schemeName like ?", (Object)("%" + map.get("schemeName") + "%"));
            sql.append(" and b.isReturn=?", (Object)map.get("isReturn"));
            sql.append(" and b.schemeType=?", (Object)map.get("schemeType"));
            sql.append(" and ( b.SUBBURO = ?", (Object)subburo);
            sql.append(" or b.BURO = ? ", (Object)subburo);
            sql.append(" or b.SUBBURO = '000000000')");
            sql.append(" and b.valid='T' ");
            sql.append("order by b.schemeNo asc ");
            if (start == 1) {
                sql.append(" limit 0,5 ");
            } else {
                int starts = (start - 1) * 5;
                int end = start * 10;
                sql.append(" limit ? ", (Object)starts);
                sql.append(" , 5 ");
            }
            this.logger.debug(sql.toString());
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (rs, rownum) -> {
                HashMap<String, Object> map1 = new HashMap<String, Object>();
                map1.put("schemeId", rs.getString("schemeId"));
                map1.put("schemeNo", rs.getString("schemeNo"));
                if ("01".equals(rs.getString("schemeType"))) {
                    map1.put("schemeType", "\u8ba1\u65f6");
                } else if ("03".equals(rs.getString("schemeType"))) {
                    map1.put("schemeType", "\u8ba1\u6b21");
                } else if ("02".equals(rs.getString("schemeType"))) {
                    map1.put("schemeType", "\u8ba1\u7535\u91cf");
                } else {
                    map1.put("schemeType", "\u8ba1\u7535\u91cf+\u8ba1\u65f6\uff08\u9636\u68af\u529f\u7387\uff09");
                }
                String powerAndPrice1 = "";
                if ("03".equals(rs.getString("schemeType"))) {
                    powerAndPrice1 = rs.getDouble("unitPrice1") + "\u5143/\u6b21";
                } else if ("05".equals(rs.getString("schemeType"))) {
                    Object schemeDetails = rs.getObject("schemeDetails");
                    String elecCost = JSONUtil.parseObj((Object)schemeDetails).getStr((Object)"elec_cost");
                    powerAndPrice1 = "\u7535\u5ea6\u7535\u4ef7\uff1a" + elecCost + "\u5143/\u5c0f\u65f6\uff0c\u670d\u52a1\u8d39\uff1a 0 W\uff5e" + rs.getInt("stepPower1") + " W  \uff1a " + rs.getDouble("unitPrice1") + " \u5143/\u5c0f\u65f6 \uff0c" + rs.getInt("stepPower1") + " W \uff5e" + rs.getInt("stepPower2") + " W \uff1a " + rs.getDouble("unitPrice2") + " \u5143/\u5c0f\u65f6 \uff0c" + rs.getInt("stepPower2") + " W \uff5e" + rs.getInt("stepPower3") + " W \uff1a " + rs.getDouble("unitPrice3") + " \u5143/\u5c0f\u65f6 \uff0c" + rs.getInt("stepPower3") + " W \uff5e \u221e  \uff1a " + rs.getDouble("unitPrice4") + " \u5143/\u5c0f\u65f6";
                } else {
                    powerAndPrice1 = " 0 W\uff5e" + String.valueOf(rs.getInt("stepPower1")) + " W  \uff1a " + rs.getDouble("unitPrice1") + " \u5c0f\u65f6/\u5143 \uff0c" + rs.getInt("stepPower1") + " W \uff5e" + rs.getInt("stepPower2") + " W \uff1a " + rs.getDouble("unitPrice2") + " \u5c0f\u65f6/\u5143 \uff0c" + rs.getInt("stepPower2") + " W \uff5e" + rs.getInt("stepPower3") + " W \uff1a " + rs.getDouble("unitPrice3") + " \u5c0f\u65f6/\u5143 \uff0c" + rs.getInt("stepPower3") + " W \uff5e \u221e  \uff1a " + rs.getDouble("unitPrice4") + " \u5c0f\u65f6/\u5143";
                }
                map1.put("schemeInfo", powerAndPrice1);
                map1.put("schemeName", rs.getString("schemeName"));
                map1.put("minCharge", rs.getDouble("minCharge"));
                map1.put("isReturn", rs.getString("isReturn"));
                map1.put("schemeDetails", rs.getObject("schemeDetails"));
                if (rs.getInt("closingPeriod") == 0) {
                    map1.put("closingPeriod", "");
                } else {
                    map1.put("closingPeriod", rs.getInt("closingPeriod"));
                }
                return map1;
            });
            this.logger.debug(">>>>>>>>>>>>getSchemeInfo<<<<<<<<<<<<<<" + sql);
        }
        catch (Exception ex) {
            return list;
        }
        return list;
    }

    @Override
    public int selectSchemCount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append("select count(1) from ebike.ebike_billingscheme a where 1=1 ");
            sql.append(" and ( a.SUBBURO = ?", (Object)subburo);
            sql.append(" or a.BURO = ? ", (Object)subburo);
            sql.append(" or a.SUBBURO = '000000000')");
            sql.append(" and a.closingPeriod=?", (Object)map.get("sclosingPeriod"));
            sql.append(" and a.schemeName like ?", (Object)("%" + map.get("schemeName") + "%"));
            sql.append(" and a.isReturn=?", (Object)map.get("isReturn"));
            sql.append(" and a.schemeType=?", (Object)map.get("schemeType"));
            sql.append(" and a.valid='T' ");
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public List<Map<String, Object>> queryChargeflList(String subburo, Map<String, String> map, int start, int limit) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append("select * from ebike.ebike_billingscheme b where 1=1");
            sql.append(" and b.schemeType=?", (Object)map.get("schemeType"));
            sql.append(" and b.schemeName like ?", (Object)("%" + map.get("schemeName") + "%"));
            sql.append(" and b.isReturn=?", (Object)map.get("isReturn"));
            sql.append(" and ( b.SUBBURO = ?", (Object)subburo);
            sql.append(" or b.BURO = ? ", (Object)subburo);
            sql.append(" or b.SUBBURO = '000000000')", (Object)subburo);
            sql.append(" and b.valid='T' ");
            sql.append("order by b.schemeNo");
            if (start != -1 && limit != -1) {
                sql.append(" limit ? ", (Object)start);
                sql.append(" , ? ", (Object)limit);
            }
            this.logger.debug(sql.toString());
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
        }
        catch (Exception ex) {
            return list;
        }
        return list;
    }

    @Override
    public int getflCount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append("select count(1) from ebike.ebike_billingscheme b where 1=1");
            sql.append(" and b.schemeType=?", (Object)map.get("schemeType"));
            sql.append(" and b.schemeName like ?", (Object)("%" + map.get("schemeName") + "%"));
            sql.append(" and b.isReturn=?", (Object)map.get("isReturn"));
            sql.append(" and ( b.SUBBURO = ?", (Object)subburo);
            sql.append(" or b.BURO = ? ", (Object)subburo);
            sql.append(" or b.SUBBURO = '000000000')");
            sql.append(" and b.valid='T' ");
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public int querySchemCount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append("select count(1) from ebike.ebike_billingscheme a where 1=1 ");
            sql.append(" and ( a.SUBBURO=?", (Object)subburo);
            sql.append(" or a.BURO=? )", (Object)subburo);
            sql.append(" and a.closingPeriod=?", (Object)map.get("sclosingPeriod"));
            sql.append(" and a.schemeName like ?", (Object)("%" + map.get("schemeName") + "%"));
            sql.append(" and a.isReturn=?", (Object)map.get("isReturn"));
            sql.append(" and schemeType=?", (Object)map.get("schemeType"));
            sql.append(" and a.valid='T' ");
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public boolean deleteflMode(String ids) {
        this.logger.debug("ids========================" + ids);
        if (ids == null || "".equals(ids)) {
            return false;
        }
        int results = 0;
        try {
            SqlParamsBuilder sql = new SqlParamsBuilder();
            sql.append("update ebike.ebike_billingscheme set valid='F' where 1=1");
            sql.append(" and schemeId in (?) ", (Object)ids, ",");
            results = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return results > 0;
    }

    @Override
    public Map<String, Object> getflModeDataById(String id) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List list = new ArrayList();
        try {
            sql.append("select * from ebike.ebike_billingscheme where 1=1");
            sql.append(id, (Object)" and schemeId=?");
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new ChargeflRowMapper());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return map;
        }
        if (list != null && list.size() > 0) {
            return (Map)list.get(0);
        }
        return map;
    }

    @Override
    public boolean addScheme(Map<String, String> map, String subburo, String orgName) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        String uuid = UuidUtils.generateUuidString();
        try {
            if ("01".equals(map.get("billingType"))) {
                if (!"".equals(map.get("addClosingPeriod"))) {
                    sql.append("insert into ebike.ebike_billingscheme");
                    sql.append("(schemeId,schemeNo,schemeName,buro,subburo,schemeType,unitPrice1,unitPrice2,unitPrice3,unitPrice4,stepCount");
                    sql.append(" ,stepPower1,stepPower2,stepPower3,minCharge,isReturn,closingPeriod,valid,creator,createTime)");
                    sql.append("values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{uuid, map.get("billingNo"), map.get("schemeName"), subburo, subburo, "01", map.get("unitPrice1"), map.get("unitPrice2"), map.get("unitPrice3"), map.get("unitPrice4"), 4, map.get("stepPower1"), map.get("stepPower2"), map.get("stepPower3"), map.get("minCharge"), map.get("addIsReturn"), map.get("addClosingPeriod"), "T", orgName, new Date()});
                } else {
                    sql.append("insert into ebike.ebike_billingscheme");
                    sql.append("(schemeId,schemeNo,schemeName,buro,subburo,schemeType,unitPrice1,unitPrice2,unitPrice3,unitPrice4,stepCount");
                    sql.append(" ,stepPower1,stepPower2,stepPower3,minCharge,isReturn,valid,creator,createTime)");
                    sql.append("values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{uuid, map.get("billingNo"), map.get("schemeName"), subburo, subburo, "01", map.get("unitPrice1"), map.get("unitPrice2"), map.get("unitPrice3"), map.get("unitPrice4"), 4, map.get("stepPower1"), map.get("stepPower2"), map.get("stepPower3"), map.get("minCharge"), map.get("addIsReturn"), "T", orgName, new Date()});
                }
            } else if ("02".equals(map.get("billingType"))) {
                sql.append("insert into ebike.ebike_billingscheme");
                sql.append("(schemeId,schemeNo,schemeName,buro,subburo,schemeType,minCharge,unitPrice1,closingPeriod,schemeDetails,");
                sql.append("isReturn,valid,creator,createTime)");
                sql.append("values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{uuid, map.get("billingNo"), map.get("schemeName"), subburo, subburo, "02", map.get("minCharge"), map.get("unitPrice"), map.get("addClosingPeriod"), map.get("schemeDetails"), "Y", "T", orgName, new Date()});
            } else if ("05".equals(map.get("billingType"))) {
                sql.append("insert into ebike.ebike_billingscheme");
                sql.append("(schemeId,schemeNo,schemeName,buro,subburo,schemeType,unitPrice1,unitPrice2,unitPrice3,unitPrice4,stepCount");
                sql.append(" ,stepPower1,stepPower2,stepPower3,minCharge,isReturn,closingPeriod,schemeDetails,valid,creator,createTime)");
                sql.append("values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{uuid, map.get("billingNo"), map.get("schemeName"), subburo, subburo, "05", map.get("unitPrice1"), map.get("unitPrice2"), map.get("unitPrice3"), map.get("unitPrice4"), 4, map.get("stepPower1"), map.get("stepPower2"), map.get("stepPower3"), map.get("minCharge"), map.get("addIsReturn"), map.get("addClosingPeriod"), map.get("schemeDetails"), "T", orgName, new Date()});
            } else {
                sql.append("insert into ebike.ebike_billingscheme");
                sql.append("(schemeId,schemeNo,schemeName,buro,subburo,schemeType,unitPrice1,");
                sql.append("isReturn,valid,creator,createTime)");
                sql.append("values(?,?,?,?,?,?,?,?,?,?,?)");
                results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{uuid, map.get("billingNo"), map.get("schemeName"), subburo, subburo, "03", map.get("unitPrice"), "N", "T", orgName, new Date()});
            }
            this.logger.debug(" ========insertFl=========" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    @Override
    public boolean modifyScheme(Map<String, String> map, String subburo, String orgName) {
        Map<String, Object> maps = this.getScheInfoById(map.get("schemeId"));
        this.logger.debug(">>>>>>>>getScheInfoById><<<<<<<<<<<<<" + maps.toString());
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            if ("01".equals(map.get("billingType"))) {
                if (!"".equals(map.get("addClosingPeriod"))) {
                    this.logger.debug(">>>>>>>>>>>>>>modifyScheme1<<<<<<<<<<<" + subburo);
                    sql.append("replace into ebike.ebike_billingscheme");
                    sql.append("(schemeId,schemeNo,schemeName,buro,subburo,schemeType,unitPrice1,unitPrice2,unitPrice3,unitPrice4,stepCount");
                    sql.append(" ,stepPower1,stepPower2,stepPower3,minCharge,isReturn,closingPeriod,valid,creator,createTime,updater,updateTime)");
                    sql.append("values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{map.get("schemeId"), map.get("billingNo"), map.get("schemeName"), subburo, subburo, map.get("billingType"), map.get("unitPrice1"), map.get("unitPrice2"), map.get("unitPrice3"), map.get("unitPrice4"), 4, map.get("stepPower1"), map.get("stepPower2"), map.get("stepPower3"), map.get("minCharge"), map.get("addIsReturn"), map.get("addClosingPeriod"), "T", maps.get("creator"), maps.get("createTime"), orgName, new Date()});
                } else {
                    sql.append("replace into ebike.ebike_billingscheme");
                    sql.append("(schemeId,schemeNo,schemeName,buro,subburo,schemeType,unitPrice1,unitPrice2,unitPrice3,unitPrice4,stepCount");
                    sql.append(" ,stepPower1,stepPower2,stepPower3,minCharge,isReturn,valid,creator,createTime,updater,updateTime)");
                    sql.append("values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{map.get("schemeId"), map.get("billingNo"), map.get("schemeName"), subburo, subburo, map.get("billingType"), map.get("unitPrice1"), map.get("unitPrice2"), map.get("unitPrice3"), map.get("unitPrice4"), 4, map.get("stepPower1"), map.get("stepPower2"), map.get("stepPower3"), map.get("minCharge"), map.get("addIsReturn"), "T", maps.get("creator"), maps.get("createTime"), orgName, new Date()});
                }
            } else if ("02".equals(map.get("billingType"))) {
                sql.append("  update ebike.ebike_billingscheme set schemeType='02' ");
                sql.append(" ,isReturn='Y' ");
                sql.append(" ,schemeName =?", (Object)map.get("schemeName"));
                sql.append(" ,closingPeriod =?", (Object)map.get("addClosingPeriod"));
                sql.append(",updater=? ", (Object)orgName);
                sql.append(" ,unitPrice1=? ", (Object)map.get("unitPrice"));
                sql.append(" ,minCharge=? ", (Object)map.get("minCharge"));
                sql.append(" ,schemeDetails=? ", (Object)map.get("schemeDetails"));
                sql.append(" ,updateTime=? ", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                sql.append(" where 1=1 ");
                sql.append(" and schemeId=? ", (Object)map.get("schemeId"));
                results = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            } else if ("05".equals(map.get("billingType"))) {
                sql.append("  update ebike.ebike_billingscheme set schemeType = '05' ");
                sql.append(" ,isReturn='Y' ");
                sql.append(" ,schemeName =?", (Object)map.get("schemeName"));
                sql.append(" ,closingPeriod =?", (Object)map.get("addClosingPeriod"));
                sql.append(",updater=? ", (Object)orgName);
                sql.append(" ,unitPrice1=? ", (Object)map.get("unitPrice1"));
                sql.append(" ,unitPrice2=? ", (Object)map.get("unitPrice2"));
                sql.append(" ,unitPrice3=? ", (Object)map.get("unitPrice3"));
                sql.append(" ,unitPrice4=? ", (Object)map.get("unitPrice4"));
                sql.append(" ,stepPower1=? ", (Object)map.get("stepPower1"));
                sql.append(" ,stepPower2=? ", (Object)map.get("stepPower2"));
                sql.append(" ,stepPower3=? ", (Object)map.get("stepPower3"));
                sql.append(" ,minCharge=? ", (Object)map.get("minCharge"));
                sql.append(" ,schemeDetails=? ", (Object)map.get("schemeDetails"));
                sql.append(" ,updateTime=? ", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                sql.append(" where 1=1 ");
                sql.append(" and schemeId=? ", (Object)map.get("schemeId"));
                results = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            } else {
                sql.append("  update ebike.ebike_billingscheme set schemeType='03',unitPrice2=0.00,unitPrice3=0.00,unitPrice4=0.00,stepCount=null, stepPower1=null,stepPower2=null,minCharge=null,closingPeriod=null");
                sql.append(" ,stepPower3=null,minCharge=0.00,isReturn='N',closingPeriod=null ");
                sql.append(" ,schemeName =?", (Object)map.get("schemeName"));
                sql.append(",updater=? ", (Object)orgName);
                sql.append(" ,unitPrice1=? ", (Object)map.get("unitPrice"));
                sql.append(" ,updateTime=? ", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                sql.append(" where 1=1 ");
                sql.append(" and schemeId=? ", (Object)map.get("schemeId"));
                results = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            }
            this.logger.debug(" ========modifyScheme=========" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    public Map<String, Object> getScheInfoById(String id) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List list = new ArrayList();
        HashMap<String, Object> maps = new HashMap<String, Object>();
        try {
            sql.append("select creator,createTime,subburo from ebike.ebike_billingscheme b where 1=1");
            sql.append(" and schemeId=?", (Object)id);
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return maps;
        }
        if (list.size() > 0 && list != null) {
            return (Map)list.get(0);
        }
        return maps;
    }

    @Override
    public boolean updateFl(String id, String schemeNo, String subburo, String schemeName, String schemeType, String isReturn, double unitPrice1, double unitPrice2, double unitPrice3, double dj, double minimumCharge, String name) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append("update ebike.ebike_billingscheme set ");
            sql.append("schemeNo = ?", (Object)schemeNo);
            sql.append(" ,schemeName=?", (Object)schemeName);
            sql.append(" ,schemeType=?", (Object)schemeType);
            sql.append(" ,unitPrice1=?", (Object)String.valueOf(unitPrice1));
            sql.append(" ,unitPrice2=?", (Object)String.valueOf(unitPrice2));
            sql.append(" ,unitPrice3=?", (Object)String.valueOf(unitPrice3));
            sql.append(" ,minCharge=?", (Object)String.valueOf(minimumCharge));
            sql.append(" ,isReturn=?", (Object)isReturn);
            sql.append(" ,updater=?", (Object)name);
            sql.append(" ,updateTime=?", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            sql.append(" where 1=1 ");
            sql.append(" and  schemeId=?", (Object)id);
            sql.append(" and ( buro=?", (Object)subburo);
            sql.append(" or subburo=? )", (Object)subburo);
            results = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            this.logger.debug(" ========UpdateFl=========" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    @Override
    public String getbh(String subburo, String schemeType) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String flawNo = "";
        try {
            sql.append("select max(cast(SUBSTRING(schemeNo,4)  as SIGNED INTEGER )) from ebike.ebike_billingscheme where 1=1 and  schemeNo not in ('FREE') ");
            sql.append(" and ( subburo=?", (Object)subburo);
            sql.append(" or buro = ? )", (Object)subburo);
            String maxFlawNo = (String)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), String.class);
            this.logger.debug(">>>>>>>>>>>>>maxFlawNo<<<<<<<<<<<<<<" + maxFlawNo);
            if (maxFlawNo == null || "".equals(maxFlawNo)) {
                flawNo = StrUtil.equals((CharSequence)schemeType, (CharSequence)"01") ? "JS-000001" : (StrUtil.equals((CharSequence)schemeType, (CharSequence)"02") ? "JL-000001" : (StrUtil.equals((CharSequence)schemeType, (CharSequence)"05") ? "JP-000001" : "JC-000001"));
                this.logger.debug(">>>>>>>>>>>>>flawNo<<<<<<<<<<<<<<" + flawNo);
            } else {
                flawNo = StrUtil.equals((CharSequence)schemeType, (CharSequence)"01") ? ChargeFlszDaoImpl.getNewEquipmentNo("JS-", maxFlawNo) : (StrUtil.equals((CharSequence)schemeType, (CharSequence)"02") ? ChargeFlszDaoImpl.getNewEquipmentNo("JL-", maxFlawNo) : (StrUtil.equals((CharSequence)schemeType, (CharSequence)"05") ? ChargeFlszDaoImpl.getNewEquipmentNo("JP-", maxFlawNo) : ChargeFlszDaoImpl.getNewEquipmentNo("JC-", maxFlawNo)));
                this.logger.debug(">>>>>>>>>>>>>flawNo1111<<<<<<<<<<<<<<" + flawNo);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return flawNo;
        }
        return flawNo;
    }

    public static String getNewEquipmentNo(String equipmentType, String equipmentNo) {
        String newEquipmentNo = "000001";
        if (equipmentNo != null && !equipmentNo.isEmpty()) {
            int newEquipment = Integer.parseInt(equipmentNo) + 1;
            newEquipmentNo = String.format(equipmentType + "%06d", newEquipment);
        }
        return newEquipmentNo;
    }

    public String getCostNextStr(String string) {
        String returnStr = "";
        String titlle = "";
        int no = 0;
        String[] a = string.split("-");
        for (int i = 0; i < a.length; ++i) {
            if (!"DJ".equals(a[i])) {
                no = Integer.parseInt(a[i]) + 1;
                continue;
            }
            titlle = a[i];
        }
        returnStr = titlle + "-" + String.valueOf(no);
        return returnStr;
    }

    private void getNextIndex(char[] chars, int cIndex) {
        char value = chars[cIndex];
        if (value == '9') {
            chars[cIndex] = 57;
            if (cIndex >= 1) {
                this.getNextIndex(chars, cIndex - 1);
            }
        } else {
            int n = cIndex;
            chars[n] = (char)(chars[n] + '\u0001');
        }
    }

    @Override
    public List<Map<String, Object>> queryStationflList(String subburo, Map<String, String> map, int start, int limit) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append("select  a.ID, a.stationNo,b.NAME,c.chargedeviceNo,b.STATUS,c.plugCount,d.schemeName,d.schemeId");
            sql.append(" from cisp_dev.dev_ebikechargestation a left join cisp_dev.dev_powersystemresource b on a.id=b.id");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.id=c.chargestationId ");
            sql.append(" left join ebike.ebike_cs_bs_rela f on (f.chargestationId=a.ID) left JOIN ebike.ebike_billingscheme d on (f.schemeId=d.schemeId) where 1=1 ");
            sql.append(" and a.stationNo like ?", (Object)("%" + map.get("stationNo") + "%"));
            sql.append(" and b.NAME like ?", (Object)("%" + map.get("name") + "%"));
            sql.append(" and ( b.SUBBURO=?", (Object)subburo);
            sql.append(" or b.BURO = ? )", (Object)subburo);
            if ("01".equals(map.get("devflsz"))) {
                sql.append(" and d.schemeId is not null");
            } else if ("02".equals(map.get("devflsz"))) {
                sql.append(" and d.schemeId is null");
            }
            if (start != -1 && limit != -1) {
                sql.append(" limit ? ", (Object)start);
                sql.append(" , ? ", (Object)limit);
            }
            this.logger.debug(sql.toString());
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
        }
        catch (Exception ex) {
            return list;
        }
        return list;
    }

    @Override
    public int getChargeStationflCount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from cisp_dev.dev_ebikechargestation a left join cisp_dev.dev_powersystemresource b on a.id=b.id");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.id=c.chargestationId ");
            sql.append(" left join ebike.ebike_cs_bs_rela f on (f.chargestationId=a.ID) left JOIN ebike.ebike_billingscheme d on (f.schemeId=d.schemeId) where 1=1 ");
            sql.append(" and a.stationNo like ?", (Object)("%" + map.get("stationNo") + "%"));
            sql.append(" and b.NAME like ?", (Object)("%" + map.get("name") + "%"));
            sql.append(" and ( b.SUBBURO=?", (Object)subburo);
            sql.append(" or b.BURO = ? )", (Object)subburo);
            if ("01".equals(map.get("devflsz"))) {
                sql.append(" and f.schemeId is not null");
            } else if ("02".equals(map.get("devflsz"))) {
                sql.append(" and f.schemeId is null");
            }
            this.logger.debug(">>>>>>>>>>>>>>>>>>>>>>getChargeStationflCount<<<<<<<<<<<<<<<<<<<<<<<" + sql.toString());
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public boolean addflsz(String schemeId, String stationId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append("replace into ebike.ebike_cs_bs_rela ");
            sql.append("(chargestationId,schemeId,effTime)");
            sql.append("values(?,?,?)");
            results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{stationId, schemeId, new Date()});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    @Override
    public boolean checkSchemeId(String schemeId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int result = 0;
        try {
            sql.append("select count(1) from ebike.ebike_csbs_info  where 1=1  and  (schemeId in (?) ", (Object)schemeId, ",");
            sql.append(" or newSchemeId in (?)) ", (Object)schemeId, ",");
            result = (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
            this.logger.debug(">>>>>>>>>>>>>>>>>>>>>checkSchemeId<<<<<<<<<<<<<<<<<" + result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return result > 0;
    }

    @Override
    public List<Map<String, Object>> queryStationCostList(String subburo, Map<String, String> map, int start, int limit) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select  a.ID, a.stationNo,b.NAME,c.chargedeviceNo,b.STATUS,c.plugCount,d.costSchemeId,d.costSchemeName ");
            sql.append(" from cisp_dev.dev_ebikechargestation a left join cisp_dev.dev_powersystemresource b on a.id=b.id");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.id=c.chargestationId ");
            sql.append(" left join ebike.ebike_cs_cs_rela f on (f.chargestationId=a.ID) left JOIN ebike.ebike_costscheme d on (f.costSchemeId=d.costSchemeId) where 1=1  ");
            sql.append(" and b.STATUS = ?", (Object)map.get("devStatus"));
            sql.append(" and c.chargedeviceNo like ?", (Object)("%" + map.get("devNo") + "%"));
            sql.append(" and ( b.SUBBURO=?", (Object)subburo);
            sql.append(" or b.BURO = ? )", (Object)subburo);
            if ("01".equals(map.get("cost"))) {
                sql.append(" and f.costSchemeId is not null");
            } else if ("02".equals(map.get("cost"))) {
                sql.append(" and f.costSchemeId is null");
            }
            if (start != -1 && limit != -1) {
                sql.append(" limit ? ", (Object)start);
                sql.append(" , ? ", (Object)limit);
            }
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
        }
        catch (Exception ex) {
            return list;
        }
        return list;
    }

    @Override
    public int getStationCostCount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from cisp_dev.dev_ebikechargestation a left join cisp_dev.dev_powersystemresource b on a.id=b.id");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.id=c.chargestationId ");
            sql.append(" left join ebike.ebike_cs_cs_rela f on (f.chargestationId=a.ID) left JOIN ebike.ebike_costscheme d on (f.costSchemeId=d.costSchemeId) where 1=1  ");
            sql.append(" and b.STATUS = ?", (Object)map.get("devStatus"));
            sql.append(" and c.chargedeviceNo like ?", (Object)("%" + map.get("devNo") + "%"));
            sql.append(" and ( b.SUBBURO=?", (Object)subburo);
            sql.append(" or b.BURO = ? )", (Object)subburo);
            if ("01".equals(map.get("cost"))) {
                sql.append(" and f.costSchemeId is not null");
            } else if ("02".equals(map.get("cost"))) {
                sql.append(" and f.costSchemeId is null");
            }
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public List<Map<String, Object>> queryCostList(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select  a.costSchemeId, a.costSchemeNo,a.costSchemeName,a.costUnitPrice");
            sql.append(" from ebike.ebike_costscheme a where 1=1 ");
            sql.append(" and a.costSchemeNo like ?", (Object)("%" + map.get("costNo") + "%"));
            sql.append(" and a.costSchemeName like ?", (Object)("%" + map.get("costName") + "%"));
            sql.append(" and ( a.SUBBURO = ?", (Object)subburo);
            sql.append(" or a.BURO = ? ", (Object)subburo);
            if ("0".equals(map.get("flag"))) {
                sql.append(" or a.SUBBURO = '000000000')");
            } else {
                sql.append(" ) ");
            }
            sql.append(" and a.valid='T' ");
            sql.append(" order by a.costSchemeNo");
            this.logger.debug(">>>>>>>>>>queryCostList111<<<<<<<<<<<<" + sql.toString());
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
            this.logger.debug(">>>>>>>>>>queryCostList<<<<<<<<<<<<" + sql.toString());
        }
        catch (Exception ex) {
            return list;
        }
        return list;
    }

    @Override
    public int getCostCount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebike.ebike_costscheme a where 1=1 ");
            sql.append(" and a.costSchemeNo like ?", (Object)("%" + map.get("costNo") + "%"));
            sql.append(" and a.costSchemeName like ?", (Object)("%" + map.get("costName") + "%"));
            sql.append(" and ( a.SUBBURO = ?", (Object)subburo);
            sql.append(" or a.BURO = ? ", (Object)subburo);
            sql.append(" or a.SUBBURO = '10')");
            sql.append(" and a.valid='T' ");
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public String getCostbh(String subburo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        boolean flowNum = false;
        String flawNo = "";
        try {
            sql.append("select max(cast(SUBSTRING(costSchemeNo,4)  as SIGNED INTEGER )) from ebike.ebike_costscheme where 1=1  and  costSchemeNo!='INIT' ");
            sql.append(" and ( subburo = ?", (Object)subburo);
            sql.append(" or buro = ? )", (Object)subburo);
            String maxFlawNo = (String)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), String.class);
            this.logger.debug(">>>>>>>>>>>>>maxFlawNo<<<<<<<<<<<<<<" + maxFlawNo);
            if (maxFlawNo == null || "".equals(maxFlawNo)) {
                flawNo = "DJ-000001";
                this.logger.debug(">>>>>>>>>>>>>flawNo<<<<<<<<<<<<<<" + flawNo);
            } else {
                flawNo = ChargeFlszDaoImpl.getNewEquipmentNo("DJ-", maxFlawNo);
                this.logger.debug(">>>>>>>>>>>>>flawNo1111<<<<<<<<<<<<<<" + flawNo);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return flawNo;
        }
        return flawNo;
    }

    @Override
    public boolean addStationCost(String costSchemeId, String stationId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" replace into ebike.ebike_cs_cs_rela ");
            sql.append("(chargestationId,costSchemeId,effTime)");
            sql.append("values(?,?,?)");
            results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{stationId, costSchemeId, new Date()});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    @Override
    public boolean insertCost(String id, String costSchemeNo, String subburo, String costSchemeName, double costUnitPrice, String name) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append("insert into ebike.ebike_costscheme");
            sql.append("(costSchemeId,buro,subburo,costSchemeNo,costSchemeName,costUnitPrice,creator,createTime)");
            sql.append("values(?,?,?,?,?,?,?,?)");
            results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{id, subburo, subburo, costSchemeNo, costSchemeName, costUnitPrice, name, new Date()});
            this.logger.debug(" ========UpdateFl=========" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    @Override
    public boolean updateCost(String id, String costSchemeNo, String subburo, String costSchemeName, double costUnitPrice, String name) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append("update ebike.ebike_costscheme set ");
            sql.append(" buro=? ", (Object)subburo);
            sql.append(" ,subburo=? ", (Object)subburo);
            sql.append(" ,costSchemeNo=? ", (Object)costSchemeNo);
            sql.append(" ,costSchemeName=? ", (Object)costSchemeName);
            sql.append(" ,costUnitPrice=? ", (Object)String.valueOf(costUnitPrice));
            sql.append(" ,updater=? ", (Object)name);
            sql.append(" ,updateTime=?", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy.MM.dd HH:mm:ss"));
            sql.append(" where costSchemeId=? ", (Object)id);
            results = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            this.logger.debug(" ========UpdateFl=========" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    @Override
    public boolean checkCostExist(String costSchemeId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append("select count(1) from ebike.ebike_cs_cs_rela c where 1=1 and costSchemeId in (?)", (Object)costSchemeId, ",");
            results = (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    @Override
    public boolean delCost(String costSchemeId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        if (costSchemeId == null || "".equals(costSchemeId)) {
            return false;
        }
        try {
            sql.append(" update ebike.ebike_costscheme set valid='F' where 1=1");
            sql.append(" and costSchemeId in (?)", (Object)costSchemeId, ",");
            this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteflById(String ids) {
        this.logger.debug("ids========================" + ids);
        if (ids == null || "".equals(ids)) {
            return false;
        }
        SqlParamsBuilder sql = new SqlParamsBuilder();
        sql.append(" delete from ebike.ebike_cs_bs_rela  where chargestationId in (?) ", (Object)ids, ",");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">>>>>>>>>>>>>>>>>>deleopperson<<<<<<<<<<<<<<<<<=" + sql.toString());
        }
        try {
            this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean checkNoExist(String schNo, String subburo) {
        int results = 0;
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebike.ebike_billingscheme where 1=1 ");
            sql.append(" and schemeNo=? ", (Object)schNo);
            sql.append(" and ( SUBBURO=?", (Object)subburo);
            sql.append(" or BURO = ? )", (Object)subburo);
            results = (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
            this.logger.debug(">>>>>>>>>>>>>>checkNoExist<<<<<<<<<<<<<<<<<<<<<<" + results);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    @Override
    public boolean checkCostNoExist(String costNo, String subburo) {
        int results = 0;
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebike.ebike_costscheme where 1=1 ");
            sql.append(" and costSchemeNo=? ", (Object)costNo);
            sql.append(" and ( SUBBURO=?", (Object)subburo);
            sql.append(" or BURO = ? )", (Object)subburo);
            results = (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
            this.logger.debug(">>>>>>>>>>>>>>checkNoExist<<<<<<<<<<<<<<<<<<<<<<" + results);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    @Override
    public boolean addCost(String uuid, String stationId, String orgName) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" insert into ebike.ebike_cscs_info(cscsId,chargestationId,cscsStatus,costSchemeId,effTime)");
            sql.append(" values(?,?,?,?,?)");
            results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{uuid, stationId, "00", "INIT", new Date()});
            results = this.addCostInfo(uuid, stationId);
            results = this.updateOpLog(uuid, orgName, "10", "00");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    public int addCostInfo(String uuid, String stationId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" insert into ebike.ebike_cs_cs_rela(chargestationId,costSchemeId,effTime)");
            sql.append(" values(?,?,?)");
            results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{stationId, uuid, new Date()});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    @Override
    public boolean addCsbsInfo(String uuid, String schemeId, String stationId, String orgName) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" insert into ebike.ebike_csbs_info(csbsId,chargestationId,csbsType,csbsStatus,schemeId,effTime)");
            sql.append(" values(?,?,?,?,?,?)");
            results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{uuid, stationId, "00", "00", schemeId, new Date()});
            results = this.addcsbsOpLog(uuid, "10", "00", orgName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    public int addcsbsOpLog(String csbsId, String logType, String csshdsStatus, String operator) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" insert into ebike.ebike_log_csbs_info(csbsId,logType,logTime,csbsStatus,operator)");
            sql.append(" values(?,?,?,?,?)");
            return this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{csbsId, logType, new Date(), csshdsStatus, operator});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public int updateOpLog(String cscsId, String orgName, String logType, String status) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        boolean count = false;
        try {
            sql.append(" insert into ebike.ebike_log_cscs_info(cscsId,logType,logTime,cscsStatus,operator)");
            sql.append(" values(?,?,?,?,?)");
            results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{cscsId, logType, new Date(), status, orgName});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    @Override
    public List<Map<String, Object>> queryBathInfos(String subburo, Map<String, String> map, int start) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select a.stationNo,a.ID,a.STATIONADDR,d.status,d.NAME,b.CHARGEDEVICENO,c.schemeId,c.schemeName ");
            sql.append("  from cisp_dev.dev_ebikechargestation  a  ");
            sql.append(" left join  ebike.ebike_csbs_info e on ( e.chargestationId=a.ID and e.csbsType='00')  ");
            sql.append("  left join ebike.ebike_billingscheme c  on e.schemeId=c.schemeId ");
            sql.append("  left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID ");
            sql.append("  left join cisp_dev.dev_powersystemresource d on d.ID=a.ID where 1=1  ");
            sql.append(" and a.id NOT IN (select chargestationId from ebike.ebike_cssh_distscheme) ");
            sql.append(" and a.stationNo like ?", (Object)("%" + map.get("stationNo") + "%"));
            sql.append(" and d.NAME like ?", (Object)("%" + map.get("stationName") + "%"));
            sql.append(" and d.status=?", (Object)map.get("status"));
            sql.append(" and ( d.SUBBURO = ?", (Object)subburo);
            sql.append(" or d.BURO = ? ) ", (Object)subburo);
            sql.append(" group by a.stationNo  ");
            sql.append(" order by d.createDate desc ");
            if (start == 1) {
                sql.append(" limit 0,10 ");
            } else {
                int starts = (start - 1) * 10;
                int end = start * 10;
                sql.append(" limit ? ", (Object)starts);
                sql.append(" , 10 ");
            }
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rownum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("schemeId", rs.getString("schemeId"));
                    map.put("ID", rs.getLong("ID"));
                    map.put("stationAddr", rs.getString("STATIONADDR"));
                    map.put("stationNo", rs.getString("stationNo"));
                    map.put("stationName", rs.getString("NAME"));
                    map.put("status", rs.getString("status"));
                    map.put("deviceNo", rs.getString("CHARGEDEVICENO"));
                    map.put("schemeName", rs.getString("schemeName"));
                    return map;
                }
            });
            this.logger.debug(">>>>>>>>>>>>queryBathInfos<<<<<<<<<<<<<<" + sql.toString());
        }
        catch (Exception ex) {
            return list;
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> queryBathCarInfos(String subburo, Map<String, String> map, int start) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" SELECT a.id AS stationId,a.charging_station_name AS stationName,a.charging_station_addr AS stationAddr,");
            sql.append("CASE a.charging_station_status when 1 then '\u521d\u59cb'  when 2 then '\u5f85\u8fd0'  when 3 then '\u8fd0\u884c'  when 4 then '\u6682\u505c'  when 9 then '\u9000\u8fd0' END AS stationStatus,");
            sql.append("CASE a.charging_station_type when 1 then '\u516c\u5171' when 2 then '\u4e2a\u4eba' when 11 then '\u516c\u4ea4(\u4e13\u7528)' when 12 then '\u73af\u536b(\u4e13\u7528)' when 13 then '\u7269\u6d41(\u4e13\u7528)' when 14 then '\u51fa\u79df\u8f66(\u4e13\u7528)' when 99 then '\u5176\u4ed6' END AS stationType,");
            sql.append("GROUP_CONCAT( DISTINCT(c.charging_pile_no) ORDER BY c.charging_pile_no ASC ) AS chargingPileNo,");
            sql.append("e.tmpl_name AS tmplName,f.schemeId,d.billing_tmpl_id AS tmplId,e.billing_interval AS billingInterval, ");
            sql.append("e.billing_params ->> '$.price_service' AS priceService,");
            sql.append("e.billing_params ->> '$.price_rate_type' AS priceRateType,e.billing_params AS billingParams,e.tmpl_no AS tmplNo,");
            sql.append("CASE e.billing_model when '1' THEN '\u672c\u5730\u8ba1\u8d39' WHEN 2 THEN '\u4e3b\u7ad9\u8ba1\u8d39' END AS billingModel");
            sql.append("  FROM oper_ev_charging_station a  ");
            sql.append(" LEFT JOIN ebike.ebike_orgopr b ON b.subburo = a.org_no  ");
            sql.append("  LEFT JOIN ebike.ebike_billingscheme f ON f.subburo = a.org_no ");
            sql.append("  LEFT JOIN dev_ev_charging_pile c ON a.id = c.charging_station_id ");
            sql.append("  LEFT JOIN oper_ev_charging_station_billing_info d ON a.id = d.charging_station_id  ");
            sql.append("LEFT JOIN tmpl_billing e ON e.id = d.billing_tmpl_id WHERE 1=1");
            sql.append(" and a.charging_station_addr like ?", (Object)("%" + map.get("stationAddr") + "%"));
            sql.append(" and a.charging_station_name like ?", (Object)("%" + map.get("stationName") + "%"));
            sql.append(" and a.charging_station_status=?", (Object)map.get("status"));
            sql.append(" and  a.org_no = ?", (Object)subburo);
            sql.append(" group by a.id  ");
            if (start == 1) {
                sql.append(" limit 0,10 ");
            } else {
                int starts = (start - 1) * 10;
                int end = start * 10;
                sql.append(" limit ? ", (Object)starts);
                sql.append(" , 10 ");
            }
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rownum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("tmplId", rs.getString("tmplId"));
                    map.put("schemeId", rs.getString("schemeId"));
                    map.put("stationId", rs.getString("stationId"));
                    map.put("stationType", rs.getString("stationType"));
                    map.put("stationAddr", rs.getString("stationAddr"));
                    map.put("stationName", rs.getString("stationName"));
                    map.put("status", rs.getString("stationStatus"));
                    map.put("chargingPileNo", rs.getString("chargingPileNo"));
                    map.put("tmplName", rs.getString("tmplName"));
                    map.put("priceRateType", rs.getString("priceRateType"));
                    map.put("billingParams", rs.getString("billingParams"));
                    map.put("tmplNo", rs.getString("tmplNo"));
                    map.put("billingModel", rs.getString("billingModel"));
                    map.put("priceService", rs.getString("priceService"));
                    map.put("billingInterval", rs.getString("billingInterval"));
                    return map;
                }
            });
            this.logger.debug(">>>>>>>>>>>>queryBathCarInfos<<<<<<<<<<<<<<" + sql.toString());
        }
        catch (Exception ex) {
            return list;
        }
        return list;
    }

    @Override
    public int queryBathCount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        ArrayList list = new ArrayList();
        try {
            sql.append(" select sum(count) from (  select count(1)  as count from cisp_dev.dev_ebikechargestation  a  ");
            sql.append(" left join  ebike.ebike_csbs_info e on ( e.chargestationId=a.ID and e.csbsType='00') ");
            sql.append("  left join ebike.ebike_billingscheme c  on e.schemeId=c.schemeId ");
            sql.append("  left join cisp_dev.dev_powersystemresource d on d.ID=a.ID where 1=1  ");
            sql.append(" and a.id NOT IN (select chargestationId from ebike.ebike_cssh_distscheme) ");
            sql.append(" and a.stationNo like ?", (Object)("%" + map.get("stationNo") + "%"));
            sql.append(" and d.NAME like ?", (Object)("%" + map.get("stationName") + "%"));
            sql.append(" and d.status=?", (Object)map.get("status"));
            sql.append(" and ( d.SUBBURO = ?", (Object)subburo);
            sql.append(" or d.BURO = ? ) ", (Object)subburo);
            sql.append(" group by a.stationNo  ) n");
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public int queryBathCarCount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" SELECT COUNT(1) FROM (");
            sql.append(" SELECT a.id AS stationId,a.charging_station_no AS stationNo,a.charging_station_name AS stationName,a.charging_station_addr AS stationAddr,");
            sql.append("CASE a.charging_station_status when 1 then '\u521d\u59cb'  when 2 then '\u5f85\u8fd0'  when 3 then '\u8fd0\u884c'  when 4 then '\u6682\u505c'  when 9 then '\u9000\u8fd0' END AS stationStatus,");
            sql.append("CASE a.charging_station_type when 1 then '\u516c\u5171' when 2 then '\u4e2a\u4eba' when 11 then '\u516c\u4ea4(\u4e13\u7528)' when 12 then '\u73af\u536b(\u4e13\u7528)' when 13 then '\u7269\u6d41(\u4e13\u7528)' when 14 then '\u51fa\u79df\u8f66(\u4e13\u7528)' when 99 then '\u5176\u4ed6' END AS stationType,");
            sql.append("GROUP_CONCAT( c.charging_pile_no ORDER BY c.charging_pile_no ASC ) AS chargingPileNo,");
            sql.append("e.tmpl_name AS tmplName,f.schemeId");
            sql.append("  FROM oper_ev_charging_station a  ");
            sql.append(" LEFT JOIN ebike.ebike_orgopr b ON b.subburo = a.org_no  ");
            sql.append("  LEFT JOIN ebike.ebike_billingscheme f ON f.subburo = a.org_no ");
            sql.append("  LEFT JOIN dev_ev_charging_pile c ON a.id = c.charging_station_id ");
            sql.append("  LEFT JOIN oper_ev_charging_station_billing_info d ON a.id = d.charging_station_id  ");
            sql.append("LEFT JOIN tmpl_billing e ON e.id = d.billing_tmpl_id WHERE 1=1");
            sql.append(" and a.charging_station_no like ?", (Object)("%" + map.get("stationNo") + "%"));
            sql.append(" and a.charging_station_name like ?", (Object)("%" + map.get("stationName") + "%"));
            sql.append(" and a.charging_station_status=?", (Object)map.get("status"));
            sql.append(" and  a.org_no = ?", (Object)subburo);
            sql.append(" group by a.id) AS g ");
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public Map<String, Object> getSchemeInfoById(String id) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List list = new ArrayList();
        HashMap<String, Object> maps = new HashMap<String, Object>();
        try {
            sql.append(" select *  from ebike.ebike_billingscheme where 1=1  ");
            sql.append(" and schemeId=? ", (Object)id);
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rownum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("schemeId", rs.getString("schemeId"));
                    map.put("schemeNo", rs.getString("schemeNo"));
                    map.put("schemeType", rs.getString("schemeType"));
                    map.put("unitPrice1", rs.getDouble("unitPrice1"));
                    map.put("unitPrice2", rs.getDouble("unitPrice2"));
                    map.put("unitPrice3", rs.getDouble("unitPrice3"));
                    map.put("unitPrice4", rs.getDouble("unitPrice4"));
                    map.put("stepPower1", rs.getInt("stepPower1"));
                    map.put("stepPower2", rs.getInt("stepPower2"));
                    map.put("stepPower3", rs.getInt("stepPower3"));
                    map.put("stepPower4", rs.getInt("stepPower4"));
                    map.put("schemeName", rs.getString("schemeName"));
                    map.put("minCharge", rs.getDouble("minCharge"));
                    if ("Y".equals(rs.getString("isReturn"))) {
                        map.put("isReturn", "\u9884\u4ed8\u53ef\u9000");
                    } else {
                        map.put("isReturn", "\u9884\u4ed8\u4e0d\u9000");
                    }
                    map.put("closingPeriod", rs.getInt("closingPeriod"));
                    return map;
                }
            });
            this.logger.debug(">>>>>>>>>>>>getSchemeInfoById<<<<<<<<<<<<<<" + sql.toString());
        }
        catch (Exception ex) {
            return maps;
        }
        if (list.size() > 0 && list != null) {
            return (Map)list.get(0);
        }
        return maps;
    }

    @Override
    public int modifyStationScheme(String schemeId, String stationIds) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" update ebike.ebike_csbs_info  SET ");
            sql.append(" schemeId= ? ", (Object)schemeId);
            sql.append(" where 1=1 and csbsType='00'");
            sql.append(" and chargestationId in (?) ", (Object)stationIds, ",");
            results = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            this.logger.debug(">>>>>>modifyStationScheme+result><<<<<<<<<<<<" + results);
            results = this.updateScheInfo(schemeId, stationIds);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    @Override
    public int modifyCarStationScheme(String schemeId, String stationIds) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" update ebike.oper_ev_charging_station_billing_info  SET ");
            sql.append(" billing_tmpl_id= ? ", (Object)schemeId);
            sql.append(" where 1=1");
            sql.append(" and charging_station_id in (?) ", (Object)stationIds, ",");
            results = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            this.logger.debug(">>>>>>modifyStationScheme+result><<<<<<<<<<<<" + results);
            results = this.updateScheInfo(schemeId, stationIds);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    @Override
    public int updateScheInfo(String schemeId, String stationIds) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        boolean results = false;
        try {
            sql.append(" update ebike.ebike_cs_bs_rela  SET  ");
            sql.append(" schemeId =? ", (Object)schemeId);
            sql.append("  where 1=1 ");
            sql.append(" and chargestationId in (?) ", (Object)stationIds, ",");
            return this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    class ChargeflRowMapper
    implements RowMapper<Map<String, Object>> {
        ChargeflRowMapper() {
        }

        public Map<String, Object> mapRow(ResultSet rs, int rownum) throws SQLException {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("schemeId", rs.getString("schemeId"));
            map.put("schemeNo", rs.getString("schemeNo"));
            map.put("schemeType", rs.getString("schemeType"));
            map.put("unitPrice1", rs.getDouble("unitPrice1"));
            map.put("unitPrice2", rs.getDouble("unitPrice2"));
            map.put("unitPrice3", rs.getDouble("unitPrice3"));
            map.put("schemeName", rs.getString("schemeName"));
            map.put("minCharge", rs.getDouble("minCharge"));
            map.put("isReturn", rs.getString("isReturn"));
            ChargeFlszDaoImpl.this.logger.debug("............schemeType.................." + rs.getString("schemeType"));
            return map;
        }
    }
}

