/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.oprmgmt.jdbcdao.impl;

import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.data.jdbc.SqlParamsBuilder;
import com.ebike.openservices.base.dao.AbstractEbikeBaseJdbcDao;
import com.ebike.openservices.oprmgmt.jdbcdao.ExcelDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class ExcelDaoImpl
extends AbstractEbikeBaseJdbcDao
implements ExcelDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Qualifier(value="ebikeJdbcTemplate")
    private final JdbcTemplate ebikeJdbcTemplate;

    @Autowired
    public ExcelDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public Map<String, String> importExcel(String stationId, String csbsId, String uuid) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<Map<String, String>> userlist = this.selectUserId(stationId, csbsId);
        this.logger.debug(">>>>>>>>>>>>>>>list.size><<<<<<<<<<<<<<" + JsonConvertUtils.convertToString(userlist));
        String userId = "";
        String phone = "";
        String count = "";
        if (userlist != null && userlist.size() > 0) {
            for (int i = 0; i < userlist.size(); ++i) {
                this.logger.debug(">>>>>>>>>>>>csbsUsersListId<<<<<<<<<<<<<<" + userlist.get(i).get("csbsUsersListId"));
                if (!"".equals(userlist.get(i).get("csbsUsersListId")) && userlist.get(i).get("csbsUsersListId") != null) {
                    userId = userlist.get(i).get("csbsUsersListId") + "," + userId;
                }
                if ("".equals(userlist.get(i).get("newCsbsUsersListId")) || userlist.get(i).get("newCsbsUsersListId") == null) continue;
                this.logger.debug(">>>>>>>>>>>>newCsbsUsersListId<<<<<<<<<<<<<<" + userlist.get(i).get("csbsUsersListId"));
                this.logger.debug("new aaa");
                userId = userlist.get(i).get("newCsbsUsersListId") + "," + userId;
            }
            userId = userId + uuid;
            this.logger.debug(">>>>>><userId<<<<<<<<<" + userId);
            this.logger.debug(">>>>>>>userId<<<<<<<<<" + userId);
            List<Map<String, Object>> phonelist = this.selectPhone(userId);
            this.logger.debug(" phonelist ", (Object)JsonConvertUtils.convertToString(phonelist));
            if (phonelist != null && phonelist.size() > 0) {
                for (int i = 0; i < phonelist.size(); ++i) {
                    if (!"".equals(phonelist.get(i).get("csbsUserMobile")) && !"null".equals(phonelist.get(i).get("csbsUserMobile")) && phonelist.get(i).get("csbsUserMobile") != null) {
                        phone = phone + phonelist.get(i).get("csbsUserMobile") + ",";
                    }
                    count = phonelist.get(i).get("count").toString();
                }
                this.logger.debug(">>>>>><phone<<<<<<<<<" + phone);
                this.logger.debug(">>>>>><count<<<<<<<<<" + count);
            }
        }
        map.put("uid", uuid);
        map.put("phone", phone);
        try {
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return map;
        }
    }

    @Override
    public int addMobilePhone(String uuid, String phone) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" insert into ebike.ebike_csbs_info_fu_userlist(csbsUsersListId,csbsUserMobile,createTime) ");
            sql.append(" values(?,?,?)");
            return this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{uuid, phone, new Date()});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public List<Map<String, String>> selectUserId(String stationId, String csbsId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        try {
            sql.append(" select b.csbsUsersListId,b.newCsbsUsersListId from ebike.ebike_csbs_info b  where 1=1 and b.csbsStatus!='10'   ");
            sql.append(" and b.chargestationId=?", (Object)stationId);
            if (!"".equals(csbsId)) {
                sql.append(" and b.csbsId!=? ", (Object)csbsId);
            }
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, String>>(){

                public Map<String, String> mapRow(ResultSet rs, int rownum) throws SQLException {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("csbsUsersListId", rs.getString("csbsUsersListId"));
                    map.put("newCsbsUsersListId", rs.getString("newCsbsUsersListId"));
                    return map;
                }
            });
            this.logger.debug(">>>>>>>>>>>>>selectUserId<<<<<<<<<<<<<<<" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    public int deleteUserPhone(String csbsUsersListId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" delete from ebike.ebike_csbs_info_fu_userlist  where 1=1 ");
            sql.append(" and csbsUsersListId in(?)", (Object)csbsUsersListId);
            return this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public List<Map<String, String>> selectUserInfo(String csbsUsersListId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        try {
            sql.append(" select b.csbsUserMobile from ebike.ebike_csbs_info_userlist b  where 1=1  ");
            sql.append(csbsUsersListId, (Object)" and b.csbsUsersListId=?");
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, String>>(){

                public Map<String, String> mapRow(ResultSet rs, int rownum) throws SQLException {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("csbsUserMobile", rs.getString("csbsUserMobile"));
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    public List<Map<String, Object>> selectPhone(String userId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        this.logger.debug(" vselectPhone " + userId);
        try {
            sql.append(" select a.csbsUserMobile,count(1) as count  from ebike.ebike_csbs_info_fu_userlist  a where 1=1  ");
            sql.append("  and a.csbsUsersListId in (?)", (Object)userId, ",");
            sql.append("  GROUP BY a.csbsUserMobile  having count>1  ");
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rownum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("csbsUserMobile", rs.getString("csbsUserMobile"));
                    map.put("count", rs.getInt("count"));
                    return map;
                }
            });
            this.logger.debug(">>>>>>>>>>>>>selectPhone<<<<<<<<<<<<<<<" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    public int addRepeatData(String csbsUserMobile, String uuid) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" insert into ebike.ebike_csbs_info_fu_userlist(csbsUsersListId,repateMobile)");
            sql.append(" values(?,?)");
            return this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{uuid, csbsUserMobile});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }
}

