/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.oprmgmt.jdbcdao.impl;

import com.easesource.commons.util.ObjectUtils;
import com.easesource.commons.util.UuidUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.data.jdbc.SqlParamsBuilder;
import com.ebike.openservices.base.dao.AbstractEbikeBaseJdbcDao;
import com.ebike.openservices.oprmgmt.jdbcdao.InShareDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class InShareDaoImpl
extends AbstractEbikeBaseJdbcDao
implements InShareDao {
    @Qualifier(value="ebikeJdbcTemplate")
    private final JdbcTemplate ebikeJdbcTemplate;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    public InShareDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public List<Map<String, Object>> partnerQuery(String stationId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select  b.orgoprType,b.orgoprName,b.orgoprCredNo,b.subburo,a.csshdsStatus,a.incomeRatio,a.costRatio, ");
            sql.append(" a.newIncomeRatio,a.newCostRatio,a.csshDistSchemeId from ebike.ebike_cssh_distscheme  a ");
            sql.append(" left join ebike.ebike_orgopr b on a.stakeholderOrgNo=b.subburo where 1=1  ");
            sql.append(" and a.chargestationId=? ", (Object)stationId);
            sql.append("  and a.csshdsStatus!='10' ");
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> incomeStation(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        String bikeStatus = map.get("status");
        try {
            String type = map.get("type");
            if (type == null || type.equals("")) {
                type = "3";
            }
            if ("1".equals(type)) {
                sql.append(" select '\u7535\u52a8\u81ea\u884c\u8f66\u7535\u6869' pileType,oo.orgoprName as operatorsOrgName,a.id,a.stationNo,a.stationAddr,b.STATUS,b.NAME,GROUP_CONCAT(DISTINCT(c.CHARGEDEVICENO) order by c.CHARGEDEVICENO asc ) as deviceNo, GROUP_CONCAT(DISTINCT(e.orgoprName)) as orgName ");
                sql.append("  , IFNULL(ecc.serviceRate, IFNULL(oo.serviceRate, 0.0)) AS serviceRate ");
                sql.append(" from cisp_dev.dev_ebikechargestation a  ");
                sql.append(" left join cisp_dev.dev_powersystemresource b on a.ID=b.ID ");
                sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID  ");
                sql.append(" left  join ebike.ebike_cssh_distscheme  d on a.ID=d.chargestationId  ");
                sql.append(" LEFT JOIN ebike.ebike_orgopr oo ON oo.subburo = b.subburo ");
                sql.append(" LEFT JOIN ebike.ebike_cssr_config ecc ON ecc.chargestationId = a.id  ");
                sql.append("  left join ebike.ebike_orgopr e on (d.stakeholderOrgNo=e.subburo  and d.csshdsStatus!='10') where 1=1  ");
                sql.append(" and oo.subburo = ? ", (Object)map.get("operatorsOrg"));
                sql.append(" and a.stationAddr like ? ", (Object)("%" + map.get("stationAddr") + "%"));
                sql.append(" and  b.NAME like ?", (Object)("%" + map.get("stationName") + "%"));
                sql.append(" and b.STATUS=?", (Object)map.get("status"));
                sql.append(" and c.CHARGEDEVICENO like ?", (Object)("%" + map.get("deviceNo") + "%"));
                sql.append(" and b.SUBBURO=?", (Object)subburo);
                sql.append(" and b.CLASSNAME='EBikeChargeStation'");
            }
            if ("2".equals(type)) {
                sql.append(" select '\u7535\u52a8\u6c7d\u8f66\u7535\u6869' pileType, b.orgoprName as operatorsOrgName, a.id,a.charging_station_no as stationNo,a.charging_station_addr as stationAddr,a.charging_station_status as status, a.charging_station_name as name, GROUP_CONCAT( DISTINCT ( c.charging_pile_no ) order by c.charging_pile_no asc ) AS deviceNo, ");
                sql.append(" b.orgoprName as orgName, b.serviceRate as serviceRate ");
                sql.append(" from oper_ev_charging_station as a  ");
                sql.append(" left join ebike.ebike_orgopr b on b.subburo = a.org_no ");
                sql.append(" left join dev_ev_charging_pile c on c.charging_station_id = a.id ");
                sql.append(" where true ");
                sql.append(" and  a.charging_station_name like ?", (Object)("%" + map.get("stationName") + "%"));
                sql.append(" and c.charging_pile_no like ? ", (Object)("%" + map.get("deviceNo") + "%"));
                sql.append(" and a.org_no = ?", (Object)subburo);
            }
            if ("3".equals(type)) {
                sql.append(" select '\u7535\u52a8\u81ea\u884c\u8f66\u7535\u6869' pileType, oo.orgoprName as operatorsOrgName,a.id,a.stationNo,a.stationAddr,b.STATUS,b.NAME,GROUP_CONCAT(DISTINCT(c.CHARGEDEVICENO) order by c.CHARGEDEVICENO asc ) as deviceNo, GROUP_CONCAT(DISTINCT(e.orgoprName)) as orgName ");
                sql.append("  , IFNULL(ecc.serviceRate, IFNULL(oo.serviceRate, 0.0)) AS serviceRate ");
                sql.append(" from cisp_dev.dev_ebikechargestation a  ");
                sql.append(" left join cisp_dev.dev_powersystemresource b on a.ID=b.ID ");
                sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID  ");
                sql.append(" left  join ebike.ebike_cssh_distscheme  d on a.ID=d.chargestationId  ");
                sql.append(" LEFT JOIN ebike.ebike_orgopr oo ON oo.subburo = b.subburo ");
                sql.append(" LEFT JOIN ebike.ebike_cssr_config ecc ON ecc.chargestationId = a.id  ");
                sql.append("  left join ebike.ebike_orgopr e on (d.stakeholderOrgNo=e.subburo  and d.csshdsStatus!='10') where 1=1  ");
                sql.append(" and oo.subburo = ? ", (Object)map.get("operatorsOrg"));
                sql.append(" and a.stationAddr like ? ", (Object)("%" + map.get("stationAddr") + "%"));
                sql.append(" and  b.NAME like ?", (Object)("%" + map.get("stationName") + "%"));
                sql.append(" and b.STATUS=?", (Object)map.get("status"));
                sql.append(" and c.CHARGEDEVICENO like ?", (Object)("%" + map.get("deviceNo") + "%"));
                sql.append(" and b.SUBBURO=?", (Object)subburo);
                sql.append(" and b.CLASSNAME='EBikeChargeStation'  GROUP BY a.ID  ");
                sql.append(" union all  ");
                sql.append(" select '\u7535\u52a8\u6c7d\u8f66\u7535\u6869' pileType, b.orgoprName as operatorsOrgName,a.id,a.charging_station_no as stationNo,a.charging_station_addr as stationAddr,a.charging_station_status as status, a.charging_station_name as name, GROUP_CONCAT( DISTINCT ( c.charging_pile_no ) order by c.charging_pile_no asc ) AS deviceNo, ");
                sql.append(" b.orgoprName as orgName, b.serviceRate as serviceRate ");
                sql.append(" from oper_ev_charging_station as a  ");
                sql.append(" left join ebike.ebike_orgopr b on b.subburo = a.org_no ");
                sql.append(" left join dev_ev_charging_pile c on c.charging_station_id = a.id ");
                sql.append(" where true ");
                sql.append(" and  a.charging_station_name like ?", (Object)("%" + map.get("stationName") + "%"));
                sql.append(" and c.charging_pile_no like ? ", (Object)("%" + map.get("deviceNo") + "%"));
                sql.append(" and a.org_no = ?", (Object)subburo);
            }
            if ("10".equals(bikeStatus)) {
                sql.append(" and a.charging_station_status = '1' or a.charging_station_status = '2' ");
            } else if ("20".equals(bikeStatus)) {
                sql.append(" and a.charging_station_status = '3' ");
            } else if ("40".equals(bikeStatus)) {
                sql.append(" and a.charging_station_status = '9' ");
            }
            sql.append(" GROUP BY a.ID ");
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rownum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("operatorsOrgName", rs.getString("operatorsOrgName"));
                    map.put("ID", rs.getLong("ID"));
                    map.put("stationNo", rs.getString("stationNo"));
                    map.put("SName", rs.getString("NAME"));
                    map.put("stationAddr", rs.getString("stationAddr"));
                    map.put("deviceNo", rs.getString("deviceNo"));
                    map.put("orgName", rs.getString("orgName"));
                    map.put("csServiceRate", rs.getDouble("serviceRate"));
                    map.put("pileType", rs.getString("pileType"));
                    String resultStatus = rs.getString("STATUS");
                    String finalStatus = null;
                    if ("1".equals(resultStatus) || "2".equals(resultStatus)) {
                        finalStatus = "10";
                    } else if ("3".equals(resultStatus)) {
                        finalStatus = "20";
                    } else if ("9".equals(resultStatus)) {
                        finalStatus = "40";
                    }
                    map.put("status", finalStatus == null ? resultStatus : finalStatus);
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int queryIncomeCount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ( select count(1) from cisp_dev.dev_ebikechargestation a  ");
            sql.append(" left join cisp_dev.dev_powersystemresource b on a.ID=b.ID ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID  ");
            sql.append(" left  join ebike.ebike_cssh_distscheme  d on a.ID=d.chargestationId  ");
            sql.append(" LEFT JOIN ebike.ebike_orgopr oo ON oo.subburo = b.subburo ");
            sql.append(" LEFT JOIN ebike.ebike_cssr_config ecc ON ecc.chargestationId = a.id  ");
            sql.append(" left join ebike.ebike_orgopr e on (d.stakeholderOrgNo=e.subburo  and d.csshdsStatus!='10') where 1=1 ");
            sql.append(" and a.stationNo like ? ", (Object)("%" + map.get("stationNo") + "%"));
            sql.append(" and oo.subburo = ? ", (Object)map.get("operatorsOrg"));
            sql.append(" and a.stationAddr like ? ", (Object)("%" + map.get("stationAddr") + "%"));
            sql.append(" and  b.NAME like ?", (Object)("%" + map.get("stationName") + "%"));
            sql.append(" and b.STATUS=?", (Object)map.get("status"));
            sql.append(" and c.CHARGEDEVICENO like ?", (Object)("%" + map.get("deviceNo") + "%"));
            sql.append(" and b.SUBBURO=?", (Object)subburo);
            sql.append(" and b.CLASSNAME='EBikeChargeStation'   GROUP BY a.ID   ) f  ");
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public int queryIncomeCountForCar(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String bikeStatus = map.get("status");
        try {
            sql.append("select count(1) from");
            sql.append("(select a.charging_station_name,c.charging_pile_no,a.charging_station_status,a.org_no from oper_ev_charging_station as a left join dev_ev_charging_pile c ON c.charging_station_id = a.id group by a.id) bb");
            sql.append(" where true ");
            sql.append(" and bb.charging_station_name like ? ", (Object)("%" + map.get("stationName") + "%"));
            sql.append(" and bb.charging_pile_no like ? ", (Object)("%" + map.get("deviceNo") + "%"));
            sql.append(" and bb.org_no = ?", (Object)subburo);
            if ("10".equals(bikeStatus)) {
                sql.append(" and bb.charging_station_status = '1' or bb.charging_station_status = '2' ");
            } else if ("20".equals(bikeStatus)) {
                sql.append(" and bb.charging_station_status = '3' ");
            } else if ("40".equals(bikeStatus)) {
                sql.append(" and bb.charging_station_status = '9' ");
            }
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public String checkYysExist(String orgoprType, String orgoprName, String orgoprCredNo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int result = 0;
        String subburo = "";
        try {
            sql.append(" select count(1) from ebike.ebike_orgopr  a where 1=1  ");
            sql.append(" and a.orgoprType=? ", (Object)orgoprType);
            sql.append(" and a.orgoprName=? ", (Object)orgoprName);
            sql.append(" and a.orgoprCredNo=? ", (Object)orgoprCredNo);
            result = (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
        subburo = result == 0 ? "0" : this.getSubburo(orgoprType, orgoprName, orgoprCredNo);
        return subburo;
    }

    public String getSubburo(String orgoprType, String orgoprName, String orgoprCredNo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String result = "";
        try {
            sql.append(" select subburo from ebike.ebike_orgopr  a where 1=1  ");
            sql.append(" and a.orgoprType=? ", (Object)orgoprType);
            sql.append(" and a.orgoprName=? ", (Object)orgoprName);
            sql.append(" and a.orgoprCredNo=? ", (Object)orgoprCredNo);
            result = (String)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), String.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
        return result;
    }

    @Override
    public int checkSameName(String stationId, String stakeholderOrgNo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebike.ebike_cssh_distscheme  a where 1=1  ");
            sql.append(" and a.chargestationId=? ", (Object)stationId);
            sql.append(" and a.stakeholderOrgNo=? ", (Object)stakeholderOrgNo);
            sql.append(" and a.csshdsStatus!='10' ");
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public int profitAdd(Map<String, String> map) {
        int results = 0;
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String uuid = UuidUtils.generateUuidString();
        String acostRatio = ObjectUtils.toStringDefaultEmpty((Object)map.get("acostRatio"));
        String loginfo = "\u8425\u6536\u91d1\u989d*" + map.get("aincomeRatio") + "%+\u7535\u8d39\u6210\u672c*" + map.get("acostRatio") + "%";
        try {
            sql.append(" insert into ebike.ebike_cssh_distscheme(csshDistSchemeId,chargestationId, ");
            sql.append(" orgoprOrgNo,stakeholderOrgNo,csshdsStatus,incomeRatio,costRatio,effTime )");
            sql.append(" values(?,?,?,?,?,?,?,?) ");
            results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{uuid, map.get("stationId"), map.get("subburo"), map.get("stakeholderOrgNo"), "01", Double.valueOf(map.get("aincomeRatio")), !acostRatio.equals("") ? Double.parseDouble(acostRatio) : 0.0, new Date()});
            results = this.addDistschemeTbc(uuid, map.get("stakeholderOrgNo"), map.get("orgName"));
            results = this.addDistschemeLog(uuid, map.get("orgName"), "10", loginfo, "01");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    public int addDistschemeTbc(String uuid, String stakeholderOrgNo, String orgName) {
        boolean results = false;
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" replace into ebike.ebike_cssh_distscheme_tbc(csshDistSchemeId,stakeholderOrgNo, ");
            sql.append(" creator,createTime,confirmFlag )");
            sql.append(" values(?,?,?,?,?) ");
            return this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{uuid, stakeholderOrgNo, orgName, new Date(), "0"});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public int addDistschemeLog(String csshDistSchemeId, String orgName, String logType, String logInfo, String csshdsStatus) {
        boolean results = false;
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" insert into ebike.ebike_log_cssh_distscheme(csshDistSchemeId, ");
            sql.append(" logType,logTime,logValue,csshdsStatus,operator)");
            sql.append(" values(?,?,?,?,?,?) ");
            return this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{csshDistSchemeId, logType, new Date(), logInfo, csshdsStatus, orgName});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public Map<String, Object> checkIncome(String stationId) {
        double results = 0.0;
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List list = new ArrayList();
        try {
            sql.append(" select sum(incomeRatio) as incomeRatios from (select IFNULL(sum(incomeRatio)+sum(newIncomeRatio),0) as incomeRatio from ebike.ebike_cssh_distscheme where 1=1  ");
            sql.append(" and chargestationId=?", (Object)Long.valueOf(stationId));
            sql.append(" and csshdsStatus!='10') p ");
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
            this.logger.debug(">>>>>>incomeRatios<<<<<<<<<" + ((Map)list.get(0)).toString());
            return (Map)list.get(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return (Map)list.get(0);
        }
    }

    @Override
    public Map<String, Object> checkCost(String stationId) {
        double results = 0.0;
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List list = new ArrayList();
        try {
            sql.append(" select sum(costRatio) as costRatios from (select IFNULL(sum(costRatio)+sum(newCostRatio),0)  as costRatio from ebike.ebike_cssh_distscheme where 1=1 ");
            sql.append(" and chargestationId=?", (Object)Long.valueOf(stationId));
            sql.append(" and csshdsStatus!='10') p");
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
            this.logger.debug(">>>>>>checkCost<<<<<<<<<" + ((Map)list.get(0)).toString());
            return (Map)list.get(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return (Map)list.get(0);
        }
    }

    @Override
    public int profitModify(Map<String, String> map) {
        int results = 0;
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String acostRatio = "0.0";
        String aincomeRatio = "0.0";
        String loginfo = "\u8425\u6536\u91d1\u989d*" + map.get("incomeRatio") + "%+\u7535\u8d39\u6210\u672c*" + map.get("costRatio") + "%(\u66f4\u6539\u524d)\u8425\u6536\u91d1\u989d*" + map.get("aincomeRatio") + "%+\u7535\u8d39\u6210\u672c*" + map.get("acostRatio") + "%(\u66f4\u6539\u540e)";
        try {
            if (!"".equals(map.get("acostRatio"))) {
                acostRatio = ObjectUtils.toStringDefaultEmpty((Object)map.get("acostRatio"));
            }
            if (!"".equals(map.get("aincomeRatio"))) {
                aincomeRatio = map.get("aincomeRatio");
            }
            sql.append(" replace into ebike.ebike_cssh_distscheme(csshDistSchemeId,chargestationId,orgoprOrgNo,stakeholderOrgNo,csshdsStatus,incomeRatio,costRatio,newIncomeRatio,newCostRatio,effTime) ");
            sql.append(" values(?,?,?,?,?,?,?,?,?,?)");
            results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{map.get("csshDistSchemeId"), map.get("stationId"), map.get("subburo"), map.get("stakeholderOrgNo"), "02", Double.valueOf(map.get("incomeRatio")), Double.valueOf(map.get("costRatio")), Double.valueOf(aincomeRatio), !acostRatio.equals("") ? Double.parseDouble(acostRatio) : 0.0, new Date()});
            results = this.addDistschemeTbc(map.get("csshDistSchemeId"), map.get("stakeholderOrgNo"), map.get("orgName"));
            results = this.addDistschemeLog(map.get("csshDistSchemeId"), map.get("orgName"), "20", loginfo, "02");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    @Override
    public boolean stopProfit(Map<String, String> map) {
        int results = 0;
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" update ebike.ebike_cssh_distscheme set csshdsStatus='03' where 1=1 ");
            sql.append(" and csshDistSchemeId=?", (Object)map.get("csshDistSchemeId"));
            results = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            results = this.addDistschemeTbc(map.get("csshDistSchemeId"), map.get("stakeholderOrgNo"), map.get("orgName"));
            results = this.addDistschemeLog(map.get("csshDistSchemeId"), map.get("orgName"), "30", "\u7ec8\u6b62", "03");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    @Override
    public List<Map<String, Object>> queryOperationInfo(String csshDistSchemeId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select a.csshDistSchemeId,a.logType,a.logTime,a.logValue,b.USER_NAME as 'userName',b.USER_ORG_NAME as 'orgName' ");
            sql.append(" from ebike.ebike_log_cssh_distscheme a left join cisp_sys.bp_user b on a.operator=b.USER_NO where 1=1 ");
            sql.append(" and a.csshDistSchemeId=?", (Object)csshDistSchemeId);
            sql.append(" order by  a.logTime desc ");
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int operationCount(String csshDistSchemeId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebike.ebike_log_cssh_distscheme a left join cisp_sys.bp_user b on a.operator=b.USER_NO where 1=1 ");
            sql.append(" and a.csshDistSchemeId=?", (Object)csshDistSchemeId);
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public List<Map<String, Object>> queryIShareStation(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        String bikeStatus = map.get("status");
        String type = map.get("type");
        try {
            if (type == null || "".equals(type)) {
                type = "3";
            }
            if ("1".equals(type)) {
                sql.append(" select  '\u7535\u52a8\u81ea\u884c\u8f66\u7535\u6869' pileType,a.id,a.stationNo,a.stationAddr,b.status,b.name,GROUP_CONCAT(DISTINCT(c.CHARGEDEVICENO) order by c.CHARGEDEVICENO asc) as deviceNo, ");
                sql.append(" d.costRatio,d.incomeRatio,d.newCostRatio,d.csshdsStatus,d.newIncomeRatio,d.csshDistSchemeId,d.stakeholderOrgNo,d.orgoprOrgNo  ");
                sql.append("  , IFNULL(ecc.serviceRate, IFNULL(oo.serviceRate, 0.0)) AS serviceRate ");
                sql.append("  from ebike.ebike_cssh_distscheme  d ");
                sql.append("  left  join cisp_dev.dev_ebikechargestation a  on a.ID=d.chargestationId  ");
                sql.append(" left join cisp_dev.dev_powersystemresource b on a.ID=b.ID   ");
                sql.append(" LEFT JOIN ebike.ebike_orgopr oo ON oo.subburo = b.subburo ");
                sql.append(" LEFT JOIN ebike.ebike_cssr_config ecc ON ecc.chargestationId = a.id  ");
                sql.append("  left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID  where 1=1  ");
                sql.append(" and a.stationNo like ? ", (Object)("%" + map.get("stationNo") + "%"));
                sql.append(" and  b.NAME like ?", (Object)("%" + map.get("stationName") + "%"));
                sql.append(" and b.STATUS=?", (Object)map.get("status"));
                sql.append(" and c.CHARGEDEVICENO like ?", (Object)("%" + map.get("deviceNo") + "%"));
                sql.append(" and d.stakeholderOrgNo=?", (Object)subburo);
                sql.append(" and a.stationNo is not null ");
                sql.append(" and d.csshdsStatus!='10' GROUP BY a.ID  ");
            }
            if ("2".equals(type)) {
                sql.append(" select '\u7535\u52a8\u6c7d\u8f66\u7535\u6869' pileType,s.id,s.charging_station_no stationNo,s.charging_station_addr stationAddr,s.charging_station_status status, ");
                sql.append("s.charging_station_name name,GROUP_CONCAT( DISTINCT ( c.charging_pile_no ) order by c.charging_pile_no asc )  deviceNo,");
                sql.append("d.costRatio,d.incomeRatio,d.newCostRatio,d.csshdsStatus,d.newIncomeRatio,d.csshDistSchemeId,d.stakeholderOrgNo,d.orgoprOrgNo,o.serviceRate ");
                sql.append("from ebike_cssh_distscheme d ");
                sql.append("left join oper_ev_charging_station s on s.id = d.chargestationId ");
                sql.append("left join dev_ev_charging_pile c on c.charging_station_id = s.id ");
                sql.append("left join ebike_orgopr o on o.subburo = s.org_no ");
                sql.append("where true ");
                sql.append(" and  s.charging_station_name like ?", (Object)("%" + map.get("stationName") + "%"));
                sql.append(" and c.charging_pile_no like ?", (Object)("%" + map.get("deviceNo") + "%"));
                sql.append(" and d.stakeholderOrgNo=?", (Object)subburo);
                sql.append("and s.charging_station_no is not null ");
                if ("10".equals(bikeStatus)) {
                    sql.append(" and s.charging_station_status = '1' or s.charging_station_status = '2' ");
                } else if ("20".equals(bikeStatus)) {
                    sql.append(" and s.charging_station_status = '3' ");
                } else if ("40".equals(bikeStatus)) {
                    sql.append(" and s.charging_station_status = '9' ");
                }
                sql.append("and d.csshdsStatus!='10' GROUP BY s.ID ");
            }
            if ("3".equals(type)) {
                sql.append(" select  '\u7535\u52a8\u81ea\u884c\u8f66\u7535\u6869' pileType,a.id,a.stationNo,a.stationAddr,b.status,b.name,GROUP_CONCAT(DISTINCT(c.CHARGEDEVICENO) order by c.CHARGEDEVICENO asc) as deviceNo, ");
                sql.append(" d.costRatio,d.incomeRatio,d.newCostRatio,d.csshdsStatus,d.newIncomeRatio,d.csshDistSchemeId,d.stakeholderOrgNo,d.orgoprOrgNo  ");
                sql.append("  , IFNULL(ecc.serviceRate, IFNULL(oo.serviceRate, 0.0)) AS serviceRate ");
                sql.append("  from ebike.ebike_cssh_distscheme  d ");
                sql.append("  left  join cisp_dev.dev_ebikechargestation a  on a.ID=d.chargestationId  ");
                sql.append(" left join cisp_dev.dev_powersystemresource b on a.ID=b.ID   ");
                sql.append(" LEFT JOIN ebike.ebike_orgopr oo ON oo.subburo = b.subburo ");
                sql.append(" LEFT JOIN ebike.ebike_cssr_config ecc ON ecc.chargestationId = a.id  ");
                sql.append("  left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID  where 1=1  ");
                sql.append(" and a.stationNo like ? ", (Object)("%" + map.get("stationNo") + "%"));
                sql.append(" and  b.NAME like ?", (Object)("%" + map.get("stationName") + "%"));
                sql.append(" and b.STATUS=?", (Object)map.get("status"));
                sql.append(" and c.CHARGEDEVICENO like ?", (Object)("%" + map.get("deviceNo") + "%"));
                sql.append(" and d.stakeholderOrgNo=?", (Object)subburo);
                sql.append(" and a.stationNo is not null ");
                sql.append(" and d.csshdsStatus!='10' GROUP BY a.ID  ");
                sql.append(" union all ");
                sql.append(" select '\u7535\u52a8\u6c7d\u8f66\u7535\u6869' pileType,s.id,s.charging_station_no stationNo,s.charging_station_addr stationAddr,s.charging_station_status status, ");
                sql.append("s.charging_station_name name,GROUP_CONCAT( DISTINCT ( c.charging_pile_no ) order by c.charging_pile_no asc )  deviceNo,");
                sql.append("d.costRatio,d.incomeRatio,d.newCostRatio,d.csshdsStatus,d.newIncomeRatio,d.csshDistSchemeId,d.stakeholderOrgNo,d.orgoprOrgNo,o.serviceRate ");
                sql.append("from ebike_cssh_distscheme d ");
                sql.append("left join oper_ev_charging_station s on s.id = d.chargestationId ");
                sql.append("left join dev_ev_charging_pile c on c.charging_station_id = s.id ");
                sql.append("left join ebike_orgopr o on o.subburo = s.org_no ");
                sql.append("where true ");
                sql.append(" and  s.charging_station_name like ?", (Object)("%" + map.get("stationName") + "%"));
                sql.append(" and c.charging_pile_no like ?", (Object)("%" + map.get("deviceNo") + "%"));
                sql.append(" and d.stakeholderOrgNo=?", (Object)subburo);
                sql.append("and s.charging_station_no is not null ");
                if ("10".equals(bikeStatus)) {
                    sql.append(" and s.charging_station_status = '1' or s.charging_station_status = '2' ");
                } else if ("20".equals(bikeStatus)) {
                    sql.append(" and s.charging_station_status = '3' ");
                } else if ("40".equals(bikeStatus)) {
                    sql.append(" and s.charging_station_status = '9' ");
                }
                sql.append("and d.csshdsStatus!='10' GROUP BY s.ID ");
            }
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rownum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("ID", rs.getLong("ID"));
                    map.put("stationNo", rs.getString("stationNo"));
                    map.put("SName", rs.getString("NAME"));
                    map.put("stationAddr", rs.getString("stationAddr"));
                    InShareDaoImpl.this.logger.debug(">>>>>>>>vstatus<<<<<<<<<" + map.get("status"));
                    map.put("deviceNo", rs.getString("deviceNo"));
                    map.put("costRatio", rs.getDouble("costRatio"));
                    map.put("incomeRatio", rs.getDouble("incomeRatio"));
                    map.put("newCostRatio", rs.getDouble("newCostRatio"));
                    map.put("newIncomeRatio", rs.getDouble("newIncomeRatio"));
                    map.put("csshdsStatus", rs.getString("csshdsStatus"));
                    map.put("csshDistSchemeId", rs.getString("csshDistSchemeId"));
                    map.put("orgoprOrgNo", rs.getString("orgoprOrgNo"));
                    map.put("stakeholderOrgNo", rs.getString("stakeholderOrgNo"));
                    map.put("csServiceRate", rs.getDouble("serviceRate"));
                    map.put("pileType", rs.getString("pileType"));
                    String resultStatus = rs.getString("STATUS");
                    String finalStatus = null;
                    if ("1".equals(resultStatus) || "2".equals(resultStatus)) {
                        finalStatus = "10";
                    } else if ("3".equals(resultStatus)) {
                        finalStatus = "20";
                    } else if ("9".equals(resultStatus)) {
                        finalStatus = "40";
                    }
                    map.put("status", finalStatus == null ? resultStatus : finalStatus);
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int queryPrifitCount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        ArrayList list = new ArrayList();
        try {
            sql.append(" select count(1) from (select count(1) ");
            sql.append("  from ebike.ebike_cssh_distscheme  d ");
            sql.append("  left  join cisp_dev.dev_ebikechargestation a  on a.ID=d.chargestationId  ");
            sql.append(" left join cisp_dev.dev_powersystemresource b on a.ID=b.ID   ");
            sql.append("  left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID  where 1=1  ");
            sql.append(" and a.stationNo like ? ", (Object)("%" + map.get("stationNo") + "%"));
            sql.append(" and  b.NAME like ?", (Object)("%" + map.get("stationName") + "%"));
            sql.append(" and b.STATUS=?", (Object)map.get("status"));
            sql.append(" and c.CHARGEDEVICENO like ?", (Object)("%" + map.get("deviceNo") + "%"));
            sql.append(" and d.stakeholderOrgNo=?", (Object)subburo);
            sql.append(" and b.CLASSNAME='EBikeChargeStation' and d.csshdsStatus!='10'  GROUP BY a.ID) f ");
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public int queryPrifitCountForCar(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String bikeStatus = map.get("status");
        try {
            sql.append(" select count(1) ");
            sql.append("from ebike_cssh_distscheme d ");
            sql.append("left join oper_ev_charging_station s on s.id = d.chargestationId ");
            sql.append("left join dev_ev_charging_pile c on c.charging_station_id = s.id ");
            sql.append("left join ebike_orgopr o on o.subburo = s.org_no ");
            sql.append("where true ");
            sql.append(" and  s.charging_station_name like ?", (Object)("%" + map.get("stationName") + "%"));
            sql.append(" and c.charging_pile_no like ?", (Object)("%" + map.get("deviceNo") + "%"));
            sql.append(" and d.stakeholderOrgNo=?", (Object)subburo);
            sql.append("and s.charging_station_no is not null ");
            if ("10".equals(bikeStatus)) {
                sql.append(" and s.charging_station_status = '1' or s.charging_station_status = '2' ");
            } else if ("20".equals(bikeStatus)) {
                sql.append(" and s.charging_station_status = '3' ");
            } else if ("40".equals(bikeStatus)) {
                sql.append(" and s.charging_station_status = '9' ");
            }
            sql.append("and d.csshdsStatus!='10'  ");
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public boolean incomeOp(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        String csshdsStatus = "";
        try {
            csshdsStatus = "12".equals(map.get("logType")) || "31".equals(map.get("logType")) ? "10" : "00";
            sql.append(" update ebike.ebike_cssh_distscheme_tbc set ");
            sql.append(" confirmFlag=?", (Object)map.get("confirmFlag"));
            sql.append(" ,confirmer=?", (Object)map.get("orgName"));
            sql.append(" ,confirmTime=? ", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            sql.append(" where 1=1 ");
            sql.append(" and csshDistSchemeId=?", (Object)map.get("csshDistSchemeId"));
            results = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            results = this.distscheme(map, csshdsStatus);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    public int distscheme(Map<String, String> map, String csshdsStatus1) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        String income = map.get("incomeRatio");
        String newincome = "0.0";
        String cost = map.get("costRatio");
        String newcost = "0.0";
        String csshdsStatus = "";
        String loginfo = "";
        if ("12".equals(map.get("logType"))) {
            loginfo = "\u8425\u6536\u91d1\u989d*" + map.get("incomeRatio") + "%+\u7535\u8d39\u6210\u672c*" + map.get("costRatio") + "%";
            csshdsStatus = "10";
        } else if ("31".equals(map.get("logType"))) {
            loginfo = "\u540c\u610f\u7ec8\u6b62";
            csshdsStatus = "10";
        } else {
            loginfo = "\u8425\u6536\u91d1\u989d*" + map.get("incomeRatio") + "%+\u7535\u8d39\u6210\u672c*" + map.get("costRatio") + "%(\u66f4\u6539\u524d)\u8425\u6536\u91d1\u989d*" + map.get("aincomeRatio") + "%+\u7535\u8d39\u6210\u672c*" + map.get("acostRatio") + "%(\u66f4\u6539\u540e)";
            csshdsStatus = "00";
        }
        this.logger.debug(map.get("aincomeRatio"));
        this.logger.debug(map.get("acostRatio"));
        this.logger.debug(map.get("incomeRatio"));
        this.logger.debug(map.get("costRatio"));
        if (!"0".equals(map.get("aincomeRatio"))) {
            this.logger.debug("true");
        }
        if (!"0".equals(map.get("acostRatio"))) {
            this.logger.debug("true");
        }
        if (!"".equals(map.get("aincomeRatio")) && "21".equals(map.get("logType"))) {
            income = map.get("aincomeRatio");
        }
        if (!"".equals(map.get("acostRatio")) && "21".equals(map.get("logType"))) {
            cost = map.get("acostRatio");
        }
        try {
            sql.append(" replace into ebike.ebike_cssh_distscheme(csshDistSchemeId,chargestationId,orgoprOrgNo,stakeholderOrgNo,csshdsStatus,incomeRatio,costRatio,effTime) ");
            sql.append(" values(?,?,?,?,?,?,?,?)");
            results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{map.get("csshDistSchemeId"), map.get("stationId"), map.get("orgoprOrgNo"), map.get("stakeholderOrgNo"), csshdsStatus, Double.valueOf(income), Double.valueOf(cost), new Date()});
            results = this.addDistschemeLog(map.get("csshDistSchemeId"), map.get("orgName"), map.get("logType"), loginfo, csshdsStatus1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }
}

