/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.oprmgmt.jdbcdao.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.easesource.commons.util.UuidUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.data.jdbc.SqlParamsBuilder;
import com.ebike.openservices.base.dao.AbstractEbikeBaseJdbcDao;
import com.ebike.openservices.oprmgmt.jdbcdao.RateSetDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class RateSetDaoImpl
extends AbstractEbikeBaseJdbcDao
implements RateSetDao {
    @Qualifier(value="ebikeJdbcTemplate")
    private final JdbcTemplate ebikeJdbcTemplate;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    public RateSetDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public List<Map<String, Object>> queryRateStation(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select  a.ID,a.stationNo,a.stationAddr,b.STATUS  as status ,b.NAME as SName, GROUP_CONCAT(c.CHARGEDEVICENO order by c.CHARGEDEVICENO asc) as deviceNo ");
            sql.append(" from cisp_dev.dev_ebikechargestation a  ");
            sql.append(" left join cisp_dev.dev_powersystemresource b on a.ID=b.ID ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID where 1=1 ");
            sql.append(" and a.stationNo like ? ", (Object)("%" + map.get("stationNo") + "%"));
            sql.append(" and  b.NAME like ?", (Object)("%" + map.get("stationName") + "%"));
            sql.append(" and  a.stationAddr like ?", (Object)("%" + map.get("stationAddr") + "%"));
            sql.append(" and b.STATUS=?", (Object)map.get("status"));
            sql.append(" and c.CHARGEDEVICENO like ?", (Object)("%" + map.get("deviceNo") + "%"));
            sql.append(" and b.SUBBURO=?", (Object)subburo);
            sql.append(" and b.CLASSNAME='EBikeChargeStation'  GROUP BY a.ID  ");
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int queryRateCount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from  (select  count(1) ");
            sql.append(" from cisp_dev.dev_ebikechargestation a  ");
            sql.append(" left join cisp_dev.dev_powersystemresource b on a.ID=b.ID ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID where 1=1 ");
            sql.append(" and a.stationNo like ? ", (Object)("%" + map.get("stationNo") + "%"));
            sql.append(" and  b.NAME like ?", (Object)("%" + map.get("stationName") + "%"));
            sql.append(" and  a.stationAddr like ?", (Object)("%" + map.get("stationAddr") + "%"));
            sql.append(" and b.STATUS=?", (Object)map.get("status"));
            sql.append(" and c.CHARGEDEVICENO like ?", (Object)("%" + map.get("deviceNo") + "%"));
            sql.append(" and b.SUBBURO=?", (Object)subburo);
            sql.append(" and b.CLASSNAME='EBikeChargeStation' GROUP BY a.ID ) n  ");
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public List<Map<String, Object>> queryRateModel(String stationId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select a.csbsId,a.csbsType,a.csbsStatus,a.csbsUsersListId,a.newCsbsUsersListId,a.newSchemeId,a.csbsDesc,b.schemeId,b.schemeName,b.unitPrice1,b.schemeType, ");
            sql.append("  b.unitPrice2,b.unitPrice4,b.stepPower1,b.stepPower2,b.stepPower3,b.closingPeriod  ");
            sql.append(" ,b.unitPrice3,b.minCharge,b.isReturn,b.schemeType, b.schemeDetails,c.schemeName as 'cschemeName',c.unitPrice1 as 'cunitPrice1',  ");
            sql.append(" c.unitPrice2 as 'cunitPrice2',c.unitPrice3 as 'cunitPrice3',c.unitPrice4 as 'cunitPrice4',c.minCharge as 'cminCharge', ");
            sql.append("  c.stepPower1  as 'cstepPower1',c.stepPower2 as 'cstepPower2',c.stepPower3 as 'cstepPower3',c.closingPeriod as 'cclosingPeriod', ");
            sql.append("  c.isReturn as 'cisReturn',c.schemeType as 'cschemeType' from ebike.ebike_csbs_info a left join ebike.ebike_billingscheme b on a.schemeId=b.schemeId  ");
            sql.append(" LEFT JOIN ebike.ebike_billingscheme c on a.newSchemeId=c.schemeId  where 1=1 ");
            sql.append(" and a.chargestationId=? ", (Object)stationId);
            sql.append("  order by field(a.csbsType,'00','01')  asc , field(a.csbsStatus,'00','01','02','03','10') asc,a.effTime desc  ");
            this.logger.debug(">>>>>>>>>>>queryRateModel<<<<<<<<<<<<<<" + sql);
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (rs, rownum) -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("csbsId", rs.getString("csbsId"));
                map.put("csbsType", rs.getString("csbsType"));
                map.put("csbsStatus", rs.getString("csbsStatus"));
                map.put("csbsUsersListId", rs.getString("csbsUsersListId"));
                map.put("newCsbsUsersListId", rs.getString("newCsbsUsersListId"));
                map.put("schemeId", rs.getString("schemeId"));
                map.put("newSchemeId", rs.getString("newSchemeId"));
                map.put("csbsDesc", rs.getString("csbsDesc"));
                map.put("schemeType", rs.getString("schemeType"));
                String schemeDetails = rs.getString("schemeDetails");
                map.put("schemeDetails", schemeDetails);
                if (!"".equals(rs.getString("cschemeName")) && rs.getString("cschemeName") != null) {
                    String minCharge1 = "";
                    String minCharge2 = "";
                    String afterSchemeInfo = "";
                    String beformSchemeInfo = "";
                    String closingPeriod1 = "";
                    String closingPeriod2 = "";
                    String isReturn = "";
                    String isReturn1 = "";
                    String schemeName = "";
                    String schemeName1 = "";
                    if ("Y".equals(rs.getString("cisReturn"))) {
                        map.put("cisReturn", "\u9884\u4ed8\u53ef\u9000");
                    } else {
                        map.put("cisReturn", "\u9884\u4ed8\u4e0d\u9000");
                    }
                    if ("03".equals(rs.getString("cschemeType"))) {
                        afterSchemeInfo = "(\u8ba1\u6b21) " + String.valueOf(rs.getInt("cunitPrice1")) + " \u5143/\u6b21 ";
                        minCharge1 = " \u65e0 (\u66f4\u6539\u540e)";
                        closingPeriod1 = " \u65e0 (\u66f4\u6539\u540e)";
                        isReturn = " \u9884\u4ed8\u4e0d\u9000 (\u66f4\u6539\u540e)";
                    } else {
                        afterSchemeInfo = " (\u8ba1\u65f6) 0 W\uff5e" + String.valueOf(rs.getInt("cstepPower1")) + " W  \uff1a " + String.valueOf(rs.getDouble("cunitPrice1")) + " \u5c0f\u65f6/\u5143 \uff0c" + String.valueOf(rs.getInt("cstepPower1")) + " W \uff5e" + String.valueOf(rs.getInt("cstepPower2")) + " W \uff1a " + String.valueOf(rs.getDouble("cunitPrice2")) + " \u5c0f\u65f6/\u5143 \uff0c" + String.valueOf(rs.getInt("cstepPower2")) + " W \uff5e" + String.valueOf(rs.getInt("cstepPower3")) + " W \uff1a " + String.valueOf(rs.getDouble("cunitPrice3")) + " \u5c0f\u65f6/\u5143 \uff0c" + String.valueOf(rs.getInt("cstepPower3")) + " W \uff5e \u221e  \uff1a " + String.valueOf(rs.getDouble("cunitPrice4")) + " \u5c0f\u65f6/\u5143\u3002 (\u66f4\u6539\u540e)";
                        minCharge1 = String.valueOf(rs.getDouble("cminCharge")) + "(\u66f4\u6539\u540e)\r\n";
                        closingPeriod1 = String.valueOf(rs.getInt("cclosingPeriod")) + "(\u66f4\u6539\u540e)";
                        isReturn = "Y".equals(rs.getString("cisReturn")) ? "\u9884\u4ed8\u53ef\u9000 (\u66f4\u6539\u540e)" : "\u9884\u4ed8\u4e0d\u9000 (\u66f4\u6539\u540e)";
                    }
                    if ("03".equals(rs.getString("schemeType"))) {
                        beformSchemeInfo = "(\u8ba1\u6b21) " + String.valueOf(rs.getInt("unitPrice1")) + " \u5143/\u6b21 (\u66f4\u6539\u524d)\r\n;";
                        minCharge2 = "\u65e0 \uff08\u66f4\u6539\u524d\uff09\r\n;";
                        closingPeriod2 = "\u65e0 \uff08\u66f4\u6539\u524d\uff09\r\n;";
                        isReturn1 = "\u9884\u4ed8\u4e0d\u9000 \uff08\u66f4\u6539\u524d\uff09\r\n;";
                    } else if ("02".equals(rs.getString("schemeType"))) {
                        if (StrUtil.isNotBlank((CharSequence)schemeDetails)) {
                            String chargeServiceFee = JSONUtil.parseObj((String)schemeDetails).getStr((Object)"charge_service_fee");
                            String elecLossFee = JSONUtil.parseObj((String)schemeDetails).getStr((Object)"elec_loss_fee");
                            beformSchemeInfo = "\uff08\u8ba1\u7535\u91cf\uff09\u7535\u5ea6\u7535\u8d39\uff1a" + rs.getDouble("unitPrice1") + "\u5143/\u5ea6\uff0c\u57fa\u7840\u670d\u52a1\u8d39\uff1a" + chargeServiceFee + "\u5143/\u5ea6\uff0c\u9644\u52a0\u670d\u52a1\u8d39\uff1a" + elecLossFee + "\u5143/\u5ea6";
                        }
                        map.put("isReturn", "\u9884\u4ed8\u53ef\u9000");
                        if (rs.getInt("closingPeriod") == 0) {
                            map.put("closingPeriod", "\u65e0");
                        } else {
                            map.put("closingPeriod", String.valueOf(rs.getInt("closingPeriod")));
                        }
                        map.put("minCharge", String.valueOf(rs.getDouble("minCharge")));
                    } else if ("05".equals(rs.getString("schemeType"))) {
                        String elecCost = JSONUtil.parseObj((String)schemeDetails).getStr((Object)"elec_cost");
                        beformSchemeInfo = "\uff08\u8ba1\u7535\u91cf+\u8ba1\u65f6\uff08\u9636\u68af\u529f\u7387\uff09\uff09\u7535\u5ea6\u7535\u4ef7\uff1a" + elecCost + "\u5143/\u5c0f\u65f6\uff0c\u670d\u52a1\u8d39\uff1a 0 W\uff5e" + rs.getInt("stepPower1") + " W  \uff1a " + rs.getDouble("unitPrice1") + " \u5143/\u5c0f\u65f6 \uff0c" + rs.getInt("stepPower1") + " W \uff5e" + rs.getInt("stepPower2") + " W \uff1a " + rs.getDouble("unitPrice2") + " \u5143/\u5c0f\u65f6 \uff0c" + rs.getInt("stepPower2") + " W \uff5e" + rs.getInt("stepPower3") + " W \uff1a " + rs.getDouble("unitPrice3") + " \u5143/\u5c0f\u65f6 \uff0c" + rs.getInt("stepPower3") + " W \uff5e \u221e  \uff1a " + rs.getDouble("unitPrice4") + " \u5143/\u5c0f\u65f6";
                        minCharge2 = rs.getDouble("minCharge") + "\uff08\u66f4\u6539\u524d\uff09\r\n;";
                        closingPeriod2 = rs.getInt("closingPeriod") + "(\u66f4\u6539\u524d)\r\n\uff1b";
                        map.put("isReturn", "\u9884\u4ed8\u53ef\u9000");
                        if (rs.getInt("closingPeriod") == 0) {
                            map.put("closingPeriod", "\u65e0");
                        } else {
                            map.put("closingPeriod", String.valueOf(rs.getInt("closingPeriod")));
                        }
                        map.put("minCharge", String.valueOf(rs.getDouble("minCharge")));
                    } else {
                        beformSchemeInfo = "\uff08\u8ba1\u65f6\uff09 0 W\uff5e" + String.valueOf(rs.getInt("stepPower1")) + " W  \uff1a " + String.valueOf(rs.getDouble("unitPrice1")) + " \u5c0f\u65f6/\u5143 \uff0c" + String.valueOf(rs.getInt("stepPower1")) + " W \uff5e" + String.valueOf(rs.getInt("stepPower2")) + " W \uff1a " + String.valueOf(rs.getDouble("unitPrice2")) + " \u5c0f\u65f6/\u5143 \uff0c" + String.valueOf(rs.getInt("stepPower2")) + " W \uff5e" + String.valueOf(rs.getInt("stepPower3")) + " W \uff1a " + String.valueOf(rs.getDouble("unitPrice3")) + " \u5c0f\u65f6/\u5143 \uff0c" + String.valueOf(rs.getInt("stepPower3")) + " W \uff5e \u221e  \uff1a " + String.valueOf(rs.getDouble("unitPrice4")) + " \u5c0f\u65f6/\u5143\u3002 (\u66f4\u6539\u524d)\r\n;";
                        minCharge2 = String.valueOf(rs.getDouble("minCharge")) + "\uff08\u66f4\u6539\u524d\uff09\r\n;";
                        closingPeriod2 = String.valueOf(rs.getInt("closingPeriod")) + "(\u66f4\u6539\u524d)\r\n\uff1b";
                        isReturn1 = "Y".equals(rs.getString("isReturn")) ? "\u9884\u4ed8\u53ef\u9000 (\u66f4\u6539\u524d)\r\n\uff1b" : "\u9884\u4ed8\u4e0d\u9000 (\u66f4\u6539\u524d)\r\n\uff1b";
                    }
                    String powerAndPrice = beformSchemeInfo + afterSchemeInfo;
                    map.put("powerAndPrice", powerAndPrice);
                    map.put("minCharge", minCharge2 + minCharge1);
                    map.put("closingPeriod", closingPeriod2 + closingPeriod1);
                    map.put("isReturn", isReturn1 + isReturn);
                    map.put("schemeName", rs.getString("schemeName") + "(\u66f4\u6539\u524d)\r\n\uff1b" + rs.getString("cschemeName") + " \uff08\u66f4\u6539\u540e\uff09");
                } else {
                    String powerAndPrice1 = "";
                    if ("03".equals(rs.getString("schemeType"))) {
                        powerAndPrice1 = "\uff08\u8ba1\u6b21\uff09" + String.valueOf(rs.getDouble("unitPrice1")) + "\u5143/\u6b21";
                        map.put("isReturn", "\u9884\u4ed8\u4e0d\u9000");
                        map.put("closingPeriod", "\u65e0");
                        map.put("minCharge", "\u65e0");
                    } else if ("02".equals(rs.getString("schemeType"))) {
                        if (StrUtil.isNotBlank((CharSequence)schemeDetails)) {
                            String chargeServiceFee = JSONUtil.parseObj((String)schemeDetails).getStr((Object)"charge_service_fee");
                            String elecLossFee = JSONUtil.parseObj((String)schemeDetails).getStr((Object)"elec_loss_fee");
                            powerAndPrice1 = "\uff08\u8ba1\u7535\u91cf\uff09\u7535\u5ea6\u7535\u8d39\uff1a" + rs.getDouble("unitPrice1") + "\u5143/\u5ea6\uff0c\u57fa\u7840\u670d\u52a1\u8d39\uff1a" + chargeServiceFee + "\u5143/\u5ea6\uff0c\u9644\u52a0\u670d\u52a1\u8d39\uff1a" + elecLossFee + "\u5143/\u5ea6";
                        }
                        map.put("isReturn", "\u9884\u4ed8\u53ef\u9000");
                        if (rs.getInt("closingPeriod") == 0) {
                            map.put("closingPeriod", "\u65e0");
                        } else {
                            map.put("closingPeriod", String.valueOf(rs.getInt("closingPeriod")));
                        }
                        map.put("minCharge", String.valueOf(rs.getDouble("minCharge")));
                    } else if ("05".equals(rs.getString("schemeType"))) {
                        String elecCost = JSONUtil.parseObj((String)schemeDetails).getStr((Object)"elec_cost");
                        powerAndPrice1 = "\uff08\u8ba1\u7535\u91cf+\u8ba1\u65f6\uff08\u9636\u68af\u529f\u7387\uff09\uff09\u7535\u5ea6\u7535\u4ef7\uff1a" + elecCost + "\u5143/\u5c0f\u65f6\uff0c\u670d\u52a1\u8d39\uff1a 0 W\uff5e" + rs.getInt("stepPower1") + " W  \uff1a " + rs.getDouble("unitPrice1") + " \u5143/\u5c0f\u65f6 \uff0c" + rs.getInt("stepPower1") + " W \uff5e" + rs.getInt("stepPower2") + " W \uff1a " + rs.getDouble("unitPrice2") + " \u5143/\u5c0f\u65f6 \uff0c" + rs.getInt("stepPower2") + " W \uff5e" + rs.getInt("stepPower3") + " W \uff1a " + rs.getDouble("unitPrice3") + " \u5143/\u5c0f\u65f6 \uff0c" + rs.getInt("stepPower3") + " W \uff5e \u221e  \uff1a " + rs.getDouble("unitPrice4") + " \u5143/\u5c0f\u65f6";
                        map.put("isReturn", "\u9884\u4ed8\u53ef\u9000");
                        if (rs.getInt("closingPeriod") == 0) {
                            map.put("closingPeriod", "\u65e0");
                        } else {
                            map.put("closingPeriod", String.valueOf(rs.getInt("closingPeriod")));
                        }
                        map.put("minCharge", String.valueOf(rs.getDouble("minCharge")));
                    } else {
                        powerAndPrice1 = "\uff08\u8ba1\u65f6\uff090 W\uff5e" + rs.getInt("stepPower1") + " W  \uff1a " + rs.getDouble("unitPrice1") + " \u5c0f\u65f6/\u5143 \uff0c" + rs.getInt("stepPower1") + " W \uff5e" + rs.getInt("stepPower2") + " W \uff1a " + rs.getDouble("unitPrice2") + " \u5c0f\u65f6/\u5143 \uff0c" + rs.getInt("stepPower2") + " W \uff5e" + rs.getInt("stepPower3") + " W \uff1a " + rs.getDouble("unitPrice3") + " \u5c0f\u65f6/\u5143 \uff0c" + rs.getInt("stepPower3") + " W \uff5e \u221e  \uff1a " + rs.getDouble("unitPrice4") + " \u5c0f\u65f6/\u5143";
                        if ("Y".equals(rs.getString("isReturn"))) {
                            map.put("isReturn", "\u9884\u4ed8\u53ef\u9000");
                        } else {
                            map.put("isReturn", "\u9884\u4ed8\u4e0d\u9000");
                        }
                        if (rs.getInt("closingPeriod") == 0) {
                            map.put("closingPeriod", "\u65e0");
                        } else {
                            map.put("closingPeriod", String.valueOf(rs.getInt("closingPeriod")));
                        }
                        map.put("minCharge", String.valueOf(rs.getDouble("minCharge")));
                    }
                    map.put("powerAndPrice", powerAndPrice1);
                    map.put("schemeName", rs.getString("schemeName"));
                }
                return map;
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int rateModelCount(String stationId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebike.ebike_csbs_info a left join ebike.ebike_billingscheme b on a.csbsId=b.schemeId ");
            sql.append(" LEFT JOIN ebike.ebike_billingscheme c on a.newSchemeId=c.schemeId  where 1=1 ");
            sql.append(" and a.chargestationId=? ", (Object)stationId);
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public String findPhoneById(String userId) {
        return null;
    }

    @Override
    public String sRateAdd(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        String message = "";
        String uuid = UuidUtils.generateUuidString();
        String phones = map.get("phoneList");
        String[] userPhones = map.get("userPhone").split(",");
        String csbsStatus = "";
        int count = this.querySCountById(map.get("stationId"));
        csbsStatus = count > 0 ? "01" : "00";
        try {
            sql.append(" insert into ebike.ebike_csbs_info(csbsId,chargestationId,csbsType,csbsStatus,csbsDesc,schemeId,csbsUsersListId,effTime)");
            sql.append(" values(?,?,?,?,?,?,?,?)");
            this.logger.debug("SRateAdd" + sql.toString());
            results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{uuid, map.get("stationId"), map.get("McsbsType"), csbsStatus, map.get("McsbsDesc"), map.get("MschemeId"), map.get("csbsUsersListId"), count <= 0 ? new Date() : null});
            if (count <= 0) {
                if (!"".equals(map.get("csbsUsersListId"))) {
                    if ("1".equals(map.get("updateOrinsert")) || "3".equals(map.get("updateOrinsert"))) {
                        String[] phoneList;
                        if (!"".equals(map.get("userPhone"))) {
                            this.logger.debug(">>>>>>><userPhone<<<<<<<<<<<<<" + map.get("userPhone"));
                            this.logger.debug(">>>>>>><userPhone<<<<<<<<<<<<<" + map.get("phoneList"));
                            for (int i = 0; i < userPhones.length; ++i) {
                                phones = phones.replaceAll(userPhones[i] + ",", "");
                            }
                        }
                        this.logger.debug(">>>>>>>>phoneList<<<<<<<<<<<<<" + phones);
                        for (String Phone : phoneList = phones.split(",")) {
                            results = this.addCsbsUser(map.get("csbsUsersListId"), Phone);
                        }
                        if ("1".equals(map.get("updateOrinsert"))) {
                            results = this.deleteRepatePhone(map.get("csbsUsersListId"), map.get("userPhone"), map.get("updateOrinsert"));
                        }
                    } else {
                        String[] phoneList;
                        results = this.deleteUserByPhone(map.get("userPhone"));
                        for (String phone : phoneList = map.get("phoneList").split(",")) {
                            results = this.addCsbsUser(map.get("csbsUsersListId"), phone);
                        }
                        List<Map<String, Object>> userlist = this.selectUserId(map.get("stationId"), uuid);
                        for (int i = 0; i < userlist.size(); ++i) {
                            if (!"".equals(userlist.get(i).get("csbsUsersListId")) && userlist.get(i).get("csbsUsersListId") != null) {
                                results = this.deleteRepatePhone(userlist.get(i).get("csbsUsersListId").toString(), map.get("userPhone"), map.get("updateOrinsert"));
                            }
                            if ("".equals(userlist.get(i).get("newCsbsUsersListId")) || userlist.get(i).get("newCsbsUsersListId") == null) continue;
                            results = this.deleteRepatePhone(userlist.get(i).get("newCsbsUsersListId").toString(), map.get("userPhone"), map.get("updateOrinsert"));
                        }
                    }
                }
            } else {
                if (!"".equals(map.get("csbsUsersListId"))) {
                    if ("1".equals(map.get("updateOrinsert"))) {
                        results = this.deleteRepatePhone(map.get("csbsUsersListId"), map.get("userPhone"), map.get("updateOrinsert"));
                    } else if ("0".equals(map.get("updateOrinsert"))) {
                        List<Map<String, Object>> userlist = this.selectUserList(map.get("stationId"), uuid);
                        for (int i = 0; i < userlist.size(); ++i) {
                            if (!"".equals(((Map)userlist.get(i)).get("csbsUsersListId")) && ((Map)userlist.get(i)).get("csbsUsersListId") != null) {
                                this.logger.debug(">>>>>>>>>SRateAdd<<<<<<<<<" + ((Map)userlist.get(i)).get("csbsUsersListId"));
                                results = this.deleteRepatePhone(((Map)userlist.get(i)).get("csbsUsersListId").toString(), map.get("userPhone"), map.get("updateOrinsert"));
                            }
                            if ("".equals(((Map)userlist.get(i)).get("newCsbsUsersListId")) || ((Map)userlist.get(i)).get("newCsbsUsersListId") == null) continue;
                            results = this.deleteRepatePhone(((Map)userlist.get(i)).get("newCsbsUsersListId").toString(), map.get("userPhone"), map.get("updateOrinsert"));
                        }
                        String[] stringArray = userPhones;
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String userPhone = stringArray[i];
                            if ("".equals(userPhone) || "null".equals(userPhone)) continue;
                            results = this.addRepeatData(userPhone, map.get("csbsUsersListId"), map.get("updateOrinsert"));
                        }
                    } else {
                        results = this.updateRepeatData(map.get("csbsUsersListId"), map.get("updateOrinsert"));
                    }
                }
                for (String userPhone : userPhones) {
                    results = !"".equals(userPhone) && !"null".equals(userPhone) ? this.addRepeatData(userPhone, map.get("csbsUsersListId"), map.get("updateOrinsert")) : this.updateRepeatData(map.get("csbsUsersListId"), map.get("updateOrinsert"));
                }
            }
            results = this.csbsOperation(map.get("stationId"), uuid, map.get("subburo"), map.get("orgName"));
            results = this.addcsbsOpLog(uuid, "10", "01", map.get("orgName"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
        message = results > 0 ? (count > 0 ? "\u8ba1\u8d39\u6a21\u677f\u65b0\u589e\u64cd\u4f5c\u6210\u529f\uff0c\u8bf7\u7b49\u5f85\u5171\u4eab\u4eba\u786e\u8ba4" : "\u8ba1\u8d39\u6a21\u677f\u8bbe\u7f6e\u6210\u529f,\u5373\u65f6\u751f\u6548") : "\u8ba1\u8d39\u6a21\u677f\u65b0\u589e\u64cd\u4f5c\u5931\u8d25\uff01";
        return message;
    }

    public List<Map<String, Object>> selectUserId(String stationId, String csbsId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select b.csbsUsersListId,b.newCsbsUsersListId from ebike.ebike_csbs_info b  where 1=1 and b.csbsStatus!='10'   ");
            sql.append(" and b.chargestationId=?", (Object)stationId);
            if (!"".equals(csbsId)) {
                sql.append(" and b.csbsId!=? ", (Object)csbsId);
            }
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    public List<Map<String, Object>> selectUserList(String stationId, String csbsId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select b.csbsUsersListId,b.newCsbsUsersListId from ebike.ebike_csbs_info b  where 1=1 and b.csbsStatus!='10' ");
            sql.append(" and b.chargestationId=?", (Object)stationId);
            if (!"".equals(csbsId)) {
                sql.append(" and b.csbsId!=? ", (Object)csbsId);
            }
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    public int querySCountById(String stationId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" select count(1) from ebike.ebike_cssh_distscheme  where 1=1 and ( csshdsStatus='00' or  csshdsStatus='02') ");
            sql.append(" and chargestationId=?", (Object)stationId);
            results = (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    public int addCsbsUser(String csbsUsersListId, String userPhone) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" insert into ebike.ebike_csbs_info_userlist(csbsUsersListId,csbsUserMobile,createTime)");
            sql.append(" values(?,?,?)");
            results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{csbsUsersListId, userPhone, new Date()});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    @Override
    public String rateModify(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        String message = "";
        String phones = map.get("phoneList");
        String[] userPhones = map.get("userPhone").split(",");
        int count = this.querySCountById(map.get("stationId"));
        this.logger.debug(">>>>>>>>>>>count<<<<<<<<<<<" + count);
        this.logger.debug(">>>>>>>>>>>count<<<<<<<<<<<" + map.get("stationId"));
        try {
            sql.append(" update ebike.ebike_csbs_info set ");
            if (count > 0) {
                sql.append(" csbsStatus='02' ");
                sql.append(",newSchemeId=?", (Object)map.get("MschemeId"));
                sql.append(",newCsbsUsersListId=?", (Object)map.get("csbsUsersListId"));
                sql.append(" ,effTime=null ");
            } else {
                sql.append(" csbsStatus='00' ");
                sql.append(",schemeId=?", (Object)map.get("MschemeId"));
                sql.append(",csbsUsersListId=?", (Object)map.get("csbsUsersListId"));
                sql.append(" ,effTime=?", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            sql.append(" ,csbsDesc=?", (Object)map.get("McsbsDesc"));
            sql.append(" where 1=1 ");
            sql.append(" and csbsId=?", (Object)map.get("csbsId"));
            results = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            String updateOrinsert = map.get("updateOrinsert");
            if (count <= 0) {
                if ("00".equals(map.get("csbsType"))) {
                    this.logger.debug("csbsType ", (Object)map.get("csbsType"));
                    int n = this.updateCsbsInfo(map.get("MschemeId"), map.get("stationId"));
                }
                if (!"".equals(map.get("csbsUsersListId"))) {
                    if ("1".equals(map.get("updateOrinsert")) || "3".equals(map.get("updateOrinsert"))) {
                        String[] phoneList;
                        if (!"".equals(map.get("userPhone"))) {
                            for (int i = 0; i < userPhones.length; ++i) {
                                phones = phones.replaceAll(userPhones[i] + ",", "");
                            }
                        }
                        for (String Phone : phoneList = phones.split(",")) {
                            results = this.addCsbsUser(map.get("csbsUsersListId"), Phone);
                        }
                        if ("1".equals(map.get("updateOrinsert"))) {
                            results = this.deleteRepatePhone(map.get("csbsUsersListId"), map.get("userPhone"), updateOrinsert);
                        }
                    } else {
                        String[] phoneList;
                        results = this.deleteUserByPhone(map.get("userPhone"));
                        for (String phone : phoneList = map.get("phoneList").split(",")) {
                            results = this.addCsbsUser(map.get("csbsUsersListId"), phone);
                        }
                        List<Map<String, Object>> userlist = this.selectUserList(map.get("stationId"), map.get("csbsId"));
                        for (int i = 0; i < userlist.size(); ++i) {
                            if (!"".equals(userlist.get(i).get("csbsUsersListId")) && userlist.get(i).get("csbsUsersListId") != null) {
                                results = this.deleteRepatePhone(userlist.get(i).get("csbsUsersListId").toString(), map.get("userPhone"), map.get("updateOrinsert"));
                            }
                            if ("".equals(userlist.get(i).get("newCsbsUsersListId")) || userlist.get(i).get("newCsbsUsersListId") == null) continue;
                            results = this.deleteRepatePhone(userlist.get(i).get("newCsbsUsersListId").toString(), map.get("userPhone"), map.get("updateOrinsert"));
                        }
                    }
                }
            } else {
                if (!"".equals(map.get("csbsUsersListId"))) {
                    if ("1".equals(map.get("updateOrinsert"))) {
                        results = this.deleteRepatePhone(map.get("csbsUsersListId"), map.get("userPhone"), updateOrinsert);
                    } else if ("0".equals(map.get("updateOrinsert"))) {
                        List<Map<String, Object>> userlist = this.selectUserList(map.get("stationId"), map.get("csbsId"));
                        this.logger.debug(">>>>>>>>>>userlist<<<<<<<<<<<<<<<<<<<<<<" + userlist.toString());
                        for (int i = 0; i < userlist.size(); ++i) {
                            if (!"".equals(userlist.get(i).get("csbsUsersListId")) && userlist.get(i).get("csbsUsersListId") != null) {
                                results = this.deleteRepatePhone(userlist.get(i).get("csbsUsersListId").toString(), map.get("userPhone"), map.get("updateOrinsert"));
                            }
                            if ("".equals(userlist.get(i).get("newCsbsUsersListId")) || userlist.get(i).get("newCsbsUsersListId") == null) continue;
                            results = this.deleteRepatePhone(userlist.get(i).get("newCsbsUsersListId").toString(), map.get("userPhone"), map.get("updateOrinsert"));
                        }
                        for (String userPhone : userPhones) {
                            if ("".equals(userPhone) || "null".equals(userPhone)) continue;
                            results = this.addRepeatData(userPhone, map.get("csbsUsersListId"), updateOrinsert);
                        }
                    } else {
                        results = this.updateRepeatData(map.get("csbsUsersListId"), updateOrinsert);
                    }
                }
                results = this.csbsOperation(map.get("stationId"), map.get("csbsId"), map.get("subburo"), map.get("orgName"));
            }
            results = this.addcsbsOpLog(map.get("csbsId"), "20", "02", map.get("orgName"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
        message = results > 0 ? (count > 0 ? "\u8ba1\u8d39\u6a21\u677f\u4fee\u6539\u64cd\u4f5c\u6210\u529f\uff0c\u8bf7\u7b49\u5f85\u5171\u4eab\u4eba\u786e\u8ba4" : "\u8ba1\u8d39\u6a21\u677f\u8bbe\u7f6e\u6210\u529f,\u5373\u65f6\u751f\u6548") : "\u8ba1\u8d39\u6a21\u677f\u4fee\u6539\u64cd\u4f5c\u5931\u8d25\uff01";
        return message;
    }

    public int addRepeatData(String csbsUserMobile, String uuid, String updateOrInsert) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" insert into ebike.ebike_csbs_info_fu_userlist(csbsUsersListId,repateMobile,updateOrInsert)");
            sql.append(" values(?,?,?)");
            return this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{uuid, csbsUserMobile, updateOrInsert});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public int updateRepeatData(String uuid, String updateOrInsert) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" update ebike.ebike_csbs_info_fu_userlist set ");
            sql.append(" updateOrInsert=? ", (Object)updateOrInsert);
            sql.append(" where 1=1 ");
            sql.append(" and csbsUsersListId=? ", (Object)uuid);
            return this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public Map<String, Object> stopRate(String csbsId, String orgName, String stationId, String subburo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        String message = "";
        int count = this.querySCountById(stationId);
        try {
            results = this.getSchemeCountByStationId(stationId);
            if (results <= 1) {
                message = "\u53ea\u6709\u5b58\u5728\u4e00\u4e2a\u4ee5\u4e0a\u751f\u6548\u7684\u8ba1\u8d39\u65b9\u6848\u624d\u53ef\u4ee5\u8fdb\u884c\u7ec8\u6b62\u64cd\u4f5c";
                map.put("status", 0);
                map.put("message", message);
                return map;
            }
            sql.append(" update ebike.ebike_csbs_info set  ");
            if (count > 0) {
                sql.append(" csbsStatus='03'  ");
                sql.append(" where 1=1 ");
            } else {
                sql.append(" csbsStatus='10'  ");
                sql.append(" ,effTime=?", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                sql.append(" where 1=1 ");
            }
            sql.append(" and csbsId=?", (Object)csbsId);
            results = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            if (count > 0) {
                results = this.csbsOperation(stationId, csbsId, subburo, orgName);
            }
            results = this.addcsbsOpLog(csbsId, "30", "03", orgName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return map;
        }
        if (results > 0) {
            message = count > 0 ? "\u8ba1\u8d39\u6a21\u677f\u7ec8\u6b62\u64cd\u4f5c\u6210\u529f\uff0c\u8bf7\u7b49\u5f85\u5171\u4eab\u4eba\u786e\u8ba4" : "\u8ba1\u8d39\u6a21\u677f\u8bbe\u7f6e\u6210\u529f,\u5373\u65f6\u751f\u6548";
            map.put("status", 1);
            map.put("message", message);
        } else {
            message = "\u8ba1\u8d39\u6a21\u677f\u7ec8\u6b62\u64cd\u4f5c\u5931\u8d25\uff01";
            map.put("status", 2);
            map.put("message", message);
        }
        return map;
    }

    @Override
    public List<Map<String, Object>> qShareStation(String subburo, Map<String, String> map) {
        System.out.println(subburo);
        System.out.println(map);
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select  a.ID,a.stationNo,a.stationAddr,b.STATUS as status,b.NAME as SName, GROUP_CONCAT(DISTINCT(c.CHARGEDEVICENO) order by c.CHARGEDEVICENO asc) as deviceNo  ");
            sql.append(" from ebike.ebike_cssh_distscheme d  ");
            sql.append(" left join cisp_dev.dev_ebikechargestation a  on a.ID=d.chargestationId ");
            sql.append(" left join cisp_dev.dev_powersystemresource b on  b.ID=a.ID  ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID  where 1=1 ");
            sql.append(" and a.stationNo like ? ", (Object)("%" + map.get("stationNo") + "%"));
            sql.append(" and  b.NAME like ?", (Object)("%" + map.get("stationName") + "%"));
            sql.append(" and  a.stationAddr like ?", (Object)("%" + map.get("stationAddr") + "%"));
            sql.append(" and b.STATUS=?", (Object)map.get("status"));
            sql.append(" and c.CHARGEDEVICENO like ?", (Object)("%" + map.get("deviceNo") + "%"));
            sql.append(" and d.stakeholderOrgNo=?", (Object)subburo);
            sql.append(" and ( d.csshdsStatus='00' or d.csshdsStatus='02') ");
            sql.append(" and b.CLASSNAME='EBikeChargeStation' GROUP BY a.ID  ");
            this.logger.debug(">>>>>>>>>>>QShareStation<<<<<<<<<<<<<" + sql.toString());
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int qShareCount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from  (select  count(1)");
            sql.append(" from ebike.ebike_cssh_distscheme d  ");
            sql.append(" left join cisp_dev.dev_ebikechargestation a  on a.ID=d.chargestationId ");
            sql.append(" left join cisp_dev.dev_powersystemresource b on  b.ID=a.ID  ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID  where 1=1 ");
            sql.append(" and a.stationNo like ? ", (Object)("%" + map.get("stationNo") + "%"));
            sql.append(" and  b.NAME like ?", (Object)("%" + map.get("stationName") + "%"));
            sql.append(" and b.STATUS=?", (Object)map.get("status"));
            sql.append(" and c.CHARGEDEVICENO like ?", (Object)("%" + map.get("deviceNo") + "%"));
            sql.append(" and d.stakeholderOrgNo=?", (Object)subburo);
            sql.append(" and ( d.csshdsStatus='00' or d.csshdsStatus='02') ");
            sql.append(" and b.CLASSNAME='EBikeChargeStation' GROUP BY a.ID ) n  ");
            this.logger.debug(">>>>>>>>>>>>>>><QShareCount<<<<<<<<<<<<" + sql.toString());
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public int csbsOperation(String stationId, String uuid, String subburo, String orgName) {
        int results = 0;
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List list = new ArrayList();
        try {
            sql.append(" select stakeholderOrgNo from ebike.ebike_cssh_distscheme where 1=1 and csshdsStatus='00' ");
            sql.append(" and orgoprOrgNo=? ", (Object)subburo);
            sql.append(" and chargestationId=?", (Object)stationId);
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
            for (int i = 0; i < list.size(); ++i) {
                results = this.addShareConfirm(((Map)list.get(i)).get("stakeholderOrgNo").toString(), uuid, orgName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    public int addShareConfirm(String stakeholderOrgNo, String uuid, String orgName) {
        int results = 0;
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" replace into ebike.ebike_csbs_info_tbc(csbsId,stakeholderOrgNo,creator,createTime,confirmFlag) ");
            sql.append(" values(?,?,?,?,?)");
            this.logger.debug(">>>>>>>>>>>>addShareConfirm<<<<<<<<<<<" + sql.toString());
            results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{uuid, stakeholderOrgNo, orgName, new Date(), "0"});
            this.logger.debug(">>>>>>>>>>>>addShareConfirm1<<<<<<<<<<<" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    @Override
    public List<Map<String, Object>> queryOperationInfo(String csbsId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select a.csbsId,a.logType,a.logTime,b.USER_NAME as 'userName',b.USER_ORG_NAME as 'orgName' ");
            sql.append(" from ebike.ebike_log_csbs_info a left join cisp_sys.bp_user b on a.operator=b.USER_NO where 1=1 ");
            sql.append(" and a.csbsId=?", (Object)csbsId);
            sql.append(" order by  a.logTime desc ");
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rownum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("csbsId", rs.getString("csbsId"));
                    map.put("logType", rs.getString("logType"));
                    map.put("logTime", rs.getTimestamp("logTime"));
                    map.put("userName", rs.getString("userName"));
                    map.put("orgName", rs.getString("orgName"));
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int operationCount(String csbsId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebike.ebike_log_csbs_info a left join cisp_sys.bp_user b on a.operator=b.USER_NO where 1=1 ");
            sql.append(" and a.csbsId=?", (Object)csbsId);
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public int addcsbsOpLog(String csbsId, String logType, String csshdsStatus, String operator) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" insert into ebike.ebike_log_csbs_info(csbsId,logType,logTime,csbsStatus,operator)");
            sql.append(" values(?,?,?,?,?)");
            return this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{csbsId, logType, new Date(), csshdsStatus, operator});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public int deleteUserByPhone(String userPhone) {
        this.logger.debug("deleteUserByPhone" + userPhone);
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" delete from ebike.ebike_csbs_info_userlist  where 1=1  ");
            sql.append(" and csbsUserMobile in (?)", (Object)userPhone, ",");
            return this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public boolean checkCsbsById(String scheId, String stationId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" select count(1) from ebike.ebike_csbs_info where 1=1  ");
            sql.append(" and (schemeId=?", (Object)scheId);
            sql.append(" or newSchemeId=?)", (Object)scheId);
            sql.append(" and chargestationId=?", (Object)stationId);
            sql.append(" and csbsStatus!='10' ");
            results = (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    @Override
    public boolean yysOpConfirm(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" update ebike.ebike_csbs_info_tbc set ");
            sql.append(" confirmFlag=?", (Object)map.get("confirmFlag"));
            sql.append(" ,confirmer=?", (Object)map.get("orgName"));
            sql.append(" ,confirmTime=?", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            sql.append(" where 1=1 ");
            sql.append(" and csbsId=?", (Object)map.get("csbsId"));
            sql.append(" and stakeholderOrgNo=?", (Object)map.get("subburo"));
            results = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            results = this.updateOpLog(map.get("csbsId"), map.get("orgName"), map.get("logType"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    public int updateOpLog(String csbsId, String orgName, String logType) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        HashMap<String, String> maps = new HashMap<String, String>();
        int results = 0;
        int count = 0;
        try {
            sql.append(" insert into ebike.ebike_log_csbs_info(csbsId,logType,logTime,csbsStatus,operator)");
            sql.append(" values(?,?,?,?,?)");
            results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{csbsId, logType, new Date(), "00", orgName});
            count = this.queryConfirmInfo(csbsId, logType, "0", maps);
            this.logger.debug(">>>>>>>updateOpLog<<<<<<<  " + count);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    public int queryConfirmInfo(String csbsId, String logType, String flag, Map<String, String> maps) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int confirmFlag1 = 0;
        int confirmFlag2 = 0;
        int confirmFlag3 = 0;
        boolean count = false;
        try {
            sql.append(" select confirmFlag from ebike.ebike_csbs_info_tbc  where 1=1 ");
            sql.append(" and csbsId=?", (Object)csbsId);
            List list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
            for (int i = 0; i < list.size(); ++i) {
                if ("0".equals(((Map)list.get(i)).get("confirmFlag"))) {
                    ++confirmFlag1;
                }
                if ("1".equals(((Map)list.get(i)).get("confirmFlag"))) {
                    ++confirmFlag2;
                }
                if (!"2".equals(((Map)list.get(i)).get("confirmFlag"))) continue;
                ++confirmFlag3;
            }
            this.logger.debug(" queryConfirmInfo " + confirmFlag3);
            this.logger.debug(" queryConfirmInfo " + confirmFlag1);
            this.logger.debug(" queryConfirmInfo " + confirmFlag1);
            if (confirmFlag1 == 0 && flag == "0") {
                Map<String, Object> map = this.queryCsbcInfo(csbsId, confirmFlag2, confirmFlag3);
            } else if (confirmFlag1 == 0 && flag == "1") {
                int n = this.foriddenOrUnForidden(csbsId, confirmFlag2, confirmFlag3, maps);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return 1;
    }

    public Map<String, Object> queryCsbcInfo(String csbsId, int confirmFlag2, int confirmFlag3) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        HashMap<String, Object> map = new HashMap<String, Object>();
        List list = null;
        int count = 0;
        int results = 0;
        try {
            sql.append(" select schemeId,newSchemeId,newCsbsUsersListId,csbsStatus,csbsUsersListId,chargestationId,csbsType from ebike.ebike_csbs_info  where 1=1");
            sql.append(" and csbsId=?", (Object)csbsId);
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
            SqlParamsBuilder sql2 = new SqlParamsBuilder();
            sql2.append(" update  ebike.ebike_csbs_info set newSchemeId='',newCsbsUsersListId='' ");
            if (confirmFlag3 != 0 && "01".equals(((Map)list.get(0)).get("csbsStatus")) && confirmFlag2 == 0) {
                sql2.append(" ,csbsStatus='10' ");
            }
            if (confirmFlag3 != 0 && "02".equals(((Map)list.get(0)).get("csbsStatus")) || confirmFlag3 != 0 && "03".equals(((Map)list.get(0)).get("csbsStatus"))) {
                sql2.append(" ,csbsStatus='00' ");
            }
            if (confirmFlag3 == 0 && confirmFlag2 != 0) {
                if ("02".equals(((Map)list.get(0)).get("csbsStatus"))) {
                    if (!"".equals(((Map)list.get(0)).get("newSchemeId")) && ((Map)list.get(0)).get("newSchemeId") != null) {
                        sql2.append(" ,schemeId=?", (Object)((Map)list.get(0)).get("newSchemeId").toString());
                        sql2.append(" ,csbsStatus='00' ");
                    }
                    if (!"".equals(((Map)list.get(0)).get("newCsbsUsersListId")) && ((Map)list.get(0)).get("newCsbsUsersListId") != null) {
                        sql2.append(" ,csbsUsersListId=?", (Object)((Map)list.get(0)).get("newCsbsUsersListId").toString());
                        sql2.append(" ,csbsStatus='00' ");
                    }
                }
                if ("01".equals(((Map)list.get(0)).get("csbsStatus"))) {
                    sql2.append(" ,csbsStatus='00' ");
                }
                if ("03".equals(((Map)list.get(0)).get("csbsStatus"))) {
                    sql2.append(" ,csbsStatus='10' ");
                }
            }
            sql2.append(" ,effTime=?", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            sql2.append(" where 1=1 ");
            sql2.append(" and csbsId=?", (Object)csbsId);
            count = this.ebikeJdbcTemplate.update(sql2.getSql(), sql2.getParams());
            if (confirmFlag3 == 0 && confirmFlag2 != 0) {
                int i;
                Object userlist;
                String[] phoneList;
                String[] userPhones;
                Map<String, String> maps;
                if ("00".equals(((Map)list.get(0)).get("csbsType"))) {
                    int n = this.updateCsbsInfo(((Map)list.get(0)).get("newSchemeId").toString(), ((Map)list.get(0)).get("chargestationId").toString());
                }
                if ("01".equals(((Map)list.get(0)).get("csbsStatus")) && !"".equals(((Map)list.get(0)).get("csbsUsersListId"))) {
                    String phone;
                    int n;
                    int n2;
                    String[] stringArray;
                    String phones = this.queryPhoneList(((Map)list.get(0)).get("csbsUsersListId").toString());
                    this.logger.debug(">>>>>>>>>>>addConfirm<<<<<<<<<<<<<" + phones);
                    maps = this.getPromptInfo(((Map)list.get(0)).get("csbsUsersListId").toString());
                    this.logger.debug(">>>>>>>>>>maps<<<<<<<<<<<<" + maps);
                    userPhones = maps.get("repateMobile").split(",");
                    this.logger.debug(">>>>>>>>>>repateMobile<<<<<<<<<<" + userPhones);
                    if ("1".equals(maps.get("updateOrInsert")) || "3".equals(maps.get("updateOrInsert"))) {
                        for (int i2 = 0; i2 < userPhones.length; ++i2) {
                            if (!"9".equals(userPhones[i2])) {
                                phones = phones.replaceAll(userPhones[i2] + ",", "");
                            }
                            this.logger.debug("userPhones[i] " + userPhones[i2]);
                        }
                        stringArray = phoneList = phones.split(",");
                        n2 = stringArray.length;
                        for (n = 0; n < n2; ++n) {
                            phone = stringArray[n];
                            if (!"null".equals(phone) && phone != null && !"".equals(phone)) {
                                results = this.addCsbsUser(((Map)list.get(0)).get("csbsUsersListId").toString(), phone);
                            }
                            if (!"1".equals(maps.get("updateOrInsert"))) continue;
                            results = this.deleteRepatePhone(((Map)list.get(0)).get("csbsUsersListId").toString(), maps.get("repateMobile"), "0");
                        }
                    } else {
                        phoneList = phones.split(",");
                        this.logger.debug(">>>>>>>>>>><<<<<<<<<<<<<" + map.get("userPhone"));
                        results = this.deleteUserByPhone(maps.get("repateMobile"));
                        stringArray = phoneList;
                        n2 = stringArray.length;
                        for (n = 0; n < n2; ++n) {
                            phone = stringArray[n];
                            if ("null".equals(phone) || phone == null || "".equals(phone)) continue;
                            results = this.addCsbsUser(((Map)list.get(0)).get("csbsUsersListId").toString(), phone);
                        }
                        userlist = this.selectUserId(((Map)list.get(0)).get("chargestationId").toString(), csbsId);
                        for (i = 0; i < userlist.size(); ++i) {
                            if (!"".equals(((Map)userlist.get(i)).get("csbsUsersListId")) && ((Map)userlist.get(i)).get("csbsUsersListId") != null) {
                                results = this.deleteRepatePhone(((Map)userlist.get(i)).get("csbsUsersListId").toString(), maps.get("repateMobile"), maps.get("updateOrinsert").toString());
                            }
                            if ("".equals(((Map)userlist.get(i)).get("newCsbsUsersListId")) || ((Map)userlist.get(i)).get("newCsbsUsersListId") == null) continue;
                            results = this.deleteRepatePhone(((Map)userlist.get(i)).get("newCsbsUsersListId").toString(), maps.get("repateMobile"), "1");
                        }
                    }
                }
                if ("02".equals(((Map)list.get(0)).get("csbsStatus")) && !"".equals(((Map)list.get(0)).get("newCsbsUsersListId"))) {
                    String phones = this.queryPhoneList(((Map)list.get(0)).get("newCsbsUsersListId").toString());
                    this.logger.debug(">>>>>>>>>>phones<<<<<<<<" + phones);
                    maps = this.getPromptInfo(((Map)list.get(0)).get("newCsbsUsersListId").toString());
                    this.logger.debug(">>>>>>>>>>phonesmaps<<<<<<<<" + maps);
                    userPhones = maps.get("repateMobile").split(",");
                    if ("1".equals(maps.get("updateOrInsert")) || "3".equals(maps.get("updateOrInsert"))) {
                        for (int i3 = 0; i3 < userPhones.length; ++i3) {
                            if (!"9".equals(userPhones[i3])) {
                                phones = phones.replaceAll(userPhones[i3] + ",", "");
                            }
                            this.logger.debug("userPhones[i] " + userPhones[i3]);
                        }
                        String[] phoneList2 = phones.split(",");
                        for (String phone : phoneList2) {
                            if (!"null".equals(phone) && phone != null && !"".equals(phone)) {
                                results = this.addCsbsUser(((Map)list.get(0)).get("newCsbsUsersListId").toString(), phone);
                            }
                            if (!"1".equals(maps.get("updateOrInsert"))) continue;
                            results = this.deleteRepatePhone(((Map)list.get(0)).get("csbsUsersListId").toString(), maps.get("repateMobile"), "0");
                        }
                    } else {
                        results = this.deleteUserByPhone(maps.get("repateMobile"));
                        phoneList = phones.split(",");
                        for (String phone : phoneList) {
                            if ("null".equals(phone) || phone == null || "".equals(phone)) continue;
                            results = this.addCsbsUser(((Map)list.get(0)).get("newCsbsUsersListId").toString(), phone);
                        }
                        userlist = this.selectUserId(((Map)list.get(0)).get("chargestationId").toString(), csbsId);
                        for (i = 0; i < userlist.size(); ++i) {
                            if (!"".equals(((Map)userlist.get(i)).get("csbsUsersListId")) && ((Map)userlist.get(i)).get("csbsUsersListId") != null) {
                                results = this.deleteRepatePhone(((Map)userlist.get(i)).get("csbsUsersListId").toString(), maps.get("repateMobile"), "1");
                            }
                            if ("".equals(((Map)userlist.get(i)).get("newCsbsUsersListId")) || ((Map)userlist.get(i)).get("newCsbsUsersListId") == null) continue;
                            results = this.deleteRepatePhone(((Map)userlist.get(i)).get("newCsbsUsersListId").toString(), maps.get("repateMobile"), "1");
                        }
                    }
                }
            }
            this.logger.debug(">>>>>>>updateOpLog212<<<<<<<" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return map;
        }
        if (list.size() > 0 && list != null) {
            return (Map)list.get(0);
        }
        return map;
    }

    public int deleteRepatePhone(String userId, String phone, String flag) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        this.logger.debug(">>>>>>>>>>>>>>vdeleteRepatePhone<<<<<<<<<<<<<<" + phone);
        this.logger.debug(">>>>>>>>>>>>>>userId<<<<<<<<<<<<<<" + userId);
        try {
            sql.append(" delete from ebike.ebike_csbs_info_fu_userlist  where 1=1 ");
            sql.append(" and csbsUserMobile in(?)", (Object)phone);
            sql.append(" and csbsUsersListId=?", (Object)userId);
            return this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public String getInsertOrUpdate(String newCsbsUsersListId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select  DISTINCT(updateOrInsert) from ebike.ebike_csbs_info_fu_userlist where 1=1 ");
            sql.append(" and csbsUsersListId=?", (Object)newCsbsUsersListId);
            sql.append(" and  LENGTH(updateOrInsert)>0 ");
            return (String)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), String.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    @Override
    public List<Map<String, Object>> getPromptData(String newCsbsUsersListId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select repateMobile,updateOrInsert from ebike.ebike_csbs_info_fu_userlist where 1=1  and LENGTH(repateMobile)>0 ");
            sql.append(" and csbsUsersListId=?", (Object)newCsbsUsersListId);
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    public Map<String, String> getPromptInfo(String newCsbsUsersListId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String userPhone = "";
        String updateOrInsert = "";
        List list = new ArrayList();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("repateMobile", "");
        map.put("updateOrInsert", "");
        this.logger.debug("newCsbsUsersListId " + newCsbsUsersListId);
        try {
            sql.append(" select IFNULL(repateMobile,'9') as repateMobile,IFNULL(updateOrInsert,'4') as updateOrInsert from ebike.ebike_csbs_info_fu_userlist where 1=1  ");
            sql.append(" and csbsUsersListId=?", (Object)newCsbsUsersListId);
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rownum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("repateMobile", rs.getString("repateMobile"));
                    map.put("updateOrInsert", rs.getString("updateOrInsert"));
                    return map;
                }
            });
            for (int i = 0; i < list.size(); ++i) {
                userPhone = userPhone + ((Map)list.get(i)).get("repateMobile") + ",";
                updateOrInsert = ((Map)list.get(i)).get("updateOrInsert").toString();
            }
            this.logger.debug("userPhone " + userPhone);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return map;
        }
        map.put("repateMobile", userPhone);
        map.put("updateOrInsert", updateOrInsert);
        return map;
    }

    public String queryPhoneList(String userId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String phoneList = "";
        List list = new ArrayList();
        try {
            sql.append(" select csbsUserMobile  from ebike.ebike_csbs_info_fu_userlist where 1=1 ");
            sql.append(" and csbsUsersListId=?", (Object)userId);
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
            this.logger.debug(">>>>>>>>>>queryPhoneList<<<<<<<<<" + list.toString());
            for (int i = 0; i < list.size(); ++i) {
                phoneList = phoneList + ((Map)list.get(i)).get("csbsUserMobile") + ",";
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
        return phoneList;
    }

    @Override
    public List<Map<String, Object>> queryUserPhone(String csbsUsersListId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String phoneList = "";
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select csbsUsersListId,csbsUserMobile from ebike.ebike_csbs_info_userlist where 1=1 ");
            sql.append(" and csbsUsersListId=?", (Object)csbsUsersListId);
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int queryPhoneCount(String csbsUsersListId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebike.ebike_csbs_info_userlist where 1=1 ");
            sql.append(" and csbsUsersListId=?", (Object)csbsUsersListId);
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public List<Map<String, Object>> queryNewUserPhone(String csbsUsersListId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String phoneList = "";
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select csbsUsersListId,csbsUserMobile from ebike.ebike_csbs_info_fu_userlist where 1=1 and csbsUserMobile is not null ");
            sql.append(" and csbsUsersListId=?", (Object)csbsUsersListId);
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int newPhoneCount(String csbsUsersListId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebike.ebike_csbs_info_fu_userlist where 1=1 ");
            sql.append(" and csbsUsersListId=?", (Object)csbsUsersListId);
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public int updateCsbsInfo(String newSchemeId, String chargestationId) {
        this.logger.debug("updateCsbsInfo  " + newSchemeId);
        this.logger.debug("updateCsbsInfo21  " + chargestationId);
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append("update ebike.ebike_cs_bs_rela set  ");
            sql.append(" schemeId=?", (Object)newSchemeId);
            sql.append(" ,effTime=?", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            sql.append(" where 1=1 ");
            sql.append(" and chargestationId=?", (Object)chargestationId);
            return this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public List<Map<String, Object>> getUserList(String csbsUsersListId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select csbsUserMobile from ebike.ebike_csbs_info_userlist where 1=1 ");
            sql.append(" and csbsUsersListId=?", (Object)csbsUsersListId);
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public Map<String, Object> getStationInfoByCsbsId(String csbsId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List list = new ArrayList();
        HashMap<String, Object> maps = new HashMap<String, Object>();
        try {
            sql.append(" select a.id,a.stationNo,b.name,a.stationAddr from ebike.ebike_csbs_info c left join cisp_dev.dev_ebikechargestation a on c.chargestationId=a.id  ");
            sql.append(" left join cisp_dev.dev_powersystemresource b on a.id=b.id where 1=1 ");
            sql.append("  and c.csbsId=?", (Object)csbsId);
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return maps;
        }
        if (list.size() > 0 && list != null) {
            return (Map)list.get(0);
        }
        return maps;
    }

    @Override
    public Map<String, Object> forbiddens(String csbsId, String orgName, String stationId, String subburo, String schemeId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        this.logger.debug("asdsadsa  " + stationId);
        int results = 0;
        String message = "";
        int count = this.querySCountById(stationId);
        this.logger.debug("count  " + count);
        try {
            results = this.getSchemeCountByStationId(stationId);
            if (results <= 1) {
                message = "\u53ea\u6709\u5b58\u5728\u4e00\u4e2a\u4ee5\u4e0a\u751f\u6548\u7684\u8ba1\u8d39\u65b9\u6848\u624d\u53ef\u4ee5\u8fdb\u884c\u7981\u7528\u64cd\u4f5c";
                map.put("status", 0);
                map.put("message", message);
                return map;
            }
            sql.append(" update ebike.ebike_csbs_info set  ");
            if (count > 0) {
                sql.append(" csbsStatus='03'  ");
                sql.append(" where 1=1 ");
            } else {
                sql.append(" csbsStatus='10'  ");
                sql.append(" ,effTime=?", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                sql.append(" where 1=1 ");
            }
            sql.append(" and csbsId=?", (Object)csbsId);
            results = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            if (count > 0) {
                results = this.csbsOperation(stationId, csbsId, subburo, orgName);
                results = this.addcsbsOpLog(csbsId, "30", "03", orgName);
            } else {
                results = this.setCsbsForiddenOrUnForidden(stationId, schemeId, "T");
                results = this.addcsbsOpLog(csbsId, "30", "10", orgName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return map;
        }
        if (results > 0) {
            message = count > 0 ? "\u8ba1\u8d39\u6a21\u677f\u7981\u7528\u64cd\u4f5c\u6210\u529f\uff0c\u8bf7\u7b49\u5f85\u5171\u4eab\u4eba\u786e\u8ba4" : "\u8ba1\u8d39\u6a21\u677f\u7981\u7528\u8bbe\u7f6e\u6210\u529f,\u5373\u65f6\u751f\u6548";
            map.put("status", 1);
            map.put("message", message);
        } else {
            message = "\u8ba1\u8d39\u6a21\u677f\u7981\u7528\u64cd\u4f5c\u5931\u8d25\uff01";
            map.put("status", 2);
            map.put("message", message);
        }
        return map;
    }

    @Override
    public String unForbiddens(String csbsId, String orgName, String stationId, String subburo, String schemeId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        String message = "";
        int count = this.querySCountById(stationId);
        try {
            sql.append(" update ebike.ebike_csbs_info set  ");
            if (count > 0) {
                sql.append(" csbsStatus='04'  ");
                sql.append(" where 1=1 ");
            } else {
                sql.append(" csbsStatus='00'  ");
                sql.append(" ,effTime=?", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                sql.append(" where 1=1 ");
            }
            sql.append(" and csbsId=?", (Object)csbsId);
            results = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            if (count > 0) {
                results = this.csbsOperation(stationId, csbsId, subburo, orgName);
                results = this.addcsbsOpLog(csbsId, "40", "04", orgName);
            } else {
                results = this.setCsbsForiddenOrUnForidden(stationId, schemeId, "F");
                results = this.addcsbsOpLog(csbsId, "40", "00", orgName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
        message = results > 0 ? (count > 0 ? "\u8ba1\u8d39\u6a21\u677f\u89e3\u7981\u64cd\u4f5c\u6210\u529f\uff0c\u8bf7\u7b49\u5f85\u5171\u4eab\u4eba\u786e\u8ba4" : "\u8ba1\u8d39\u6a21\u677f\u89e3\u7981\u8bbe\u7f6e\u6210\u529f,\u5373\u65f6\u751f\u6548") : "\u8ba1\u8d39\u6a21\u677f\u89e3\u7981\u64cd\u4f5c\u5931\u8d25\uff01";
        return message;
    }

    public int setCsbsForiddenOrUnForidden(String chargestationId, String schemeId, String disabled) {
        this.logger.debug("updateCsbsInfo  " + schemeId);
        this.logger.debug("updateCsbsInfo21  " + chargestationId);
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append("update ebike.ebike_cs_bs_rela set  ");
            sql.append(" disabled=?", (Object)disabled);
            sql.append(" ,disable_time=?", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            sql.append(" where 1=1 ");
            sql.append(" and chargestationId=?", (Object)chargestationId);
            sql.append(" and schemeId=? ", (Object)schemeId);
            return this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public int foriddenConfirm(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" update ebike.ebike_csbs_info_tbc set ");
            sql.append(" confirmFlag=?", (Object)map.get("confirmFlag"));
            sql.append(" ,confirmer=?", (Object)map.get("orgName"));
            sql.append(" ,confirmTime=?", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            sql.append(" where 1=1 ");
            sql.append(" and csbsId=?", (Object)map.get("csbsId"));
            sql.append(" and stakeholderOrgNo=?", (Object)map.get("subburo"));
            results = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            results = this.queryConfirmInfo(map.get("csbsId"), "", "1", map);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    int foriddenOrUnForidden(String csbsId, int confirmFlag2, int confirmFlag3, Map<String, String> map) {
        int results = 0;
        SqlParamsBuilder sql = new SqlParamsBuilder();
        sql.append(" update  ebike.ebike_csbs_info set ");
        if ("1".equals(map.get("flag"))) {
            if (confirmFlag3 != 0 && confirmFlag2 == 0) {
                sql.append(" csbsStatus='10' ");
            }
            if (confirmFlag3 == 0 && confirmFlag2 != 0) {
                sql.append(" csbsStatus='00' ");
            }
        } else {
            if (confirmFlag3 != 0 && confirmFlag2 == 0) {
                sql.append(" csbsStatus='00' ");
            }
            if (confirmFlag3 == 0 && confirmFlag2 != 0) {
                sql.append(" csbsStatus='10' ");
            }
        }
        sql.append(" ,effTime=?", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        sql.append(" where 1=1 ");
        sql.append(" and csbsId=?", (Object)csbsId);
        results = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        if ("1".equals(map.get("flag"))) {
            if (confirmFlag3 == 0 && confirmFlag2 != 0) {
                results = this.setCsbsForiddenOrUnForidden(map.get("stationId"), map.get("schemeId"), "F");
                results = this.addcsbsOpLog(csbsId, "41", "00", map.get("orgName"));
            } else {
                results = this.addcsbsOpLog(csbsId, "42", "10", map.get("orgName"));
            }
        } else if (confirmFlag3 == 0 && confirmFlag2 != 0) {
            results = this.setCsbsForiddenOrUnForidden(map.get("stationId"), map.get("schemeId"), "T");
            results = this.addcsbsOpLog(csbsId, "31", "10", map.get("orgName"));
        } else {
            results = this.addcsbsOpLog(csbsId, "32", "00", map.get("orgName"));
        }
        return results;
    }

    public int getSchemeCountByStationId(String stationId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        sql.append(" select count(1)  from ebike.ebike_csbs_info  ");
        sql.append(" where 1=1 and csbsStatus='00' ");
        sql.append(" and chargestationId=?", (Object)stationId);
        return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
    }
}

