/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.oprmgmt.jdbcdao.impl;

import com.easesource.commons.util.UuidUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.data.jdbc.SqlParamsBuilder;
import com.ebike.openservices.base.dao.AbstractEbikeBaseJdbcDao;
import com.ebike.openservices.oprmgmt.jdbcdao.StationCostDao;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class StationCostImpl
extends AbstractEbikeBaseJdbcDao
implements StationCostDao {
    @Qualifier(value="ebikeJdbcTemplate")
    private final JdbcTemplate ebikeJdbcTemplate;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    public StationCostImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public List<Map<String, Object>> queryCost(String subburo, Map<String, String> map) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append("  select  a.ID,a.stationNo,a.stationAddr,b.STATUS as status ,b.NAME as SName ,GROUP_CONCAT(DISTINCT(c.CHARGEDEVICENO) order by c.CHARGEDEVICENO asc) as deviceNo, ");
            sql.append(" d.cscsStatus,d.cscsId,e.costUnitPrice,e.costSchemeName,e.costSchemeId,f.costSchemeName as 'newCostSchemeName',f.costUnitPrice  as 'newCostUnitPrice'  ");
            sql.append(" from cisp_dev.dev_ebikechargestation a ");
            sql.append(" left join cisp_dev.dev_powersystemresource b on a.ID=b.ID   ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID   ");
            sql.append("   left  join ebike.ebike_cscs_info d on a.ID=d.chargestationId   ");
            sql.append(" left join ebike.ebike_costscheme e on d.costSchemeId=e.costSchemeId ");
            sql.append(" left join  ebike.ebike_costscheme f on d.newCostSchemeId=f.costSchemeId where 1=1 ");
            sql.append(" and a.stationNo like ? ", (Object)("%" + map.get("stationNo") + "%"));
            sql.append(" and  b.NAME like ?", (Object)("%" + map.get("stationName") + "%"));
            sql.append(" and b.STATUS=?", (Object)map.get("status"));
            sql.append(" and c.CHARGEDEVICENO like ?", (Object)("%" + map.get("deviceNo") + "%"));
            sql.append(" and b.SUBBURO=?", (Object)subburo);
            sql.append(" and d.cscsStatus=? ", (Object)map.get("cscsStatus"));
            sql.append(" and e.costSchemeName like ? ", (Object)("%" + map.get("costSchemeName") + "%"));
            sql.append(" and b.CLASSNAME='EBikeChargeStation'  GROUP BY a.ID  ");
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int costCount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from (select count(1) from cisp_dev.dev_ebikechargestation a ");
            sql.append(" left join cisp_dev.dev_powersystemresource b on a.ID=b.ID   ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID   ");
            sql.append("   left  join ebike.ebike_cscs_info d on a.ID=d.chargestationId   ");
            sql.append(" left join ebike.ebike_costscheme e on d.costSchemeId=e.costSchemeId ");
            sql.append(" left join  ebike.ebike_costscheme f on d.newCostSchemeId=f.costSchemeId where 1=1 ");
            sql.append(" and a.stationNo like ? ", (Object)("%" + map.get("stationNo") + "%"));
            sql.append(" and  b.NAME like ?", (Object)("%" + map.get("stationName") + "%"));
            sql.append(" and b.STATUS=?", (Object)map.get("status"));
            sql.append(" and c.CHARGEDEVICENO like ?", (Object)("%" + map.get("deviceNo") + "%"));
            sql.append(" and b.SUBBURO=?", (Object)subburo);
            sql.append(" and d.cscsStatus=? ", (Object)map.get("cscsStatus"));
            sql.append("and  e.costSchemeName like ? ", (Object)("%" + map.get("costSchemeName") + "%"));
            sql.append(" and b.CLASSNAME='EBikeChargeStation'  GROUP BY a.ID ) g ");
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public boolean updateCscsinfo(String csId, String stationId, String costId, String cscsStatus, String orgName) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        int count = this.querySCountById(stationId);
        try {
            sql.append(" update ebike.ebike_cscs_info set ");
            if (count <= 0) {
                sql.append(" costSchemeId=?", (Object)costId);
                sql.append(" ,cscsStatus='00' ");
            } else if ("".equals(cscsStatus)) {
                sql.append(" newCostSchemeId=?", (Object)costId);
                sql.append(" ,cscsStatus='02' ");
            } else if ("00".equals(cscsStatus)) {
                sql.append(" costSchemeId=?", (Object)costId);
                sql.append(" ,cscsStatus='00' ");
                sql.append(" ,newCostSchemeId='' ");
            } else {
                sql.append(" cscsStatus='00' ");
                sql.append(" ,newCostSchemeId='' ");
            }
            sql.append(" ,effTime=date_format(?,'%Y-%m-%d %H:%i:%S') ", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            sql.append(" where 1=1 ");
            sql.append(" and cscsId=?", (Object)csId);
            results = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            results = this.updateOpLog(csId, orgName, "20", cscsStatus);
            if (count > 0) {
                results = this.csbsOperation(stationId, csId, orgName);
            } else {
                int n = this.updateCostInfo(costId, stationId);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    @Override
    public boolean insertCscsInfo(String stationId, String costId, String orgName) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        int count = this.querySCountById(stationId);
        String cscsStatus = "";
        String costSchemeId = "";
        String newCostSchemeId = "";
        String uuid = UuidUtils.generateUuidString();
        if (count <= 0) {
            cscsStatus = "00";
            costSchemeId = costId;
        } else {
            cscsStatus = "02";
            newCostSchemeId = costId;
        }
        try {
            sql.append(" insert into ebike.ebike_cscs_info(cscsId,chargestationId,cscsStatus,costSchemeId,newCostSchemeId,effTime) ");
            sql.append("values(?,?,?,?,?,?)");
            results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{uuid, stationId, cscsStatus, costSchemeId, newCostSchemeId, new Date()});
            results = this.updateOpLog(uuid, orgName, "01", cscsStatus);
            if (count > 0) {
                results = this.csbsOperation(stationId, uuid, orgName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    public int querySCountById(String stationId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" select count(1) from ebike.ebike_cssh_distscheme  where 1=1 and csshdsStatus='00' ");
            sql.append(" and chargestationId=?", (Object)stationId);
            results = (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    @Override
    public String queryCostCount(String stationId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String results = "";
        int count = 0;
        try {
            sql.append(" select count(1) from ebike.ebike_cscs_info  where 1=1  ");
            sql.append(" and chargestationId=?", (Object)stationId);
            count = (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
            if (count > 0) {
                results = this.getCscsId(stationId);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
        return results;
    }

    public String getCscsId(String stationId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String results = "";
        boolean count = false;
        try {
            sql.append(" select cscsId from ebike.ebike_cscs_info  where 1=1  ");
            sql.append(" and chargestationId=?", (Object)stationId);
            results = (String)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), String.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
        return results;
    }

    public int updateOpLog(String cscsId, String orgName, String logType, String status) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        boolean count = false;
        try {
            sql.append(" insert into ebike.ebike_log_cscs_info(cscsId,logType,logTime,cscsStatus,operator)");
            sql.append(" values(?,?,?,?,?)");
            results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{cscsId, logType, new Date(), status, orgName});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    public int addShareConfirm(String stakeholderOrgNo, String uuid, String orgName) {
        int results = 0;
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" replace into ebike.ebike_cscs_info_tbc(cscsId,stakeholderOrgNo,creator,createTime,confirmFlag) ");
            sql.append(" values(?,?,?,?,?)");
            this.logger.debug(">>>>>>>>>>>>addShareConfirm<<<<<<<<<<<" + sql.toString());
            results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{uuid, stakeholderOrgNo, orgName, new Date(), "0"});
            this.logger.debug(">>>>>>>>>>>>addShareConfirm1<<<<<<<<<<<" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    public int csbsOperation(String stationId, String uuid, String orgName) {
        int results = 0;
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List list = new ArrayList();
        try {
            sql.append(" select stakeholderOrgNo from ebike.ebike_cssh_distscheme where 1=1 and csshdsStatus='00' ");
            sql.append(" and chargestationId=?", (Object)stationId);
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
            for (int i = 0; i < list.size(); ++i) {
                results = this.addShareConfirm(((Map)list.get(i)).get("stakeholderOrgNo").toString(), uuid, orgName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    @Override
    public List<Map<String, Object>> costOpInfo(String cscsId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select a.cscsId,a.logType,a.logTime,b.USER_NAME as 'userName',b.USER_ORG_NAME as 'orgName' ");
            sql.append(" from ebike.ebike_log_cscs_info a left join cisp_sys.bp_user b on a.operator=b.USER_NO where 1=1 ");
            sql.append(" and a.cscsId=?", (Object)cscsId);
            sql.append(" order by  a.logTime desc ");
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int costOpInfoCount(String cscsId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebike.ebike_log_cscs_info a left join cisp_sys.bp_user b on a.operator=b.USER_NO where 1=1 ");
            sql.append(" and a.cscsId=?", (Object)cscsId);
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public List<Map<String, Object>> queryShareCost(String subburo, Map<String, String> map) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append("  select  a.ID,a.stationNo,a.stationAddr,b.STATUS as status,b.NAME as SName,GROUP_CONCAT(DISTINCT(c.CHARGEDEVICENO) order by c.CHARGEDEVICENO asc) as deviceNo, ");
            sql.append(" d.cscsStatus,d.cscsId,e.costUnitPrice,e.costSchemeName,e.costSchemeId,f.costSchemeName as 'newCostSchemeName',f.costUnitPrice  as 'newCostUnitPrice'  ");
            sql.append("  from ebike.ebike_cssh_distscheme g ");
            sql.append(" left join  cisp_dev.dev_ebikechargestation a on g.chargestationId=a.ID   ");
            sql.append(" LEFT JOIN ebike.ebike_cscs_info d   on a.ID=d.chargestationId   ");
            sql.append("   left join cisp_dev.dev_powersystemresource b on a.ID=b.ID   ");
            sql.append("  left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID  ");
            sql.append(" left join ebike.ebike_costscheme e on d.costSchemeId=e.costSchemeId  ");
            sql.append("  left join  ebike.ebike_costscheme f on d.newCostSchemeId=f.costSchemeId where 1=1 ");
            sql.append(" and a.stationNo like ? ", (Object)("%" + map.get("stationNo") + "%"));
            sql.append(" and  b.NAME like ?", (Object)("%" + map.get("stationName") + "%"));
            sql.append(" and b.STATUS=?", (Object)map.get("status"));
            sql.append(" and c.CHARGEDEVICENO like ?", (Object)("%" + map.get("deviceNo") + "%"));
            sql.append(" and g.stakeholderOrgNo=?", (Object)subburo);
            sql.append(" and d.cscsStatus=? ", (Object)map.get("cscsStatus"));
            sql.append(" e.costSchemeName=? ", (Object)("%" + map.get("costSchemeName") + "%"));
            sql.append(" and ( g.csshdsStatus='00' or g.csshdsStatus='02') ");
            sql.append(" and b.CLASSNAME='EBikeChargeStation'  GROUP BY a.ID  ");
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int queryShareCostCount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from (select count(1) from ebike.ebike_cssh_distscheme g ");
            sql.append(" left join  cisp_dev.dev_ebikechargestation a on g.chargestationId=a.ID   ");
            sql.append(" LEFT JOIN ebike.ebike_cscs_info d   on a.ID=d.chargestationId   ");
            sql.append("   left join cisp_dev.dev_powersystemresource b on a.ID=b.ID   ");
            sql.append("  left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID  ");
            sql.append(" left join ebike.ebike_costscheme e on d.costSchemeId=e.costSchemeId  ");
            sql.append("  left join  ebike.ebike_costscheme f on d.newCostSchemeId=f.costSchemeId where 1=1 ");
            sql.append(" and a.stationNo like ? ", (Object)("%" + map.get("stationNo") + "%"));
            sql.append(" and  b.NAME like ?", (Object)("%" + map.get("stationName") + "%"));
            sql.append(" and b.STATUS=?", (Object)map.get("status"));
            sql.append(" and c.CHARGEDEVICENO like ?", (Object)("%" + map.get("deviceNo") + "%"));
            sql.append(" and g.stakeholderOrgNo=?", (Object)subburo);
            sql.append(" and ( g.csshdsStatus='00' or g.csshdsStatus='02') ");
            sql.append(" and d.cscsStatus=? ", (Object)map.get("cscsStatus"));
            sql.append(" e.costSchemeName=? ", (Object)("%" + map.get("costSchemeName") + "%"));
            sql.append(" and b.CLASSNAME='EBikeChargeStation'  GROUP BY a.ID ) j ");
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public boolean yysOpConfirm(String cscsId, String confirmFlag, String subburo, String orgName, String logType) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        int confirmFlag1 = 0;
        int confirmFlag2 = 0;
        int confirmFlag3 = 0;
        Map<String, Object> map = null;
        try {
            sql.append(" update ebike.ebike_cscs_info_tbc set ");
            sql.append(" confirmFlag=?", (Object)confirmFlag);
            sql.append(",confirmer=?", (Object)orgName);
            sql.append(" ,confirmTime=date_format(?,'%Y-%m-%d %H:%i:%S') ", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            sql.append(" where 1=1 ");
            sql.append(" and stakeholderOrgNo=?", (Object)subburo);
            sql.append(" and cscsId=?", (Object)cscsId);
            results = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            SqlParamsBuilder sql2 = new SqlParamsBuilder();
            sql2.append(" select confirmFlag from ebike.ebike_cscs_info_tbc  where 1=1 ");
            sql2.append(" and cscsId=?", (Object)cscsId);
            List list = this.ebikeJdbcTemplate.query(sql2.getSql(), sql2.getParams(), this.mapRowMapper);
            for (int i = 0; i < list.size(); ++i) {
                if ("0".equals(((Map)list.get(i)).get("confirmFlag").toString())) {
                    ++confirmFlag1;
                }
                if ("1".equals(((Map)list.get(i)).get("confirmFlag").toString())) {
                    ++confirmFlag2;
                }
                if (!"2".equals(((Map)list.get(i)).get("confirmFlag").toString())) continue;
                ++confirmFlag3;
            }
            String csshdsStatus = "";
            if (confirmFlag1 == 0) {
                map = this.updateCsbcInfo(cscsId, confirmFlag2, confirmFlag3);
                csshdsStatus = "00";
            } else {
                csshdsStatus = "02";
            }
            results = this.updateOpLog(cscsId, orgName, logType, csshdsStatus);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    public Map<String, Object> updateCsbcInfo(String cscsId, int confirmFlag2, int confirmFlag3) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<HashMap<String, Object>> list = new ArrayList();
        try {
            sql.append(" select costSchemeId,newCostSchemeId,chargestationId from ebike.ebike_cscs_info where 1=1 ");
            sql.append(" and cscsId=?", (Object)cscsId);
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
            SqlParamsBuilder sql2 = new SqlParamsBuilder();
            if (confirmFlag2 == 0 && confirmFlag3 != 0) {
                this.logger.debug(">>>>>>>>>>>confirmFlag2<<<<<<<<<<<<<<" + confirmFlag2);
                sql2.append(" update ebike.ebike_cscs_info set newCostSchemeId='',cscsStatus='00' where 1=1  ");
                sql2.append(" and cscsId=?", (Object)cscsId);
                map.put("csshdsStatus", "00");
                list.add(map);
            } else {
                sql2.append(" update ebike.ebike_cscs_info set newCostSchemeId='',cscsStatus='00'   ");
                sql2.append(" ,costSchemeId=?", (Object)((String)((Map)list.get(0)).get("newCostSchemeId")));
                sql2.append(" where 1=1 ");
                sql2.append(" and cscsId=?", (Object)cscsId);
                map.put("csshdsStatus", "00");
                list.add(map);
            }
            int result = this.ebikeJdbcTemplate.update(sql2.getSql(), sql2.getParams());
            if (confirmFlag2 != 0 && confirmFlag3 == 0) {
                int n = this.updateCostInfo((String)((Map)list.get(0)).get("newCostSchemeId"), ((Map)list.get(0)).get("chargestationId").toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return map;
        }
        return (Map)list.get(0);
    }

    public int updateCostInfo(String newCostSchemeId, String stationId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append("update ebike.ebike_cs_cs_rela set  ");
            sql.append(" costSchemeId=?", (Object)newCostSchemeId);
            sql.append(" ,effTime=?", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            sql.append(" where 1=1 ");
            sql.append(" and chargestationId=?", (Object)stationId);
            return this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }
}

