/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.oprmgmt.jdbcdao.impl;

import com.easesource.data.jdbc.SqlParamsBuilder;
import com.ebike.openservices.base.dao.AbstractEbikeBaseJdbcDao;
import com.ebike.openservices.oprmgmt.jdbcdao.StationMaDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class StationMaDaoImpl
extends AbstractEbikeBaseJdbcDao
implements StationMaDao {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Qualifier(value="ebikeJdbcTemplate")
    private final JdbcTemplate ebikeJdbcTemplate;

    @Autowired
    public StationMaDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public List<Map<String, Object>> queryStationMain(String subburo, Map<String, String> map, int start, int limit) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        sql.append(" select a.ID, a.stationNo,b.NAME,b.STATUS,c.chargedeviceNo,e.stakeholderId,e.stakeholderName,c.plugcount,GROUP_CONCAT(d.oppersonId) AS 'oppersonId',GROUP_CONCAT(d.oppersonName) as 'oppersonName' ");
        sql.append(" FROM cisp_dev.dev_ebikechargestation a left join cisp_dev.dev_powersystemresource b on a.id=b.id  ");
        sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.id=c.chargestationId ");
        sql.append(" left join ebike.ebike_cs_op_rela f on (f.chargestationId=a.ID) ");
        sql.append(" left join ebike.ebike_opperson d on (f.oppersonId=d.oppersonId) ");
        sql.append(" left join ebike.ebike_cs_sh_rela g on (g.chargestationId=a.ID) LEFT JOIN ebike.ebike_stakeholder e on (g.stakeholderId=e.stakeholderId) where 1=1  ");
        sql.append(" and a.stationNo like?", (Object)("%" + map.get("stationNo") + "%"));
        sql.append(" and c.chargedeviceNo like ?", (Object)("%" + map.get("devNo") + "%"));
        sql.append(" and d.oppersonId= ?", (Object)map.get("oppersonId"));
        sql.append(" and ( b.BURO= ? ", (Object)subburo);
        sql.append("or  b.SUBBURO = ? ) ", (Object)subburo);
        sql.append(" group by a.ID ");
        if (start != -1 && limit != -1) {
            sql.append(" limit ? ", (Object)start);
            sql.append(" , ? ", (Object)limit);
        }
        this.logger.debug("============================queryStation==============" + sql.toString());
        try {
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), this.mapRowMapper);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int getStationMaCount(String subburoNo, Map<String, String> map) {
        try {
            SqlParamsBuilder sql = new SqlParamsBuilder();
            sql.append(" select count(1) FROM cisp_dev.dev_ebikechargestation a left join cisp_dev.dev_powersystemresource b on a.id=b.id  ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.id=c.chargestationId ");
            sql.append(" left join ebike.ebike_cs_op_rela f on (f.chargestationId=a.ID) ");
            sql.append(" left join ebike.ebike_opperson d on (f.oppersonId=d.oppersonId) ");
            sql.append(" left join ebike.ebike_cs_sh_rela g on (g.chargestationId=a.ID) LEFT JOIN ebike.ebike_stakeholder e on (g.stakeholderId=e.stakeholderId) where 1=1  ");
            sql.append(" and a.stationNo like?", (Object)("%" + map.get("stationNo") + "%"));
            sql.append(" and c.chargedeviceNo like ?", (Object)("%" + map.get("devNo") + "%"));
            sql.append(" and d.oppersonId= ?", (Object)map.get("oppersonId"));
            sql.append(" and ( b.BURO= ? ", (Object)subburoNo);
            sql.append("or  b.SUBBURO = ? ) ", (Object)subburoNo);
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public List<Map<String, String>> getChargeOppersonNameList(String subburoNo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        try {
            sql.append(" select a.oppersonId,a.oppersonName from ebike.ebike_opperson a where 1=1");
            sql.append(" and ( a.BURO= ? ", (Object)subburoNo);
            sql.append("or  a.SUBBURO = ? ) ", (Object)subburoNo);
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, String>>(){

                public Map<String, String> mapRow(ResultSet rs, int rownum) throws SQLException {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("oppersonId", rs.getString("oppersonId"));
                    map.put("oppersonName", rs.getString("oppersonName"));
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public boolean initopperson(String oppersonId, String stationid) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append("insert into ebike.ebike_cs_op_rela ");
            sql.append("(chargestationId,oppersonId,createTime)");
            sql.append("values(?,?,?)");
            results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{stationid, oppersonId, new Date()});
            this.logger.debug(sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    @Override
    public boolean deleopperson(String ids) {
        this.logger.debug("ids========================" + ids);
        if (ids == null || "".equals(ids)) {
            return false;
        }
        SqlParamsBuilder sql = new SqlParamsBuilder();
        sql.append(" delete from ebike.ebike_cs_op_rela  where chargestationId in (?) ", (Object)ids, ",");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">>>>>>>>>>>>>>>>>>deleopperson<<<<<<<<<<<<<<<<<=" + sql.toString());
        }
        try {
            this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public Map<String, Object> getdevInfoByNo(String chargedeviceNo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List list = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            sql.append(" select a.chargedeviceNo,a.protocolType,a.protocolVersion,a.plugCount,d.USER_NAME as 'installer',f.USER_NAME as 'dismantler',b.RUNDATE,b.STOPDATE,b.STATUS,b.XH");
            sql.append(" from cisp_dev.dev_ebikechargedevice a left join cisp_dev.dev_powersystemresource b on a.ID=b.ID");
            sql.append(" left join cisp_sys.bp_user d on a.INSTALLER=d.USER_NO ");
            sql.append(" left join cisp_sys.bp_user f on a.DISMANTLER=f.USER_NO where 1=1");
            sql.append(" and a.chargedeviceNo=?", (Object)chargedeviceNo);
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rownum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    SimpleDateFormat formattime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String RUNDATE = "";
                    String STOPDATE = "";
                    if (rs.getTimestamp("RUNDATE") != null) {
                        Date time1 = new Date(rs.getTimestamp("RUNDATE").getTime());
                        RUNDATE = formattime.format(time1);
                    }
                    if (rs.getTimestamp("STOPDATE") != null) {
                        Date time2 = new Date(rs.getTimestamp("STOPDATE").getTime());
                        STOPDATE = formattime.format(time2);
                    }
                    map.put("chargedeviceNo", rs.getString("chargedeviceNo"));
                    map.put("plugCount", rs.getString("plugCount"));
                    map.put("protocolType", rs.getString("protocolType"));
                    map.put("protocolVersion", rs.getString("protocolVersion"));
                    map.put("XH", rs.getString("XH"));
                    map.put("STATUS", rs.getString("STATUS"));
                    map.put("installer", rs.getString("installer"));
                    map.put("dismantler", rs.getString("dismantler"));
                    map.put("RUNDATE", RUNDATE);
                    map.put("STOPDATE", STOPDATE);
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return map;
        }
        if (list != null && list.size() > 0) {
            return (Map)list.get(0);
        }
        return map;
    }
}

