/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.oprmgmt.jdbcdao.impl;

import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.data.jdbc.SqlParamsBuilder;
import com.ebike.openservices.base.dao.AbstractEbikeBaseJdbcDao;
import com.ebike.openservices.oprmgmt.jdbcdao.YysRegisterDao;
import com.ebike.openservices.oprmgmt.util.EbikeCommonUtil;
import com.ebikecharge.openservices.cloudapi.entity.request.OrgoprCertRequest;
import com.ebikecharge.openservices.cloudapi.entity.response.OrgoprCertResponse;
import com.ebikecharge.openservices.cloudapi.service.OrgoprCertService;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class YysRegisterDaoImpl
extends AbstractEbikeBaseJdbcDao
implements YysRegisterDao {
    @Qualifier(value="ebikeJdbcTemplate")
    private final JdbcTemplate ebikeJdbcTemplate;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private OrgoprCertService orgoprCertService;

    @Autowired
    public YysRegisterDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public boolean yysRegister(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        String checkResult = "";
        if (map.get("orgoprType").equals("20")) {
            checkResult = "W";
        }
        try {
            sql.append(" insert into ebike.ebike_orgopr_reginfo(orgoprRegId,orgoprType,orgoprName ");
            sql.append(" ,orgoprCredNo,orgoprCredAttach,userNo,userName,userPassword,userMobile,bankCardNo,bankBranchLinkNo ");
            sql.append(",regTime,checkResult,verifyResult )");
            sql.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{map.get("orgoprRegId"), map.get("orgoprType"), map.get("orgoprName"), map.get("orgoprCredNo"), map.get("orgoprCredAttach"), map.get("userNo"), map.get("userName"), map.get("userPassword"), map.get("userMobile"), map.get("bankCardNo"), map.get("bankBranchLinkNo"), new Date(), checkResult, "W"});
            this.logger.debug(">>>>>>>>>>>yysRegistersds<<<<<<<<<<" + sql.toString());
            if (map.get("orgoprType").equals("20")) {
                OrgoprCertRequest req = new OrgoprCertRequest();
                req.setOrgoprType(map.get("orgoprType"));
                req.setBankBranchLinkNo(map.get("bankBranchLinkNo"));
                req.setBankCardNo(map.get("bankCardNo"));
                req.setOrgoprName(map.get("orgoprName"));
                req.setOrgoprCredNo(map.get("orgoprCredNo"));
                OrgoprCertResponse response = this.orgoprCertService.verify(req, Boolean.valueOf(true));
                results = this.updateOrgInfo(response.getMsg(), response.getStatus(), map.get("orgoprRegId"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    public int updateOrgInfo(String message, int status, String orgoprRegId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String checkResult = "";
        try {
            checkResult = status == 0 ? "S" : "F";
            sql.append(" update ebike.ebike_orgopr_reginfo  set ");
            sql.append(" checkResult=?", (Object)checkResult);
            sql.append(" ,checkRemark=?", (Object)message);
            if (status != 0) {
                sql.append(",verifyResult='W' ");
                sql.append(" ,verifyTime  =? ", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                sql.append(" ,verifyRemark=?", (Object)message);
            }
            sql.append(" ,checkTime =? ", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            sql.append(" where 1=1 ");
            sql.append(" and orgoprRegId=?", (Object)orgoprRegId);
            return this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public int checkyysExist(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int result = 0;
        try {
            sql.append(" select count(1) from ebike.ebike_orgopr_reginfo where 1=1  ");
            sql.append(" and orgoprCredNo=?", (Object)map.get("orgoprCredNo"));
            sql.append(" and  verifyResult!='F' ");
            result = (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
            this.logger.debug(">>>>>>>>>>CheckyysExist<<<<<<<<<<<" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return result;
    }

    @Override
    public String checkNameExist(String userNo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String result = "";
        try {
            sql.append(" select IFNULL(userNo,'N') from ebike.ebike_orgopr_reginfo where 1=1  ");
            sql.append(" and userNo=?", (Object)userNo);
            sql.append(" and  verifyResult!='F' ");
            result = (String)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), String.class);
            this.logger.debug(">>>>>>>>>>CheckyysExist<<<<<<<<<<<" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> queryYysInfo(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select a.orgoprRegId,a.orgoprType,a.orgoprName,a.orgoprCredNo,a.orgoprCredAttach,a.checkResult,a.checkRemark,a.verifyRemark,a.userNo,a.userName,a.userPassword ");
            sql.append(" ,a.userMobile,a.bankCardNo,a.regTime,a.verifyResult,b.bankBranchName,a.bankBranchLinkNo ");
            sql.append(" from ebike.ebike_orgopr_reginfo a  ");
            sql.append(" left join ebike.code_bankbranchs b on a.bankBranchLinkNo=b.bankBranchLinkNo  where 1=1 ");
            sql.append(" and a.verifyResult=?", (Object)map.get("AuditingStatus"));
            sql.append(" and a.orgoprType=?", (Object)map.get("orgoprType"));
            if (!"".equals(map.get("startDay"))) {
                sql.append(" and a.regTime >= ?", (Object)DateConvertUtils.convertFromString((String)map.get("startDay"), (String[])new String[]{"yyyy-MM-dd"}));
            }
            if (!"".equals(map.get("endDay"))) {
                sql.append(" and a.regTime <= ?", (Object)EbikeCommonUtil.addDay(DateConvertUtils.convertFromString((String)map.get("endDay"), (String[])new String[]{"yyyy-MM-dd"}), 1));
            }
            sql.append(" and a.orgoprRegId=? ", (Object)map.get("orgoprRegId"));
            sql.append(" order by a.regTime desc");
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("orgoprRegId", rs.getString("orgoprRegId"));
                    map.put("orgoprType", rs.getString("orgoprType"));
                    map.put("orgoprName", rs.getString("orgoprName"));
                    map.put("orgoprCredNo", rs.getString("orgoprCredNo"));
                    map.put("userNo", rs.getString("userNo"));
                    map.put("userName", rs.getString("userName"));
                    map.put("userPassword", rs.getString("userPassword"));
                    map.put("userMobile", rs.getString("userMobile"));
                    map.put("bankCardNo", rs.getString("bankCardNo"));
                    map.put("regTime", rs.getTimestamp("regTime"));
                    map.put("verifyResult", rs.getString("verifyResult"));
                    map.put("bankBranchName", rs.getString("bankBranchName"));
                    map.put("orgoprCredAttach", rs.getString("orgoprCredAttach"));
                    map.put("checkRemark", rs.getString("checkRemark"));
                    map.put("verifyRemark", rs.getString("verifyRemark"));
                    map.put("checkResult", rs.getString("checkResult"));
                    map.put("bankBranchLinkNo", rs.getString("bankBranchLinkNo"));
                    return map;
                }
            });
            this.logger.debug(">>>>>>>>>>queryYysInfo<<<<<<<<<<<<" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int queryYysCount(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebike.ebike_orgopr_reginfo a  ");
            sql.append(" left join ebike.code_bankbranchs b on a.bankBranchLinkNo=b.bankBranchLinkNo  where 1=1 ");
            sql.append(" and a.verifyResult=?", (Object)map.get("AuditingStatus"));
            sql.append(" and a.orgoprType=?", (Object)map.get("orgoprType"));
            if (!"".equals(map.get("startDay"))) {
                sql.append(" and a.regTime >= ?", (Object)DateConvertUtils.convertFromString((String)map.get("startDay"), (String[])new String[]{"yyyy-MM-dd"}));
            }
            if (!"".equals(map.get("endDay"))) {
                sql.append(" and a.regTime <= ?", (Object)EbikeCommonUtil.addDay(DateConvertUtils.convertFromString((String)map.get("endDay"), (String[])new String[]{"yyyy-MM-dd"}), 1));
            }
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public List<Map<String, Object>> queryCarRegisterInfo(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select a.orgoprRegId,a.orgoprType,a.orgoprName,a.orgoprCredNo,a.orgoprCredAttach,a.checkResult,a.checkRemark,a.verifyRemark,a.userNo,a.userName,a.userPassword ");
            sql.append(" ,a.userMobile,a.bankCardNo,a.regTime,a.verifyResult,b.bankBranchName,a.bankBranchLinkNo,c.wxPersonalInfo, c.subburo");
            sql.append(" from ebike.ebike_orgopr_reginfo a  ");
            sql.append(" left join ebike.code_bankbranchs b on a.bankBranchLinkNo=b.bankBranchLinkNo");
            sql.append(" left join ebike.ebike_orgopr c on a.orgoprNo = c.subburo where 1=1");
            sql.append(" and a.verifyResult=?", (Object)map.get("AuditingStatus"));
            sql.append(" and a.orgoprType=?", (Object)map.get("orgoprType"));
            if ("Y".equals(map.get("isWx"))) {
                sql.append(" and json_extract(c.wxPersonalInfo,'$.openId') is not null ");
            }
            if ("N".equals(map.get("isWx"))) {
                sql.append(" and a.verifyResult != 'W' and json_extract(c.wxPersonalInfo,'$.openId') is null ");
            }
            if (!"".equals(map.get("startDay")) && null != map.get("startDay")) {
                sql.append(" and a.regTime >= ?", (Object)DateConvertUtils.convertFromString((String)map.get("startDay"), (String[])new String[]{"yyyy-MM-dd"}));
            }
            if (!"".equals(map.get("endDay")) && null != map.get("endDay")) {
                sql.append(" and a.regTime <= ?", (Object)EbikeCommonUtil.addDay(DateConvertUtils.convertFromString((String)map.get("endDay"), (String[])new String[]{"yyyy-MM-dd"}), 1));
            }
            sql.append(" and a.orgoprRegId=? ", (Object)map.get("orgoprRegId"));
            sql.append(" order by a.regTime desc");
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("orgoprRegId", rs.getString("orgoprRegId"));
                    map.put("orgoprType", rs.getString("orgoprType"));
                    map.put("orgoprName", rs.getString("orgoprName"));
                    map.put("orgoprCredNo", rs.getString("orgoprCredNo"));
                    map.put("userNo", rs.getString("userNo"));
                    map.put("userName", rs.getString("userName"));
                    map.put("userPassword", rs.getString("userPassword"));
                    map.put("userMobile", rs.getString("userMobile"));
                    map.put("bankCardNo", rs.getString("bankCardNo"));
                    map.put("regTime", rs.getTimestamp("regTime"));
                    map.put("verifyResult", rs.getString("verifyResult"));
                    map.put("bankBranchName", rs.getString("bankBranchName"));
                    map.put("orgoprCredAttach", rs.getString("orgoprCredAttach"));
                    map.put("checkRemark", rs.getString("checkRemark"));
                    map.put("verifyRemark", rs.getString("verifyRemark"));
                    map.put("checkResult", rs.getString("checkResult"));
                    map.put("bankBranchLinkNo", rs.getString("bankBranchLinkNo"));
                    map.put("wxPersonalInfo", rs.getString("wxPersonalInfo"));
                    map.put("subburo", rs.getString("subburo"));
                    return map;
                }
            });
            this.logger.debug(">>>>>>>>>>queryYysInfo<<<<<<<<<<<<" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> queryCarRegisterInfoById(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select a.orgoprRegId,a.orgoprType,a.orgoprName,a.orgoprCredNo,a.orgoprCredAttach,a.checkResult,a.checkRemark,a.verifyRemark,a.userNo,a.userName,a.userPassword ");
            sql.append(" ,a.userMobile,a.bankCardNo,a.regTime,a.verifyResult,b.bankBranchName,a.bankBranchLinkNo,c.wxPersonalInfo, c.subburo");
            sql.append(" from ebike.ebike_orgopr_reginfo a  ");
            sql.append(" left join ebike.code_bankbranchs b on a.bankBranchLinkNo=b.bankBranchLinkNo");
            sql.append(" left join ebike.ebike_orgopr c on a.orgoprNo = c.subburo where a.orgoprRegId = ?", (Object)map.get("orgoprRegId"));
            sql.append(" limit 1 ");
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("orgoprRegId", rs.getString("orgoprRegId"));
                    map.put("orgoprType", rs.getString("orgoprType"));
                    map.put("orgoprName", rs.getString("orgoprName"));
                    map.put("orgoprCredNo", rs.getString("orgoprCredNo"));
                    map.put("userNo", rs.getString("userNo"));
                    map.put("userName", rs.getString("userName"));
                    map.put("userPassword", rs.getString("userPassword"));
                    map.put("userMobile", rs.getString("userMobile"));
                    map.put("bankCardNo", rs.getString("bankCardNo"));
                    map.put("regTime", rs.getTimestamp("regTime"));
                    map.put("verifyResult", rs.getString("verifyResult"));
                    map.put("bankBranchName", rs.getString("bankBranchName"));
                    map.put("orgoprCredAttach", rs.getString("orgoprCredAttach"));
                    map.put("checkRemark", rs.getString("checkRemark"));
                    map.put("verifyRemark", rs.getString("verifyRemark"));
                    map.put("checkResult", rs.getString("checkResult"));
                    map.put("bankBranchLinkNo", rs.getString("bankBranchLinkNo"));
                    map.put("wxPersonalInfo", rs.getString("wxPersonalInfo"));
                    map.put("subburo", rs.getString("subburo"));
                    return map;
                }
            });
            this.logger.debug(">>>>>>>>>>queryYysInfo<<<<<<<<<<<<" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int queryCarRegisterCount(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebike.ebike_orgopr_reginfo a  ");
            sql.append(" left join ebike.code_bankbranchs b on a.bankBranchLinkNo=b.bankBranchLinkNo ");
            sql.append(" left join ebike.ebike_orgopr c on a.orgoprNo = c.subburo where 1=1");
            sql.append(" and a.verifyResult=?", (Object)map.get("AuditingStatus"));
            sql.append(" and a.orgoprType=?", (Object)map.get("orgoprType"));
            if ("Y".equals(map.get("isWx"))) {
                sql.append(" and json_extract(c.wxPersonalInfo,'$.openId') is not null ");
            }
            if ("N".equals(map.get("isWx"))) {
                sql.append(" and a.verifyResult != 'W' and json_extract(c.wxPersonalInfo,'$.openId') is null ");
            }
            if (!"".equals(map.get("startDay"))) {
                sql.append(" and a.regTime >= ?", (Object)DateConvertUtils.convertFromString((String)map.get("startDay"), (String[])new String[]{"yyyy-MM-dd"}));
            }
            if (!"".equals(map.get("endDay"))) {
                sql.append(" and a.regTime <= ?", (Object)EbikeCommonUtil.addDay(DateConvertUtils.convertFromString((String)map.get("endDay"), (String[])new String[]{"yyyy-MM-dd"}), 1));
            }
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public boolean yysAuditing(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" update  ebike.ebike_orgopr_reginfo set   ");
            sql.append(" verifyResult=? ", (Object)map.get("Confirmflag"));
            sql.append(" ,verifyRemark=?", (Object)map.get("verifyRemark"));
            sql.append(" where 1=1 ");
            sql.append(" and orgoprRegId=?", (Object)map.get("orgoprRegId"));
            results = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    @Override
    public boolean updateYysInfo(Map<String, Object> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        String orgoprType = "";
        orgoprType = map.get("orgoprType").equals("\u6cd5\u4eba") ? "10" : "20";
        try {
            sql.append(" insert into ebike.ebike_orgopr(buro,subburo,orgoprType,orgoprName ");
            sql.append(" ,orgoprCredNo,orgoprCredAttach,valid,serviceRate,regTime,effTime ) ");
            sql.append(" values(?,?,?,?,?,?,?,?,?,?)");
            results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{map.get("burro"), map.get("burro"), orgoprType, map.get("orgoprName"), map.get("orgoprCredNo"), map.get("orgoprCredAttach"), "T", map.get("serviceRate"), map.get("regTime"), new Date()});
            boolean bl = this.upOrgRegioInfo(map);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    @Override
    public boolean updateYysInfoForCar(Map<String, Object> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        String orgoprType = "";
        orgoprType = map.get("orgoprType").equals("\u6cd5\u4eba") ? "10" : "20";
        try {
            sql.append(" insert into ebike.ebike_orgopr(buro,subburo,orgoprType,orgoprName ");
            sql.append(" ,orgoprCredNo,orgoprCredAttach,valid,serviceRate,regTime,effTime,wxPersonalInfo ) ");
            sql.append(" values(?,?,?,?,?,?,?,?,?,?,?)");
            results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{map.get("burro"), map.get("burro"), orgoprType, map.get("orgoprName"), map.get("orgoprCredNo"), map.get("orgoprCredAttach"), "T", map.get("serviceRate"), map.get("regTime"), new Date(), map.get("wxPersonalInfo")});
            boolean bl = this.upOrgRegioInfo(map);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    @Override
    public String getUrlById(String id) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String url = "";
        try {
            sql.append(" select archiveAttach from  ebike.ebike_log_orgacct_withdraw  where 1=1 ");
            sql.append(" and wdapplyId=? ", (Object)id);
            url = (String)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), String.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return url;
        }
        return url;
    }

    @Override
    public Map<String, Object> getOrg() {
        List list = new ArrayList();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            sql.append(" select *  from ebike.param_idtable where 1=1  ");
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("keyid", rs.getString("keyid"));
                    map.put("keyvalue", rs.getInt("keyvalue"));
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return map;
        }
        if (list.size() > 0 && list != null) {
            return (Map)list.get(0);
        }
        return map;
    }

    @Override
    public int updateOrg(Map<String, Object> omap) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int result = 0;
        try {
            sql.append(" replace into  ebike.param_idtable(keyid,keyvalue) ");
            sql.append("values(?,?)");
            result = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{omap.get("keyid"), (Integer)omap.get("keyvalue") + 1});
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return result;
    }

    @Override
    public Map<String, Object> getModalInfo(String orgoprRegId) {
        List list = new ArrayList();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            sql.append(" select a.orgoprRegId,a.orgoprType,a.serviceRate,a.orgoprName,a.orgoprCredNo,a.orgoprCredAttach,a.checkResult,a.checkRemark,a.verifyRemark,a.userNo,a.userName,a.userPassword ");
            sql.append(" ,a.userMobile,a.bankCardNo,a.regTime,a.verifyResult,b.bankBranchName ");
            sql.append(" from ebike.ebike_orgopr_reginfo a  ");
            sql.append(" left join ebike.code_bankbranchs b on a.bankBranchLinkNo=b.bankBranchLinkNo  WHERE 1=1  ");
            sql.append(" and a.orgoprRegId=? ", (Object)orgoprRegId);
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("orgoprRegId", rs.getString("orgoprRegId"));
                    map.put("orgoprType", rs.getString("orgoprType"));
                    map.put("orgoprName", rs.getString("orgoprName"));
                    map.put("orgoprCredNo", rs.getString("orgoprCredNo"));
                    map.put("userNo", rs.getString("userNo"));
                    map.put("userName", rs.getString("userName"));
                    map.put("userPassword", rs.getString("userPassword"));
                    map.put("userMobile", rs.getString("userMobile"));
                    map.put("bankCardNo", rs.getString("bankCardNo"));
                    map.put("regTime", rs.getTimestamp("regTime"));
                    map.put("verifyResult", rs.getString("verifyResult"));
                    map.put("bankBranchName", rs.getString("bankBranchName"));
                    map.put("orgoprCredAttach", rs.getString("orgoprCredAttach"));
                    map.put("checkRemark", rs.getString("checkRemark"));
                    map.put("verifyRemark", rs.getString("verifyRemark"));
                    map.put("checkResult", rs.getString("checkResult"));
                    map.put("serviceRate", rs.getDouble("serviceRate"));
                    return map;
                }
            });
            this.logger.debug(">>>>>>>>>>getModalInfo<<<<<<<<<<<<" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return map;
        }
        if (list.size() > 0 && list != null) {
            return (Map)list.get(0);
        }
        return map;
    }

    @Override
    public boolean upOrgRegioInfo(Map<String, Object> maps) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        this.logger.debug(">>>>>>>>>>>maps<<<<<<<<<<<<<<" + maps);
        try {
            sql.append(" update ebike.ebike_orgopr_reginfo set ");
            sql.append(" verifier=?", (Object)((String)maps.get("orgName")));
            sql.append(" ,verifyResult=? ", (Object)((String)maps.get("Confirmflag")));
            sql.append(" ,orgoprNo=? ", (Object)((String)maps.get("burro")));
            sql.append(" ,verifyRemark=? ", (Object)((String)maps.get("verifyRemark")));
            sql.append(" ,verifyTime  =? ", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy.MM.dd HH:mm:ss"));
            if (null != maps.get("serviceRate") && !"".equals(maps.get("serviceRate"))) {
                sql.append(" ,serviceRate=?", (Object)maps.get("serviceRate").toString());
            }
            sql.append(" where 1=1 ");
            sql.append(" and orgoprRegId=?", (Object)((String)maps.get("orgoprRegId")));
            results = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return results > 0;
    }

    @Override
    public int insertSms(Map<String, String> map) {
        this.logger.debug(" insertSms " + JsonConvertUtils.convertToString(map));
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" insert into ebike.ebike_log_sms ");
            sql.append(" (mobile,operation_type,identify_code,status,create_time)");
            sql.append(" values(?,?,?,?,?) ");
            return this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{map.get("phone"), "3", map.get("code"), map.get("status"), new Date()});
        }
        catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public int getCode(String vodeValue, String userMobile) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" select count(1) from ebike.ebike_log_sms  where create_time >= now()-interval 10 minute ");
            sql.append(" and mobile=? ", (Object)userMobile);
            sql.append("  and identify_code=? ", (Object)vodeValue);
            results = (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
            this.logger.debug(">>>>>>>>>>>getCode<<<<<<<<<<" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    @Override
    public int checkBankNo(String bankBranchLinkNo, String bankCardNo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" select count(1) from ebike.ebike_orgopr_reginfo m where 1=1  ");
            sql.append("  and m.bankCardNo=? ", (Object)bankCardNo);
            sql.append(" and m.verifyResult!='F' ");
            results = (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
            this.logger.debug(">>>>>>>>>>>getCode<<<<<<<<<<" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }
}

