/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.oprmgmt.service.impl;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.easesource.data.bean.Pager;
import com.ebike.openservices.base.service.AbstractEbikeBaseService;
import com.ebike.openservices.oprmgmt.dao.BillingSchemeSettingDao;
import com.ebike.openservices.oprmgmt.dao.OperEvChargingStationBillingEvcarListDao;
import com.ebike.openservices.oprmgmt.dao.OperEvChargingStationBillingInfoDao;
import com.ebike.openservices.oprmgmt.dao.OperEvChargingStationBillingInfoLogDao;
import com.ebike.openservices.oprmgmt.dao.OperEvChargingStationBillingInfoTbcDao;
import com.ebike.openservices.oprmgmt.dao.OperEvChargingStationBillingUserListDao;
import com.ebike.openservices.oprmgmt.dao.OperEvChargingStationStakeholderDistInfoDao;
import com.ebike.openservices.oprmgmt.dto.PageResponse;
import com.ebike.openservices.oprmgmt.entity.po.OperEvChargingStationBillingEvcarList;
import com.ebike.openservices.oprmgmt.entity.po.OperEvChargingStationBillingInfo;
import com.ebike.openservices.oprmgmt.entity.po.OperEvChargingStationBillingInfoLog;
import com.ebike.openservices.oprmgmt.entity.po.OperEvChargingStationBillingInfoTbc;
import com.ebike.openservices.oprmgmt.entity.po.OperEvChargingStationBillingUserList;
import com.ebike.openservices.oprmgmt.entity.po.OperEvChargingStationStakeholderDistInfo;
import com.ebike.openservices.oprmgmt.entity.vo.ListChargingStationBillingInfoLogVO;
import com.ebike.openservices.oprmgmt.entity.vo.ListEarningsShareChargeStationVO;
import com.ebike.openservices.oprmgmt.entity.vo.ListSelfSupportChargeStationBillingInfoVO;
import com.ebike.openservices.oprmgmt.entity.vo.ListSelfSupportChargeStationVO;
import com.ebike.openservices.oprmgmt.entity.vo.UploadTemplateFileVO;
import com.ebike.openservices.oprmgmt.enums.ErrorCodeEnum;
import com.ebike.openservices.oprmgmt.enums.ICode;
import com.ebike.openservices.oprmgmt.enums.SuccessCodeEnum;
import com.ebike.openservices.oprmgmt.exception.BizException;
import com.ebike.openservices.oprmgmt.request.InsertBillingSchemeParam;
import com.ebike.openservices.oprmgmt.request.IsAgreeBillingSchemeParam;
import com.ebike.openservices.oprmgmt.request.ListEarningsShareChargeStationParam;
import com.ebike.openservices.oprmgmt.request.ListSelfSupportChargeStationParam;
import com.ebike.openservices.oprmgmt.request.UpdateBillingSchemeParam;
import com.ebike.openservices.oprmgmt.request.UploadTemplateFileParam;
import com.ebike.openservices.oprmgmt.service.BillingSchemeSettingService;
import com.ebike.openservices.oprmgmt.util.ConvertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BillingSchemeSettingServiceImpl
extends AbstractEbikeBaseService
implements BillingSchemeSettingService {
    private static final Integer IS_INSERT = 1;
    private static final Integer IS_UPDATE = 2;
    private final BillingSchemeSettingDao billingSchemeSettingDao;
    private final OperEvChargingStationStakeholderDistInfoDao operEvChargingStationStakeholderDistInfoDao;
    private final OperEvChargingStationBillingInfoDao operEvChargingStationBillingInfoDao;
    private final OperEvChargingStationBillingInfoTbcDao operEvChargingStationBillingInfoTbcDao;
    private final OperEvChargingStationBillingInfoLogDao operEvChargingStationBillingInfoLogDao;
    private final OperEvChargingStationBillingUserListDao operEvChargingStationBillingUserListDao;
    private final OperEvChargingStationBillingEvcarListDao operEvChargingStationBillingEvcarListDao;

    @Autowired
    public BillingSchemeSettingServiceImpl(BillingSchemeSettingDao billingSchemeSettingDao, OperEvChargingStationStakeholderDistInfoDao operEvChargingStationStakeholderDistInfoDao, OperEvChargingStationBillingInfoDao operEvChargingStationBillingInfoDao, OperEvChargingStationBillingInfoTbcDao operEvChargingStationBillingInfoTbcDao, OperEvChargingStationBillingInfoLogDao operEvChargingStationBillingInfoLogDao, OperEvChargingStationBillingUserListDao operEvChargingStationBillingUserListDao, OperEvChargingStationBillingEvcarListDao operEvChargingStationBillingEvcarListDao) {
        this.billingSchemeSettingDao = billingSchemeSettingDao;
        this.operEvChargingStationStakeholderDistInfoDao = operEvChargingStationStakeholderDistInfoDao;
        this.operEvChargingStationBillingInfoDao = operEvChargingStationBillingInfoDao;
        this.operEvChargingStationBillingInfoTbcDao = operEvChargingStationBillingInfoTbcDao;
        this.operEvChargingStationBillingInfoLogDao = operEvChargingStationBillingInfoLogDao;
        this.operEvChargingStationBillingUserListDao = operEvChargingStationBillingUserListDao;
        this.operEvChargingStationBillingEvcarListDao = operEvChargingStationBillingEvcarListDao;
    }

    public PageResponse<ListSelfSupportChargeStationVO> listSelfSupportChargeStation(ListSelfSupportChargeStationParam param, Pager pager) {
        List<ListSelfSupportChargeStationVO> list = this.billingSchemeSettingDao.listSelfSupportChargeStation(param, pager);
        long total = this.billingSchemeSettingDao.listSelfSupportChargeStationTotal(param);
        return PageResponse.of(list, (int)pager.getPageNumber(), (int)pager.getPageSize(), (long)total);
    }

    public PageResponse<ListEarningsShareChargeStationVO> listEarningsShareChargeStation(ListEarningsShareChargeStationParam param, Pager pager) {
        List<ListEarningsShareChargeStationVO> list = this.billingSchemeSettingDao.listEarningsShareChargeStation(param, pager);
        long total = this.billingSchemeSettingDao.listEarningsShareChargeStationTotal(param);
        return PageResponse.of(list, (int)pager.getPageNumber(), (int)pager.getPageSize(), (long)total);
    }

    public UploadTemplateFileVO uploadTemplateFile(UploadTemplateFileParam param) {
        Integer userType = 1;
        Integer vehicleType = 2;
        LinkedList<String> repetition = new LinkedList<String>();
        LinkedList<String> uniqueness = new LinkedList<String>();
        for (List objects : param.getList()) {
            for (Object object : objects) {
                int count;
                if (!ObjectUtils.isNotEmpty(object) || !StringUtils.isNotBlank((CharSequence)object.toString())) continue;
                if (userType.equals(param.getType())) {
                    count = this.billingSchemeSettingDao.countOperEvChargingStationBillingUserList(param.getChargingStationId(), object.toString());
                    if (count > 0) {
                        repetition.add(object.toString());
                    } else {
                        uniqueness.add(object.toString());
                    }
                }
                if (!vehicleType.equals(param.getType())) continue;
                count = this.billingSchemeSettingDao.countOperEvChargingStationBillingEvcarList(param.getChargingStationId(), object.toString());
                if (count > 0) {
                    repetition.add(object.toString());
                    continue;
                }
                uniqueness.add(object.toString());
            }
        }
        uniqueness.remove(0);
        uniqueness.remove(0);
        if (userType.equals(param.getType())) {
            return UploadTemplateFileVO.builder().uniquenessPhone(uniqueness.stream().distinct().collect(Collectors.toList())).repetitionPhone(repetition.stream().distinct().collect(Collectors.toList())).build().setUniquenessVin(new ArrayList()).setRepetitionVin(new ArrayList());
        }
        if (vehicleType.equals(param.getType())) {
            return UploadTemplateFileVO.builder().uniquenessVin(uniqueness.stream().distinct().collect(Collectors.toList())).repetitionVin(repetition.stream().distinct().collect(Collectors.toList())).build().setUniquenessPhone(new ArrayList()).setRepetitionVin(new ArrayList());
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class}, noRollbackFor={BizException.class})
    public void insertBillingScheme(InsertBillingSchemeParam param) {
        Integer stationBillingStatus;
        OperEvChargingStationBillingUserList user;
        OperEvChargingStationBillingInfo o = this.operEvChargingStationBillingInfoDao.existFromStation(param.getChargingStationId(), param.getBillingTmplId());
        if (ObjectUtils.isNotEmpty((Object)o)) {
            throw new BizException((ICode)ErrorCodeEnum.BILLING_SCHEME_ID_ERROR);
        }
        Long billingTmplId = this.idGenerator.nextId();
        Long chargingUserId = null;
        Long chargingVinId = null;
        if (CollectionUtils.isNotEmpty((Collection)param.getUniquenessUser())) {
            if (ObjectUtils.isEmpty(chargingUserId)) {
                chargingUserId = this.idGenerator.nextId();
            }
            for (String phone : param.getUniquenessUser()) {
                user = OperEvChargingStationBillingUserList.builder().id(chargingUserId).chargingUserMobile(phone).chargingUserName("").creator(param.getCreator()).build().defaultField();
                this.operEvChargingStationBillingUserListDao.insert(user);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)param.getUniquenessCars())) {
            if (ObjectUtils.isEmpty(chargingVinId)) {
                chargingVinId = this.idGenerator.nextId();
            }
            for (String vin : param.getUniquenessCars()) {
                this.operEvChargingStationBillingEvcarListDao.insert(OperEvChargingStationBillingEvcarList.builder().id(chargingVinId).evcarVinCode(vin).creator(param.getCreator()).build().defaultField());
            }
        }
        if (Objects.equals(param.getUpdateOrInsert(), IS_UPDATE)) {
            if (CollectionUtils.isNotEmpty((Collection)param.getRepetitionUsers())) {
                if (ObjectUtils.isEmpty((Object)chargingUserId)) {
                    chargingUserId = this.idGenerator.nextId();
                }
                for (String phone : param.getRepetitionUsers()) {
                    this.operEvChargingStationBillingUserListDao.deleteChargingStationUser(param.getChargingStationId(), phone);
                }
                for (String phone : param.getRepetitionUsers()) {
                    user = OperEvChargingStationBillingUserList.builder().id(chargingUserId).chargingUserMobile(phone).chargingUserName("").creator(param.getCreator()).build().defaultField();
                    this.operEvChargingStationBillingUserListDao.insert(user);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)param.getRepetitionCars())) {
                if (ObjectUtils.isEmpty((Object)chargingVinId)) {
                    chargingVinId = this.idGenerator.nextId();
                }
                for (String vin : param.getRepetitionCars()) {
                    this.operEvChargingStationBillingEvcarListDao.deleteChargingStationVin(param.getChargingStationId(), vin);
                }
                for (String vin : param.getRepetitionCars()) {
                    OperEvChargingStationBillingEvcarList car = OperEvChargingStationBillingEvcarList.builder().id(chargingVinId).evcarVinCode(vin).creator(param.getCreator()).build().defaultField();
                    this.operEvChargingStationBillingEvcarListDao.insert(car);
                }
            }
        }
        int count = this.operEvChargingStationStakeholderDistInfoDao.countEarningsSharePersonByStationId(param.getChargingStationId());
        Date effTime = null;
        if (count > 0) {
            stationBillingStatus = 2;
        } else {
            stationBillingStatus = 1;
            effTime = new Date();
        }
        OperEvChargingStationBillingInfo po = OperEvChargingStationBillingInfo.builder().id(billingTmplId).primaryOrgNo(param.getOrgNo()).orgNo(param.getOrgNo()).chargingStationId(param.getChargingStationId()).stationBillingType(Integer.valueOf(2)).stationBillingStatus(stationBillingStatus).stationBillingDesc(param.getStationBillingDesc()).billingTmplId(param.getBillingTmplId()).stationBillingWhiteUserlistId(chargingUserId).stationBillingWhiteEvcarlistId(chargingVinId).effTime(effTime).creator(param.getCreator()).build().defaultField();
        this.operEvChargingStationBillingInfoDao.insertOperEvChargingStationBillingInfo(po);
        HashMap<String, Object> dictParam = new HashMap<String, Object>(1);
        dictParam.put("chargingStationId", param.getChargingStationId());
        List<OperEvChargingStationStakeholderDistInfo> dictList = this.operEvChargingStationStakeholderDistInfoDao.selectList(dictParam);
        if (CollectionUtils.isNotEmpty(dictList)) {
            for (OperEvChargingStationStakeholderDistInfo info : dictList) {
                OperEvChargingStationBillingInfoTbc tbc = OperEvChargingStationBillingInfoTbc.builder().id(Long.valueOf(this.idGenerator.nextId())).primaryOrgNo(param.getOrgNo()).orgNo(param.getOrgNo()).stationBillingInfoId(billingTmplId).stakeholderOrgNo(info.getStakeholderOrgNo()).confirmStatus(Integer.valueOf(0)).confirmer("").creator(param.getCreator()).build().defaultField();
                this.operEvChargingStationBillingInfoTbcDao.insert(tbc);
            }
        }
        OperEvChargingStationBillingInfoLog log = OperEvChargingStationBillingInfoLog.builder().id(Long.valueOf(this.idGenerator.nextId())).primaryOrgNo(param.getOrgNo()).orgNo(param.getOrgNo()).stationBillingInfoId(po.getId()).logType(Integer.valueOf(10)).logValue("").stationBillingStatus(Integer.valueOf(2)).creator(param.getCreator()).build().defaultField();
        this.operEvChargingStationBillingInfoLogDao.insert(log);
        if (stationBillingStatus == 1) {
            throw new BizException((ICode)SuccessCodeEnum.BILLING_SCHEME_ID_SUCCESS);
        }
        if (stationBillingStatus == 2) {
            throw new BizException((ICode)SuccessCodeEnum.BILLING_SCHEME_ADD_SHARE_SUCCESS);
        }
    }

    public void updateBillingScheme(UpdateBillingSchemeParam param) {
        OperEvChargingStationBillingEvcarList car;
        OperEvChargingStationBillingUserList user;
        OperEvChargingStationBillingInfo info = this.operEvChargingStationBillingInfoDao.selectById(param.getId());
        if (ObjectUtils.isEmpty((Object)info)) {
            throw new BizException((ICode)ErrorCodeEnum.ERROR);
        }
        OperEvChargingStationBillingInfo o = this.operEvChargingStationBillingInfoDao.existFromStation(param.getChargingStationId(), param.getBillingTmplId());
        if (ObjectUtils.isNotEmpty((Object)o) && !info.getBillingTmplId().equals(param.getBillingTmplId())) {
            throw new BizException((ICode)ErrorCodeEnum.BILLING_SCHEME_ID_ERROR);
        }
        if (info.getBillingTmplId().equals(param.getBillingTmplId()) && info.getStationBillingDesc().equals(param.getStationBillingDesc()) && CollectionUtils.isEmpty((Collection)param.getRepetitionUsers()) && CollectionUtils.isEmpty((Collection)param.getUniquenessUsers()) && CollectionUtils.isEmpty((Collection)param.getRepetitionCars()) && CollectionUtils.isEmpty((Collection)param.getUniquenessCars())) {
            return;
        }
        Long chargingUserId = null;
        Long chargingVinId = null;
        if (Objects.equals(param.getUpdateOrInsert(), 2)) {
            if (CollectionUtils.isNotEmpty((Collection)param.getRepetitionUsers())) {
                for (String phone : param.getRepetitionUsers()) {
                    if (phone.length() == 11) continue;
                    throw new BizException((ICode)ErrorCodeEnum.BILLING_SCHEME_FORMAT_USER_ERROR);
                }
                if (ObjectUtils.isEmpty(chargingUserId)) {
                    chargingUserId = this.idGenerator.nextId();
                }
                for (String phone : param.getRepetitionUsers()) {
                    this.operEvChargingStationBillingUserListDao.deleteChargingStationUser(param.getChargingStationId(), phone);
                }
                for (String phone : param.getRepetitionUsers()) {
                    user = OperEvChargingStationBillingUserList.builder().id(chargingUserId).chargingUserMobile(phone).creator(param.getModifier()).gmtCreate(Long.valueOf(System.currentTimeMillis())).version(Integer.valueOf(1)).build();
                    ConvertUtils.toEmptyDefaultValue(user);
                    this.operEvChargingStationBillingUserListDao.insert(user);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)param.getRepetitionCars())) {
                if (ObjectUtils.isEmpty(chargingVinId)) {
                    chargingVinId = this.idGenerator.nextId();
                }
                for (String vin : param.getRepetitionCars()) {
                    this.operEvChargingStationBillingEvcarListDao.deleteChargingStationVin(param.getChargingStationId(), vin);
                }
                for (String vin : param.getRepetitionCars()) {
                    car = OperEvChargingStationBillingEvcarList.builder().id(chargingVinId).evcarVinCode(vin).creator(param.getModifier()).gmtCreate(Long.valueOf(System.currentTimeMillis())).version(Integer.valueOf(1)).build();
                    ConvertUtils.toEmptyDefaultValue(car);
                    this.operEvChargingStationBillingEvcarListDao.insert(car);
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)param.getUniquenessUsers())) {
            for (String phone : param.getUniquenessUsers()) {
                if (phone.length() == 11) continue;
                throw new BizException((ICode)ErrorCodeEnum.BILLING_SCHEME_FORMAT_USER_ERROR);
            }
            if (ObjectUtils.isEmpty(chargingUserId)) {
                chargingUserId = this.idGenerator.nextId();
            }
            for (String phone : param.getUniquenessUsers()) {
                user = OperEvChargingStationBillingUserList.builder().id(chargingUserId).chargingUserMobile(phone).creator(param.getModifier()).gmtCreate(Long.valueOf(System.currentTimeMillis())).version(Integer.valueOf(1)).build();
                ConvertUtils.toEmptyDefaultValue(user);
                this.operEvChargingStationBillingUserListDao.insert(user);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)param.getUniquenessCars())) {
            if (ObjectUtils.isEmpty(chargingVinId)) {
                chargingVinId = this.idGenerator.nextId();
            }
            for (String vin : param.getUniquenessCars()) {
                car = OperEvChargingStationBillingEvcarList.builder().id(chargingVinId).evcarVinCode(vin).creator(param.getModifier()).gmtCreate(Long.valueOf(System.currentTimeMillis())).version(Integer.valueOf(1)).build();
                ConvertUtils.toEmptyDefaultValue(car);
                this.operEvChargingStationBillingEvcarListDao.insert(car);
            }
        }
        info.setModifier(param.getModifier());
        info.setGmtModified(Long.valueOf(System.currentTimeMillis()));
        info.setStationBillingDesc(param.getStationBillingDesc());
        int count = this.operEvChargingStationStakeholderDistInfoDao.countEarningsSharePersonByStationId(param.getChargingStationId());
        if (count > 0) {
            info.setStationBillingStatus(Integer.valueOf(3));
            info.setNewBillingTmplId(param.getBillingTmplId());
            info.setNewStationBillingWhiteUserlistId(chargingUserId);
            info.setNewStationBillingWhiteEvcarlistId(chargingVinId);
        } else {
            info.setStationBillingStatus(Integer.valueOf(1));
            info.setEffTime(new Date());
            info.setBillingTmplId(param.getBillingTmplId());
            info.setStationBillingWhiteUserlistId(chargingUserId);
            info.setStationBillingWhiteEvcarlistId(chargingVinId);
        }
        this.operEvChargingStationBillingInfoDao.updateById(info);
        HashMap<String, Object> dictParam = new HashMap<String, Object>(2);
        dictParam.put("orgNo", param.getOrgNo());
        dictParam.put("chargingStationId", info.getChargingStationId());
        List<OperEvChargingStationStakeholderDistInfo> dictList = this.operEvChargingStationStakeholderDistInfoDao.selectList(dictParam);
        if (CollectionUtils.isNotEmpty(dictList)) {
            for (OperEvChargingStationStakeholderDistInfo info1 : dictList) {
                OperEvChargingStationBillingInfoTbc tbc = OperEvChargingStationBillingInfoTbc.builder().id(Long.valueOf(this.idGenerator.nextId())).primaryOrgNo(param.getOrgNo()).orgNo(param.getOrgNo()).confirmStatus(Integer.valueOf(0)).stationBillingInfoId(info1.getId()).stakeholderOrgNo(info1.getStakeholderOrgNo()).version(Integer.valueOf(1)).build();
                ConvertUtils.toEmptyDefaultValue(tbc);
                this.operEvChargingStationBillingInfoTbcDao.insert(tbc);
            }
        }
        OperEvChargingStationBillingInfoLog log = OperEvChargingStationBillingInfoLog.builder().id(Long.valueOf(this.idGenerator.nextId())).primaryOrgNo(param.getOrgNo()).orgNo(param.getOrgNo()).stationBillingInfoId(info.getId()).logType(Integer.valueOf(20)).stationBillingStatus(Integer.valueOf(3)).creator(param.getModifier()).gmtCreate(Long.valueOf(System.currentTimeMillis())).version(Integer.valueOf(1)).build();
        ConvertUtils.toEmptyDefaultValue(log);
        this.operEvChargingStationBillingInfoLogDao.insert(log);
        if (count > 0) {
            throw new BizException((ICode)SuccessCodeEnum.BILLING_SCHEME_ADD_SHARE_SUCCESS);
        }
        throw new BizException((ICode)SuccessCodeEnum.BILLING_SCHEME_ID_SUCCESS);
    }

    public int stopBillingScheme(Long id, String orgNo, String userNo) {
        OperEvChargingStationBillingInfo info = this.operEvChargingStationBillingInfoDao.selectById(id);
        if (ObjectUtils.isEmpty((Object)info)) {
            return 400;
        }
        int schemeCount = this.operEvChargingStationBillingInfoDao.countSchemeByStationId(info.getChargingStationId());
        if (schemeCount <= 1) {
            return 400001;
        }
        int personCount = this.operEvChargingStationStakeholderDistInfoDao.countEarningsSharePersonByStationId(info.getChargingStationId());
        if (personCount > 0) {
            info.setStationBillingStatus(Integer.valueOf(4));
        } else {
            info.setStationBillingStatus(Integer.valueOf(9));
            info.setInvalidTime(new Date());
        }
        this.operEvChargingStationBillingInfoDao.updateById(info);
        HashMap<String, Object> dictParam = new HashMap<String, Object>(2);
        dictParam.put("orgNo", orgNo);
        dictParam.put("chargingStationId", info.getChargingStationId());
        List<OperEvChargingStationStakeholderDistInfo> dictList = this.operEvChargingStationStakeholderDistInfoDao.selectList(dictParam);
        if (CollectionUtils.isNotEmpty(dictList)) {
            for (OperEvChargingStationStakeholderDistInfo vo : dictList) {
                OperEvChargingStationBillingInfoTbc tbc = OperEvChargingStationBillingInfoTbc.builder().id(Long.valueOf(this.idGenerator.nextId())).primaryOrgNo(orgNo).orgNo(orgNo).confirmStatus(Integer.valueOf(0)).stationBillingInfoId(info.getId()).stakeholderOrgNo(vo.getStakeholderOrgNo()).version(Integer.valueOf(1)).build();
                ConvertUtils.toEmptyDefaultValue(tbc);
                this.operEvChargingStationBillingInfoTbcDao.insert(tbc);
            }
            OperEvChargingStationBillingInfoLog log = OperEvChargingStationBillingInfoLog.builder().id(Long.valueOf(this.idGenerator.nextId())).primaryOrgNo(orgNo).orgNo(orgNo).stationBillingInfoId(info.getId()).logType(Integer.valueOf(30)).stationBillingStatus(Integer.valueOf(4)).creator(userNo).gmtCreate(Long.valueOf(System.currentTimeMillis())).version(Integer.valueOf(1)).build();
            ConvertUtils.toEmptyDefaultValue(log);
            this.operEvChargingStationBillingInfoLogDao.insert(log);
        } else {
            OperEvChargingStationBillingInfoLog log = OperEvChargingStationBillingInfoLog.builder().id(Long.valueOf(this.idGenerator.nextId())).primaryOrgNo(orgNo).orgNo(orgNo).stationBillingInfoId(info.getId()).logType(Integer.valueOf(30)).stationBillingStatus(Integer.valueOf(9)).creator(userNo).gmtCreate(Long.valueOf(System.currentTimeMillis())).version(Integer.valueOf(1)).build();
            ConvertUtils.toEmptyDefaultValue(log);
            this.operEvChargingStationBillingInfoLogDao.insert(log);
        }
        if (personCount > 0) {
            return 201;
        }
        return 200;
    }

    public List<ListSelfSupportChargeStationBillingInfoVO> listSelfSupportChargeStationBillingInfo(Long chargingStationId) {
        List<ListSelfSupportChargeStationBillingInfoVO> list = this.operEvChargingStationBillingInfoDao.listSelfSupportChargeStationBillingInfo(chargingStationId);
        list.forEach(vo -> {
            StringBuilder stringBuilder = new StringBuilder();
            String string = vo.getBillingDetail();
            JSONObject json = JSONUtil.parseObj((String)string);
            String priceRateType = json.getStr((Object)"price_rate_type");
            if ("single".equals(priceRateType)) {
                stringBuilder.append("\u7535\u5ea6\u7535\u8d39").append(json.getStr((Object)"price_total")).append("\u5143/kwh").append("\uff0c\u6284\u8868\u95f4\u9694").append(10).append("\u5206\u949f");
            }
            if ("multi".equals(priceRateType) && "1".equals(json.getStr((Object)"rate_period_type"))) {
                stringBuilder.append("\u5c16\u7535\u4ef7").append(json.getStr((Object)"price_rate01")).append("\u5143/kwh").append("\uff0c\u5cf0\u7535\u4ef7").append(json.getStr((Object)"price_rate02")).append("\u5143/kwh").append("\uff0c\u5e73\u7535\u4ef7").append(json.getStr((Object)"price_rate03")).append("\u5143/kwh").append("\uff0c\u8c37\u7535\u4ef7").append(json.getStr((Object)"price_rate04")).append("\u5143/kwh").append("\uff0c\u670d\u52a1\u8d39").append(json.getStr((Object)"price_service")).append("\u5143/kwh").append("\uff0c\u6284\u8868\u95f4\u9694").append(10).append("\u5206\u949f");
            }
            if ("multi".equals(priceRateType) && "2".equals(json.getStr((Object)"rate_period_type"))) {
                for (int i = 1; i <= 10; ++i) {
                    String index = String.format("%02d", i);
                    String indexOne = String.format("%02d", i + 1);
                    stringBuilder.append(json.getStr((Object)("start_value_rate_period" + index))).append("-");
                    if (StringUtils.isNotBlank((CharSequence)json.getStr((Object)("start_value_rate_period" + indexOne)))) {
                        stringBuilder.append(json.getStr((Object)("start_value_rate_period" + indexOne)));
                    }
                    if (StringUtils.isBlank((CharSequence)json.getStr((Object)("start_value_rate_period" + indexOne)))) {
                        stringBuilder.append("24:00");
                        stringBuilder.append(" ").append(json.getStr((Object)("price_rate" + index))).append("\u5143/kwh ");
                        break;
                    }
                    stringBuilder.append(" ").append(json.getStr((Object)("price_rate" + index))).append("\u5143/kwh ");
                }
                stringBuilder.append("\uff0c\u670d\u52a1\u8d39").append(json.getStr((Object)"price_service")).append("\u5143/kwh").append("\uff0c\u6284\u8868\u95f4\u9694").append(10).append("\u5206\u949f");
            }
            vo.setBillingDetail(stringBuilder.toString());
        });
        return list;
    }

    public PageResponse listChargingStationBillingUser(Long id, Pager pager) {
        List<Map<String, Object>> list = this.operEvChargingStationBillingInfoDao.listChargingStationBillingUser(id, pager);
        if (CollectionUtils.isNotEmpty(list) && ObjectUtils.isEmpty(list.get(0))) {
            list.remove(0);
        }
        long total = this.operEvChargingStationBillingInfoDao.countChargingStationBillingUserTotal(id);
        return PageResponse.of(list, (int)pager.getPageNumber(), (int)pager.getPageSize(), (long)total);
    }

    public PageResponse listChargingStationBillingUserAfter(Long id, Pager pager) {
        List<Map<String, Object>> list = this.operEvChargingStationBillingInfoDao.listChargingStationBillingUserAfter(id, pager);
        if (CollectionUtils.isNotEmpty(list) && ObjectUtils.isEmpty(list.get(0))) {
            list.remove(0);
        }
        long total = this.operEvChargingStationBillingInfoDao.countChargingStationBillingUserAfterTotal(id);
        return PageResponse.of(list, (int)pager.getPageNumber(), (int)pager.getPageSize(), (long)total);
    }

    public PageResponse listChargingStationBillingCar(Long id, Pager pager) {
        List<Map<String, Object>> list = this.operEvChargingStationBillingInfoDao.listChargingStationBillingCar(id, pager);
        if (CollectionUtils.isNotEmpty(list) && ObjectUtils.isEmpty(list.get(0))) {
            list.remove(0);
        }
        long total = this.operEvChargingStationBillingInfoDao.countChargingStationBillingCarTotal(id);
        return PageResponse.of(list, (int)pager.getPageNumber(), (int)pager.getPageSize(), (long)total);
    }

    public PageResponse listChargingStationBillingCarAfter(Long id, Pager pager) {
        List<Map<String, Object>> list = this.operEvChargingStationBillingInfoDao.listChargingStationBillingCarAfter(id, pager);
        if (CollectionUtils.isNotEmpty(list) && ObjectUtils.isEmpty(list.get(0))) {
            list.remove(0);
        }
        long total = this.operEvChargingStationBillingInfoDao.countChargingStationBillingCarAfterTotal(id);
        return PageResponse.of(list, (int)pager.getPageNumber(), (int)pager.getPageSize(), (long)total);
    }

    public PageResponse<ListChargingStationBillingInfoLogVO> listChargingStationBillingInfoLog(Long stationBillingInfoId, Pager pager) {
        List<ListChargingStationBillingInfoLogVO> list = this.operEvChargingStationBillingInfoLogDao.listChargingStationBillingInfoLog(stationBillingInfoId, pager);
        long total = this.operEvChargingStationBillingInfoLogDao.countChargingStationBillingInfoLogTotal(stationBillingInfoId);
        return PageResponse.of(list, (int)pager.getPageNumber(), (int)pager.getPageSize(), (long)total);
    }

    public void isAgreeBillingScheme(IsAgreeBillingSchemeParam param) {
        OperEvChargingStationBillingInfo info = this.operEvChargingStationBillingInfoDao.selectById(param.getStationBillingInfoId());
        param.setGmtModified(Long.valueOf(System.currentTimeMillis()));
        param.setConfirmTime(new Date());
        int count = this.operEvChargingStationBillingInfoTbcDao.isAgreeBillingScheme(param);
        if (count <= 0) {
            return;
        }
        Integer logType = null;
        if (Integer.valueOf(2).equals(info.getStationBillingStatus())) {
            logType = Integer.valueOf(1).equals(param.getConfirmStatus()) ? 11 : 12;
        }
        if (Integer.valueOf(3).equals(info.getStationBillingStatus())) {
            logType = Integer.valueOf(1).equals(param.getConfirmStatus()) ? 21 : 22;
        }
        if (Integer.valueOf(4).equals(info.getStationBillingStatus())) {
            logType = Integer.valueOf(1).equals(param.getConfirmStatus()) ? 31 : 32;
        }
        if (Integer.valueOf(5).equals(info.getStationBillingStatus())) {
            logType = Integer.valueOf(1).equals(param.getConfirmStatus()) ? 41 : 42;
        }
        OperEvChargingStationBillingInfoLog log = OperEvChargingStationBillingInfoLog.builder().id(Long.valueOf(this.idGenerator.nextId())).primaryOrgNo(param.getStakeholderOrgNo()).orgNo(param.getStakeholderOrgNo()).stationBillingInfoId(param.getStationBillingInfoId()).logType(logType).stationBillingStatus(Integer.valueOf(1)).creator(param.getUserNo()).gmtCreate(Long.valueOf(System.currentTimeMillis())).version(Integer.valueOf(1)).build();
        ConvertUtils.toEmptyDefaultValue(log);
        this.operEvChargingStationBillingInfoLogDao.insert(log);
        boolean flag = true;
        boolean toBeConfirmed = false;
        List<OperEvChargingStationBillingInfoTbc> tbcList = this.operEvChargingStationBillingInfoTbcDao.selectList(param.getStationBillingInfoId());
        if (CollectionUtils.isNotEmpty(tbcList)) {
            for (OperEvChargingStationBillingInfoTbc tbc : tbcList) {
                if (Integer.valueOf(0).equals(tbc.getConfirmStatus())) {
                    flag = false;
                    toBeConfirmed = true;
                }
                if (!Integer.valueOf(2).equals(tbc.getConfirmStatus())) continue;
                flag = false;
            }
        }
        if (flag) {
            info.setStationBillingStatus(Integer.valueOf(1));
            info.setEffTime(new Date());
            if (Integer.valueOf(3).equals(info.getStationBillingStatus())) {
                info.setBillingTmplId(info.getNewBillingTmplId());
                info.setNewBillingTmplId(null);
                info.setStationBillingWhiteUserlistId(info.getNewStationBillingWhiteUserlistId());
                info.setNewStationBillingWhiteUserlistId(null);
                info.setStationBillingWhiteEvcarlistId(info.getNewStationBillingWhiteEvcarlistId());
                info.setNewStationBillingWhiteEvcarlistId(null);
            }
            this.operEvChargingStationBillingInfoDao.updateById(info);
        }
        if (!flag && !toBeConfirmed) {
            info.setStationBillingStatus(Integer.valueOf(9));
            info.setInvalidTime(new Date());
            this.operEvChargingStationBillingInfoDao.updateById(info);
        }
    }

    public int liftABanBillingScheme(Long id, String orgNo, String userNo) {
        OperEvChargingStationBillingInfo info = this.operEvChargingStationBillingInfoDao.selectById(id);
        if (ObjectUtils.isEmpty((Object)info)) {
            return 400;
        }
        int personCount = this.operEvChargingStationStakeholderDistInfoDao.countEarningsSharePersonByStationId(info.getChargingStationId());
        if (personCount > 0) {
            info.setStationBillingStatus(Integer.valueOf(5));
        } else {
            info.setStationBillingStatus(Integer.valueOf(1));
            info.setEffTime(new Date());
        }
        this.operEvChargingStationBillingInfoDao.updateById(info);
        HashMap<String, Object> dictParam = new HashMap<String, Object>(2);
        dictParam.put("orgNo", orgNo);
        dictParam.put("chargingStationId", info.getChargingStationId());
        List<OperEvChargingStationStakeholderDistInfo> dictList = this.operEvChargingStationStakeholderDistInfoDao.selectList(dictParam);
        if (CollectionUtils.isNotEmpty(dictList)) {
            for (OperEvChargingStationStakeholderDistInfo vo : dictList) {
                OperEvChargingStationBillingInfoTbc tbc = OperEvChargingStationBillingInfoTbc.builder().id(Long.valueOf(this.idGenerator.nextId())).primaryOrgNo(orgNo).orgNo(orgNo).confirmStatus(Integer.valueOf(0)).stationBillingInfoId(info.getId()).stakeholderOrgNo(vo.getStakeholderOrgNo()).version(Integer.valueOf(1)).build();
                ConvertUtils.toEmptyDefaultValue(tbc);
                this.operEvChargingStationBillingInfoTbcDao.insert(tbc);
            }
            OperEvChargingStationBillingInfoLog log = OperEvChargingStationBillingInfoLog.builder().id(Long.valueOf(this.idGenerator.nextId())).primaryOrgNo(orgNo).orgNo(orgNo).stationBillingInfoId(info.getId()).logType(Integer.valueOf(40)).stationBillingStatus(Integer.valueOf(5)).creator(userNo).gmtCreate(Long.valueOf(System.currentTimeMillis())).version(Integer.valueOf(1)).build();
            ConvertUtils.toEmptyDefaultValue(log);
            this.operEvChargingStationBillingInfoLogDao.insert(log);
        } else {
            OperEvChargingStationBillingInfoLog log = OperEvChargingStationBillingInfoLog.builder().id(Long.valueOf(this.idGenerator.nextId())).primaryOrgNo(orgNo).orgNo(orgNo).stationBillingInfoId(info.getId()).logType(Integer.valueOf(40)).stationBillingStatus(Integer.valueOf(1)).creator(userNo).gmtCreate(Long.valueOf(System.currentTimeMillis())).version(Integer.valueOf(1)).build();
            ConvertUtils.toEmptyDefaultValue(log);
            this.operEvChargingStationBillingInfoLogDao.insert(log);
        }
        if (personCount > 0) {
            return 201;
        }
        return 200;
    }
}

