/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.oprmgmt.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.ebike.openservices.base.service.util.CurveUtil;
import com.ebike.openservices.oprmgmt.dao.ChargingTrendAnalysisCarDao;
import com.ebike.openservices.oprmgmt.entity.vo.ChargingTrendAnalysisCarVo;
import com.ebike.openservices.oprmgmt.request.ChargingTrendAnalysisCarRequest;
import com.ebike.openservices.oprmgmt.service.ChargingTrendAnalysisCarService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ChargingTrendAnalysisCarServiceImpl
implements ChargingTrendAnalysisCarService {
    @Resource
    private ChargingTrendAnalysisCarDao chargingTrendAnalysisCarDao;

    public List<ChargingTrendAnalysisCarVo> getChargingStationNameList(ChargingTrendAnalysisCarRequest request) {
        String adCode = request.getAdcode();
        if (StrUtil.isNotBlank((CharSequence)adCode)) {
            while (adCode.endsWith("0")) {
                adCode = adCode.substring(0, adCode.length() - 1);
            }
        }
        request.setAdcode(adCode);
        return this.chargingTrendAnalysisCarDao.getChargingStationNameList(request);
    }

    public List<Map<String, Object>> getChargePrinceCarList(String orgNo) {
        ArrayList resultList = Lists.newArrayList();
        List<Map<String, Object>> nameList = this.chargingTrendAnalysisCarDao.getChargePrinceCarList(orgNo);
        for (Map<String, Object> objectMap : nameList) {
            HashMap map = Maps.newHashMap();
            map.put("id", objectMap.get("id").toString());
            map.put("name", objectMap.get("name").toString());
            resultList.add(map);
        }
        return resultList;
    }

    public Map<String, Object> getChargingTrendAnalysisCarCure(ChargingTrendAnalysisCarRequest request) {
        String dateType = request.getDateType();
        Map<Object, Object> result = Maps.newHashMap();
        switch (dateType) {
            case "0": {
                List<ChargingTrendAnalysisCarVo> listCure = this.chargingTrendAnalysisCarDao.getChargingTrendAnalysisCarCureDayAndMonth(request);
                DateTime startTime = DateUtil.parse((CharSequence)request.getStartTime());
                DateTime endTime = DateUtil.parse((CharSequence)request.getEndTime());
                List labels = CurveUtil.getDatesBetweenTwoDateFormat((Date)startTime, (Date)endTime);
                result = ChargingTrendAnalysisCarServiceImpl.getChargingTrendAnalysisCarDay(listCure, labels);
                result.put("labels", labels);
                return result;
            }
            case "1": {
                List<ChargingTrendAnalysisCarVo> monthList = this.chargingTrendAnalysisCarDao.getChargingTrendAnalysisCarCureDayAndMonth(request);
                int year = Integer.parseInt(request.getDateStat().substring(0, 4));
                int month = Integer.parseInt(request.getDateStat().substring(5, 7));
                List monthLabels = CurveUtil.getMonthFullDay((int)year, (int)month);
                result = ChargingTrendAnalysisCarServiceImpl.getChargingTrendAnalysisCarDay(monthList, monthLabels);
                result.put("labels", CurveUtil.getMonthFullDayForDay((int)year, (int)month));
                return result;
            }
            case "2": {
                List<ChargingTrendAnalysisCarVo> yearList = this.chargingTrendAnalysisCarDao.getChargingTrendAnalysisCarCureYear(request);
                int yearDate = Integer.parseInt(request.getDateStat());
                List yearLabels = CurveUtil.getMonthsByYear((Integer)yearDate);
                result = ChargingTrendAnalysisCarServiceImpl.getChargingTrendAnalysisCarDay(yearList, yearLabels);
                result.put("labels", CurveUtil.getMonthsByYearForMonth((Integer)yearDate));
                return result;
            }
        }
        return result;
    }

    private static Map<String, Object> getChargingTrendAnalysisCarDay(List<ChargingTrendAnalysisCarVo> list, List<String> labels) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            ArrayList<Integer> chargeCntList = new ArrayList<Integer>();
            ArrayList<String> chargeIncomeList = new ArrayList<String>();
            ArrayList<Integer> plugPtsCntList = new ArrayList<Integer>();
            ArrayList<String> chargeUseRatioList = new ArrayList<String>();
            if (list != null && list.size() > 0) {
                int a;
                int index = 0;
                for (int k = 0; k < labels.size(); ++k) {
                    if (!list.get(index).getDateStat().equals(labels.get(k))) {
                        chargeCntList.add(null);
                        chargeIncomeList.add(null);
                        plugPtsCntList.add(null);
                        chargeUseRatioList.add(null);
                    } else {
                        chargeCntList.add(list.get(index).getChargeCnt());
                        chargeIncomeList.add(list.get(index).getChargeIncome());
                        plugPtsCntList.add(list.get(index).getPlugPtsCnt());
                        chargeUseRatioList.add(list.get(index).getChargeUseRatio());
                        ++index;
                    }
                    if (index == list.size()) break;
                }
                int differenceDays = labels.size() - chargeCntList.size();
                int chargeIncomeDays = labels.size() - chargeIncomeList.size();
                int plugPtsCntDays = labels.size() - plugPtsCntList.size();
                int chargeUseRatioDays = labels.size() - chargeUseRatioList.size();
                for (int j = 0; j < differenceDays; ++j) {
                    chargeCntList.add(null);
                }
                for (a = 0; a < chargeIncomeDays; ++a) {
                    chargeIncomeList.add(null);
                }
                for (int b = 0; b < plugPtsCntDays; ++b) {
                    plugPtsCntList.add(null);
                }
                for (a = 0; a < chargeUseRatioDays; ++a) {
                    chargeUseRatioList.add(null);
                }
            }
            map.put("chargeCntList", chargeCntList);
            map.put("chargeIncomeList", chargeIncomeList);
            map.put("plugPtsCntList", plugPtsCntList);
            map.put("chargeUseRatioList", chargeUseRatioList);
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

