/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.oprmgmt.service.impl;

import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.ebike.openservices.oprmgmt.dao.DisasterPreventionDao;
import com.ebike.openservices.oprmgmt.dao.EbikeChargeDeviceExtparamDao;
import com.ebike.openservices.oprmgmt.dao.EbikeLogChargeDeviceExtparamDao;
import com.ebike.openservices.oprmgmt.entity.DisasterPreventionVo;
import com.ebike.openservices.oprmgmt.entity.EbikeChargeDeviceExtparamDo;
import com.ebike.openservices.oprmgmt.entity.EbikeLogChargeDeviceExtparamDo;
import com.ebike.openservices.oprmgmt.request.DisasterSetUpRequest;
import com.ebike.openservices.oprmgmt.service.DisasterPreventionService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DisasterPreventionServiceImpl
implements DisasterPreventionService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DisasterPreventionDao disasterPreventionDao;
    private final EbikeChargeDeviceExtparamDao ebikeChargeDeviceExtparamDao;
    private final EbikeLogChargeDeviceExtparamDao ebikeLogChargeDeviceExtparamDao;

    @Autowired
    public DisasterPreventionServiceImpl(DisasterPreventionDao disasterPreventionDao, EbikeChargeDeviceExtparamDao ebikeChargeDeviceExtparamDao, EbikeLogChargeDeviceExtparamDao ebikeLogChargeDeviceExtparamDao) {
        this.disasterPreventionDao = disasterPreventionDao;
        this.ebikeChargeDeviceExtparamDao = ebikeChargeDeviceExtparamDao;
        this.ebikeLogChargeDeviceExtparamDao = ebikeLogChargeDeviceExtparamDao;
    }

    public List<DisasterPreventionVo> getDisasterPreventionList(Map params, Sorter sorter, Pager pager) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("params00 : " + params);
        }
        return this.disasterPreventionDao.getList(params, sorter, pager);
    }

    public int getDisasterPreventionCount(Map params) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("params01 : " + params);
        }
        return this.disasterPreventionDao.getCount(params);
    }

    public List<EbikeLogChargeDeviceExtparamDo> getLogList(Map params, Sorter sorter, Pager pager) {
        return this.ebikeLogChargeDeviceExtparamDao.getList(params, sorter, pager);
    }

    public int getLogCount(Map params) {
        return this.ebikeLogChargeDeviceExtparamDao.getCount(params);
    }

    public int setUpDisasterPrevention(List<DisasterSetUpRequest> disasterSetUpRequestList) {
        int result = 0;
        for (DisasterSetUpRequest disasterSetUpRequest : disasterSetUpRequestList) {
            Long chargedeviceId = Long.parseLong(disasterSetUpRequest.getChargedeviceId());
            EbikeChargeDeviceExtparamDo ebikeChargeDeviceExtparamDo = (EbikeChargeDeviceExtparamDo)this.ebikeChargeDeviceExtparamDao.get(chargedeviceId);
            EbikeLogChargeDeviceExtparamDo ebikeLogChargeDeviceExtparamDo = new EbikeLogChargeDeviceExtparamDo();
            ebikeLogChargeDeviceExtparamDo.setChargedeviceId(chargedeviceId);
            ebikeLogChargeDeviceExtparamDo.setLogType("100");
            ebikeLogChargeDeviceExtparamDo.setLogRemark(disasterSetUpRequest.getLogRemark());
            ebikeLogChargeDeviceExtparamDo.setOperator(disasterSetUpRequest.getOperator());
            ebikeLogChargeDeviceExtparamDo.setOperatorMobile(disasterSetUpRequest.getOperatorMobile());
            ebikeLogChargeDeviceExtparamDo.setOperateTime(DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ebikeLogChargeDeviceExtparamDos : " + ebikeLogChargeDeviceExtparamDo);
            }
            this.ebikeLogChargeDeviceExtparamDao.insert(ebikeLogChargeDeviceExtparamDo);
            if (ebikeChargeDeviceExtparamDo != null && ebikeChargeDeviceExtparamDo.getChargedeviceId() > 0L) {
                ebikeChargeDeviceExtparamDo.setEmerStatus(disasterSetUpRequest.getEmerStatus());
                ebikeChargeDeviceExtparamDo.setChargedeviceId(chargedeviceId);
                ebikeChargeDeviceExtparamDo.setEmerExecDesc(disasterSetUpRequest.getEmerExecDesc());
                ebikeChargeDeviceExtparamDo.setEmerExecTime(new Date());
                ebikeChargeDeviceExtparamDo.setEmerExecutor(disasterSetUpRequest.getEmerExecutor());
                this.ebikeChargeDeviceExtparamDao.update(ebikeChargeDeviceExtparamDo);
                continue;
            }
            ebikeChargeDeviceExtparamDo = new EbikeChargeDeviceExtparamDo();
            ebikeChargeDeviceExtparamDo.setChargedeviceId(chargedeviceId);
            ebikeChargeDeviceExtparamDo.setEmerStatus(disasterSetUpRequest.getEmerStatus());
            ebikeChargeDeviceExtparamDo.setEmerExecDesc(disasterSetUpRequest.getEmerExecDesc());
            ebikeChargeDeviceExtparamDo.setEmerExecTime(new Date());
            ebikeChargeDeviceExtparamDo.setEmerExecutor(disasterSetUpRequest.getEmerExecutor());
            ebikeChargeDeviceExtparamDo.setLampStatus("00");
            this.ebikeChargeDeviceExtparamDao.insert(ebikeChargeDeviceExtparamDo);
        }
        return result;
    }

    public int removeDisasterPrevention(List<DisasterSetUpRequest> disasterSetUpRequestList) {
        int result = 0;
        for (DisasterSetUpRequest disasterSetUpRequest : disasterSetUpRequestList) {
            Long chargedeviceId = Long.parseLong(disasterSetUpRequest.getChargedeviceId());
            EbikeChargeDeviceExtparamDo ebikeChargeDeviceExtparamDo = (EbikeChargeDeviceExtparamDo)this.ebikeChargeDeviceExtparamDao.get(chargedeviceId);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ebikeChargeDeviceExtparamDo0    : " + ebikeChargeDeviceExtparamDo);
            }
            EbikeLogChargeDeviceExtparamDo ebikeLogChargeDeviceExtparamDo = new EbikeLogChargeDeviceExtparamDo();
            ebikeLogChargeDeviceExtparamDo.setChargedeviceId(chargedeviceId);
            ebikeLogChargeDeviceExtparamDo.setLogType("101");
            ebikeLogChargeDeviceExtparamDo.setLogRemark(disasterSetUpRequest.getLogRemark());
            ebikeLogChargeDeviceExtparamDo.setOperator(disasterSetUpRequest.getOperator());
            ebikeLogChargeDeviceExtparamDo.setOperatorMobile(disasterSetUpRequest.getOperatorMobile());
            ebikeLogChargeDeviceExtparamDo.setOperateTime(DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ebikeLogChargeDeviceExtparamDo1 : " + ebikeLogChargeDeviceExtparamDo);
            }
            this.ebikeLogChargeDeviceExtparamDao.insert(ebikeLogChargeDeviceExtparamDo);
            if (ebikeChargeDeviceExtparamDo == null || ebikeChargeDeviceExtparamDo.getChargedeviceId() <= 0L) continue;
            ebikeChargeDeviceExtparamDo.setEmerStatus(disasterSetUpRequest.getEmerStatus());
            ebikeChargeDeviceExtparamDo.setChargedeviceId(chargedeviceId);
            ebikeChargeDeviceExtparamDo.setEmerRemover(disasterSetUpRequest.getEmerRemover());
            ebikeChargeDeviceExtparamDo.setEmerStatus("00");
            ebikeChargeDeviceExtparamDo.setEmerRemoveTime(new Date());
            ebikeChargeDeviceExtparamDo.setEmerRemoveDesc(disasterSetUpRequest.getEmerRemoveDesc());
            this.ebikeChargeDeviceExtparamDao.update(ebikeChargeDeviceExtparamDo);
        }
        return result;
    }

    public int getChangeOrderCount(String stationId) {
        return this.disasterPreventionDao.getChangeOrderCount(stationId);
    }

    public int getCheckCode(String codeValue, String userMobile) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getcodeValueService : " + codeValue);
            this.logger.debug("getCheckCodeService : " + userMobile);
        }
        return this.disasterPreventionDao.getCheckCode(codeValue, userMobile);
    }

    public int updateCodeStatus(String codeValue) {
        return this.disasterPreventionDao.updateCodeStatus(codeValue);
    }

    public int insertSms(Map<String, String> map) {
        return this.disasterPreventionDao.insertSms(map);
    }

    public Map<String, Object> getUserMobileByUserNo(String userNo) {
        return this.disasterPreventionDao.getUserMobileByUserNo(userNo);
    }

    public List<Map<String, Object>> getProvinceList() {
        return this.disasterPreventionDao.getProvinceList();
    }

    public List<Map<String, Object>> getCityList(String level, String parentid) {
        return this.disasterPreventionDao.getCityList(level, parentid);
    }

    public List<Map<String, Object>> getDistrictList(String level, String parentid) {
        return this.disasterPreventionDao.getDistrictList(level, parentid);
    }
}

