/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.oprmgmt.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.easesource.commons.util.DateUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.ebike.openservices.base.service.AbstractEbikeBaseService;
import com.ebike.openservices.oprmgmt.dao.EbikeMainDao;
import com.ebike.openservices.oprmgmt.entity.ModalVo;
import com.ebike.openservices.oprmgmt.entity.StatPowerOrgDayVo;
import com.ebike.openservices.oprmgmt.entity.StatPowerOrgMonthVo;
import com.ebike.openservices.oprmgmt.entity.StatPowerOrgYear;
import com.ebike.openservices.oprmgmt.entity.vo.EbikeMainChargingPileInfoVo;
import com.ebike.openservices.oprmgmt.entity.vo.EbikeMainOrderInfoVo;
import com.ebike.openservices.oprmgmt.service.EbikeMainService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EbikeMainServiceImpl
extends AbstractEbikeBaseService
implements EbikeMainService {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final EbikeMainDao ebikeMainDao;

    @Autowired
    public EbikeMainServiceImpl(EbikeMainDao ebikeMainDao) {
        this.ebikeMainDao = ebikeMainDao;
    }

    public List<Map<String, Object>> getDqcdjl(Map<String, Object> params) {
        return this.ebikeMainDao.getDqcdjl(params);
    }

    public Map<String, Object> getChargeOrderInfo(Map<String, Object> params) {
        HashMap result = Maps.newHashMap();
        Integer chargingCount = this.ebikeMainDao.getChargingCount(params);
        Integer chargingCarCount = this.ebikeMainDao.getChargingCarCount(params);
        Integer finishCount = this.ebikeMainDao.getFinishCount(params);
        Integer finishCarCount = this.ebikeMainDao.getFinishCarCount(params);
        List<EbikeMainOrderInfoVo> dqcdjl2 = this.ebikeMainDao.getDqcdjl2(params);
        result.put("chargingCount", chargingCount);
        result.put("chargingCarCount", chargingCarCount);
        result.put("finishCount", finishCount);
        result.put("finishCarCount", finishCarCount);
        result.put("list", dqcdjl2);
        return result;
    }

    public Map<String, Object> getZs(Map<String, Object> params) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getZs : ", this.ebikeMainDao.getZs(params));
        }
        return this.ebikeMainDao.getZs(params);
    }

    public List<Map<String, Object>> getYs(Map<String, Object> params) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getYs : ", this.ebikeMainDao.getYs(params));
        }
        return this.ebikeMainDao.getYs(params);
    }

    public Map<String, String> getQgCdzb(Map<String, Object> m) {
        HashMap re = Maps.newHashMap();
        List<Map<String, String>> zblist = this.ebikeMainDao.getQgCdzb(m);
        if (zblist.size() != 0) {
            for (Map<String, String> zb : zblist) {
                re.put(zb.get("code"), zb.get("zbz"));
            }
        }
        return re;
    }

    public Map<String, Object> getCdqs(Map<String, Object> m, int[] x, String type) {
        int xnum;
        String dayF;
        HashMap reM = Maps.newHashMap();
        String year = DateConvertUtils.convertToString((Date)DateUtils.addDays((Date)new Date(), (int)-1), (String)"yyyy");
        m.put("year", year);
        List<Map<String, Object>> relist = this.ebikeMainDao.getCdqs(m);
        List<Map<String, Object>> relist1 = this.ebikeMainDao.getCdqsCar(m);
        Calendar cal = Calendar.getInstance();
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        String[] cdcs = new String[x.length];
        String[] cdys = new String[x.length];
        String[] cdcsCar = new String[x.length];
        String[] cdysCar = new String[x.length];
        for (int k = 0; k < cdcs.length; ++k) {
            if ("month".equals(type)) {
                if (k + 1 > day) {
                    cdcs[k] = "";
                    cdys[k] = "";
                    continue;
                }
                cdcs[k] = "0";
                cdys[k] = "0";
                continue;
            }
            if (k + 1 > month) {
                cdcs[k] = "";
                cdys[k] = "";
                continue;
            }
            cdcs[k] = "0";
            cdys[k] = "0";
        }
        block1: for (Map<String, Object> re : relist) {
            dayF = String.valueOf(re.get("dayF"));
            xnum = 0;
            xnum = "0".equals(dayF.substring(0, 1)) ? Integer.parseInt(dayF.substring(1, 2)) : Integer.parseInt(dayF);
            for (int xx : x) {
                if (xx != xnum) continue;
                cdcs[xx - 1] = re.get("cdcs") == null ? "0" : String.valueOf(re.get("cdcs"));
                if (re.get("cdsr") == null) {
                    cdys[xx - 1] = "0";
                    continue block1;
                }
                cdys[xx - 1] = re.get("cdsr").toString();
                continue block1;
            }
        }
        for (int k = 0; k < cdcsCar.length; ++k) {
            if ("month".equals(type)) {
                if (k + 1 > day) {
                    cdcsCar[k] = "";
                    cdysCar[k] = "";
                    continue;
                }
                cdcsCar[k] = "0";
                cdysCar[k] = "0";
                continue;
            }
            if (k + 1 > month) {
                cdcsCar[k] = "";
                cdysCar[k] = "";
                continue;
            }
            cdcsCar[k] = "0";
            cdysCar[k] = "0";
        }
        block4: for (Map<String, Object> re : relist1) {
            dayF = String.valueOf(re.get("dayF"));
            xnum = 0;
            xnum = "0".equals(dayF.substring(0, 1)) ? Integer.parseInt(dayF.substring(1, 2)) : Integer.parseInt(dayF);
            for (int xx : x) {
                if (xx != xnum) continue;
                cdcsCar[xx - 1] = re.get("cdcs") == null ? "0" : String.valueOf(re.get("cdcs"));
                if (re.get("cdsr") == null) {
                    cdysCar[xx - 1] = "0";
                    continue block4;
                }
                cdysCar[xx - 1] = re.get("cdsr").toString();
                continue block4;
            }
        }
        reM.put("cdcs", cdcs);
        reM.put("cdys", cdys);
        reM.put("cdcsCar", cdcsCar);
        reM.put("cdysCar", cdysCar);
        return reM;
    }

    public List<Map<String, Object>> getJkInfo(Map<String, Object> m) {
        return this.ebikeMainDao.getJkInfo(m);
    }

    public Map<String, Object> getDevInfo(Map<String, Object> m) {
        return this.ebikeMainDao.getDevInfo(m);
    }

    public List<Map<String, Object>> getPlugInfo(Map<String, Object> m) {
        return this.ebikeMainDao.getPlugInfo(m);
    }

    public List<Map<String, String>> getDqcdzList(Map<String, Object> m) {
        return this.ebikeMainDao.getDqcdzList(m);
    }

    public Map<String, String> getChargingRevenue(Map<String, Object> param) {
        HashMap re = Maps.newHashMap();
        List<Map<String, String>> zblist = this.ebikeMainDao.getChargingRevenue(param);
        if (zblist.size() != 0) {
            for (Map<String, String> zb : zblist) {
                re.put(zb.get("code"), zb.get("codeValue"));
            }
        }
        return re;
    }

    public List<ModalVo> getDeviceAbnormal(Map<String, Object> param) {
        return this.ebikeMainDao.getDeviceAbnormal(param);
    }

    public List<StatPowerOrgDayVo> getPowerOrgDay(Map<String, Object> param) {
        return this.ebikeMainDao.getPowerOrgDay(param);
    }

    public List<StatPowerOrgMonthVo> getPowerOrgMonth(Map<String, Object> param) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        Date y = c.getTime();
        String dataTime = format.format(y);
        return this.ebikeMainDao.getPowerOrgMonth(dataTime, (String)param.get("orgNo"));
    }

    public List<StatPowerOrgYear> getPowerOrg(Map<String, Object> param) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        Date y = c.getTime();
        String dataTime = format.format(y);
        return this.ebikeMainDao.getPowerOrg(dataTime, (String)param.get("orgNo"));
    }

    public List<StatPowerOrgDayVo> getPowerOrgDayVo(Map<String, Object> param) {
        return this.ebikeMainDao.getPowerOrgDayVo(param);
    }

    public List<StatPowerOrgMonthVo> getPowerOrgMonthVo(Map<String, Object> param) {
        return this.ebikeMainDao.getPowerOrgMonthVo(param);
    }

    public List<StatPowerOrgYear> getPowerOrgYear(Map<String, Object> param) {
        String dataTime = null;
        if (param.get("type").equals(1)) {
            Calendar date = Calendar.getInstance();
            dataTime = String.valueOf(date.get(1));
        } else {
            SimpleDateFormat format = new SimpleDateFormat("yyyy");
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            c.add(1, -1);
            Date y = c.getTime();
            dataTime = format.format(y);
        }
        return this.ebikeMainDao.getPowerOrgYear(dataTime, (String)param.get("orgNo"));
    }

    public Map<String, Object> getChargingPileInfo(String chargingPileNo) {
        HashMap result = Maps.newHashMap();
        EbikeMainChargingPileInfoVo chargingPileInfo = this.ebikeMainDao.getChargingPileInfo(chargingPileNo);
        if (ObjectUtil.isNotEmpty((Object)chargingPileInfo) && Objects.equals(chargingPileInfo.getPriceRateTypeNo(), 3)) {
            ArrayList timeList = Lists.newArrayList();
            JSONObject billingParamsJsonObject = JSONUtil.parseObj((String)chargingPileInfo.getBillingParams());
            ArrayList priceDetailList = Lists.newArrayList();
            for (int i = 1; i <= 10; ++i) {
                String startIndex = String.format("%02d", i);
                String endIndex = String.format("%02d", i + 1);
                BigDecimal priceRate = billingParamsJsonObject.getBigDecimal((Object)("price_rate" + startIndex));
                if (ObjectUtil.isNotEmpty((Object)priceRate)) {
                    priceDetailList.add(priceRate);
                }
                String startTime = billingParamsJsonObject.getStr((Object)("start_value_rate_period" + startIndex));
                String endTime = billingParamsJsonObject.getStr((Object)("start_value_rate_period" + endIndex));
                if (!StringUtils.isNotBlank((CharSequence)endTime)) {
                    timeList.add(startTime + "-23:59");
                    break;
                }
                timeList.add(startTime + "-" + endTime);
            }
            chargingPileInfo.setTimeList((List)timeList);
            chargingPileInfo.setPriceRateList((List)priceDetailList);
        }
        List<EbikeMainChargingPileInfoVo> chargingGunList = null;
        if (ObjectUtil.isNotEmpty((Object)chargingPileInfo)) {
            chargingGunList = this.ebikeMainDao.getChargingGunList(chargingPileInfo.getChargingPileId());
        }
        result.put("chargingPileInfo", chargingPileInfo);
        result.put("chargingGunList", chargingGunList);
        return result;
    }
}

