/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.oprmgmt.service.impl;

import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.ebike.openservices.oprmgmt.dao.EbikeChargeDeviceExtparamDao;
import com.ebike.openservices.oprmgmt.dao.PanelLightControlDao;
import com.ebike.openservices.oprmgmt.entity.EbikeChargeDeviceExtparamDo;
import com.ebike.openservices.oprmgmt.entity.PanelLightControlVo;
import com.ebike.openservices.oprmgmt.request.PanelLightUpdateDateByIdRequest;
import com.ebike.openservices.oprmgmt.service.PanelLightControlService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PanelLightControlServiceImpl
implements PanelLightControlService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PanelLightControlDao panelLightControlDao;
    private final EbikeChargeDeviceExtparamDao ebikeChargeDeviceExtparamDao;

    public PanelLightControlServiceImpl(PanelLightControlDao panelLightControlDao, EbikeChargeDeviceExtparamDao ebikeChargeDeviceExtparamDao) {
        this.panelLightControlDao = panelLightControlDao;
        this.ebikeChargeDeviceExtparamDao = ebikeChargeDeviceExtparamDao;
    }

    public List<PanelLightControlVo> getPanelLightControlList(Map params, Sorter sorter, Pager pager) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("params00P : " + params);
        }
        return this.panelLightControlDao.getList(params, sorter, pager);
    }

    public int getPanelLightControlCount(Map params) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("params01P : " + params);
        }
        return this.panelLightControlDao.getCount(params);
    }

    public List<Map<String, Object>> getProvinceList() {
        return this.panelLightControlDao.getProvinceList();
    }

    public List<Map<String, Object>> getCityList(String level, String parentid) {
        return this.panelLightControlDao.getCityList(level, parentid);
    }

    public List<Map<String, Object>> getDistrictList(String level, String parentid) {
        return this.panelLightControlDao.getDistrictList(level, parentid);
    }

    public int updateDateById(List<PanelLightUpdateDateByIdRequest> dateByIdRequestList) {
        int result = 0;
        for (PanelLightUpdateDateByIdRequest dateByIdRequest : dateByIdRequestList) {
            Long chargedeviceId = Long.parseLong(dateByIdRequest.getChargedeviceId());
            EbikeChargeDeviceExtparamDo ebikeChargeDeviceExtparamDo = (EbikeChargeDeviceExtparamDo)this.ebikeChargeDeviceExtparamDao.get(chargedeviceId);
            if (ebikeChargeDeviceExtparamDo != null && ebikeChargeDeviceExtparamDo.getChargedeviceId() > 0L) {
                ebikeChargeDeviceExtparamDo.setChargedeviceId(chargedeviceId);
                ebikeChargeDeviceExtparamDo.setLampOpenTimemark(dateByIdRequest.getLampOpenTimemark());
                ebikeChargeDeviceExtparamDo.setLampCloseTimemark(dateByIdRequest.getLampCloseTimemark());
                this.ebikeChargeDeviceExtparamDao.update(ebikeChargeDeviceExtparamDo);
            } else {
                ebikeChargeDeviceExtparamDo = new EbikeChargeDeviceExtparamDo();
                ebikeChargeDeviceExtparamDo.setChargedeviceId(chargedeviceId);
                ebikeChargeDeviceExtparamDo.setLampOpenTimemark(dateByIdRequest.getLampOpenTimemark());
                ebikeChargeDeviceExtparamDo.setLampCloseTimemark(dateByIdRequest.getLampCloseTimemark());
                ebikeChargeDeviceExtparamDo.setEmerStatus("00");
                ebikeChargeDeviceExtparamDo.setLampStatus("00");
                this.ebikeChargeDeviceExtparamDao.insert(ebikeChargeDeviceExtparamDo);
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("ebikeChargeDeviceExtparamDo : " + ebikeChargeDeviceExtparamDo);
            this.logger.debug("result : " + result);
        }
        return result;
    }
}

