/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.oprmgmt.service.impl;

import cn.hutool.core.lang.tree.TreeNode;
import cn.hutool.core.lang.tree.TreeUtil;
import com.easesource.data.bean.Pager;
import com.ebike.openservices.base.service.AbstractEbikeBaseService;
import com.ebike.openservices.oprmgmt.dao.OperEvChargingStationBillingInfoLogDao;
import com.ebike.openservices.oprmgmt.dao.PowerStationSafeguardDao;
import com.ebike.openservices.oprmgmt.dto.PageResponse;
import com.ebike.openservices.oprmgmt.entity.po.OperEvChargingStation;
import com.ebike.openservices.oprmgmt.entity.po.OperEvChargingStationBillingInfo;
import com.ebike.openservices.oprmgmt.entity.po.OperEvChargingStationBillingInfoLog;
import com.ebike.openservices.oprmgmt.entity.vo.DetailPowerStationSafeguardChargingGunVO;
import com.ebike.openservices.oprmgmt.entity.vo.DetailPowerStationSafeguardChargingPileVO;
import com.ebike.openservices.oprmgmt.entity.vo.DetailPowerStationSafeguardVO;
import com.ebike.openservices.oprmgmt.entity.vo.ListPowerStationSafeguardVO;
import com.ebike.openservices.oprmgmt.enums.ErrorCodeEnum;
import com.ebike.openservices.oprmgmt.enums.ICode;
import com.ebike.openservices.oprmgmt.exception.BizException;
import com.ebike.openservices.oprmgmt.request.InsertPowerStationParam;
import com.ebike.openservices.oprmgmt.request.ListPowerStationSafeguardParam;
import com.ebike.openservices.oprmgmt.request.UpdateChargingGunParam;
import com.ebike.openservices.oprmgmt.request.UpdateChargingPileParam;
import com.ebike.openservices.oprmgmt.request.UpdatePowerStationParam;
import com.ebike.openservices.oprmgmt.service.PowerStationSafeguardService;
import com.ebike.openservices.oprmgmt.util.ConvertUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PowerStationSafeguardServiceImpl
extends AbstractEbikeBaseService
implements PowerStationSafeguardService {
    private final PowerStationSafeguardDao powerStationSafeguardDao;
    private final OperEvChargingStationBillingInfoLogDao operEvChargingStationBillingInfoLogDao;

    @Autowired
    public PowerStationSafeguardServiceImpl(PowerStationSafeguardDao powerStationSafeguardDao, OperEvChargingStationBillingInfoLogDao operEvChargingStationBillingInfoLogDao) {
        this.powerStationSafeguardDao = powerStationSafeguardDao;
        this.operEvChargingStationBillingInfoLogDao = operEvChargingStationBillingInfoLogDao;
    }

    public PageResponse<ListPowerStationSafeguardVO> listPowerStationSafeguard(ListPowerStationSafeguardParam param, Pager pager) {
        List<ListPowerStationSafeguardVO> list = this.powerStationSafeguardDao.listPowerStationSafeguard(param, pager);
        long total = this.powerStationSafeguardDao.listPowerStationSafeguardTotal(param);
        return PageResponse.of(list, (int)pager.getPageNumber(), (int)pager.getPageSize(), (long)total);
    }

    @Transactional(rollbackFor={Exception.class})
    public int insertPowerStation(InsertPowerStationParam param) {
        OperEvChargingStation po = ConvertUtils.convert(param, OperEvChargingStation.class);
        po.setId(Long.valueOf(this.idGenerator.nextId())).setChargingStationDesc(param.getChargingStationName()).setSortSn(Integer.valueOf(1)).setGmtCreate(Long.valueOf(System.currentTimeMillis())).setParkingUnitPrice(BigDecimal.ZERO).setVersion(Integer.valueOf(1)).setPrimaryOrgNo(param.getOrgNo());
        ConvertUtils.toEmptyDefaultValue(po);
        int count = this.powerStationSafeguardDao.insertOperEvChargingStation(po);
        if (count > 0) {
            OperEvChargingStationBillingInfo o = new OperEvChargingStationBillingInfo();
            o.setId(Long.valueOf(this.idGenerator.nextId())).setPrimaryOrgNo(param.getOrgNo()).setOrgNo(param.getOrgNo()).setChargingStationId(po.getId()).setStationBillingType(Integer.valueOf(1)).setStationBillingStatus(Integer.valueOf(1)).setBillingTmplId(param.getBillingTmplId()).setSortSn(Integer.valueOf(1)).setGmtCreate(Long.valueOf(System.currentTimeMillis())).setVersion(Integer.valueOf(1));
            ConvertUtils.toEmptyDefaultValue(o);
            count = this.powerStationSafeguardDao.insertOperEvChargingStationBillingInfo(o);
            OperEvChargingStationBillingInfoLog log = OperEvChargingStationBillingInfoLog.builder().id(Long.valueOf(this.idGenerator.nextId())).primaryOrgNo(param.getOrgNo()).orgNo(param.getOrgNo()).stationBillingInfoId(o.getId()).logType(Integer.valueOf(10)).logValue("").stationBillingStatus(Integer.valueOf(1)).creator(param.getCreator()).build().defaultField();
            this.operEvChargingStationBillingInfoLogDao.insert(log);
        }
        return count;
    }

    public int updateChargingPile(UpdateChargingPileParam param) {
        return this.powerStationSafeguardDao.updateChargingPile(param);
    }

    public int updateChargingGun(UpdateChargingGunParam param) {
        return this.powerStationSafeguardDao.updateChargingGun(param);
    }

    public DetailPowerStationSafeguardVO getDetailPowerStationSafeguardById(Long id) {
        return this.powerStationSafeguardDao.getDetailPowerStationSafeguardById(id);
    }

    public DetailPowerStationSafeguardChargingPileVO getPowerStationSafeguardChargingPileById(Long id) {
        return this.powerStationSafeguardDao.getPowerStationSafeguardChargingPileById(id);
    }

    public DetailPowerStationSafeguardChargingGunVO getPowerStationSafeguardChargingGunById(Long id) {
        return this.powerStationSafeguardDao.getPowerStationSafeguardChargingGunById(id);
    }

    public void deletePowerStationById(Long id) {
        long pileTotal = this.powerStationSafeguardDao.countChargingPileByStationId(id);
        if (pileTotal > 0L) {
            throw new BizException((ICode)ErrorCodeEnum.POWER_STATION_CHARGING_PILE_ERROR);
        }
        long gunTotal = this.powerStationSafeguardDao.countChargingGunByStationId(id);
        if (gunTotal > 0L) {
            throw new BizException((ICode)ErrorCodeEnum.POWER_STATION_CHARGING_GUN_ERROR);
        }
        this.powerStationSafeguardDao.deletePowerStationById(id);
    }

    public String getPowerStationNo() {
        String no = this.powerStationSafeguardDao.getPowerStationNo();
        if (StringUtils.isBlank((CharSequence)no)) {
            return "100001";
        }
        Long noL = Long.valueOf(no);
        return String.valueOf(noL + 1L);
    }

    public int updatePowerStation(UpdatePowerStationParam param) {
        param.setGmtModified(Long.valueOf(System.currentTimeMillis()));
        return this.powerStationSafeguardDao.updateById(param);
    }

    public Object treePowerStation(String orgNo) {
        List<Map<String, String>> adCodeList = this.powerStationSafeguardDao.listAdCode();
        List codeNodeList = adCodeList.stream().map(map -> {
            TreeNode node = new TreeNode().setId(map.get("adcode")).setName((CharSequence)map.get("adname")).setParentId(map.get("parentAdcode"));
            return node;
        }).collect(Collectors.toList());
        List<Map<String, String>> stationList = this.powerStationSafeguardDao.listTreePowerStation(orgNo);
        List stationNodeList = stationList.stream().map(map -> {
            TreeNode node = new TreeNode().setId(map.get("id")).setName((CharSequence)map.get("chargingStationName")).setParentId(map.get("adcode"));
            return node;
        }).collect(Collectors.toList());
        codeNodeList.addAll(stationNodeList);
        List treeNodes = TreeUtil.build(codeNodeList, (Object)"100000");
        return treeNodes;
    }
}

