/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.oprmgmt.service.impl;

import com.easesource.data.bean.Pager;
import com.ebike.openservices.oprmgmt.dao.PowerStationDao;
import com.ebike.openservices.oprmgmt.entity.vo.ChargingGunInformationVo;
import com.ebike.openservices.oprmgmt.entity.vo.ChargingPileInformationVo;
import com.ebike.openservices.oprmgmt.entity.vo.ChargingPileVo;
import com.ebike.openservices.oprmgmt.entity.vo.PowerStationEssentialInformationVo;
import com.ebike.openservices.oprmgmt.entity.vo.PowerStationIncomeDistributionVo;
import com.ebike.openservices.oprmgmt.entity.vo.PowerStationVo;
import com.ebike.openservices.oprmgmt.request.PowerStationRequestParam;
import com.ebike.openservices.oprmgmt.service.PowerStationService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PowerStationServiceImpl
implements PowerStationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PowerStationServiceImpl.class);
    @Resource
    private PowerStationDao powerStationDao;

    public Map<String, Object> getPowerStation(PowerStationRequestParam param) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u7535\u7ad9\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)param);
        }
        Pager pager = new Pager();
        Integer current = param.getCurrent() == null ? 1 : param.getCurrent();
        pager.setPageNumber(current.intValue());
        Integer pageSize = param.getPageSize() == null ? 10 : param.getPageSize();
        pager.setPageSize(pageSize.intValue());
        List<PowerStationVo> list = this.powerStationDao.getPowerStation(param, pager);
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                list.get(i).setType(Integer.valueOf(1));
                List chargPiles = list.get(i).getChargingPileVos();
                if (chargPiles.size() > 0) {
                    for (int j = 0; j < chargPiles.size(); ++j) {
                        ((ChargingPileVo)chargPiles.get(j)).setType(Integer.valueOf(2));
                    }
                }
                Integer chargingPileNum = this.powerStationDao.getChargingPileTotal(list.get(i).getId());
                list.get(i).setChargingNum(chargingPileNum);
            }
        }
        Integer total = this.powerStationDao.getPowerStationTotal(param);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("list", list);
        map.put("total", total);
        return map;
    }

    public Map<String, Object> getPowerStationEssentialInformation(Long id, Integer current) {
        Pager pager = new Pager();
        pager.setPageNumber(current.intValue());
        pager.setPageSize(10);
        List<PowerStationEssentialInformationVo> essentialInformationVos = this.powerStationDao.getPowerStationEssentialInformation(id, pager);
        Integer total = this.powerStationDao.getPowerStationEssentialInformationToTal(id);
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("essentialInformationVos", essentialInformationVos);
        map.put("total", total);
        return map;
    }

    public Map<String, Object> getPowerStationIncomeDistribution(Long id, Integer current) {
        Pager pager = new Pager();
        pager.setPageNumber(current.intValue());
        pager.setPageSize(10);
        List<PowerStationIncomeDistributionVo> distributionVos = this.powerStationDao.getPowerStationIncomeDistribution(id, pager);
        Integer total = this.powerStationDao.getPowerStationIncomeDistributionTotal(id);
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        if (null == distributionVos) {
            map.put("msg", "\u6682\u65e0\u4fe1\u606f");
        } else {
            map.put("distributionVos", distributionVos);
            map.put("total", total);
        }
        return map;
    }

    public List<ChargingPileInformationVo> getChargingPileInformation(Long id) {
        return this.powerStationDao.getChargingPileInformation(id);
    }

    public List<ChargingGunInformationVo> getChargingGunInformation(Long id) {
        return this.powerStationDao.getChargingGunInformation(id);
    }
}

