/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.oprmgmt.service.impl;

import cn.hutool.core.lang.Dict;
import cn.hutool.core.util.ObjectUtil;
import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.easesource.data.id.generator.IdGenerator;
import com.ebike.openservices.oprmgmt.dao.RechargeCardsDao;
import com.ebike.openservices.oprmgmt.entity.po.CardCustomPurchaseApplyRelacs;
import com.ebike.openservices.oprmgmt.entity.vo.RechargeCardVo;
import com.ebike.openservices.oprmgmt.entity.vo.RefundRecordVo;
import com.ebike.openservices.oprmgmt.entity.vo.StationVo;
import com.ebike.openservices.oprmgmt.request.RechargeCardRequest;
import com.ebike.openservices.oprmgmt.service.RechargeCardsService;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RechargeCardsServiceImpl
implements RechargeCardsService {
    @Resource
    private RechargeCardsDao rechargeCardsDao;
    @Resource
    private IdGenerator idGenerator;

    public Map<String, Object> listRechargeCardVo(RechargeCardRequest request) {
        String orgNo = request.getOrgNo();
        BigDecimal totalAccountBalance = new BigDecimal(0);
        BigDecimal totalInAmount = new BigDecimal(0);
        RechargeCardVo rechargeCardVo = this.rechargeCardsDao.getBalance(orgNo);
        RechargeCardVo rechargeCardVov = this.rechargeCardsDao.getIncome(orgNo);
        if (ObjectUtil.isNotEmpty((Object)rechargeCardVo) && ObjectUtil.isNotEmpty((Object)rechargeCardVo.getTotalAccountBalance())) {
            totalAccountBalance = rechargeCardVo.getTotalAccountBalance();
        }
        if (ObjectUtil.isNotEmpty((Object)rechargeCardVov) && ObjectUtil.isNotEmpty((Object)rechargeCardVov.getTotalInAmount())) {
            totalInAmount = rechargeCardVov.getTotalInAmount();
        }
        Sorter sorter = new Sorter();
        Pager pager = new Pager();
        pager.setPageNumber(request.getCurrent());
        pager.setPageSize(10);
        List<RechargeCardVo> rechargeCardVos = this.rechargeCardsDao.listRechargeCardVo(request, sorter, pager);
        Integer totalPage = this.rechargeCardsDao.getTotalPage(request);
        rechargeCardVos.forEach(rechargeCardVo1 -> {
            if (ObjectUtil.isNotEmpty((Object)rechargeCardVo1.getStatus()) && rechargeCardVo1.getStatus() == 0) {
                rechargeCardVo1.setBindTime(null);
                rechargeCardVo1.setPhoneNo(null);
            }
        });
        Dict map = Dict.create().set("rechargeCardVos", rechargeCardVos).set("totalAccountBalance", (Object)totalAccountBalance).set("totalInAmount", (Object)totalInAmount).set("totalPage", (Object)totalPage);
        return map;
    }

    public Map<String, Object> listRechargeCardOrder(String batch, String phoneNo, String orgNo, Integer current) {
        Sorter sorter = new Sorter();
        Pager pager = new Pager();
        pager.setPageNumber(current.intValue());
        pager.setPageSize(10);
        List<RechargeCardVo> rechargeCardOrders = this.rechargeCardsDao.listRechargeCardOrder(batch, phoneNo, orgNo, sorter, pager);
        Integer totalPage = this.rechargeCardsDao.getOrderTotalPage(batch, phoneNo, orgNo);
        Dict map = Dict.create().set("rechargeCardOrders", rechargeCardOrders).set("totalPage", (Object)totalPage);
        return map;
    }

    public Map<String, Object> listStation(Long id, String orgNo, String stationName, String stationAddr, String type) {
        List<StationVo> stationVos = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (type.equals("1")) {
            stationVos = this.rechargeCardsDao.listStationAssociated(id, stationName, stationAddr);
            map.put("stationVos", stationVos);
        } else if (type.equals("2")) {
            stationVos = this.rechargeCardsDao.listStation(orgNo, stationName, stationAddr);
            map.put("stationVos", stationVos);
        }
        return map;
    }

    public Integer removeAssociated(Long id, String stationIdStr) {
        Integer num = null;
        String[] stationIds = stationIdStr.split(",");
        for (int i = 0; i < stationIds.length; ++i) {
            Long stationId = Long.parseLong(stationIds[i]);
            num = this.rechargeCardsDao.removeAssociated(id, stationId);
        }
        return num;
    }

    public Integer createAssociated(Long purchaseApplyId, String stationIdStr, String orgNo) {
        Integer num = null;
        String[] stationIds = stationIdStr.split(",");
        for (int i = 0; i < stationIds.length; ++i) {
            Long stationId = Long.parseLong(stationIds[i]);
            CardCustomPurchaseApplyRelacs customPurchaseApplyRelacs = CardCustomPurchaseApplyRelacs.builder().id(Long.valueOf(this.idGenerator.nextId())).primaryOrgNo(orgNo).purchaseApplyId(purchaseApplyId).orgNo(orgNo).chargeStationId(stationId).gmtCreate(Long.valueOf(System.currentTimeMillis())).build();
            num = this.rechargeCardsDao.createAssociated(customPurchaseApplyRelacs);
        }
        return num;
    }

    public Map<String, Object> getRefundRecord(String id, Integer current, String startDate, String endDate) {
        Sorter sorter = new Sorter();
        Pager pager = new Pager();
        pager.setPageNumber(current.intValue());
        pager.setPageSize(10);
        List<RefundRecordVo> refundRecordVos = this.rechargeCardsDao.getRefundRecord(id, startDate, endDate, sorter, pager);
        Integer totalPage = this.rechargeCardsDao.getRefundTotalPage(id, startDate, endDate);
        Dict map = Dict.create().set("refundRecordVos", refundRecordVos).set("totalPage", (Object)totalPage);
        return map;
    }
}

