/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.oprmgmt.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.ebike.openservices.base.service.AbstractEbikeBaseService;
import com.ebike.openservices.oprmgmt.dao.TmplBillingDao;
import com.ebike.openservices.oprmgmt.entity.TmplBillingDo;
import com.ebike.openservices.oprmgmt.enums.ErrorCodeEnum;
import com.ebike.openservices.oprmgmt.enums.ICode;
import com.ebike.openservices.oprmgmt.exception.BizException;
import com.ebike.openservices.oprmgmt.request.TmplBillingRequest;
import com.ebike.openservices.oprmgmt.service.TmplBillingService;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class TmplBillingServiceImpl
extends AbstractEbikeBaseService
implements TmplBillingService {
    @Resource
    private TmplBillingDao tmplBillingDao;

    public List<TmplBillingDo> getTmplBillingDoList(TmplBillingRequest params, Sorter sorter, Pager pager) {
        List<TmplBillingDo> list = this.tmplBillingDao.getTmplBillingDoList(params, sorter, pager);
        for (TmplBillingDo tmplBillingDo : list) {
            Long gmtCreate = tmplBillingDo.getGmtCreate();
            String gmtCreateTime = DateUtil.format((Date)new Date(gmtCreate), (String)"yyyy-MM-dd HH:mm");
            tmplBillingDo.setGmtCreateTime(gmtCreateTime);
        }
        return list;
    }

    public Integer getTmplBillingDoCount(TmplBillingRequest params) {
        return this.tmplBillingDao.getTmplBillingDoCount(params);
    }

    public void insertTmplBilling(TmplBillingRequest params) {
        long id = this.idGenerator.nextId();
        params.setId(Long.valueOf(id));
        params.setTmplDesc("\u6a21\u677f\u8bf4\u660e");
        params.setBillingClass(Integer.valueOf(2));
        params.setBillingSubclass(Integer.valueOf(2));
        HashMap json = Maps.newHashMap();
        if ("single".equals(params.getPriceRateType())) {
            json.put("price_rate_type", "single");
            json.put("price_total", params.getPriceTotal());
        } else if ("deviceMulti".equals(params.getPriceRateType())) {
            json.put("price_rate_type", "multi");
            json.put("rate_count", 4);
            json.put("rate_period_type", 1);
            json.put("price_rate01", params.getPriceRate01());
            json.put("price_rate02", params.getPriceRate02());
            json.put("price_rate03", params.getPriceRate03());
            json.put("price_rate04", params.getPriceRate04());
            json.put("price_service", params.getPriceService());
        } else if ("multi".equals(params.getPriceRateType())) {
            json.put("price_rate_type", "multi");
            json.put("rate_count", params.getRateCount());
            json.put("rate_period_type", 2);
            if (StrUtil.isNotBlank((CharSequence)params.getStartValueRatePeriod01())) {
                json.put("start_value_rate_period01", params.getStartValueRatePeriod01());
            }
            if (StrUtil.isNotBlank((CharSequence)params.getPriceRate01())) {
                json.put("price_rate01", params.getPriceRate01());
                json.put("number_rate_period01", 1);
            }
            if (StrUtil.isNotBlank((CharSequence)params.getStartValueRatePeriod02())) {
                json.put("start_value_rate_period02", params.getStartValueRatePeriod02());
            }
            if (StrUtil.isNotBlank((CharSequence)params.getPriceRate02())) {
                json.put("price_rate02", params.getPriceRate02());
                json.put("number_rate_period02", 2);
            }
            if (StrUtil.isNotBlank((CharSequence)params.getStartValueRatePeriod03())) {
                json.put("start_value_rate_period03", params.getStartValueRatePeriod03());
            }
            if (StrUtil.isNotBlank((CharSequence)params.getPriceRate03())) {
                json.put("price_rate03", params.getPriceRate03());
                json.put("number_rate_period03", 3);
            }
            if (StrUtil.isNotBlank((CharSequence)params.getStartValueRatePeriod04())) {
                json.put("start_value_rate_period04", params.getStartValueRatePeriod04());
            }
            if (StrUtil.isNotBlank((CharSequence)params.getPriceRate04())) {
                json.put("price_rate04", params.getPriceRate04());
                json.put("number_rate_period04", 4);
            }
            if (StrUtil.isNotBlank((CharSequence)params.getStartValueRatePeriod05())) {
                json.put("start_value_rate_period05", params.getStartValueRatePeriod05());
            }
            if (StrUtil.isNotBlank((CharSequence)params.getPriceRate05())) {
                json.put("price_rate05", params.getPriceRate05());
                json.put("number_rate_period05", 5);
            }
            if (StrUtil.isNotBlank((CharSequence)params.getStartValueRatePeriod06())) {
                json.put("start_value_rate_period06", params.getStartValueRatePeriod06());
            }
            if (StrUtil.isNotBlank((CharSequence)params.getPriceRate06())) {
                json.put("price_rate06", params.getPriceRate06());
                json.put("number_rate_period06", 6);
            }
            if (StrUtil.isNotBlank((CharSequence)params.getStartValueRatePeriod07())) {
                json.put("start_value_rate_period07", params.getStartValueRatePeriod07());
            }
            if (StrUtil.isNotBlank((CharSequence)params.getPriceRate07())) {
                json.put("price_rate07", params.getPriceRate07());
                json.put("number_rate_period07", 7);
            }
            if (StrUtil.isNotBlank((CharSequence)params.getStartValueRatePeriod08())) {
                json.put("start_value_rate_period08", params.getStartValueRatePeriod08());
            }
            if (StrUtil.isNotBlank((CharSequence)params.getPriceRate08())) {
                json.put("price_rate08", params.getPriceRate08());
                json.put("number_rate_period08", 8);
            }
            if (StrUtil.isNotBlank((CharSequence)params.getStartValueRatePeriod09())) {
                json.put("start_value_rate_period09", params.getStartValueRatePeriod09());
            }
            if (StrUtil.isNotBlank((CharSequence)params.getPriceRate09())) {
                json.put("price_rate09", params.getPriceRate09());
                json.put("number_rate_period09", 9);
            }
            if (StrUtil.isNotBlank((CharSequence)params.getStartValueRatePeriod10())) {
                json.put("start_value_rate_period10", params.getStartValueRatePeriod10());
            }
            if (StrUtil.isNotBlank((CharSequence)params.getPriceRate10())) {
                json.put("price_rate10", params.getPriceRate10());
                json.put("number_rate_period10", 10);
            }
            json.put("price_service", params.getPriceService());
        }
        JSONObject jso = new JSONObject((Object)json);
        params.setBillingParams(jso.toString());
        params.setBillingModel(params.getBillingModel());
        params.setBillingInterval(params.getBillingInterval());
        params.setSortSn(Integer.valueOf(1));
        params.setCreator(params.getCreator());
        if (params.getType() == 2) {
            params.setGmtCreate(Long.valueOf(System.currentTimeMillis()));
            params.setGmtModified(Long.valueOf(System.currentTimeMillis()));
            params.setGmtDeleted(Long.valueOf(System.currentTimeMillis()));
        } else {
            params.setGmtCreate(Long.valueOf(System.currentTimeMillis()));
            params.setGmtModified(Long.valueOf(0L));
            params.setGmtDeleted(Long.valueOf(0L));
        }
        params.setModifier(params.getModifier());
        params.setIsDeleted(Integer.valueOf(0));
        params.setDeleter(params.getDeleter());
        params.setVersion(Integer.valueOf(1));
        this.tmplBillingDao.insertTmplBilling(params);
    }

    public void updateTmplBilling(TmplBillingRequest params) {
        this.deleteTmplBilling(params);
        this.insertTmplBilling(params);
    }

    public void deleteTmplBilling(TmplBillingRequest params) {
        int countByTmplId = this.tmplBillingDao.getCountByTmplId(params.getId());
        if (countByTmplId > 0) {
            throw new BizException((ICode)ErrorCodeEnum.CHARGING_STATION_ASSOCIATION_ERROR);
        }
        this.tmplBillingDao.deleteTmplBilling(params);
    }

    public TmplBillingDo getMaxTmplNo() {
        String pre = "EVT";
        TmplBillingDo maxTmplNo = this.tmplBillingDao.getMaxTmplNo();
        if (maxTmplNo == null || StrUtil.isBlank((CharSequence)maxTmplNo.getTmplNo())) {
            maxTmplNo.setTmplNo(pre + "00001");
        } else {
            String tmplNo = maxTmplNo.getTmplNo();
            String format = String.format("%05d", Long.parseLong(StrUtil.removePrefix((CharSequence)tmplNo, (CharSequence)pre)) + 1L);
            maxTmplNo.setTmplNo(pre + format);
        }
        return maxTmplNo;
    }

    public String queryTmplInfoById(String tmplId) {
        return this.tmplBillingDao.selectTmplInfoById(tmplId);
    }
}

