/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.oprmgmt.util;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.BeanUtils;

public class ConvertUtils {
    public static <T> T convert(Object source, Class<T> target) {
        if (source == null) {
            return null;
        }
        T targetObject = null;
        try {
            targetObject = target.newInstance();
            BeanUtils.copyProperties((Object)source, targetObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return targetObject;
    }

    public static <T> List<T> convert(Collection<?> sourceList, Class<T> target) {
        if (sourceList == null) {
            return null;
        }
        ArrayList<T> targetList = new ArrayList<T>(sourceList.size());
        try {
            for (Object source : sourceList) {
                T targetObject = target.newInstance();
                BeanUtils.copyProperties(source, targetObject);
                targetList.add(targetObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return targetList;
    }

    public static Boolean toEmptyDefaultValue(Object object) {
        try {
            Field[] fields;
            for (Field field : fields = object.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                if (!ObjectUtils.isEmpty((Object)field.get(object))) continue;
                Class<?> type = field.getType();
                if (type == Integer.class) {
                    field.set(object, 0);
                    continue;
                }
                if (type == Long.class) {
                    field.set(object, 0L);
                    continue;
                }
                if (type == Float.class) {
                    field.set(object, 0);
                    continue;
                }
                if (type == Double.class) {
                    field.set(object, 0);
                    continue;
                }
                if (type == BigDecimal.class) {
                    field.set(object, BigDecimal.ZERO);
                    continue;
                }
                if (type != String.class) continue;
                field.set(object, "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

