package com.ebike.openservices.opsmgmt.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @param
 * @ClassName ChargingGunDetailsVo 充电枪详情
 * @Description TODO
 * @Author zhouyi
 * @Data 2021/4/16 18:47
 * @Version 1.0
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode()
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class ChargingGunDetailsVo implements Serializable {

    private static final long serialVersionUID = 1272477353197456553L;

    /**
     *电枪id
     */
    private Long id;


    /**
     *电站名称
     */
    private String chargingStationName;

    /**
     *充电桩编号
     */
    private String chargingPileNo;

    /**
     *充电枪编号
     */
    private String chargingGunNo;

    /**
     *充电电压
     */
    private BigDecimal rtEvcarOutputVoltage;

    /**
     *充电电流
     */
    private BigDecimal rtEvcarOutputCurrent;

    /**
     *充电功率
     */
    private BigDecimal rtEvcarOutputPower;

    /**
     *BMS需求电压
     */
     private BigDecimal rtEvcarBmsDemandVoltage;

    /**
     *BMS需求电流
     */
    private BigDecimal rtEvcarBmsDemandCurrent;


    /**
     *SOC
     */
    private BigDecimal rtEvcarSoc;

    /**
     *最近开始充电时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private String latestChargeOpenTime;

    /**
     *最近充电账号
     */
    private String chargeUserMobile;

    /**
     *最近充电VIN码
     */
    private String evcarVinCode;

    /**
     *累计充电电量
     */
    private BigDecimal chargeEconsTotalHisaccum;

    /**
     *累计充电时长
     */
    private Integer chargeDurationTimesHisaccum;

    /**
     *累计充电收入
     */
    private BigDecimal chargeIncomeHisaccum;

    /**
     *累计充电次数
     */
     private Integer chargeCountHisaccum;

    /**
     *工作状态
     */
    private String runStatusStr;

    /**
     *当前电能表值
     */
}
