package com.ebike.openservices.opsmgmt.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;

/**
 * @param
 * @ClassName EcarEquipmentConditionVo  设备工况实体
 * @Description TODO
 * @Author zhouyi
 * @Data 2021/4/16 14:11
 * @Version 1.0
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode()
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class EcarEquipmentConditionVo implements Serializable {

    private static final long serialVersionUID = -7706694769524445361L;

    /**
     * 电桩类型：自行车、汽车
     * 此属性为已知的固定值，方便前端处理
     */
    private String type;

    /**
     *主键id
     */
    private Long id;

    /**
     * 设备通讯标识
     */
    private String deviceId;

    /**
     *电桩id
     */
    private Long chargingPileId;

    /**
     * 电桩编号
     */
    private String chargingPileNo;

    /**
     *电桩类型
     */
    private String chargingPileTypeStr;

    /**
     *在线状态：0-离线；1-在线
     */
    private String runStatusStr;

    /**
     *电枪数量
     */
    private Integer installChargingGunCount;

    /**
     *电桩状态
     */
    private String chargingPileInstallStatusStr;

    /**
     *最近上送报文时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
     private String latestCommTime;

    /**
     *初次上送报文时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private String firstCommTime;


    /**
     *设备厂家
     */
    private String mfrCode;

    /**
     *电站名称
     */
     private String chargingStationName;

    /**
     *运营商名称
     */
    private String orgoprName;

    /**
     *装接时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private String installTime;

    /**
     *电站地址
     */
    private String ChargingStationAddr;
}
