package com.ebike.openservices.opsmgmt.request;

import lombok.*;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;

/**
 * @param
 * @ClassName EcarEquipmentConditionRequestParam  设备工况查询请求参数
 * @Description TODO
 * @Author zhouyi
 * @Data 2021/4/16 15:09
 * @Version 1.0
 **/
@Data
@Accessors(chain = true)
@EqualsAndHashCode()
@ToString(callSuper = true)
@AllArgsConstructor
@NoArgsConstructor
@SuperBuilder
public class EcarEquipmentConditionRequestParam implements Serializable {


    private static final long serialVersionUID = -6986448903252566871L;

    /**
     * 充电站大类：1-全部；2-自行车；3-汽车
     */
    private Integer type;

    /**
     * 是否分页：true-是；false-否（查询所有）
     */
    private boolean isAll;

    /**
     *电桩编号
     */
    private String chargingPileNo;


    /**
     *电站名称
     */
    private String chargingStationName;

    /**
     *设备厂家
     */
    private String mfrCode;

    /**
     *在线状态
     */
    private Integer runStatus;

    /**
     *电桩类型
     */
    private Integer chargingPileType;

    /**
     *电站地址
     */
    private String ChargingStationAddr;

    /**
     *运营商名称
     */
    private String orgoprName;

    /**
     *电桩状态  1 - 待装；2 - 待投；3 - 投运；4 - 故障；5 - 暂停；6 - 停运；7 - 拆除
     */
    private Integer chargingPileInstallStatus;

    /**
     *业务单位编号
     */
    private String orgNo;

    /**
     *当前页
     */
    private Integer current;

    /**
     * 页数据大小
     * 添加：liumu
     * 日期：2021-07-28
     */
    private Integer pageSize;


}
