package com.ebike.openservices.opsmgmt.service;

import com.ebike.openservices.opsmgmt.entity.vo.ChargingGunDetailsVo;
import com.ebike.openservices.opsmgmt.entity.vo.ChargingGunVo;
import com.ebike.openservices.opsmgmt.entity.vo.EcarEquipmentConditionVo;
import com.ebike.openservices.opsmgmt.request.EcarEquipmentConditionRequestParam;

import java.util.List;
import java.util.Map;

/**
 * @author zhouyi
 * @className EcarEquipmentConditionService
 * @data 2021/4/16 15:36
 **/
public interface EcarEquipmentConditionService {
    /**
     * 功能描述   设备工况查询
     * @author zhouyi
     * @return java.util.Map<java.lang.String,java.lang.Object>
     * @data 2021/4/16
     * @param param
     */
    Map<String,Object> getEcarEquipmentCondition(EcarEquipmentConditionRequestParam param);

    /**
     * 功能描述   设备工况excle导出
     * @author zhouyi
     * @return java.util.List<com.ebike.openservices.opsmgmt.entity.vo.EcarEquipmentConditionVo>
     * @data 2021/4/16
     * @param param
     */
    List<EcarEquipmentConditionVo> exportEcarEquipmentCondition(EcarEquipmentConditionRequestParam param);

    /**
     * 功能描述  设备工况——电枪详情
     * @author zhouyi
     * @return java.util.List<com.ebike.openservices.opsmgmt.entity.vo.ChargingGunDetailsVo>
     * @data 2021/4/22
     * @param id
     */
    List<ChargingGunDetailsVo> getChargingGunDetails(Long id);

    /**
     * 功能描述  设备工况—根据电桩id查询点状下的电枪信息
     * @author zhouyi
     * @return java.util.List<com.ebike.openservices.opsmgmt.entity.vo.ChargingGunVo>
     * @data 2021/4/22
     * @param id
     */
    Map<String,Object> getChargingGunList(Long id);
}
