/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.rcbmgmt.jdbcdao.Impl;

import com.easesource.commons.util.UuidUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.data.jdbc.SqlParamsBuilder;
import com.ebike.openservices.rcbmgmt.jdbcdao.EbikeEleIssueDao;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class EbikeEleIssueDaoImpl
implements EbikeEleIssueDao {
    @Qualifier(value="ebikeJdbcTemplate")
    private final JdbcTemplate ebikeJdbcTemplate;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    public EbikeEleIssueDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public List<Map<String, Object>> getStationInfo(String subburo, Map<String, String> maps) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select   a.STATIONNO,a.STATIONADDR,a.ID,b.`STATUS`,b.`NAME`,c.CHARGEDEVICENO  ");
            sql.append(" from cisp_dev.dev_ebikechargestation a LEFT JOIN cisp_dev.dev_powersystemresource b  on a.ID=b.ID ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID  where 1=1 and (b.`STATUS`='20' or b.`STATUS`='40')  ");
            sql.append(" and b.SUBBURO=? ", (Object)subburo);
            sql.append(" and a.STATIONNO like ? ", (Object)("%" + maps.get("stationNo") + "%"));
            sql.append(" and a.STATIONADDR like ? ", (Object)("%" + maps.get("stationAddr") + "%"));
            sql.append(" and b.STATUS=? ", (Object)maps.get("status"));
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("ID", rs.getLong("ID"));
                    map.put("stationNo", rs.getString("STATIONNO"));
                    map.put("name", rs.getString("NAME"));
                    map.put("stationAddr", rs.getString("STATIONADDR"));
                    map.put("status", rs.getString("STATUS"));
                    map.put("deviceNo", rs.getString("CHARGEDEVICENO"));
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int getStationCount(String subburo, Map<String, String> maps) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" SELECT COUNT(1) from cisp_dev.dev_ebikechargestation a LEFT JOIN cisp_dev.dev_powersystemresource b  on a.ID=b.ID ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID  where 1=1 and (b.`STATUS`='20' or b.`STATUS`='40')  ");
            sql.append(" and b.SUBBURO=? ", (Object)subburo);
            sql.append(" and a.STATIONNO like ? ", (Object)("%" + maps.get("stationNo") + "%"));
            sql.append(" and a.STATIONADDR like ? ", (Object)("%" + maps.get("stationAddr") + "%"));
            sql.append(" and b.STATUS=? ", (Object)maps.get("status"));
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public List<Map<String, Object>> getMeterIssueInfo(String subburo, Map<String, String> maps) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select a.billorder_id,a.start_date,a.end_date,a.ec_pos_active_total,a.eleccharge_value,a.issue_time,a.pay_flag,b.STATIONNO,b.STATIONADDR,c.`NAME`  ");
            sql.append(" from ebike.ebike_billorder_cs_eleccharge a left join  ");
            sql.append(" cisp_dev.dev_ebikechargestation b on a.chargestation_id=b.ID   ");
            sql.append(" left join cisp_dev.dev_powersystemresource c on c.ID=b.ID where 1=1 ");
            sql.append(" and c.SUBBURO=? ", (Object)subburo);
            sql.append(" and b.STATIONNO like ? ", (Object)("%" + maps.get("stationNo") + "%"));
            sql.append(" and b.STATIONADDR like ? ", (Object)("%" + maps.get("stationAddr") + "%"));
            sql.append(" and a.pay_flag=? ", (Object)maps.get("payType"));
            sql.append(" and a.issue_time >= STR_TO_DATE(?,'%Y-%m-%d') ", (Object)maps.get("startDay"));
            sql.append(" and a.issue_time <= STR_TO_DATE(?,'%Y-%m-%d') ", (Object)maps.get("endDay"));
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("billorder_id", rs.getString("billorder_id"));
                    map.put("stationNo", rs.getString("STATIONNO"));
                    map.put("name", rs.getString("NAME"));
                    map.put("stationAddr", rs.getString("STATIONADDR"));
                    map.put("start_date", rs.getTimestamp("start_date"));
                    map.put("end_date", rs.getTimestamp("end_date"));
                    map.put("ec_pos_active_total", rs.getBigDecimal("ec_pos_active_total"));
                    map.put("eleccharge_value", rs.getBigDecimal("eleccharge_value"));
                    map.put("issue_time", rs.getTimestamp("issue_time"));
                    map.put("pay_flag", rs.getString("pay_flag"));
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int getMeterIssueCount(String subburo, Map<String, String> maps) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" SELECT COUNT(1) from ebike.ebike_billorder_cs_eleccharge a left join  ");
            sql.append(" cisp_dev.dev_ebikechargestation b on a.chargestation_id=b.ID   ");
            sql.append(" left join cisp_dev.dev_powersystemresource c on c.ID=b.ID where 1=1 ");
            sql.append(" and c.SUBBURO=? ", (Object)subburo);
            sql.append(" and b.STATIONNO like ? ", (Object)("%" + maps.get("stationNo") + "%"));
            sql.append(" and b.STATIONADDR like ? ", (Object)("%" + maps.get("stationAddr") + "%"));
            sql.append(" and a.pay_flag=? ", (Object)maps.get("payType"));
            sql.append(" and a.issue_time >= STR_TO_DATE(?,'%Y-%m-%d') ", (Object)maps.get("startDay"));
            sql.append(" and a.issue_time <= STR_TO_DATE(?,'%Y-%m-%d') ", (Object)maps.get("endDay"));
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public Map<String, Object> getElectricityInfo(String stationId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List list = new ArrayList();
        HashMap<String, Object> maps = new HashMap<String, Object>();
        try {
            sql.append(" select DATE_ADD(end_date,INTERVAL 1 DAY) AS stat_date  from ebike.ebike_billorder_cs_eleccharge   ");
            sql.append(" union  select    ");
            sql.append(" MIN(stat_date) as stat_date   from ebike.stat_cs_eleccharge_day WHERE 1=1     ");
            sql.append(" and  chargestation_id= ? ", (Object)stationId);
            sql.append(" limit 1 ");
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("stat_date", DateConvertUtils.convertToString((Date)rs.getDate("stat_date"), (String)"yyyy-MM-dd"));
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return maps;
        }
        if (list.size() > 0 && list != null) {
            return (Map)list.get(0);
        }
        return maps;
    }

    @Override
    public Map<String, Object> getEleQutityOrCharge(String stationId, String startDay, String endDay) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List list = new ArrayList();
        HashMap<String, Object> maps = new HashMap<String, Object>();
        try {
            sql.append(" select sum(ec_pos_active_total) as ec_pos_active_total  ,sum(eleccharge_value) as eleccharge_value from ebike.stat_cs_eleccharge_day where 1=1    ");
            sql.append(stationId, (Object)" and  chargestation_id= ? ");
            sql.append(startDay, (Object)" and stat_date>=STR_TO_DATE(?,'%Y-%m-%d') ");
            sql.append(endDay, (Object)" and stat_date<=STR_TO_DATE(?,'%Y-%m-%d') ");
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("ec_pos_active_total", rs.getDouble("ec_pos_active_total"));
                    map.put("eleccharge_value", rs.getDouble("eleccharge_value"));
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return maps;
        }
        if (list.size() > 0 && list != null) {
            return (Map)list.get(0);
        }
        return maps;
    }

    @Override
    public boolean addEleIssue(Map<String, String> maps) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        String uuid = UuidUtils.generateUuidString();
        try {
            sql.append(" insert into ebike.ebike_billorder_cs_eleccharge(billorder_id,chargestation_id,start_date ");
            sql.append(" ,end_date,ec_pos_active_total,eleccharge_value,issue_flag,issue_time,issuer,pay_flag,pay_time,payer,create_time,update_time)");
            sql.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,? ) ");
            results = this.ebikeJdbcTemplate.update(sql.getSql(), new Object[]{uuid, maps.get("stationId"), maps.get("startDay"), maps.get("endDay"), maps.get("eleQuantity"), maps.get("MTotalElcCharge"), "Y", new Date(), maps.get("orgName"), "N", new Date(), maps.get("orgName"), new Date(), new Date()});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return results > 0;
    }

    @Override
    public Map<String, Object> ChargeBillDetail(String billorder_id) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List list = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            sql.append(" select a.billorder_id,a.start_date,a.end_date,a.ec_pos_active_total,a.eleccharge_value,a.issue_time,a.pay_flag,b.STATIONNO,b.STATIONADDR,c.`NAME` ,  ");
            sql.append(" a.pay_time,d.user_name as payer,a.pay_desc,a.pay_attach,e.user_name as issuer ");
            sql.append(" from ebike.ebike_billorder_cs_eleccharge a left join     ");
            sql.append(" cisp_dev.dev_ebikechargestation b on a.chargestation_id=b.ID   ");
            sql.append("  left join cisp_dev.dev_powersystemresource c on c.ID=b.ID  ");
            sql.append("  left join cisp_sys.bp_user d on a.payer=d.user_no   ");
            sql.append("  left join cisp_sys.bp_user e  on a.issuer=e.user_no where 1=1  ");
            sql.append(" and a.billorder_id=? ", (Object)billorder_id);
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("billorder_id", rs.getString("billorder_id"));
                    map.put("stationNo", rs.getString("STATIONNO"));
                    map.put("name", rs.getString("NAME"));
                    map.put("stationAddr", rs.getString("STATIONADDR"));
                    map.put("start_date", rs.getTimestamp("start_date"));
                    map.put("end_date", rs.getTimestamp("end_date"));
                    map.put("ec_pos_active_total", rs.getBigDecimal("ec_pos_active_total"));
                    map.put("eleccharge_value", rs.getBigDecimal("eleccharge_value"));
                    map.put("issue_time", DateConvertUtils.convertToString((Date)rs.getTimestamp("issue_time"), (String)"yyyy.MM.dd HH:mm:ss"));
                    map.put("pay_time", DateConvertUtils.convertToString((Date)rs.getTimestamp("pay_time"), (String)"yyyy.MM.dd HH:mm:ss"));
                    map.put("start_date", DateConvertUtils.convertToString((Date)rs.getTimestamp("start_date"), (String)"yyyy.MM.dd HH:mm:ss"));
                    map.put("end_date", DateConvertUtils.convertToString((Date)rs.getTimestamp("end_date"), (String)"yyyy.MM.dd HH:mm:ss"));
                    map.put("pay_flag", rs.getString("pay_flag"));
                    map.put("payer", rs.getString("payer"));
                    map.put("pay_desc", rs.getString("pay_desc"));
                    map.put("pay_attach", rs.getString("pay_attach"));
                    map.put("issuer", rs.getString("issuer"));
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return map;
        }
        if (list.size() > 0 && list != null) {
            return (Map)list.get(0);
        }
        return map;
    }

    @Override
    public boolean updateCharge(Map<String, String> maps) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        String uuid = UuidUtils.generateUuidString();
        try {
            sql.append(" update ebike.ebike_billorder_cs_eleccharge  set pay_flag='Y' ");
            sql.append(maps.get("attachment"), (Object)" ,pay_attach=? ");
            sql.append(" ,pay_time=? ", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy.MM.dd HH:mm:ss"));
            sql.append(" ,update_time=? ", (Object)DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy.MM.dd HH:mm:ss"));
            sql.append(" ,payer=? ", (Object)maps.get("orgName"));
            sql.append(" ,pay_desc=? ", (Object)maps.get("pay_Desc"));
            sql.append(" where 1=1 ");
            sql.append(" and billorder_id=? ", (Object)maps.get("billorder_id"));
            results = this.ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return results > 0;
    }

    @Override
    public List<Map<String, Object>> getStationDetail(String subburo, Map<String, String> maps) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select  a.chargestation_id,a.stat_date,a.ec_pos_active_total,a.cost_unit_price,a.eleccharge_value,b.STATIONNO,b.STATIONADDR,c.`NAME`  ");
            sql.append(" from  ebike.stat_cs_eleccharge_day a   ");
            sql.append(" left join cisp_dev.dev_ebikechargestation b on a.chargestation_id=b.ID   ");
            sql.append(" LEFT JOIN cisp_dev.dev_powersystemresource c on b.ID=c.ID where 1=1 ");
            sql.append(" and c.SUBBURO=? ", (Object)subburo);
            sql.append(" and b.STATIONNO like ? ", (Object)("%" + maps.get("stationNo") + "%"));
            sql.append(" and b.STATIONADDR like ? ", (Object)("%" + maps.get("stationAddr") + "%"));
            sql.append(" and a.stat_date >= STR_TO_DATE(?,'%Y-%m-%d') ", (Object)maps.get("startDay"));
            sql.append(" and a.stat_date <= STR_TO_DATE(?,'%Y-%m-%d') ", (Object)maps.get("endDay"));
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("chargestation_id", rs.getString("chargestation_id"));
                    map.put("ec_pos_active_total", rs.getDouble("ec_pos_active_total"));
                    map.put("cost_unit_price", rs.getDouble("cost_unit_price"));
                    map.put("eleccharge_value", rs.getDouble("eleccharge_value"));
                    map.put("stationAddr", rs.getString("STATIONADDR"));
                    map.put("stat_date", rs.getDate("stat_date"));
                    map.put("ec_pos_active_total", rs.getBigDecimal("ec_pos_active_total"));
                    map.put("eleccharge_value", rs.getBigDecimal("eleccharge_value"));
                    map.put("name", rs.getString("NAME"));
                    map.put("stationNo", rs.getString("STATIONNO"));
                    return map;
                }
            });
            this.logger.debug(">>>>>>>>>>>>>>>>getStationDetail<<<<<<<<<<<<<<<<<<<" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int getStationDetailCount(String subburo, Map<String, String> maps) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1)  from  ebike.stat_cs_eleccharge_day a   ");
            sql.append(" left join cisp_dev.dev_ebikechargestation b on a.chargestation_id=b.ID   ");
            sql.append(" LEFT JOIN cisp_dev.dev_powersystemresource c on b.ID=c.ID where 1=1 ");
            sql.append(" and c.SUBBURO=? ", (Object)subburo);
            sql.append(" and b.STATIONNO like ? ", (Object)("%" + maps.get("stationNo") + "%"));
            sql.append(" and b.STATIONADDR like ? ", (Object)("%" + maps.get("stationAddr") + "%"));
            sql.append(" and a.stat_date >= STR_TO_DATE(?,'%Y-%m-%d') ", (Object)maps.get("startDay"));
            sql.append(" and a.stat_date <= STR_TO_DATE(?,'%Y-%m-%d') ", (Object)maps.get("endDay"));
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public List<Map<String, Object>> getStationStatics(String subburo, Map<String, String> maps) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select  sum(a.ec_pos_active_total) as ec_pos_active_total,sum(a.eleccharge_value) as eleccharge_value ,b.STATIONNO,b.STATIONADDR,c.`NAME`  ");
            sql.append(" from  cisp_dev.dev_ebikechargestation b  ");
            sql.append(" left join ebike.stat_cs_eleccharge_day a on a.chargestation_id=b.ID   ");
            sql.append(" LEFT JOIN cisp_dev.dev_powersystemresource c on b.ID=c.ID where 1=1 ");
            sql.append(" and c.SUBBURO=? ", (Object)subburo);
            sql.append(" and b.STATIONNO like ? ", (Object)("%" + maps.get("stationNo") + "%"));
            sql.append(" and b.STATIONADDR like ? ", (Object)("%" + maps.get("stationAddr") + "%"));
            sql.append(" and a.stat_date >= STR_TO_DATE(?,'%Y-%m-%d') ", (Object)maps.get("startDay"));
            sql.append(" and a.stat_date <= STR_TO_DATE(?,'%Y-%m-%d') ", (Object)maps.get("endDay"));
            sql.append(" and c.status='20' group by b.ID ");
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("ec_pos_active_total", rs.getDouble("ec_pos_active_total"));
                    map.put("eleccharge_value", rs.getDouble("eleccharge_value"));
                    map.put("stationAddr", rs.getString("STATIONADDR"));
                    map.put("ec_pos_active_total", rs.getBigDecimal("ec_pos_active_total"));
                    map.put("eleccharge_value", rs.getBigDecimal("eleccharge_value"));
                    map.put("name", rs.getString("NAME"));
                    map.put("stationNo", rs.getString("STATIONNO"));
                    return map;
                }
            });
            this.logger.debug(">>>>>>>>>>>>>>>>getStationStatics<<<<<<<<<<<<<<<<<<<" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int getStationStaticsCount(String subburo, Map<String, String> maps) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append("  select count(1) from ( select count(1) from  cisp_dev.dev_ebikechargestation b  ");
            sql.append(" left join ebike.stat_cs_eleccharge_day a on a.chargestation_id=b.ID   ");
            sql.append(" LEFT JOIN cisp_dev.dev_powersystemresource c on b.ID=c.ID where 1=1 ");
            sql.append(" and c.SUBBURO=? ", (Object)subburo);
            sql.append(" and b.STATIONNO like ? ", (Object)("%" + maps.get("stationNo") + "%"));
            sql.append(" and b.STATIONADDR like ? ", (Object)("%" + maps.get("stationAddr") + "%"));
            sql.append(" and a.stat_date >= STR_TO_DATE(?,'%Y-%m-%d') ", (Object)maps.get("startDay"));
            sql.append(" and a.stat_date <= STR_TO_DATE(?,'%Y-%m-%d') ", (Object)maps.get("endDay"));
            sql.append(" and c.status='20' group by b.ID ) n  ");
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public List<Map<String, Object>> getAcquistionData(String subburo, Map<String, String> maps) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select a.meterdevice_id,a.meterdevice_no,a.comm_address,a.comm_protocol,a.run_status,b.cum_pos_active_total,IFNULL(d.chargedeviceNo ,'\u65e0') as chargedeviceNo   ");
            sql.append(" ,b.measdata_time from ebike.measdata_epower  b left join    ");
            sql.append(" ebike.ebike_measpoint_meterdevice c  on c.measpoint_id=b.measpoint_id  ");
            sql.append(" \t left join  ebike.ebike_assets_meterdevice  a  on a.meterdevice_id=c.meterdevice_id    ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice d  on c.chargedevice_id=d.ID where 1=1 ");
            sql.append(" and a.orgopr_no=? ", (Object)subburo);
            sql.append(" and a.run_status= ? ", (Object)maps.get("status"));
            sql.append(" and a.meterdevice_no like ? ", (Object)("%" + maps.get("meterdevice_no") + "%"));
            sql.append(" and b.measdata_time >= STR_TO_DATE(?,'%Y-%m-%d') ", (Object)maps.get("startDay"));
            sql.append(" and d.chargedeviceNo like ? ", (Object)("%" + maps.get("devNo") + "%"));
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("meterdevice_id", rs.getString("meterdevice_id"));
                    map.put("chargedeviceNo", rs.getString("chargedeviceNo"));
                    map.put("meterdevice_no", rs.getString("meterdevice_no"));
                    map.put("comm_address", rs.getString("comm_address"));
                    map.put("comm_protocol", rs.getString("comm_protocol"));
                    map.put("run_status", rs.getString("run_status"));
                    map.put("cum_pos_active_total", rs.getBigDecimal("cum_pos_active_total"));
                    map.put("measdata_time", DateConvertUtils.convertToString((Date)rs.getTimestamp("measdata_time"), (String)"yyyy.MM.dd HH:mm:ss"));
                    return map;
                }
            });
            this.logger.debug(">>>>>>>>><getAcquistionData<<<<<<<<<<<<<<<<" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int getAcquistionCount(String subburo, Map<String, String> maps) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebike.measdata_epower  b left join    ");
            sql.append(" ebike.ebike_measpoint_meterdevice c  on c.measpoint_id=b.measpoint_id  ");
            sql.append(" \t left join  ebike.ebike_assets_meterdevice  a  on a.meterdevice_id=c.meterdevice_id    ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice d  on c.chargedevice_id=d.ID where 1=1 ");
            sql.append(" and a.orgopr_no=? ", (Object)subburo);
            sql.append(" and a.run_status= ? ", (Object)maps.get("status"));
            sql.append(" and a.meterdevice_no like ? ", (Object)("%" + maps.get("meterdevice_no") + "%"));
            sql.append(" and b.measdata_time = STR_TO_DATE(?,'%Y-%m-%d') ", (Object)maps.get("startDay"));
            sql.append(" and d.chargedeviceNo like ? ", (Object)("%" + maps.get("devNo") + "%"));
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public List<Map<String, Object>> getMeterData(String subburo, Map<String, String> maps) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select a.meterdevice_id,a.meterdevice_no,a.comm_address,a.comm_protocol,a.run_status,IFNULL(d.chargedeviceNo ,'\u65e0') as chargedeviceNo    ");
            sql.append(" from ebike.ebike_assets_meterdevice  a      ");
            sql.append(" left join ebike_measpoint_meterdevice_his c on a.meterdevice_id=c.meterdevice_id   ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice d  on c.chargedevice_id=d.ID where 1=1    ");
            sql.append(" and a.orgopr_no=? ", (Object)subburo);
            sql.append(" and a.run_status= ? ", (Object)maps.get("status"));
            sql.append(" and a.meterdevice_no like ? ", (Object)("%" + maps.get("meterdevice_no") + "%"));
            sql.append(" and b.measdata_time >= STR_TO_DATE(?,'%Y-%m-%d') ", (Object)maps.get("startDay"));
            sql.append(" and d.chargedeviceNo like ? ", (Object)("%" + maps.get("devNo") + "%"));
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("meterdevice_id", rs.getString("meterdevice_id"));
                    map.put("chargedeviceNo", rs.getString("chargedeviceNo"));
                    map.put("meterdevice_no", rs.getString("meterdevice_no"));
                    map.put("comm_address", rs.getString("comm_address"));
                    map.put("comm_protocol", rs.getString("comm_protocol"));
                    map.put("run_status", rs.getString("run_status"));
                    return map;
                }
            });
            this.logger.debug(">>>>>>>>><getAcquistionData<<<<<<<<<<<<<<<<" + sql.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int getMeterCount(String subburo, Map<String, String> maps) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebike.ebike_assets_meterdevice  a      ");
            sql.append(" left join ebike.ebike_measpoint_meterdevice c on a.meterdevice_id=c.meterdevice_id   ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice d  on c.chargedevice_id=d.ID where 1=1    ");
            sql.append(" and a.orgopr_no=? ", (Object)subburo);
            sql.append(" and a.run_status= ? ", (Object)maps.get("status"));
            sql.append(" and a.meterdevice_no like ? ", (Object)("%" + maps.get("meterdevice_no") + "%"));
            sql.append(" and b.measdata_time >= STR_TO_DATE(?,'%Y-%m-%d') ", (Object)maps.get("startDay"));
            sql.append(" and d.chargedeviceNo like ? ", (Object)("%" + maps.get("devNo") + "%"));
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public List<Map<String, Object>> loadingDetailLog(String id) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select a.log_time,a.lif_estate_chgtype,e.USER_NAME,c.chargedeviceNo,d.stationNo,a.measdatas     ");
            sql.append(" from ebike.log_lifestate_meterdevice  a   left join   ");
            sql.append(" ebike.ebike_measpoint_meterdevice b on a.meterdevice_id=b.meterdevice_id  ");
            sql.append(" left join  cisp_dev.dev_ebikechargedevice c on b.chargedevice_id=c.ID    ");
            sql.append(" left join cisp_dev.dev_ebikechargestation  d  on c.chargestationid=d.ID ");
            sql.append(" left join cisp_sys.bp_user  e on a.operator=e.USER_NO  where 1=1 ");
            sql.append(" and a.meterdevice_id=? ", (Object)id);
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("USER_NAME", rs.getString("USER_NAME"));
                    map.put("chargedeviceNo", rs.getDouble("chargedeviceNo"));
                    map.put("stationNo", rs.getString("stationNo"));
                    map.put("lifestate_chgtype", rs.getString("lif_estate_chgtype"));
                    map.put("log_time", DateConvertUtils.convertToString((Date)rs.getTimestamp("log_time"), (String)"yyyy.MM.dd HH:mm:ss"));
                    Map m = (Map)JsonConvertUtils.convertFromString((String)rs.getString("measdatas"), Map.class);
                    map.put("measdatas", m.get("cum_pos_active_total"));
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int loadingDetailLogCount(String id) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebike.log_lifestate_meterdevice  a   left join   ");
            sql.append(" ebike.ebike_measpoint_meterdevice b on a.meterdevice_id=b.meterdevice_id  ");
            sql.append(" left join  cisp_dev.dev_ebikechargedevice c on b.chargedevice_id=c.ID    ");
            sql.append(" left join cisp_dev.dev_ebikechargestation  d  on c.chargestationid=d.ID ");
            sql.append(" left join cisp_sys.bp_user  e on a.operator=e.USER_NO  where 1=1 ");
            sql.append(" and a.meterdevice_id=? ", (Object)id);
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public List<Map<String, Object>> devInfoDetail(String id) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select a.fitconnectTime,a.fitconnectType,e.USER_NAME  from ebike.ebike_log_fitconndebugging a      ");
            sql.append(" left join cisp_sys.bp_user  e on a.operator=e.USER_NO  where 1=1   ");
            sql.append(" and a.chargedeviceId=? ", (Object)id);
            list = this.ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (RowMapper)new RowMapper<Map<String, Object>>(){

                public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("USER_NAME", rs.getString("USER_NAME"));
                    map.put("fitconnectTime", DateConvertUtils.convertToString((Date)rs.getTimestamp("fitconnectTime"), (String)"yyyy.MM.dd HH:mm:ss"));
                    if (rs.getString("fitconnectType").equals("fitconnect ")) {
                        map.put("fitconnectType", "\u88c5\u63a5");
                    } else {
                        map.put("fitconnectType", "\u62c6\u9664");
                    }
                    return map;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int devInfoDetailCount(String id) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1)  from ebike.ebike_log_fitconndebugging a      ");
            sql.append(" left join cisp_sys.bp_user  e on a.operator=e.USER_NO  where 1=1   ");
            sql.append(" and a.chargedeviceId=? ", (Object)id);
            return (Integer)this.ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }
}

