package com.ebike.openservices.simmanage.entity;

import lombok.Data;
import org.checkerframework.checker.formatter.qual.Format;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 物联卡资产
 **/
@Data
public class IotcardAssetsCardDo {


    /**
     * 充电设备大类：1-自行车；2-汽车
     */
    private Integer type;

    private Long id;
    /**
     * 系统单位编号
     */
    private String orgNo;
    /**
     * MSISDN;MSISDN：Mobile Station ISDN number 手机ISDN号码
     */
    private String msisdn;
    /**
     * ICCID;ICCID：Integrate circuit card identity 集成电路卡识别码（固化在手机SIM卡中）
     * ICCID为IC卡的唯一识别号码，共有20位数字组成，其编码格式为：XXXXXX 0MFSS YYGXX XXXXX。分别介绍如下： 前六位运营商代码：中国移动的为：898600；中国联通的为：898601。
     */
    private String iccid;
    /**
     * IMSI;国际移动用户识别码（IMSI：International Mobile Subscriber Identification Number）
     */
    private String imsi;
    /**
     * IMEI;IMEI（International Mobile Equipment Identity）是移动设备国际身份码的缩写，移动装备国际辨识码，是由15位数字组成的"电子串号"，它与每台手机一一对应，而且该码是全世界唯一的。
     */
    private String imei;
    /**
     * 物联卡所属公司;见编码IOTCARD_BELONG_COMPANY
     */
    private String cardBelongCompany;
    /**
     * 通信运营商编号
     */
    private String commOperatorNo;
    /**
     * 通信网络类型;GSM - ；
     * CDMA - ；
     * TD-LTE - ；
     * FDD-LTE - ；
     */
    private String commType;
    /**
     * 物联卡管理平台配置标识;无物联卡管理平台，则填0
     */
    private Long cardMgmtPlatformConfigId;
    /**
     * 物联卡状态;0 - 库存；1 - 待激活；2 - 正常；3 - 单向停机；4 - 停机；5 - 过户；6 - 休眠；8 - 预销号；9 - 销号；
     * 10 - 可测试；99 - 卡不存在；
     */
    private int cardStatus;
    /**
     * 购卡时间
     */
    private Date purchaseTime;
    /**
     * 激活时间
     */
    private Date activateTime;
    /**
     * 最近一次充值时间
     */
    private Date latestRechargeTime;
    /**
     * 最近一次充值金额
     */
    private BigDecimal latestRechargeMoney;
    /**
     * 最近一次充值时长;单位：月
     */
    private int latestRechargeDuration;
    /**
     * 下次到期时间
     */
    private Date nextDueTime;

    /**
    *  物联卡管理平台最后一次同步时间
    */
    private Date latestCardMgmtPlatformSyncTime;

    /**
     * 资费套餐标识
     */
    private Long pricingPackageId;
    /**
     * 资费套餐当期值;当资费套餐流量结算周期为 1 - 每月 时，格式为：YYYYMM；
     */
    private String pricingPackageCurrentPeriod;
    /**
     * 资费套餐当期总流量;单位：Kb
     */
    private BigDecimal pricingPackageCurrentTotalAmount;
    /**
     * 资费套餐当期使用量;单位：Kb
     */
    private BigDecimal pricingPackageCurrentUsageAmount;
    /**
     * 资费套餐当期剩余量;单位：Kb
     */
    private BigDecimal pricingPackageCurrentRemainAmount;
    /**
     * 物联卡资产绑定设备分类编号;EBIKECHARGEDEVICENO - 驿吧充电桩设备编号（二维码编号）
     */
    private String assetsCardBindDeviceSortNo;
    /**
     * 物联卡资产绑定设备标识号
     */
    private String assetsCardBindDeviceId;
    /**
     * 物联卡资产业务属性;{}
     */
    private String assetsCardProps;
    /**
     * 排序序号
     */
    private int sortSn;
    /**
     * 是否有效
     */
    private boolean isValid;
    /**
     * 创建人;系统用户表用户编号字段（user_no）
     */
    private String creator;
    /**
     * 创建时间;为0表示为空
     */
    private long gmtCreate;
    /**
     * 更新人;系统用户表用户编号字段（user_no）
     */
    private String modifier;
    /**
     * 更新时间;为0表示为空
     */
    private long gmtModified;
    /**
     * 失效人;系统用户表用户编号字段（user_no）
     */
    private String invalider;
    /**
     * 失效时间;为0表示为空
     */
    private long gmtInvalid;
    /**
     * 版本号;用于乐观锁
     */
    private int version;

    private String[] ids;

    private String startTime;
    private String endTime;

    /** 关联SIM 卡同步字段 */
    private int cardLifeState;

    private String orgNoEmp;

    private String deviceOrgName;

    private String buro;

}
