package com.ebike.openservices.simmanage.entity;

import lombok.Data;

import java.math.BigDecimal;

/** 物联卡资费套餐   */
@Data
public class IotcardPricingPackageDo {
    private Long id ;
    /** 物联卡管理平台配置标识 */
    private Long cardMgmtPlatformConfigId ;
    /** 资费套餐编号 */
    private String pricingPackageNo ;
    /** 资费套餐名称 */
    private String pricingPackageName ;
    /** 资费套餐说明 */
    private String pricingPackageDesc ;
    /** 资费套餐类型;1 - 客户接入类型；2 - 群组接入类型；3 - 物联卡接入类型； */
    private int pricingPackageType ;
    /** 资费套餐流量结算周期;1 - 每月； */
    private int pricingPackageFlowSettlePeriod ;
    /** 资费套餐流量;单位：Kb */
    private BigDecimal pricingPackageFlow ;
    /** 资费套餐详情 */
    private String pricingPackageDetail ;
    /** 排序序号 */
    private int sortSn ;
    /** 是否有效 */
    private boolean isValid ;
    /** 创建人;系统用户表用户编号字段（user_no） */
    private String creator ;
    /** 创建时间;为0表示为空 */
    private long gmtCreate ;
    /** 更新人;系统用户表用户编号字段（user_no） */
    private String modifier ;
    /** 更新时间;为0表示为空 */
    private long gmtModified ;
    /** 失效人;系统用户表用户编号字段（user_no） */
    private String invalider ;
    /** 失效时间;为0表示为空 */
    private long gmtInvalid ;
    /** 版本号;用于乐观锁 */
    private int version ;
}
