package com.ebike.openservices.simmanage.entity;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**  物联卡充值记录  */
@Data
public class IotcardRechargeRecordDo {
    private Long id ;
    /** 系统单位编号 */
    private String orgNo ;
    /** 物联卡资产标识 */
    private Long assetsCardId ;
    /** 充值时间 */
    private Date rechargeTime ;
    /** 充值金额 */
    private BigDecimal rechargeMoney ;
    /** 充值方式;1 - 物联卡管理平台API充值；9 - 线下充值（手工记录）； */
    private int rechargeMode ;
    /** 充值时长;单位：月 */
    private int rechargeDuration ;
    /** 充值详情 */
    private String rechargeDetail ;
    /** 排序序号 */
    private int sortSn ;
    /** 是否有效 */
    private boolean isValid ;
    /** 创建人;系统用户表用户编号字段（user_no） */
    private String creator ;
    /** 创建时间;为0表示为空 */
    private long gmtCreate ;
    /** 更新人;系统用户表用户编号字段（user_no） */
    private String modifier ;
    /** 更新时间;为0表示为空 */
    private long gmtModified ;
    /** 失效人;系统用户表用户编号字段（user_no） */
    private String invalider ;
    /** 失效时间;为0表示为空 */
    private long gmtInvalid ;
    /** 版本号;用于乐观锁 */
    private int version ;


}
