package com.ebike.openservices.simmanage.request;

import com.easesource.data.bean.Pager;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author lzx
 * @version 1.0
 * @date 2020/6/4 16:48
 */
@Data
public class RechargeRecordAddRequest implements Serializable {
    private long id;
    /**
     * 系统单位编号
     */
    private String orgNo;
    /**
     * 物联卡资产标识
     */
    private String assetsCardId;
    /**
     * 充值时间
     */
    private String rechargeTime;
    /**
     * 充值金额
     */
    private String rechargeMoney;
    /**
     * 充值方式;1 - 物联卡管理平台API充值；9 - 线下充值（手工记录）；
     */
    private int rechargeMode;
    /**
     * 充值时长;单位：月
     */
    private String rechargeDuration;
    /**
     * 充值详情
     */
    private String rechargeDetail;
    /**
     * 排序序号
     */
    private int sortSn;
    /**
     * 是否有效
     */
    private boolean isValid;
    /**
     * 创建人;系统用户表用户编号字段（user_no）
     */
    private String creator;
    /**
     * 创建时间;为0表示为空
     */
    private long gmtCreate;
    /**
     * 更新人;系统用户表用户编号字段（user_no）
     */
    private String modifier;
    /**
     * 更新时间;为0表示为空
     */
    private long gmtModified;
    /**
     * 失效人;系统用户表用户编号字段（user_no）
     */
    private String invalider;
    /**
     * 失效时间;为0表示为空
     */
    private long gmtInvalid;
    /**
     * 版本号;用于乐观锁
     */
    private int version;

    private String userNo;

    private String assetsCardBindDeviceId;
    private String iccid;
}
