package com.ebike.openservices.simmanage.request;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lzx
 * @version 1.0
 * @date 2020/6/4 16:48
 */
@Data
public class RechargeRecordLogAddRequest implements Serializable {
    private long id;
    /**
     * 维护日志类型;1 - 新增；2 - 修改；3 - 删除；
     */
    private int logType;
    /**
     * 维护日志说明
     */
    private String logDesc;
    /**
     * 物联卡充值记录标识
     */
    private String rechargeRecordId;
    /**
     * 维护前记录;
     */
    private String oldEntityDetail;
    /**
     * 维护后记录;
     */
    private String newEntityDetail;
    /**
     * 排序序号
     */
    private int sortSn;
    /**
     * 是否有效
     */
    private boolean isValid = true;
    /**
     * 创建人;系统用户表用户编号字段（user_no）
     */
    private String creator;
    /**
     * 创建时间;为0表示为空
     */
    private long gmtCreate;
    /**
     * 更新人;系统用户表用户编号字段（user_no）
     */
    private String modifier;
    /**
     * 更新时间;为0表示为空
     */
    private long gmtModified;
    /**
     * 失效人;系统用户表用户编号字段（user_no）
     */
    private String invalider;
    /**
     * 失效时间;为0表示为空
     */
    private long gmtInvalid;
    /**
     * 版本号;用于乐观锁
     */
    private int version;
}
