package com.ebike.openservices.simmanage.response;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author lzx
 * @version 1.0
 * @date 2020/6/4 16:48
 */
@Data
public class RechargeRecordResponse implements Serializable {

    /**
     * 充电设备大类：1-自行车；2-汽车
     */
    private Integer type;

    /**
     * 序号
     */
    private String key;
    /**
     * 资产标识
     */
    private String assetsCardId;
    /**
     * 物联卡资产绑定设备标识号
     */
    private String assetsCardBindDeviceId;
    /**
     * MSISDN
     */
    private String msisdn;
    /**
     * ICCID
     */
    private String iccid;
    /**
     * 充值记录标识
     */
    private String id;
    /**
     * 充值时间
     */
    private String rechargeTime;
    /**
     * 充值金额
     */
    private BigDecimal rechargeMoney;
    /**
     * 充值方式;1 - 物联卡管理平台API充值；9 - 线下充值（手工记录）；
     */
    private int rechargeMode;
    /**
     * 充值时长;单位：月
     */
    private int rechargeDuration;
    /**
     * 充值详情
     */
    private String rechargeDetail;
    /**
     * 运营商名称
     */
    private String orgName;
    /**
     * 运营商编号
     */
    private String orgNo;
    private String stationAddr;
    private String stationName;
    private String runDate;
    private String creator;

}
