package com.ebike.openservices.simmanage.service;

import com.ebike.openservices.simmanage.request.CustomerAnalysisQueryRequest;
import com.ebike.openservices.simmanage.response.CustomerAnalysisResponse;

import java.util.List;
import java.util.Map;

/**
 * @author lzx
 * @version 1.0
 * @date 2020/6/4 16:48
 */
public interface CustomerAnalysisService {
    /**
     * 新增注册用户
     * @param pojo
     * @return
     */
    List<CustomerAnalysisResponse> queryAddLogonUser(CustomerAnalysisQueryRequest pojo);

    /**
     * 充电卡新绑定用户
     * @param pojo
     * @return
     */
    List<CustomerAnalysisResponse> querySimUser(CustomerAnalysisQueryRequest pojo);

    List<CustomerAnalysisResponse> queryAddYearUser(CustomerAnalysisQueryRequest pojo);

    Map<String,Object> queryClientProperty();

    Map<String,Object> queryLogonAddress();

    Map<String,Object> queryPayingHabit();

    Map<String,Object> queryCustomerPrice(CustomerAnalysisQueryRequest pojo);

    /**
     * 充电汽车 近一个月平均消费金额和支付金额
     */
    Map<String, Object> queryPaymentCar(CustomerAnalysisQueryRequest pojo);

    /**
     * 电动汽车，自行车近七天，近十四天复充率
     */
    String queryRecharging(CustomerAnalysisQueryRequest pojo);
    String queryCarRecharging(CustomerAnalysisQueryRequest pojo);
}
