package com.ebike.openservices.simmanage.service;

import com.ebike.openservices.simmanage.entity.IotcardAssetsCardDo;
import com.ebike.openservices.simmanage.entity.IotcardAssetsCardLogDo;
import com.ebike.openservices.simmanage.entity.IotcardPricingPackageDo;
import com.ebike.openservices.simmanage.request.IotcardAssetsCardRequest;
import com.ebike.openservices.simmanage.response.BpCodeSlectVo;
import com.ebike.openservices.simmanage.response.IotcardAssetsCardVo;
import com.ebike.openservices.simmanage.response.SimDeviceVo;

import java.util.List;

/**
* @Description:
* @Param: Sim卡的管理
* @returns:
* @Author: 杨德志
* @Date: 2020/6/3 11:36
*/
public interface SimManageService {

    /** 查询出 sim 卡的list 信息 */

    List<IotcardAssetsCardVo>  findSimManage(IotcardAssetsCardDo IotcardAssetsCardDo);

    /**  新增资产管理的信息 */
    Integer addSimManage(IotcardAssetsCardDo iotcardAssetsCardDo);

    /**  修改一条记录 */
    Integer updateSimManage(IotcardAssetsCardDo iotcardAssetsCardDo);

    /**  删除一条记录 **/
    Integer   delSimManage(String[] ids);


    /**  查询出所有设备  充电桩的地址 名称  为在运 ***/
     List<SimDeviceVo>  findSimDevice(SimDeviceVo SimDeviceVo);

    /**  查询出所有设备  充电桩的地址 名称  为在运 ***/
    List<SimDeviceVo> findAllSimDevice(SimDeviceVo simDeviceVo);

    /** 查询出物联卡的资费套餐表的list   */
    List<IotcardPricingPackageDo> findIotcardPricingPackage(IotcardPricingPackageDo iotcardPricingPackageDo);

    /** 查询编码表  查询出所有的SIM 卡的所属公司  通信运营商等 */
    List<BpCodeSlectVo>  findCompany(BpCodeSlectVo bpCodeSlectVo);

    /** 查询SIM卡 中获取所有的运营商 */

    List<BpCodeSlectVo> findCommOperator();


    /** 根据这个传入的ID 找到这条记录   */
    List<IotcardAssetsCardVo> findSimManageByID(Long id);

    /**  物联卡资产维护日志  给日志表新增一条记录  **/
    Integer  addIotcardAssetsCardLog(IotcardAssetsCardLogDo iotcardAssetsCardLogDo,Integer type);

    int selectSimManage(IotcardAssetsCardRequest iotcardAssetsCardRequest);
    /** 根据设备ID 查询换卡记录 */
    List<IotcardAssetsCardVo> findDiviceCard(String assetsCardBindDeviceId);

    /**  新增  和编辑 时验证这个是否可以插入 **/

    Integer   findVerification( String valueName  ,String type);


    /**根据SSID 同步sim 卡的信息  **/
    Integer updateSynchronization(IotcardAssetsCardDo iotcardAssetsCardDo);

    List<IotcardAssetsCardVo> selectSimManageOn(IotcardAssetsCardRequest iotcardAssetsCardRequest);

    int addSimManageExcel(List<IotcardAssetsCardRequest> list);

    int addSimManageLogExcel(List<IotcardAssetsCardLogDo> list);
}
