package com.ebike.openservices.simmanage.service;

import com.ebike.openservices.simmanage.request.RechargeRecordAddRequest;
import com.ebike.openservices.simmanage.request.RechargeRecordDeleteRequest;
import com.ebike.openservices.simmanage.request.RechargeRecordRequest;
import com.ebike.openservices.simmanage.response.EbikeOrgoprResponse;

import java.util.List;
import java.util.Map;

/**
 * @author lzx
 * @version 1.0
 * @date 2020/6/4 16:48
 */
public interface SimRechargeRecordService {
    /**
     * 查询充值记录列表
     * @param rechargeRecordRequest
     * @return list
     */
    Map<String, Object> queryRechargeRecordList(RechargeRecordRequest rechargeRecordRequest);

    /**
     * 新增充值记录
     * @param rechargeRecordAddRequest
     * @return int 成功 或 失败
     */
    int addRechargeRecord(RechargeRecordAddRequest rechargeRecordAddRequest);

    /**
     * 删除充值记录
     * @return int 成功 或 失败
     */
    int deleteRechargeRecord(RechargeRecordDeleteRequest pojo);

    /**
     * 查询操作记录列表
     * @param rechargeRecordRequest
     * @return list
     */
    Map<String, Object> queryRechargeRecordLogList(RechargeRecordRequest rechargeRecordRequest);

    /**
     * 查询运营商
     */
    List<EbikeOrgoprResponse> queryOrgNameList(String orgNo,int orgType);

    /**
     * 查询orgType
     */
    int queryOrgType(String orgNo);
}
