package com.ebike.openservices.dao;

import com.ebike.openservices.simmanage.request.*;
import com.ebike.openservices.simmanage.response.*;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @author lzx
 * @version 1.0
 * @date 2020/6/4 16:52
 */
public interface CustomerAnalysisDao {
    /**
     * 新增注册用户
     *
     * @param pojo
     * @return
     */
    List<CustomerAnalysisResponse> queryAddLogonUser(CustomerAnalysisQueryRequest pojo);

    /**
     * 充电卡新绑定用户
     *
     * @param pojo
     * @return
     */
    List<CustomerAnalysisResponse> querySimUser(CustomerAnalysisQueryRequest pojo);

    List<CustomerAnalysisResponse> queryAddYearUser(CustomerAnalysisQueryRequest pojo);

    List<ClientPropertyResponse> queryClientProperty();

    int queryIsCode(String adName);

    int queryAddressAliPay();

    int queryAddressWeChat();

    int queryAddressYz();

    int queryPayingHabit(@Param("type") int type);

    /**
     * 充电自行车 近一个月平均消费金额和支付金额
     */
    Map<String, Object> queryPayment(CustomerAnalysisQueryRequest pojo);

    /**
     * 充电汽车 近一个月平均消费金额和支付金额
     */
    Map<String, Object> queryPaymentCar(CustomerAnalysisQueryRequest pojo);

    int queryHisCount(CustomerAnalysisQueryRequest pojo);

    int queryHisBigTwoCount(CustomerAnalysisQueryRequest pojo);

    int queryHisCarCount(CustomerAnalysisQueryRequest pojo);

    int queryHisBigTwoCarCount(CustomerAnalysisQueryRequest pojo);
}
