package com.ebike.openservices.dao;


import com.ebike.openservices.simmanage.entity.IotcardAssetsCardDo;
import com.ebike.openservices.simmanage.entity.IotcardAssetsCardLogDo;
import com.ebike.openservices.simmanage.entity.IotcardPricingPackageDo;
import com.ebike.openservices.simmanage.request.IotcardAssetsCardRequest;
import com.ebike.openservices.simmanage.response.BpCodeSlectVo;
import com.ebike.openservices.simmanage.response.IotcardAssetsCardVo;
import com.ebike.openservices.simmanage.response.SimDeviceVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;


public interface SimManageDao {

    /** 查询list表格的list   */
    List<IotcardAssetsCardVo> findSimManage(IotcardAssetsCardDo IotcardAssetsCardDo);
    /** 新增  */
    Integer addSimManage(IotcardAssetsCardDo iotcardAssetsCardDo);
    /** 修改  */
    Integer updateSimManage(IotcardAssetsCardDo iotcardAssetsCardDo);
    /** 批量删除  */
    Integer delSimManage(@Param("ids")String[] ids);
    /** 查到到设备的list*/
    List<SimDeviceVo> findSimDevice(SimDeviceVo simDeviceVo);
    /** 查到到设备的list*/
    List<SimDeviceVo> findAllSimDevice(SimDeviceVo simDeviceVo);
    /** 查到套餐资费的list*/
    List<IotcardPricingPackageDo> findIotcardPricingPackage(IotcardPricingPackageDo iotcardPricingPackageDo);
    /** 查询所属公司list */
    List<BpCodeSlectVo> findCompany(BpCodeSlectVo bpCodeSlectVo);
    /** 查询运营商   */
    List<BpCodeSlectVo> findCommOperator();

    /** 根据id 查找资产管理表  */
    List<IotcardAssetsCardVo> findSimManageByID(@Param("id")Long id);

    /**日志表的 **/
    Integer addIotcardAssetsCardLog(IotcardAssetsCardLogDo iotcardAssetsCardLogDo);

    /** 查询设备的换卡记录  */
    List<IotcardAssetsCardVo> findDiviceCard(@Param("assetsCardBindDeviceId")String assetsCardBindDeviceId);
    int selectSimManage(IotcardAssetsCardRequest iotcardAssetsCardRequest);

    List<IotcardAssetsCardVo>  selectSimManageOn(IotcardAssetsCardRequest iotcardAssetsCardRequest);

    int addSimManageExcel(@Param("list") List<IotcardAssetsCardRequest> list);

    int addSimManageLogExcel(@Param("list") List<IotcardAssetsCardLogDo> list);

    Integer findVerification(@Param("valueName")String valueName ,@Param("type")String type);
    /** sim卡的信息同步 */
    Integer updateSynchronization(IotcardAssetsCardDo iotcardAssetsCardDo);
}
