package com.ebike.openservices.dao;

import com.ebike.openservices.simmanage.request.IotcardAssetsCard;
import com.ebike.openservices.simmanage.request.RechargeRecordAddRequest;
import com.ebike.openservices.simmanage.request.RechargeRecordLogAddRequest;
import com.ebike.openservices.simmanage.request.RechargeRecordRequest;
import com.ebike.openservices.simmanage.response.EbikeOrgoprResponse;
import com.ebike.openservices.simmanage.response.RechargeRecordLogResponse;
import com.ebike.openservices.simmanage.response.RechargeRecordResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author lzx
 * @version 1.0
 * @date 2020/6/4 16:52
 */
public interface SimRechargeRecordDao {

    List<RechargeRecordResponse> queryRechargeRecordList(RechargeRecordRequest rechargeRecordRequest);

    List<Integer> queryRechargeRecordListTotal(RechargeRecordRequest rechargeRecordRequest);

    int addRechargeRecord(RechargeRecordAddRequest rechargeRecordAddRequest);

    int addRechargeRecordLog(RechargeRecordLogAddRequest rechargeRecordLogAddRequest);

    int deleteRechargeRecord(@Param("id") String id);

    int updateAssetsCard(IotcardAssetsCard iotcardAssetsCard);

    List<RechargeRecordLogResponse> queryRechargeRecordLogList(RechargeRecordRequest rechargeRecordRequest);

    int queryRechargeRecordLogListTotal(RechargeRecordRequest rechargeRecordRequest);

    List<EbikeOrgoprResponse> queryOrgNameList(@Param("orgNo") String orgNo,@Param("orgType") int orgType);

    int queryOrgType(String orgNo);
}
