package com.ebike.openservices.service.impl;

import com.ebike.openservices.dao.CustomerAnalysisDao;
import com.ebike.openservices.simmanage.request.CustomerAnalysisQueryRequest;
import com.ebike.openservices.simmanage.response.ClientPropertyResponse;
import com.ebike.openservices.simmanage.response.CustomerAnalysisResponse;
import com.ebike.openservices.simmanage.service.CustomerAnalysisService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lzx
 * @version 1.0
 * @date 2020/6/4 16:51
 */
@Service
public class CustomerAnalysisServiceImpl implements CustomerAnalysisService {

    @Resource
    private CustomerAnalysisDao customerAnalysisDao;

    @Override
    public List<CustomerAnalysisResponse> queryAddLogonUser(CustomerAnalysisQueryRequest pojo) {
        return customerAnalysisDao.queryAddLogonUser(pojo);
    }

    @Override
    public List<CustomerAnalysisResponse> querySimUser(CustomerAnalysisQueryRequest pojo) {
        return customerAnalysisDao.querySimUser(pojo);
    }

    @Override
    public List<CustomerAnalysisResponse> queryAddYearUser(CustomerAnalysisQueryRequest pojo) {
        return customerAnalysisDao.queryAddYearUser(pojo);
    }

    @Override
    public Map<String,Object> queryClientProperty() {
        List<ClientPropertyResponse> list = customerAnalysisDao.queryClientProperty();
        List<String> resultAddress = new ArrayList<>();
        List<Integer> resultNum = new ArrayList<>();
        int sum = 0;
        for (int i = 0; i < list.size(); i++) {
            String address = list.get(i).getAddress();
            int num = list.get(i).getNum();
            if (!"".equals(address)) {
                int i1 = customerAnalysisDao.queryIsCode(address);
                if (i1 > 0) {
                    resultAddress.add(address);
                    resultNum.add(num);
                }else {
                    sum = sum + num;
                }
            }else {
                sum = sum + num;
            }
        }
        resultAddress.add("其他");
        resultNum.add(sum);
        Map<String, Object> map = new HashMap<>();
        map.put("resultAddress", resultAddress);
        map.put("resultNum", resultNum);
        return map;
    }

    @Override
    public Map<String, Object> queryLogonAddress() {
        Map<String, Object> map = new HashMap<>();
        map.put("aliPay", customerAnalysisDao.queryAddressAliPay());
        map.put("weChat", customerAnalysisDao.queryAddressWeChat());
        map.put("app", customerAnalysisDao.queryAddressYz());
        return map;
    }

    @Override
    public Map<String, Object> queryPayingHabit() {
        Map<String, Object> map = new HashMap<>();
        map.put("aliPay", customerAnalysisDao.queryPayingHabit(1));
        map.put("weChat", customerAnalysisDao.queryPayingHabit(2));
        return map;
    }

    @Override
    public Map<String, Object> queryCustomerPrice(CustomerAnalysisQueryRequest pojo) {
        return customerAnalysisDao.queryPayment(pojo);
    }

    @Override
    public Map<String, Object> queryPaymentCar(CustomerAnalysisQueryRequest pojo) {
        return customerAnalysisDao.queryPaymentCar(pojo);
    }

    @Override
    public String queryRecharging(CustomerAnalysisQueryRequest pojo) {
        int count = customerAnalysisDao.queryHisCount(pojo);
        int bigTwoCount = customerAnalysisDao.queryHisBigTwoCount(pojo);
        DecimalFormat bigDecimal = new DecimalFormat("0");
        return count != 0 ? bigDecimal.format(((float) bigTwoCount / count * 100)) : "0";
    }

    @Override
    public String queryCarRecharging(CustomerAnalysisQueryRequest pojo) {
        int count = customerAnalysisDao.queryHisCarCount(pojo);
        int bigTwoCount = customerAnalysisDao.queryHisBigTwoCarCount(pojo);
        DecimalFormat bigDecimal = new DecimalFormat("0");
        return count != 0 ? bigDecimal.format(((float) bigTwoCount / count * 100)) : "0";
    }
}
