package com.ebike.openservices.service.impl;

import com.easesource.commons.util.convert.JsonConvertUtils;
import com.ebike.openservices.base.service.AbstractEbikeBaseService;
import com.ebike.openservices.dao.SimManageDao;
import com.ebike.openservices.simmanage.entity.IotcardAssetsCardDo;
import com.ebike.openservices.simmanage.entity.IotcardAssetsCardLogDo;
import com.ebike.openservices.simmanage.entity.IotcardPricingPackageDo;
import com.ebike.openservices.simmanage.entity.SimManageVo;

import com.ebike.openservices.simmanage.request.IotcardAssetsCardRequest;
import com.ebike.openservices.simmanage.response.BpCodeSlectVo;
import com.ebike.openservices.simmanage.response.IotcardAssetsCardVo;
import com.ebike.openservices.simmanage.response.SimDeviceVo;
import com.ebike.openservices.simmanage.service.SimManageService;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Service;


import javax.annotation.Resource;
import java.util.List;
@Service
public class SimManageImpl extends AbstractEbikeBaseService implements SimManageService {

    @Resource
    private SimManageDao simManageDao;

/*    @Override
    public List<SimManageVo> findSimManage() {
        System.out.println("打印一下啊啊啊啊啊");
        return simManageDao.findSimManage();
    }*/

    @Override
    public List<IotcardAssetsCardVo> findSimManage(IotcardAssetsCardDo IotcardAssetsCardDo ) {
        return simManageDao.findSimManage(IotcardAssetsCardDo);
    }

    @Override
    public Integer addSimManage(IotcardAssetsCardDo iotcardAssetsCardDo) {
        return simManageDao.addSimManage(iotcardAssetsCardDo);
    }

    @Override
    public Integer updateSimManage(IotcardAssetsCardDo iotcardAssetsCardDo) {
        return simManageDao.updateSimManage(iotcardAssetsCardDo);
    }

    @Override
    public Integer delSimManage(String[] ids) {
        return simManageDao.delSimManage(ids);
    }

    @Override
    public List<SimDeviceVo> findSimDevice(SimDeviceVo SimDeviceVo) {
        return simManageDao.findSimDevice(SimDeviceVo);
    }

    @Override
    public List<SimDeviceVo> findAllSimDevice(SimDeviceVo simDeviceVo) {
        return simManageDao.findAllSimDevice(simDeviceVo);
    }

    @Override
    public List<IotcardPricingPackageDo> findIotcardPricingPackage(IotcardPricingPackageDo iotcardPricingPackageDo) {
        return simManageDao.findIotcardPricingPackage(iotcardPricingPackageDo);
    }

    @Override
    public List<BpCodeSlectVo> findCompany(BpCodeSlectVo bpCodeSlectVo) {
        return simManageDao.findCompany(bpCodeSlectVo);
    }

    @Override
    public List<BpCodeSlectVo> findCommOperator() {
        return simManageDao.findCommOperator();
    }

    @Override
    public List<IotcardAssetsCardVo> findSimManageByID(Long id) {
        return simManageDao.findSimManageByID(id);
    }


    /** 给日志表新增记录 */
    @Override
    public Integer addIotcardAssetsCardLog(IotcardAssetsCardLogDo iotcardAssetsCardLogDo,Integer type) {
       //type   1 - 新增；2 - 修改；3 - 删除；
        if(type == 1){
            iotcardAssetsCardLogDo.setLogType(1);
        }else if(type == 2){
            iotcardAssetsCardLogDo.setLogType(2);
        }else if(type == 3){
            iotcardAssetsCardLogDo.setLogType(3);
        }
        return simManageDao.addIotcardAssetsCardLog(iotcardAssetsCardLogDo);
    }

    /** 查询设备的换卡记录 */
    @Override
    public List<IotcardAssetsCardVo> findDiviceCard(String assetsCardBindDeviceId) {
        return simManageDao.findDiviceCard( assetsCardBindDeviceId);
    }

    @Override
    public int selectSimManage(IotcardAssetsCardRequest iotcardAssetsCardRequest) {
        return simManageDao.selectSimManage(iotcardAssetsCardRequest);
    }

    @Override
    public int addSimManageExcel(List<IotcardAssetsCardRequest> list) {
        return simManageDao.addSimManageExcel(list);
    }

    @Override
    public int addSimManageLogExcel(List<IotcardAssetsCardLogDo> list) {
        return simManageDao.addSimManageLogExcel(list);
    }
    @Override
    public Integer findVerification(String  valueName ,String type) {
        return simManageDao.findVerification(valueName,type);
    }

    @Override
    public Integer updateSynchronization(IotcardAssetsCardDo iotcardAssetsCardDo) {
        return simManageDao.updateSynchronization(iotcardAssetsCardDo);
    }

    @Override
    public List<IotcardAssetsCardVo> selectSimManageOn(IotcardAssetsCardRequest iotcardAssetsCardRequest) {
        return simManageDao.selectSimManageOn(iotcardAssetsCardRequest);
    }

}
