package com.ebike.openservices.service.impl;

import com.easesource.commons.util.convert.JsonConvertUtils;
import com.ebike.openservices.dao.SimRechargeRecordDao;
import com.ebike.openservices.simmanage.request.*;
import com.ebike.openservices.simmanage.response.RechargeRecordLogResponse;
import com.ebike.openservices.simmanage.response.RechargeRecordResponse;
import com.ebike.openservices.simmanage.response.EbikeOrgoprResponse;
import com.ebike.openservices.simmanage.service.SimRechargeRecordService;
import com.ebike.openservices.base.service.AbstractEbikeBaseService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author lzx
 * @version 1.0
 * @date 2020/6/4 16:51
 */
@Service
public class SimRechargeRecordServiceImpl extends AbstractEbikeBaseService implements SimRechargeRecordService {

    @Resource
    private SimRechargeRecordDao simRechargeRecordDao;

    @Override
    public Map<String, Object> queryRechargeRecordList(RechargeRecordRequest rechargeRecordRequest) {
        Map<String, Object> map = new HashMap<>();
        List<RechargeRecordResponse> list = simRechargeRecordDao.queryRechargeRecordList(rechargeRecordRequest);
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                int keys = (rechargeRecordRequest.getStart() - 1) * 10 + i + 1;
                list.get(i).setKey(String.valueOf(keys));
            }
        }
        List<Integer> totals = simRechargeRecordDao.queryRechargeRecordListTotal(rechargeRecordRequest);
        if(rechargeRecordRequest.getType() == 1){
            //如果查询全部（自行车和汽车）uniaon all 得到的total累加
            map.put("total",totals.get(0)+totals.get(1));
        }else{
            map.put("total",totals.get(0));
        }
        map.put("list", list);
        return map;
    }

    @Override
    @Transactional
    public int addRechargeRecord(RechargeRecordAddRequest rechargeRecordAddRequest) {
        rechargeRecordAddRequest.setRechargeMode(9);
        rechargeRecordAddRequest.setGmtCreate(System.currentTimeMillis());
        rechargeRecordAddRequest.setGmtModified(System.currentTimeMillis());
        rechargeRecordAddRequest.setSortSn(1);
        rechargeRecordAddRequest.setCreator(rechargeRecordAddRequest.getUserNo());
        rechargeRecordAddRequest.setModifier(rechargeRecordAddRequest.getUserNo());
        rechargeRecordAddRequest.setInvalider("");
        rechargeRecordAddRequest.setGmtInvalid(0);
        rechargeRecordAddRequest.setVersion(1);


        RechargeRecordLogAddRequest rechargeRecordLogAddRequest = new RechargeRecordLogAddRequest();
        rechargeRecordLogAddRequest.setLogType(1);
        rechargeRecordLogAddRequest.setLogDesc("");
        rechargeRecordLogAddRequest.setOldEntityDetail("{}");
        rechargeRecordLogAddRequest.setGmtCreate(System.currentTimeMillis());
        rechargeRecordLogAddRequest.setGmtModified(System.currentTimeMillis());
        rechargeRecordLogAddRequest.setSortSn(1);
        rechargeRecordLogAddRequest.setCreator(rechargeRecordAddRequest.getUserNo());
        rechargeRecordLogAddRequest.setModifier(rechargeRecordAddRequest.getUserNo());
        rechargeRecordLogAddRequest.setInvalider("");
        rechargeRecordLogAddRequest.setGmtInvalid(0);
        rechargeRecordLogAddRequest.setVersion(1);

        String[] assetsCardIdArray = rechargeRecordAddRequest.getAssetsCardId().split(",");
        String[] orgNoArray = rechargeRecordAddRequest.getOrgNo().split(",");
        String[] assetsArray = rechargeRecordAddRequest.getAssetsCardBindDeviceId().split(",");
        String[] iccidArray = rechargeRecordAddRequest.getIccid().split(",");

        IotcardAssetsCard iotcardAssetsCard = new IotcardAssetsCard();
        iotcardAssetsCard.setLatestRechargeMoney(new BigDecimal(rechargeRecordAddRequest.getRechargeMoney()));
        iotcardAssetsCard.setLatestRechargeDuration(Integer.parseInt(rechargeRecordAddRequest.getRechargeDuration()));
        iotcardAssetsCard.setLatestRechargeTime(new Date());
        String nextDueTime = addMonth(new Date(), "yyyy-MM-dd", 10);
        iotcardAssetsCard.setNextDueTime(nextDueTime);

        int rows = 0;
        for (int i = 0; i < assetsCardIdArray.length; i++) {

            long nextId = idGenerator.nextId();
            rechargeRecordAddRequest.setId(nextId);
            rechargeRecordAddRequest.setAssetsCardId(iccidArray[i]);
            rechargeRecordAddRequest.setOrgNo(orgNoArray[i]);
            rechargeRecordAddRequest.setAssetsCardBindDeviceId(assetsArray[i]);

            rechargeRecordLogAddRequest.setId(idGenerator.nextId());
            rechargeRecordLogAddRequest.setRechargeRecordId(String.valueOf(nextId));
            rechargeRecordLogAddRequest.setNewEntityDetail(JsonConvertUtils.convertToString(rechargeRecordAddRequest));
            iotcardAssetsCard.setId(assetsCardIdArray[i]);

            simRechargeRecordDao.addRechargeRecordLog(rechargeRecordLogAddRequest);
            simRechargeRecordDao.updateAssetsCard(iotcardAssetsCard);
            rows = simRechargeRecordDao.addRechargeRecord(rechargeRecordAddRequest);
        }
        return rows;
    }

    public static String addMonth(Date parse,String dateType,int month) {
        String nowDate = null;
        SimpleDateFormat f = new SimpleDateFormat(dateType);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(parse);
        calendar.add(Calendar.MONTH, month);
        long time = calendar.getTimeInMillis();
        nowDate = f.format(time);
        return nowDate;
    }

    @Override
    @Transactional
    public int deleteRechargeRecord(RechargeRecordDeleteRequest rechargeRecordDeleteRequest) {
        String[] idArray = rechargeRecordDeleteRequest.getRecordIds().split(",");
        String[] oldEntityDetailArray = rechargeRecordDeleteRequest.getOldEntityDetail().split("__");
        RechargeRecordLogAddRequest pojo = new RechargeRecordLogAddRequest();
        pojo.setLogType(3);
        pojo.setLogDesc("");
        pojo.setNewEntityDetail("{}");
        pojo.setGmtCreate(System.currentTimeMillis());
        pojo.setGmtModified(System.currentTimeMillis());
        pojo.setSortSn(1);
        pojo.setCreator(rechargeRecordDeleteRequest.getUserNo());
        pojo.setModifier(rechargeRecordDeleteRequest.getUserNo());
        pojo.setInvalider("");
        pojo.setGmtInvalid(0);
        pojo.setVersion(1);
        int rows = 0;
        for (int i = 0; i < idArray.length; i++) {
            pojo.setId(idGenerator.nextId());
            pojo.setRechargeRecordId(idArray[i]);
            pojo.setOldEntityDetail(oldEntityDetailArray[i]);
            simRechargeRecordDao.deleteRechargeRecord(idArray[i]);
            rows = simRechargeRecordDao.addRechargeRecordLog(pojo);
        }
        return rows;
    }

    @Override
    public Map<String, Object> queryRechargeRecordLogList(RechargeRecordRequest rechargeRecordRequest) {
        Map<String, Object> map = new HashMap<>();
        List<RechargeRecordLogResponse> list = simRechargeRecordDao.queryRechargeRecordLogList(rechargeRecordRequest);
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                int keys = (rechargeRecordRequest.getStart() - 1) * 10 + i + 1;
                list.get(i).setKey(keys);
            }
        }
        int total = simRechargeRecordDao.queryRechargeRecordLogListTotal(rechargeRecordRequest);
        map.put("list", list);
        map.put("total", total);
        return map;
    }

    @Override
    public List<EbikeOrgoprResponse> queryOrgNameList(String orgNo,int orgType) {
        return simRechargeRecordDao.queryOrgNameList(orgNo,orgType);
    }

    /**
     * 查询orgType
     *
     * @param orgNo
     */
    @Override
    public int queryOrgType(String orgNo) {
        return simRechargeRecordDao.queryOrgType(orgNo);
    }
}
