/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.service.impl;

import com.ebike.openservices.dao.CustomerAnalysisDao;
import com.ebike.openservices.simmanage.request.CustomerAnalysisQueryRequest;
import com.ebike.openservices.simmanage.response.ClientPropertyResponse;
import com.ebike.openservices.simmanage.response.CustomerAnalysisResponse;
import com.ebike.openservices.simmanage.service.CustomerAnalysisService;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CustomerAnalysisServiceImpl
implements CustomerAnalysisService {
    @Resource
    private CustomerAnalysisDao customerAnalysisDao;

    public List<CustomerAnalysisResponse> queryAddLogonUser(CustomerAnalysisQueryRequest pojo) {
        return this.customerAnalysisDao.queryAddLogonUser(pojo);
    }

    public List<CustomerAnalysisResponse> querySimUser(CustomerAnalysisQueryRequest pojo) {
        return this.customerAnalysisDao.querySimUser(pojo);
    }

    public List<CustomerAnalysisResponse> queryAddYearUser(CustomerAnalysisQueryRequest pojo) {
        return this.customerAnalysisDao.queryAddYearUser(pojo);
    }

    public Map<String, Object> queryClientProperty() {
        List<ClientPropertyResponse> list = this.customerAnalysisDao.queryClientProperty();
        ArrayList<String> resultAddress = new ArrayList<String>();
        ArrayList<Integer> resultNum = new ArrayList<Integer>();
        int sum = 0;
        for (int i = 0; i < list.size(); ++i) {
            String address = list.get(i).getAddress();
            int num = list.get(i).getNum();
            if (!"".equals(address)) {
                int i1 = this.customerAnalysisDao.queryIsCode(address);
                if (i1 > 0) {
                    resultAddress.add(address);
                    resultNum.add(num);
                    continue;
                }
                sum += num;
                continue;
            }
            sum += num;
        }
        resultAddress.add("\u5176\u4ed6");
        resultNum.add(sum);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resultAddress", resultAddress);
        map.put("resultNum", resultNum);
        return map;
    }

    public Map<String, Object> queryLogonAddress() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("aliPay", this.customerAnalysisDao.queryAddressAliPay());
        map.put("weChat", this.customerAnalysisDao.queryAddressWeChat());
        map.put("app", this.customerAnalysisDao.queryAddressYz());
        return map;
    }

    public Map<String, Object> queryPayingHabit() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("aliPay", this.customerAnalysisDao.queryPayingHabit(1));
        map.put("weChat", this.customerAnalysisDao.queryPayingHabit(2));
        return map;
    }

    public Map<String, Object> queryCustomerPrice(CustomerAnalysisQueryRequest pojo) {
        return this.customerAnalysisDao.queryPayment(pojo);
    }

    public Map<String, Object> queryPaymentCar(CustomerAnalysisQueryRequest pojo) {
        return this.customerAnalysisDao.queryPaymentCar(pojo);
    }

    public String queryRecharging(CustomerAnalysisQueryRequest pojo) {
        int count = this.customerAnalysisDao.queryHisCount(pojo);
        int bigTwoCount = this.customerAnalysisDao.queryHisBigTwoCount(pojo);
        DecimalFormat bigDecimal = new DecimalFormat("0");
        return count != 0 ? bigDecimal.format((float)bigTwoCount / (float)count * 100.0f) : "0";
    }

    public String queryCarRecharging(CustomerAnalysisQueryRequest pojo) {
        int count = this.customerAnalysisDao.queryHisCarCount(pojo);
        int bigTwoCount = this.customerAnalysisDao.queryHisBigTwoCarCount(pojo);
        DecimalFormat bigDecimal = new DecimalFormat("0");
        return count != 0 ? bigDecimal.format((float)bigTwoCount / (float)count * 100.0f) : "0";
    }
}

