/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.statanaly.service.impl;

import com.easesource.commons.util.convert.DateConvertUtils;
import com.ebike.openservices.statanaly.dao.StatPowerOrgAndSystemDao;
import com.ebike.openservices.statanaly.entity.BpOrgDo;
import com.ebike.openservices.statanaly.entity.StatPowerOrgSystemDayDo;
import com.ebike.openservices.statanaly.entity.StatPowerOrgSystemMonthDo;
import com.ebike.openservices.statanaly.entity.StatPowerOrgSystemYearDo;
import com.ebike.openservices.statanaly.service.StatPowerOrgAndSystemService;
import com.ebike.openservices.statanaly.service.impl.AbstractIesmsBaseService;
import com.ebike.openservices.statanaly.util.StringDateUtil;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class StatPowerOrgAndSystemServiceImpl
extends AbstractIesmsBaseService
implements StatPowerOrgAndSystemService {
    private static final Logger log = LoggerFactory.getLogger(StatPowerOrgAndSystemServiceImpl.class);
    @Resource
    private StatPowerOrgAndSystemDao powerOrgAndSystemDao;

    public void stateOrgAndSystem(BpOrgDo bpOrgDo) {
        bpOrgDo.setType1("1");
        bpOrgDo.setOrgType("2");
        List<BpOrgDo> bpOrgDoList = this.powerOrgAndSystemDao.getBpOrgByType(bpOrgDo);
        ArrayList<StatPowerOrgSystemDayDo> orgSystemDayDoList = new ArrayList<StatPowerOrgSystemDayDo>(bpOrgDoList.size());
        if (bpOrgDoList != null && bpOrgDoList.size() > 0) {
            bpOrgDoList.removeIf(Objects::isNull);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("dateStat", bpOrgDo.getDateStat());
            for (BpOrgDo bpOrg : bpOrgDoList) {
                bpOrgDo.setPOrgNo(bpOrg.getOrgNo());
                bpOrgDo.setOrgType2("2");
                StatPowerOrgSystemDayDo orgAndSystemValue = this.powerOrgAndSystemDao.getOrgAndSystemValue(bpOrgDo);
                if (orgAndSystemValue == null) continue;
                orgAndSystemValue.setId(Long.valueOf(this.idGenerator.nextId()));
                orgAndSystemValue.setGmtCreate(Long.valueOf(System.currentTimeMillis()));
                orgAndSystemValue.setGmtModified(Long.valueOf(System.currentTimeMillis()));
                orgAndSystemValue.setVersion(Integer.valueOf(1));
                orgAndSystemValue.setOrgNo(bpOrg.getOrgNo());
                String[] strings = this.computeMaxMinAvg(orgAndSystemValue, map);
                orgAndSystemValue.setAvgValue(new BigDecimal(strings[0]));
                orgAndSystemValue.setMaxValue(new BigDecimal(strings[1]));
                orgAndSystemValue.setMaxValueTime(DateConvertUtils.convertFromString((String)strings[2], (String[])new String[]{"yyyy-MM-dd HH:mm:ss"}));
                orgAndSystemValue.setMinValue(new BigDecimal(strings[3]));
                orgAndSystemValue.setMinValueTime(DateConvertUtils.convertFromString((String)strings[4], (String[])new String[]{"yyyy-MM-dd HH:mm:ss"}));
                orgSystemDayDoList.add(orgAndSystemValue);
            }
        }
        bpOrgDo.setOrgType2("1");
        StatPowerOrgSystemDayDo orgAndSystemValue2 = this.powerOrgAndSystemDao.getOrgAndSystemValue(bpOrgDo);
        orgAndSystemValue2.setId(Long.valueOf(this.idGenerator.nextId()));
        orgAndSystemValue2.setGmtCreate(Long.valueOf(System.currentTimeMillis()));
        orgAndSystemValue2.setGmtModified(Long.valueOf(System.currentTimeMillis()));
        orgAndSystemValue2.setVersion(Integer.valueOf(1));
        orgAndSystemValue2.setOrgNo("000000000");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("dateStat", bpOrgDo.getDateStat());
        String[] strings2 = this.computeMaxMinAvg(orgAndSystemValue2, map);
        orgAndSystemValue2.setAvgValue(new BigDecimal(strings2[0]));
        orgAndSystemValue2.setMaxValue(new BigDecimal(strings2[1]));
        orgAndSystemValue2.setMaxValueTime(DateConvertUtils.convertFromString((String)strings2[2], (String[])new String[]{"yyyy-MM-dd HH:mm:ss"}));
        orgAndSystemValue2.setMinValue(new BigDecimal(strings2[3]));
        orgAndSystemValue2.setMinValueTime(DateConvertUtils.convertFromString((String)strings2[4], (String[])new String[]{"yyyy-MM-dd HH:mm:ss"}));
        orgSystemDayDoList.add(orgAndSystemValue2);
        try {
            this.powerOrgAndSystemDao.insertOrUpdateOrgAndSystem(orgSystemDayDoList);
        }
        catch (RuntimeException e) {
            log.error("insertOrUpdateOrgAndSystem error:" + e.getMessage());
        }
        this.statMonthAndYear(bpOrgDo);
    }

    private void statMonthAndYear(BpOrgDo bpOrgDo) {
        List<StatPowerOrgSystemYearDo> powerOrgSystemYearDos;
        List<StatPowerOrgSystemMonthDo> powerOrgSystemMonthDos = this.powerOrgAndSystemDao.getOrgAndSystemMonth(bpOrgDo);
        if (powerOrgSystemMonthDos != null) {
            try {
                powerOrgSystemMonthDos.forEach(orgAndSystemMonth -> {
                    orgAndSystemMonth.setId(Long.valueOf(this.idGenerator.nextId()));
                    orgAndSystemMonth.setGmtCreate(Long.valueOf(System.currentTimeMillis()));
                    orgAndSystemMonth.setGmtModified(Long.valueOf(System.currentTimeMillis()));
                    orgAndSystemMonth.setVersion(Integer.valueOf(1));
                });
                this.powerOrgAndSystemDao.insertOrUpdateOrgAndSystemMonth(powerOrgSystemMonthDos);
            }
            catch (RuntimeException e) {
                log.error("insertOrUpdateOrgAndSystemMonth error:" + e.getMessage());
            }
        }
        if ((powerOrgSystemYearDos = this.powerOrgAndSystemDao.getOrgAndSystemYear(bpOrgDo)) != null) {
            try {
                powerOrgSystemYearDos.forEach(orgAndSystemYear -> {
                    orgAndSystemYear.setId(Long.valueOf(this.idGenerator.nextId()));
                    orgAndSystemYear.setGmtCreate(Long.valueOf(System.currentTimeMillis()));
                    orgAndSystemYear.setGmtModified(Long.valueOf(System.currentTimeMillis()));
                    orgAndSystemYear.setVersion(Integer.valueOf(1));
                });
                this.powerOrgAndSystemDao.insertOrUpdateOrgAndSystemYear(powerOrgSystemYearDos);
            }
            catch (RuntimeException e) {
                log.error("insertOrUpdateOrgAndSystemYear error:" + e.getMessage());
            }
        }
    }

    private String[] computeMaxMinAvg(StatPowerOrgSystemDayDo distnrEloadDayDo, Map<String, String> map) {
        String[] strings = null;
        if (distnrEloadDayDo == null) {
            return null;
        }
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
        Class<?> aClass = distnrEloadDayDo.getClass();
        try {
            for (int i = 1; i < 97; ++i) {
                String name = String.format("powerValue%02d", i);
                Field field = aClass.getDeclaredField(name);
                field.setAccessible(true);
                Object object = field.get(distnrEloadDayDo);
                if (object != null) {
                    BigDecimal bigDecimal = new BigDecimal(object.toString());
                    list.add(bigDecimal);
                    continue;
                }
                list.add(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        strings = this.getMaxMin(list, map);
        return strings;
    }

    private String[] getMaxMin(List<BigDecimal> list, Map<String, String> map) {
        String[] dayLables = StringDateUtil.getDayLables(96, 15);
        String[] values = new String[5];
        BigDecimal maxValue = null;
        BigDecimal minValue = null;
        BigDecimal totalValue = null;
        int count = 0;
        int maxIndex = 0;
        int minIndex = 0;
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                BigDecimal value = list.get(i);
                Boolean flag = value != null;
                if (flag.booleanValue() && maxValue != null && maxValue.compareTo(value) < 0) {
                    maxValue = value;
                    maxIndex = i;
                } else if (flag.booleanValue() && maxValue == null) {
                    maxValue = value;
                    maxIndex = i;
                }
                if (flag.booleanValue() && minValue != null && minValue.compareTo(value) > 0) {
                    minValue = value;
                    minIndex = i;
                } else if (flag.booleanValue() && minValue == null) {
                    minValue = value;
                    minIndex = i;
                }
                if (flag.booleanValue() && totalValue != null) {
                    totalValue = totalValue.add(value);
                    ++count;
                    continue;
                }
                if (!flag.booleanValue() || totalValue != null) continue;
                totalValue = value;
                ++count;
            }
        }
        String dateStat = map.get("dateStat");
        String maxDate = dateStat + " " + dayLables[maxIndex] + ":00";
        String minDate = dateStat + " " + dayLables[minIndex] + ":00";
        Date maxTime = DateConvertUtils.convertFromString((String)maxDate, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
        Date minTine = DateConvertUtils.convertFromString((String)minDate, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
        maxDate = DateConvertUtils.convertToString((Date)maxTime, (String)"yyyy-MM-dd HH:mm:ss");
        minDate = DateConvertUtils.convertToString((Date)minTine, (String)"yyyy-MM-dd HH:mm:ss");
        if (count > 0) {
            totalValue = totalValue.divide(BigDecimal.valueOf(count), 8, 0);
        }
        values[0] = String.valueOf(totalValue);
        values[1] = String.valueOf(maxValue);
        values[2] = maxDate;
        values[3] = String.valueOf(minValue);
        values[4] = minDate;
        return values;
    }
}

