/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.statanaly.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.data.id.generator.IdGenerator;
import com.ebike.openservices.statanaly.dao.ChargeDeviceOpsDao;
import com.ebike.openservices.statanaly.dao.StatDeviceDao;
import com.ebike.openservices.statanaly.dao.StatEbikeOrgoprEbtityDao;
import com.ebike.openservices.statanaly.dao.StatPowerChargedeviceDayDao;
import com.ebike.openservices.statanaly.dao.StatPowerChargedeviceMonthDao;
import com.ebike.openservices.statanaly.dao.StatPowerChargedeviceYearDao;
import com.ebike.openservices.statanaly.dao.StatPowerOrgAndSystemDao;
import com.ebike.openservices.statanaly.dao.StatPowerOrgDayDao;
import com.ebike.openservices.statanaly.dao.StatPowerOrgMonthDao;
import com.ebike.openservices.statanaly.dao.StatPowerOrgYearDao;
import com.ebike.openservices.statanaly.entity.ChargeDeviceOps;
import com.ebike.openservices.statanaly.entity.StatDeviceEntity;
import com.ebike.openservices.statanaly.entity.StatEbikeOrgoprEbtity;
import com.ebike.openservices.statanaly.entity.StatPowerChargedeviceDay;
import com.ebike.openservices.statanaly.entity.StatPowerChargedeviceMonth;
import com.ebike.openservices.statanaly.entity.StatPowerChargedeviceYear;
import com.ebike.openservices.statanaly.entity.StatPowerOrgDay;
import com.ebike.openservices.statanaly.entity.StatPowerOrgMonth;
import com.ebike.openservices.statanaly.entity.StatPowerOrgYear;
import com.ebike.openservices.statanaly.service.StatPowerService;
import com.ebike.openservices.statanaly.util.EbDateUtil;
import com.ebike.openservices.statanaly.util.StringDateUtil;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StatPowerServiceImpl
implements StatPowerService {
    private static final Logger log = LoggerFactory.getLogger(StatPowerServiceImpl.class);
    @Resource
    StatDeviceDao statDeviceDao;
    @Resource
    StatPowerOrgDayDao dayDao;
    @Resource
    IdGenerator easeSnowflake;
    @Resource
    StatPowerOrgMonthDao monthDao;
    @Resource
    StatPowerOrgYearDao yearDao;
    @Autowired
    ChargeDeviceOpsDao chargeDeviceOpsDao;
    @Resource
    StatPowerChargedeviceDayDao deviceDayDao;
    @Resource
    StatEbikeOrgoprEbtityDao orgoprEbtityDao;
    @Resource
    StatPowerChargedeviceMonthDao statPowerChargedeviceMonthDao;
    @Resource
    StatPowerChargedeviceYearDao statPowerChargedeviceYearDao;
    @Resource
    private StatPowerOrgAndSystemDao powerOrgAndSystemDao;

    public int statAnalyPower() {
        BigDecimal newValue;
        ChargeDeviceOps ops;
        Long time = System.currentTimeMillis();
        HashMap<String, BigDecimal> table = new HashMap<String, BigDecimal>(32);
        List<StatDeviceEntity> plugs = this.statDeviceDao.getPlugDevice();
        List<StatDeviceEntity> station = this.statDeviceDao.getStationDevice();
        for (StatDeviceEntity entity : plugs) {
            if (entity.getDeviceId() == null || (ops = this.chargeDeviceOpsDao.selectOnById(entity.getDeviceId().longValue())) == null || entity.getSubburo() == null) continue;
            if (table.get(entity.getSubburo()) == null) {
                table.put(entity.getSubburo(), ops.getCurPower());
            } else if (ops.getCurPower() != null) {
                newValue = ((BigDecimal)table.get(entity.getSubburo())).add(ops.getCurPower());
                table.put(entity.getSubburo(), newValue);
            }
            if (ops.getCurPower() == null) continue;
            this.updateOrInsertPowerDriveDay(entity.getDeviceId().longValue(), entity.getSubburo(), new Date(System.currentTimeMillis()), ops.getCurPower(), ops.getCurPowerTime().getTime());
        }
        for (StatDeviceEntity entity : station) {
            if (entity.getDeviceId() == null) continue;
            ops = this.chargeDeviceOpsDao.selectOnById(entity.getDeviceId().longValue());
            if (ops != null) {
                if (table.get(entity.getSubburo()) == null) {
                    table.put(entity.getSubburo(), ops.getCurPower());
                } else if (ops.getCurPower() != null) {
                    newValue = ((BigDecimal)table.get(entity.getSubburo())).add(ops.getCurPower());
                    table.put(entity.getSubburo(), newValue);
                }
            }
            if (ops.getCurPower() == null) continue;
            this.updateOrInsertPowerDriveDay(entity.getDeviceId().longValue(), entity.getSubburo(), new Date(System.currentTimeMillis()), ops.getCurPower(), ops.getCurPowerTime().getTime());
        }
        for (String orgno : table.keySet()) {
            String[] strings;
            HashMap<String, String> map;
            String dateStat = DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy-MM-dd");
            BigDecimal curPower = (BigDecimal)table.get(orgno);
            Date date = new Date(time);
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"org_No", (Object)orgno)).eq((Object)"date_stat", (Object)date);
            StatPowerOrgDay day = (StatPowerOrgDay)this.dayDao.selectOne((Wrapper)queryWrapper);
            if (day == null) {
                day = new StatPowerOrgDay();
                day.setOrgNo(orgno);
                StatPowerServiceImpl.setDayValue(StatPowerOrgDay.class, day, curPower);
                day.setGmtCreate(time);
                day.setDateStat(date);
                day.setId(Long.valueOf(this.easeSnowflake.nextId()));
                day.setGmtModified(time);
                map = new HashMap();
                map.put("dateStat", dateStat);
                strings = this.computeMaxMinAvg(day, map);
                if (strings != null) {
                    try {
                        day.setAvgValue(new BigDecimal(strings[0] == null ? "0" : strings[0]));
                        day.setMaxValue(new BigDecimal(strings[1] == null ? "0" : strings[1]));
                        day.setMaxValueTime(DateConvertUtils.convertFromString((String)(strings[2] == null ? "0" : strings[2]), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"}));
                        day.setMinValue(new BigDecimal(strings[3] == null ? "0" : strings[3]));
                        day.setMinValueTime(DateConvertUtils.convertFromString((String)(strings[4] == null ? "0" : strings[4]), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"}));
                    }
                    catch (Exception e) {
                        log.error("strings error:" + e.getMessage());
                    }
                }
                day.setVersion(Integer.valueOf(1));
                day.setDateStat(date);
                this.powerOrgAndSystemDao.insertOrUpdateOrgAndSystemOne(day);
                continue;
            }
            StatPowerServiceImpl.setDayValue(StatPowerOrgDay.class, day, (BigDecimal)table.get(orgno));
            map = new HashMap<String, String>();
            map.put("dateStat", dateStat);
            day.setId(Long.valueOf(this.easeSnowflake.nextId()));
            day.setGmtCreate(Long.valueOf(System.currentTimeMillis()));
            day.setGmtModified(Long.valueOf(System.currentTimeMillis()));
            day.setVersion(Integer.valueOf(1));
            day.setDateStat(date);
            strings = this.computeMaxMinAvg(day, map);
            if (strings != null) {
                try {
                    day.setAvgValue(new BigDecimal(strings[0] == null ? "0" : strings[0]));
                    day.setMaxValue(new BigDecimal(strings[1] == null ? "0" : strings[1]));
                    day.setMaxValueTime(DateConvertUtils.convertFromString((String)(strings[2] == null ? "0" : strings[2]), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"}));
                    day.setMinValue(new BigDecimal(strings[3] == null ? "0" : strings[3]));
                    day.setMinValueTime(DateConvertUtils.convertFromString((String)(strings[4] == null ? "0" : strings[4]), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"}));
                }
                catch (Exception e) {
                    log.error("strings error:" + e.getMessage());
                }
            }
            this.powerOrgAndSystemDao.insertOrUpdateOrgAndSystemOne(day);
        }
        return 1;
    }

    public int statorgMonth(Long timeStamp) {
        Date date = new Date(timeStamp);
        List orgoprEbtitys = this.orgoprEbtityDao.selectList(null);
        for (StatEbikeOrgoprEbtity ebikeOrgoprEbtity : orgoprEbtitys) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.between((Object)"date_stat", (Object)new Date(EbDateUtil.getPreviousMonthBegin(timeStamp)), (Object)new Date(EbDateUtil.getYesterday()));
            queryWrapper.eq((Object)"org_no", (Object)ebikeOrgoprEbtity.getSubburo());
            List days = this.dayDao.selectList((Wrapper)queryWrapper);
            if (null == days || days.isEmpty()) continue;
            StatPowerOrgMonth month = new StatPowerOrgMonth();
            month.setId(Long.valueOf(this.easeSnowflake.nextId()));
            BigDecimal max = null;
            BigDecimal min = null;
            Date maxDate = null;
            Date minDate = null;
            BigDecimal count = BigDecimal.ZERO;
            for (StatPowerOrgDay day : days) {
                if (max == null) {
                    max = day.getMaxValue();
                    maxDate = day.getDateStat();
                } else if (day.getMaxValue().compareTo(max) == 1) {
                    max = day.getMaxValue();
                    maxDate = day.getDateStat();
                }
                if (min == null) {
                    min = day.getMinValue();
                    minDate = day.getMinValueTime();
                } else if (day.getMinValue().compareTo(min) == -1) {
                    min = day.getMinValue();
                    minDate = day.getMinValueTime();
                }
                if (null == day.getAvgValue()) continue;
                count = count.add(day.getAvgValue());
            }
            StatPowerOrgMonth statPowerOrgMonth = new StatPowerOrgMonth();
            statPowerOrgMonth.setOrgNo(ebikeOrgoprEbtity.getSubburo());
            statPowerOrgMonth.setId(Long.valueOf(this.easeSnowflake.nextId()));
            statPowerOrgMonth.setGmtModified(timeStamp);
            statPowerOrgMonth.setMonthStat(Integer.valueOf((date.getYear() + 1900) * 100 + date.getMonth()));
            statPowerOrgMonth.setMaxValueTime(maxDate);
            statPowerOrgMonth.setMinValueTime(minDate);
            statPowerOrgMonth.setGmtCreate(timeStamp);
            statPowerOrgMonth.setMaxValue(max);
            statPowerOrgMonth.setMaxValueTime(maxDate);
            statPowerOrgMonth.setMinValue(min);
            statPowerOrgMonth.setAvgValue(count.divide(new BigDecimal(days.size() + 1), 2, 1));
            QueryWrapper monthQueryWrapper = new QueryWrapper();
            monthQueryWrapper.eq((Object)"org_no", (Object)ebikeOrgoprEbtity.getSubburo());
            monthQueryWrapper.eq((Object)"month_stat", (Object)((date.getYear() + 1900) * 100 + date.getMonth()));
            StatPowerOrgMonth oldMoth = (StatPowerOrgMonth)this.monthDao.selectOne((Wrapper)monthQueryWrapper);
            if (oldMoth == null) {
                this.monthDao.insert(statPowerOrgMonth);
                continue;
            }
            this.monthDao.update(statPowerOrgMonth, (Wrapper)monthQueryWrapper);
        }
        return 1;
    }

    public int statDeviceMonth(Long timeStamp) {
        StatPowerChargedeviceMonth statPowerChargedeviceDay;
        QueryWrapper queryWrapper;
        Date minDate;
        Date maxDate;
        BigDecimal min;
        BigDecimal max;
        BigDecimal count;
        List days;
        QueryWrapper dayWrapper;
        List<StatDeviceEntity> plugs = this.statDeviceDao.getPlugDevice();
        List<StatDeviceEntity> station = this.statDeviceDao.getStationDevice();
        for (StatDeviceEntity entity : plugs) {
            dayWrapper = new QueryWrapper();
            dayWrapper.eq((Object)"charge_device_id", (Object)entity.getDeviceId());
            dayWrapper.between((Object)"date_stat", (Object)new Date(EbDateUtil.getPreviousMonthBegin(timeStamp)), (Object)new Date(EbDateUtil.getYesterday()));
            days = this.deviceDayDao.selectList((Wrapper)dayWrapper);
            count = BigDecimal.ZERO;
            max = BigDecimal.ZERO;
            min = BigDecimal.ZERO;
            maxDate = null;
            minDate = null;
            if (days.size() == 0) continue;
            for (StatPowerChargedeviceDay day : days) {
                count.add(day.getAvgValue() == null ? BigDecimal.ZERO : day.getAvgValue());
                if (maxDate == null) {
                    maxDate = day.getMaxValueTime();
                    max = day.getMaxValue();
                } else if (day.getMaxValue().compareTo(max) == 1) {
                    max = day.getMaxValue();
                    maxDate = day.getMaxValueTime();
                }
                if (minDate == null) {
                    minDate = day.getMinValueTime();
                    min = day.getMinValue();
                    continue;
                }
                if (day.getMaxValue().compareTo(min) != -1) continue;
                min = day.getMinValue();
                minDate = day.getMinValueTime();
            }
            queryWrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"org_no", (Object)entity.getSubburo())).eq((Object)"charge_device_id", (Object)entity.getDeviceId())).eq((Object)"month_stat", (Object)this.getCurTimeYYYYMM(new Date(timeStamp)));
            statPowerChargedeviceDay = new StatPowerChargedeviceMonth();
            statPowerChargedeviceDay.setChargeDeviceId(entity.getDeviceId().toString());
            statPowerChargedeviceDay.setId(Long.valueOf(this.easeSnowflake.nextId()));
            statPowerChargedeviceDay.setGmtCreate(timeStamp);
            statPowerChargedeviceDay.setOrgNo(entity.getSubburo());
            statPowerChargedeviceDay.setGmtModified(timeStamp);
            statPowerChargedeviceDay.setMaxValue(max);
            statPowerChargedeviceDay.setMinValue(min);
            statPowerChargedeviceDay.setMaxValueTime(maxDate);
            statPowerChargedeviceDay.setMinValueTime(minDate);
            statPowerChargedeviceDay.setMonthStat(this.getCurTimeYYYYMM(new Date(timeStamp)));
            statPowerChargedeviceDay.setAvgValue(count.divide(new BigDecimal(days.size()), 2, 0));
            if (this.statPowerChargedeviceMonthDao.selectOne((Wrapper)queryWrapper) == null) {
                this.statPowerChargedeviceMonthDao.insert(statPowerChargedeviceDay);
                continue;
            }
            this.statPowerChargedeviceMonthDao.update(statPowerChargedeviceDay, (Wrapper)queryWrapper);
        }
        for (StatDeviceEntity entity : station) {
            dayWrapper = new QueryWrapper();
            dayWrapper.eq((Object)"charge_device_id", (Object)entity.getDeviceId());
            dayWrapper.between((Object)"date_stat", (Object)new Date(EbDateUtil.getPreviousMonthBegin(timeStamp)), (Object)new Date(timeStamp));
            days = this.deviceDayDao.selectList((Wrapper)dayWrapper);
            count = BigDecimal.ZERO;
            max = BigDecimal.ZERO;
            min = BigDecimal.ZERO;
            maxDate = null;
            minDate = null;
            if (days.size() == 0) continue;
            for (StatPowerChargedeviceDay day : days) {
                count.add(day.getAvgValue() == null ? BigDecimal.ZERO : day.getAvgValue());
                if (maxDate == null) {
                    maxDate = day.getMaxValueTime();
                    max = day.getMaxValue();
                } else if (day.getMaxValue().compareTo(max) == 1) {
                    max = day.getMaxValue();
                    maxDate = day.getMaxValueTime();
                }
                if (minDate == null) {
                    minDate = day.getMinValueTime();
                    min = day.getMinValue();
                    continue;
                }
                if (day.getMaxValue().compareTo(min) != -1) continue;
                min = day.getMinValue();
                minDate = day.getMinValueTime();
            }
            queryWrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"org_no", (Object)entity.getSubburo())).eq((Object)"charge_device_id", (Object)entity.getDeviceId())).eq((Object)"month_stat", (Object)this.getCurTimeYYYYMM(new Date(timeStamp)));
            statPowerChargedeviceDay = new StatPowerChargedeviceMonth();
            statPowerChargedeviceDay.setChargeDeviceId(entity.getDeviceId().toString());
            statPowerChargedeviceDay.setId(Long.valueOf(this.easeSnowflake.nextId()));
            statPowerChargedeviceDay.setGmtCreate(timeStamp);
            statPowerChargedeviceDay.setOrgNo(entity.getSubburo());
            statPowerChargedeviceDay.setGmtModified(timeStamp);
            statPowerChargedeviceDay.setMaxValue(max);
            statPowerChargedeviceDay.setMonthStat(this.getCurTimeYYYYMM(new Date(timeStamp)));
            statPowerChargedeviceDay.setMinValue(min);
            statPowerChargedeviceDay.setMaxValueTime(maxDate);
            statPowerChargedeviceDay.setMinValueTime(minDate);
            statPowerChargedeviceDay.setAvgValue(count.divide(new BigDecimal(days.size()), 2, 0));
            if (this.statPowerChargedeviceMonthDao.selectOne((Wrapper)queryWrapper) == null) {
                this.statPowerChargedeviceMonthDao.insert(statPowerChargedeviceDay);
                continue;
            }
            this.statPowerChargedeviceMonthDao.update(statPowerChargedeviceDay, (Wrapper)queryWrapper);
        }
        return 1;
    }

    public int statDeviceYears(Long timeStamp) {
        StatPowerChargedeviceYear statPowerChargedeviceDay;
        QueryWrapper queryWrapper;
        Date minDate;
        Date maxDate;
        BigDecimal min;
        BigDecimal max;
        BigDecimal count;
        List days;
        QueryWrapper dayWrapper;
        List<StatDeviceEntity> plugs = this.statDeviceDao.getPlugDevice();
        List<StatDeviceEntity> station = this.statDeviceDao.getStationDevice();
        Date date = new Date(timeStamp);
        for (StatDeviceEntity entity : plugs) {
            dayWrapper = new QueryWrapper();
            dayWrapper.eq((Object)"charge_device_id", (Object)entity.getDeviceId());
            dayWrapper.between((Object)"month_stat", (Object)(this.getCurTimeYYYYMM(date) - 1), (Object)this.getCurTimeYYYYMM(date));
            days = this.statPowerChargedeviceMonthDao.selectList((Wrapper)dayWrapper);
            count = BigDecimal.ZERO;
            max = BigDecimal.ZERO;
            min = BigDecimal.ZERO;
            maxDate = null;
            minDate = null;
            if (days.size() == 0 || days.size() == 0) continue;
            for (StatPowerChargedeviceMonth day : days) {
                count.add(day.getAvgValue() == null ? BigDecimal.ZERO : day.getAvgValue());
                if (maxDate == null) {
                    maxDate = day.getMaxValueTime();
                    max = day.getMaxValue();
                } else if (day.getMaxValue().compareTo(max) == 1) {
                    max = day.getMaxValue();
                    maxDate = day.getMaxValueTime();
                }
                if (minDate == null) {
                    minDate = day.getMinValueTime();
                    min = day.getMinValue();
                    continue;
                }
                if (day.getMaxValue().compareTo(min) != -1) continue;
                min = day.getMinValue();
                minDate = day.getMinValueTime();
            }
            queryWrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"org_no", (Object)entity.getSubburo())).eq((Object)"charge_device_id", (Object)entity.getDeviceId())).eq((Object)"year_stat", (Object)this.getCurTimeYYYYMM(new Date(timeStamp)));
            statPowerChargedeviceDay = new StatPowerChargedeviceYear();
            statPowerChargedeviceDay.setChargeDeviceId(entity.getDeviceId().toString());
            statPowerChargedeviceDay.setId(Long.valueOf(this.easeSnowflake.nextId()));
            statPowerChargedeviceDay.setGmtCreate(timeStamp);
            statPowerChargedeviceDay.setOrgNo(entity.getSubburo());
            statPowerChargedeviceDay.setGmtModified(timeStamp);
            statPowerChargedeviceDay.setMaxValue(max);
            statPowerChargedeviceDay.setMinValue(min);
            statPowerChargedeviceDay.setMaxValueTime(maxDate);
            statPowerChargedeviceDay.setMinValueTime(minDate);
            statPowerChargedeviceDay.setYearStat(date.getYear() + 1900);
            statPowerChargedeviceDay.setAvgValue(count.divide(new BigDecimal(days.size()), 2, 0));
            if (this.statPowerChargedeviceYearDao.selectOne((Wrapper)queryWrapper) == null) {
                this.statPowerChargedeviceYearDao.insert(statPowerChargedeviceDay);
                continue;
            }
            this.statPowerChargedeviceYearDao.update(statPowerChargedeviceDay, (Wrapper)queryWrapper);
        }
        for (StatDeviceEntity entity : station) {
            dayWrapper = new QueryWrapper();
            dayWrapper.eq((Object)"charge_device_id", (Object)entity.getDeviceId());
            dayWrapper.between((Object)"month_stat", (Object)(this.getCurTimeYYYYMM(date) - 1), (Object)this.getCurTimeYYYYMM(date));
            days = this.statPowerChargedeviceMonthDao.selectList((Wrapper)dayWrapper);
            count = BigDecimal.ZERO;
            max = BigDecimal.ZERO;
            min = BigDecimal.ZERO;
            maxDate = null;
            minDate = null;
            if (days.size() == 0) continue;
            for (StatPowerChargedeviceMonth day : days) {
                count.add(day.getAvgValue() == null ? BigDecimal.ZERO : day.getAvgValue());
                if (maxDate == null) {
                    maxDate = day.getMaxValueTime();
                    max = day.getMaxValue();
                } else if (day.getMaxValue().compareTo(max) == 1) {
                    max = day.getMaxValue();
                    maxDate = day.getMaxValueTime();
                }
                if (minDate == null) {
                    minDate = day.getMinValueTime();
                    min = day.getMinValue();
                    continue;
                }
                if (day.getMaxValue().compareTo(min) != -1) continue;
                min = day.getMinValue();
                minDate = day.getMinValueTime();
            }
            queryWrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"org_no", (Object)entity.getSubburo())).eq((Object)"charge_device_id", (Object)entity.getDeviceId())).eq((Object)"year_stat", (Object)this.getCurTimeYYYYMM(new Date(timeStamp)));
            statPowerChargedeviceDay = new StatPowerChargedeviceYear();
            statPowerChargedeviceDay.setChargeDeviceId(entity.getDeviceId().toString());
            statPowerChargedeviceDay.setId(Long.valueOf(this.easeSnowflake.nextId()));
            statPowerChargedeviceDay.setGmtCreate(timeStamp);
            statPowerChargedeviceDay.setOrgNo(entity.getSubburo());
            statPowerChargedeviceDay.setGmtModified(timeStamp);
            statPowerChargedeviceDay.setMaxValue(max);
            statPowerChargedeviceDay.setMinValue(min);
            statPowerChargedeviceDay.setMaxValueTime(maxDate);
            statPowerChargedeviceDay.setMinValueTime(minDate);
            statPowerChargedeviceDay.setYearStat(date.getYear() + 1900);
            statPowerChargedeviceDay.setAvgValue(count.divide(new BigDecimal(days.size()), 2, 0));
            if (this.statPowerChargedeviceYearDao.selectOne((Wrapper)queryWrapper) == null) {
                this.statPowerChargedeviceYearDao.insert(statPowerChargedeviceDay);
                continue;
            }
            this.statPowerChargedeviceYearDao.update(statPowerChargedeviceDay, (Wrapper)queryWrapper);
        }
        return 1;
    }

    public int statYear(Long timeStamp) {
        Date date = new Date(timeStamp);
        List orgoprEbtitys = this.orgoprEbtityDao.selectList(null);
        for (StatEbikeOrgoprEbtity ebikeOrgoprEbtity : orgoprEbtitys) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.between((Object)"month_stat", (Object)(this.getCurTimeYYYYMM(date) - 1), (Object)this.getCurTimeYYYYMM(date));
            queryWrapper.eq((Object)"org_no", (Object)ebikeOrgoprEbtity.getSubburo());
            List days = this.monthDao.selectList((Wrapper)queryWrapper);
            if (null == days || days.isEmpty()) continue;
            StatPowerOrgMonth month = new StatPowerOrgMonth();
            month.setId(Long.valueOf(this.easeSnowflake.nextId()));
            BigDecimal max = null;
            BigDecimal min = null;
            Date maxDate = null;
            Date minDate = null;
            BigDecimal count = BigDecimal.ZERO;
            for (StatPowerOrgMonth day : days) {
                if (max == null) {
                    max = day.getMaxValue();
                    maxDate = day.getMaxValueTime();
                } else if (day.getMaxValue().compareTo(max) == 1) {
                    max = day.getMaxValue();
                    maxDate = day.getMaxValueTime();
                }
                if (min == null) {
                    min = day.getMinValue();
                    minDate = day.getMinValueTime();
                } else if (day.getMinValue().compareTo(min) == -1) {
                    min = day.getMinValue();
                    minDate = day.getMinValueTime();
                }
                if (null == day.getAvgValue()) continue;
                count = count.add(day.getAvgValue());
            }
            StatPowerOrgYear statPowerOrgMonth = new StatPowerOrgYear();
            statPowerOrgMonth.setOrgNo(ebikeOrgoprEbtity.getSubburo());
            statPowerOrgMonth.setId(Long.valueOf(this.easeSnowflake.nextId()));
            statPowerOrgMonth.setGmtModified(timeStamp);
            statPowerOrgMonth.setYearStat(date.getYear() + 1900);
            statPowerOrgMonth.setMaxValueTime(maxDate);
            statPowerOrgMonth.setMinValueTime(minDate);
            statPowerOrgMonth.setGmtCreate(timeStamp);
            statPowerOrgMonth.setMaxValue(max);
            statPowerOrgMonth.setMaxValueTime(maxDate);
            statPowerOrgMonth.setMinValue(min);
            statPowerOrgMonth.setAvgValue(count.divide(new BigDecimal(days.size() + 1), 2, 1));
            QueryWrapper monthQueryWrapper = new QueryWrapper();
            monthQueryWrapper.eq((Object)"org_no", (Object)ebikeOrgoprEbtity.getSubburo());
            monthQueryWrapper.eq((Object)"year_stat", (Object)(date.getYear() + 1900));
            StatPowerOrgYear oldMoth = (StatPowerOrgYear)this.yearDao.selectOne((Wrapper)monthQueryWrapper);
            if (oldMoth == null) {
                this.yearDao.insert(statPowerOrgMonth);
                continue;
            }
            this.yearDao.update(statPowerOrgMonth, (Wrapper)monthQueryWrapper);
        }
        return 1;
    }

    private static int getTimeQuarter() {
        int date = (int)(Duration.between(LocalDateTime.of(LocalDate.now(), LocalTime.MIN), LocalDateTime.now()).toMinutes() / 15L);
        if (date == 97) {
            return 96;
        }
        return date;
    }

    private static void setDayValue(Class clazz, Object statPowerOrgDay, BigDecimal value) {
        String fieldName = "powerValue";
        BigDecimal count = BigDecimal.ZERO;
        int timeQuarter = StatPowerServiceImpl.getTimeQuarter();
        fieldName = timeQuarter / 10 < 1 ? fieldName + "0" + timeQuarter : fieldName + timeQuarter;
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(statPowerOrgDay, value);
            for (int i = 1; i < 97; ++i) {
                String fn = "powerValue";
                fn = i / 10 < 1 ? fn + "0" + i : fn + i;
                Field date = clazz.getDeclaredField(fn);
                date.setAccessible(true);
                BigDecimal bg = null;
                if (null == date.get(statPowerOrgDay)) continue;
                bg = (BigDecimal)date.get(statPowerOrgDay);
                count = count.add(bg);
            }
            Field field2 = clazz.getDeclaredField("avgValue");
            field2.setAccessible(true);
            field2.set(statPowerOrgDay, count.divide(new BigDecimal(StatPowerServiceImpl.getTimeQuarter()), 2, 3));
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private int updateOrInsertPowerOrgDay(String orgNo, Date date, BigDecimal power) {
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"orgNo", (Object)orgNo);
        StatPowerOrgDay day = (StatPowerOrgDay)this.dayDao.selectOne((Wrapper)qw);
        if (null == day) {
            StatPowerOrgDay newDay = new StatPowerOrgDay();
            newDay.setId(Long.valueOf(this.easeSnowflake.nextId()));
            newDay.setOrgNo(orgNo);
            newDay.setDateStat(date);
            StatPowerServiceImpl.setDayValue(StatPowerOrgDay.class, newDay, power);
            newDay.setMaxValue(power);
            newDay.setMinValue(power);
            newDay.setMaxValueTime(date);
            newDay.setMinValueTime(date);
            newDay.setGmtModified(Long.valueOf(date.getTime()));
            return this.dayDao.insert(newDay);
        }
        if (day.getMinValue().compareTo(power) == 1) {
            day.setMinValueTime(date);
            day.setMinValue(power);
        }
        StatPowerServiceImpl.setDayValue(StatPowerOrgDay.class, day, power);
        day.setGmtModified(Long.valueOf(date.getTime()));
        return this.dayDao.updateById(day);
    }

    private void updateOrInsertPowerDriveDay(Long chargeDeviceId, String orgNo, Date date, BigDecimal power, Long curPowerTime) {
        QueryWrapper qw = new QueryWrapper();
        String dateStat = DateConvertUtils.convertToString((Date)date, (String)"yyyy-MM-dd");
        ((QueryWrapper)qw.eq((Object)"charge_device_id", (Object)chargeDeviceId)).eq((Object)"date_stat", (Object)new Date(System.currentTimeMillis()));
        StatPowerChargedeviceDay day = (StatPowerChargedeviceDay)this.deviceDayDao.selectOne((Wrapper)qw);
        if (null == day) {
            StatPowerChargedeviceDay newDay = new StatPowerChargedeviceDay();
            newDay.setId(Long.valueOf(this.easeSnowflake.nextId()));
            newDay.setChargeDeviceId(chargeDeviceId + "");
            newDay.setOrgNo(orgNo);
            newDay.setDateStat(date);
            StatPowerServiceImpl.setDayValue(StatPowerChargedeviceDay.class, newDay, power);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("dateStat", dateStat);
            String[] strings = this.computeMaxMinAvg(newDay, map);
            if (strings != null) {
                try {
                    newDay.setAvgValue(new BigDecimal(strings[0] == null ? "0" : strings[0]));
                    newDay.setMaxValue(new BigDecimal(strings[1] == null ? "0" : strings[1]));
                    newDay.setMaxValueTime(DateConvertUtils.convertFromString((String)(strings[2] == null ? "0" : strings[2]), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"}));
                    newDay.setMinValue(new BigDecimal(strings[3] == null ? "0" : strings[3]));
                    newDay.setMinValueTime(DateConvertUtils.convertFromString((String)(strings[4] == null ? "0" : strings[4]), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"}));
                }
                catch (Exception e) {
                    log.error("strings error:" + e.getMessage());
                }
            }
            newDay.setGmtModified(Long.valueOf(date.getTime()));
            newDay.setGmtCreate(Long.valueOf(date.getTime()));
            newDay.setVersion(Integer.valueOf(1));
            this.powerOrgAndSystemDao.insertOrUpdatePowerChargedeviceDay(newDay);
        } else {
            if (date.getTime() - curPowerTime > 3600000L) {
                power = BigDecimal.ZERO;
            }
            day.setId(Long.valueOf(this.easeSnowflake.nextId()));
            day.setGmtModified(Long.valueOf(date.getTime()));
            day.setGmtCreate(Long.valueOf(date.getTime()));
            day.setVersion(Integer.valueOf(1));
            day.setDateStat(date);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("dateStat", dateStat);
            String[] strings = this.computeMaxMinAvg(day, map);
            if (strings != null) {
                try {
                    day.setAvgValue(new BigDecimal(strings[0] == null ? "0" : strings[0]));
                    day.setMaxValue(new BigDecimal(strings[1] == null ? "0" : strings[1]));
                    day.setMaxValueTime(DateConvertUtils.convertFromString((String)(strings[2] == null ? "0" : strings[2]), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"}));
                    day.setMinValue(new BigDecimal(strings[3] == null ? "0" : strings[3]));
                    day.setMinValueTime(DateConvertUtils.convertFromString((String)(strings[4] == null ? "0" : strings[4]), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"}));
                }
                catch (Exception e) {
                    log.error("strings error:" + e.getMessage());
                }
            }
            this.powerOrgAndSystemDao.insertOrUpdatePowerChargedeviceDay(day);
        }
    }

    private int updateOrInsertPowerOrgDay(StatDeviceEntity deviceEntity) {
        ChargeDeviceOps ops = new ChargeDeviceOps();
        return -1;
    }

    private int getCurTimeYYYYMM(Date date) {
        return (date.getYear() + 1900) * 100 + date.getMonth() + 1;
    }

    private <T> String[] computeMaxMinAvg(T chargedeviceDay, Map<String, String> map) {
        String[] strings = null;
        if (chargedeviceDay == null) {
            return null;
        }
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
        Class<?> aClass = chargedeviceDay.getClass();
        try {
            for (int i = 1; i < 97; ++i) {
                String name = String.format("powerValue%02d", i);
                Field field = aClass.getDeclaredField(name);
                field.setAccessible(true);
                Object object = field.get(chargedeviceDay);
                if (object != null) {
                    BigDecimal bigDecimal = new BigDecimal(object.toString());
                    list.add(bigDecimal);
                    continue;
                }
                list.add(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        strings = this.getMaxMin(list, map);
        return strings;
    }

    private String[] getMaxMin(List<BigDecimal> list, Map<String, String> map) {
        String[] dayLables = StringDateUtil.getDayLables(96, 15);
        String[] values = new String[5];
        BigDecimal maxValue = null;
        BigDecimal minValue = null;
        BigDecimal totalValue = null;
        int count = 0;
        int maxIndex = 0;
        int minIndex = 0;
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                BigDecimal value = list.get(i);
                Boolean flag = value != null;
                if (flag.booleanValue() && maxValue != null && maxValue.compareTo(value) < 0) {
                    maxValue = value;
                    maxIndex = i;
                } else if (flag.booleanValue() && maxValue == null) {
                    maxValue = value;
                    maxIndex = i;
                }
                if (flag.booleanValue() && minValue != null && minValue.compareTo(value) > 0) {
                    minValue = value;
                    minIndex = i;
                } else if (flag.booleanValue() && minValue == null) {
                    minValue = value;
                    minIndex = i;
                }
                if (flag.booleanValue() && totalValue != null) {
                    totalValue = totalValue.add(value);
                    ++count;
                    continue;
                }
                if (!flag.booleanValue() || totalValue != null) continue;
                totalValue = value;
                ++count;
            }
        }
        String dateStat = map.get("dateStat");
        String maxDate = dateStat + " " + dayLables[maxIndex] + ":00";
        String minDate = dateStat + " " + dayLables[minIndex] + ":00";
        Date maxTime = DateConvertUtils.convertFromString((String)maxDate, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
        Date minTine = DateConvertUtils.convertFromString((String)minDate, (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
        maxDate = DateConvertUtils.convertToString((Date)maxTime, (String)"yyyy-MM-dd HH:mm:ss");
        minDate = DateConvertUtils.convertToString((Date)minTine, (String)"yyyy-MM-dd HH:mm:ss");
        if (count > 0) {
            totalValue = totalValue.divide(BigDecimal.valueOf(count), 8, 0);
        }
        values[0] = String.valueOf(totalValue);
        values[1] = String.valueOf(maxValue);
        values[2] = maxDate;
        values[3] = String.valueOf(minValue);
        values[4] = minDate;
        return values;
    }
}

