/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.statanaly.util;

import com.easesource.commons.util.convert.DateConvertUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class StringDateUtil {
    public static Date getBeforeDay(Date date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.add(5, -1);
        Date beforeDay = ca.getTime();
        return beforeDay;
    }

    public static int getYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int month = cal.get(1);
        return month;
    }

    public static int getMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int month = cal.get(2) + 1;
        return month;
    }

    public static int getYearMonth(Date date) {
        Date dates = StringDateUtil.getBeforeDay(date);
        int month = StringDateUtil.getMonth(dates);
        int year = StringDateUtil.getYear(dates);
        String months = "";
        months = month < 10 ? "0" + String.valueOf(month) : String.valueOf(month);
        return Integer.parseInt(String.valueOf(year) + months);
    }

    public static int getBreforeDayYear(Date date) {
        Date dates = StringDateUtil.getBeforeDay(date);
        int year = StringDateUtil.getYear(dates);
        return year;
    }

    public static int getYearAndMonth(Date date) {
        String yearAndMonth = new SimpleDateFormat("yyyyMM").format(date);
        return Integer.parseInt(yearAndMonth);
    }

    public static String getFirstDayOfMonth(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, 0);
        cal.set(5, 1);
        String firstday = format.format(cal.getTime());
        return firstday;
    }

    public static Date getDates(int hour) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, hour);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    public static Boolean checkDate() {
        long eight = StringDateUtil.getDates(18).getTime();
        long four = StringDateUtil.getDates(6).getTime();
        long zeros = StringDateUtil.getDates(24).getTime();
        long zero = StringDateUtil.getDates(0).getTime();
        long systemDate = System.currentTimeMillis();
        boolean flag = false;
        if (eight < systemDate && systemDate <= zeros || zero <= systemDate && systemDate <= four) {
            flag = true;
        }
        return flag;
    }

    public static long getMillis(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public static int getIndex(Date date) {
        int hh = Integer.valueOf(DateConvertUtils.convertToString((Date)date, (String)"HH"));
        int mm = Integer.valueOf(DateConvertUtils.convertToString((Date)date, (String)"mm"));
        return hh * 4 + mm / 15;
    }

    public static Date getDateTimeByIndex(Date date, int index) {
        int hh = index / 4;
        int mm = index % 4 * 15;
        String s = DateConvertUtils.convertToString((Date)date, (String)"yyyy-MM-dd");
        Date date2 = DateConvertUtils.convertFromString((String)(s + " " + hh + ":" + mm + ":00"), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
        return date2;
    }

    public static <T> BigDecimal getEloadValueByName(T t, String name) {
        BigDecimal bigDecimal = null;
        try {
            Class<?> aClass = t.getClass();
            Field field = aClass.getDeclaredField(name);
            field.setAccessible(true);
            Object valueObject = field.get(t);
            if (valueObject != null) {
                bigDecimal = new BigDecimal(valueObject.toString());
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        return bigDecimal;
    }

    public static String[] getDayLables(int length, int step) {
        try {
            String newTime;
            String[] strings = new String[length];
            strings[0] = newTime = "00:00";
            for (int i = 1; i < length; ++i) {
                strings[i] = newTime = StringDateUtil.timeAdd(newTime, step);
            }
            return strings;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String timeAdd(String oldTime, int step) {
        try {
            int addMit = step;
            SimpleDateFormat df = new SimpleDateFormat("HH:mm");
            Date date = null;
            date = df.parse(oldTime);
            Date expireTime = new Date(date.getTime() + (long)(addMit * 60 * 1000));
            String newTime = df.format(expireTime);
            return newTime;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }
}

