package com.ebikecharge.openservices.cloudapi.entity.request;

import java.io.Serializable;
import java.util.Objects;

/**
 * 银行卡认证请求
 */
public class BankcardCertRequest implements Serializable {

    private String orgoprType;                  // 运营商类型，10 - 公司；20 - 个人；
    private String orgoprName;                  // 运营商名称，企业名称或个人姓名；
    private String orgoprCredNo;                // 运营商证件号码
    private String bankCardNo;                  // 银行卡号
    private String bankBranchLinkNo;            // 银行联行号
    private String bankMobile;                  // 银行预留手机号（可选）

    public String getOrgoprType() {
        return orgoprType;
    }

    public void setOrgoprType(String orgoprType) {
        this.orgoprType = orgoprType;
    }

    public String getOrgoprName() {
        return orgoprName;
    }

    public void setOrgoprName(String orgoprName) {
        this.orgoprName = orgoprName;
    }

    public String getOrgoprCredNo() {
        return orgoprCredNo;
    }

    public void setOrgoprCredNo(String orgoprCredNo) {
        this.orgoprCredNo = orgoprCredNo;
    }

    public String getBankCardNo() {
        return bankCardNo;
    }

    public void setBankCardNo(String bankCardNo) {
        this.bankCardNo = bankCardNo;
    }

    public String getBankBranchLinkNo() {
        return bankBranchLinkNo;
    }

    public void setBankBranchLinkNo(String bankBranchLinkNo) {
        this.bankBranchLinkNo = bankBranchLinkNo;
    }

    public String getBankMobile() {
        return bankMobile;
    }

    public void setBankMobile(String bankMobile) {
        this.bankMobile = bankMobile;
    }

    @Override
    public String toString() {
        return "BankcardCertRequest{" +
                "orgoprType='" + orgoprType + '\'' +
                ", orgoprName='" + orgoprName + '\'' +
                ", orgoprCredNo='" + orgoprCredNo + '\'' +
                ", bankCardNo='" + bankCardNo + '\'' +
                ", bankBranchLinkNo='" + bankBranchLinkNo + '\'' +
                ", bankMobile='" + bankMobile + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if(this == o) return true;
        if(o == null || getClass() != o.getClass()) return false;
        BankcardCertRequest that = (BankcardCertRequest) o;
        return Objects.equals(orgoprType, that.orgoprType) &&
                Objects.equals(orgoprName, that.orgoprName) &&
                Objects.equals(orgoprCredNo, that.orgoprCredNo) &&
                Objects.equals(bankCardNo, that.bankCardNo) &&
                Objects.equals(bankBranchLinkNo, that.bankBranchLinkNo) &&
                Objects.equals(bankMobile, that.bankMobile);
    }

    @Override
    public int hashCode() {
        return Objects.hash(orgoprType, orgoprName, orgoprCredNo, bankCardNo, bankBranchLinkNo, bankMobile);
    }

}
